Attribute VB_Name = "HW"
Option Explicit
Declare Sub Sleep Lib "kernel32" (ByVal dwMilliseconds As Long)
Declare Function Beep Lib "kernel32" (ByVal dwFreq As Long, ByVal dwDuration As Long) As Long
Declare Function CreateThread Lib "kernel32" (lpThreadAttributes As Any, ByVal dwStackSize As Long, ByVal lpStartAddress As Long, lpParameter As Any, ByVal dwCreationFlags As Long, lpThreadID As Long) As Long
Global CSVtable As String
Global Bpuf() As Byte '0-9 keyboard buffer
Global SoundDB As Long
Global CRTreg(18) As Long ' 0-17 reg, 18 cimzett regiszter
Global Pcounter As Long ' pitch counter
Global TcrtINT As Long
Global Tact3 As Long ' global emu 20 msec timer counter
Global Tact3Back As Long '
Global CRTfilename As String
'Dim CRTcim

'TVC *****************************************
'CPU: Z80 3.125MHZ



Function peek(cim As Long) As Long
''
If cim > 65535 Then cim = cim - 65536 Else If cim < 0 Then cim = 65536 + cim
Dim lapreg As Long
Dim CNN As Long
Dim n As Long
lapreg = Pmem(2) ' And 252

'base memory  MS1,MS2,MS3,MS4 / 16kb*4=64kb
'PAGING memorys:
'0 U0*16KB  USER   RAM
'1 U1*16KB  USER   RAM
'2 U2*16KB  USER   RAM
'3 U3*16KB  USER   RAM
'4 VID*16KB VIDEO  RAM
'5 CART*16KB CARTRIDGE ROM
'6 SYS*16KB SYSTEM ROM
'7 EXT*16KB 8KB IOEM + 8KB EXTENDED SYS
'max cim: 131071

'* CSAK 64K+ / ** CSAK 64K+ VAGY 32K 32 BOVITESSEL
'LAP3       LAP2    LAP0        LAP1
'B7 B6      B5      B4 B3       B2          B1          B0
'------------------------------------------------------------
'00 CART    0 VID   00 SYS      0 U1        X           X
'01 SYS     1 U2    01 CART     1 VID*
'10 U3              10 U0
'11 EXT             11 U3**

 If cim < 16384 Then
 n = lapreg And 24
 If n = 0 Then CNN = cim + 98304: GoTo tova0
 If n = 8 Then CNN = cim + 81920: GoTo tova0
 If n = 16 Then CNN = cim: GoTo tova0
 If n = 24 Then CNN = cim + 49152: GoTo tova0
 End If
 
 If cim < 32768 Then
 n = lapreg And 4
 If n = 0 Then CNN = cim: GoTo tova0
 If n = 4 Then CNN = cim + 49152: GoTo tova0
 End If
 
 If cim < 49152 Then
 n = lapreg And 32
 If n = 0 Then CNN = cim + 32768: GoTo tova0
 If n = 32 Then CNN = cim: GoTo tova0
 End If
 
 If cim < 65536 Then
 n = lapreg And 192
 If n = 0 Then CNN = cim + 32768: GoTo tova0
 If n = 64 Then CNN = cim + 49152: GoTo tova0
 If n = 128 Then CNN = cim: GoTo tova0
 If n = 192 Then CNN = cim + 65536: GoTo tova0
 End If
 
 
 '*************************************************
z80mon.List1.AddItem "Illegal Memory Paging read!:" & lapreg
tova0:
 
peek = Memory(CNN)
End Function

Function poke(cim As Long, Value) As Long
Dim lapreg As Long
''
If cim > 65535 Then cim = cim - 65536 Else If cim < 0 Then cim = 65536 + cim
Dim CNN As Long
'If cim > 65535 Then z80mon.REgtoForm: MsgBox "too biG mem" 'cim = cim - 65535
lapreg = Pin(2) ' And 252

 Dim n As Long
 
 If cim < 16384 Then
 n = lapreg And 24
 'If n = 0 Then z80mon.List1.AddItem "SYS ROM WRITE!": Exit Function: CNN = cim + 98304: GoTo tova0
 'If n = 8 Then z80mon.List1.AddItem "CART ROM WRITE!": Exit Function: CNN = cim + 81920: GoTo tova0
 If n = 16 Then CNN = cim: GoTo tova0
 If n = 24 Then CNN = cim + 49152: GoTo tova0
 End If
 
 If cim < 32768 Then
 n = lapreg And 4
 If n = 0 Then CNN = cim: GoTo tova0
 If n = 4 Then CNN = cim + 49152: GoTo tova0
 End If
 
 If cim < 49152 Then
 n = lapreg And 32
 If n = 0 Then CNN = cim + 32768: GoTo tova0
 If n = 32 Then CNN = cim: GoTo tova0
 End If
 
 
 If cim < 65536 Then 'iomem es ext ?????
 n = lapreg And 192
 'If n = 0 Then z80mon.List1.AddItem "CRT ROM WRITE!!": Exit Function: CNN = cim + 32768: GoTo tova0
 If n = 64 Then CNN = cim + 49152: GoTo tova0
 If n = 128 Then CNN = cim: GoTo tova0
 'If n = 192 Then z80mon.List1.AddItem "EXT ROM WRITE!!": Exit Function: CNN = cim + 65536: GoTo tova0
 End If
 'z80mon.List1.AddItem "Illegal Memory Paging write!:" & lapreg
 Exit Function
  '******************************************************************
tova0:

 Memory(CNN) = Value

End Function

Sub Reset()
'mem + i/o Reset
ReDim Pmem(254) As Byte
ReDim Memory(131071) As Byte
ReDim Bpuf(2559) As Byte

'register reset
H = 255: L = 255: B = 255: C = 255: D = 255: E = 255
H2 = 255: L2 = 255: B2 = 255: C2 = 255: D2 = 255: E2 = 255
a = 255: A2 = 255: F = 255: F2 = 255
SP = 65535: i = 0: r = 0
PC = 0: IX = 65535: IY = 65535
IFF1 = 0: IFF2 = 0: IM = 0

FS = 1: FZ = 1: FY = 1: FH = 1: FX = 1: FP = 1: FN = 1: FC = 1
FS2 = 1: FZ2 = 1: FY2 = 1: FH2 = 1: FX2 = 1: FP2 = 1: FN2 = 1: FC2 = 1

'******** global reload ***********
OPcode = 0: Tact = 0

PREfix = vbNullString
Tact = 0
ResetON = 0
InstCount = 0

Dim memb As Byte: Dim t As Long


On Error GoTo FileError

Open "TVC12_D4.rom" For Binary Access Read As #1
For t = 1 To 8192
Get #1, t, memb
Memory(t + 98303) = memb
Next t
Close #1
'sys2
Open "TVC12_D3.rom" For Binary Access Read As #1
For t = 1 To 8192
Get #1, t, memb
Memory(t + 98303 + 8192) = memb
Next t
Close #1

'ext
Open "TVC12_D7.rom" For Binary Access Read As #1
For t = 1 To 8192
Get #1, t, memb
Memory(t + 114687 + 8192) = memb
Next t
Close #1

'*******************************
'Cartridge load
If CRTfilename <> "" Then
Open CRTfilename For Binary Access Read As #1
For t = 1 To 16384
Get #1, t, memb
Memory(t + 81919) = memb
Next t
Close #1
Close #2
End If
Exit Sub

FileError:
MsgBox "Rom File error: ", vbCritical, "Error": End

End Sub

Sub loadCSVtable()
'Dim hossz
'hossz = FileLen("z80opcodes.txt")
'Dim a As String
'a = String(hossz, " ")
'Open "z80opcodes.txt" For Binary As #1
'Get #1, , a
'Close #1
'Z80OPCodes = a
Z80OPCodes = LoadResString(101)

End Sub

Function Pout(cim As Long, n As Long)
'z80mon.List2.AddItem cim & " " & n

'If z80mon.Check1 Then z80mon.List1.AddItem "Out " & cim & "," & n

'Memoria lapozas 2-7 bit
If cim = 2 Then Pmem(cim) = n:  Exit Function
If cim = 3 Then: Pmem(cim) = n: Exit Function
If cim = 4 Then Pmem(cim) = n: Exit Function
If cim = 5 Then Pmem(cim) = n: Exit Function

If cim = 6 Then
 Pmem(cim) = n
 nn = (n And 60) ' 4 'volume
 Dim kc As Integer: Dim os As Integer ':dim ho as long
os = 142  ' 22khz/20msec= 440 byte, 62500 os = 62500/440
kc = Tact3 / os
'ho = (Tact3 - Tact3Back) \ os
'If ho < 0 Then
'ho = Tact3 \ os
'End If
'Tact3Back = Tact3
Mid(soundbuffer, 45 + kc, 16) = String(16, Chr(128 + nn * 2)) ' SoundDB = SoundDB + 1
Exit Function
End If


'CRT controls
If cim = 112 Then Pmem(cim) = n: CRTreg(18) = n And 31: Exit Function 'reg select
If cim = 113 Then
CRTreg(CRTreg(18)) = n: 'Pmem(cim) = n: ' 'reg write
'if n=14 or 15
TcrtINT = (CRTreg(14) * 256 + CRTreg(15)) * 17

Exit Function
End If

'VGA bordercolor 0-7 bit
If cim = 0 Then
'If Pmem(cim) <> n Then
'Dim BBC As Long
'If n And 2 Then BBC = BBC + 1
'If n And 8 Then BBC = BBC + 4
'If n And 32 Then BBC = BBC + 2
'If n And 128 Then BBC = BBC + 8
'Screen1.Picture4.BackColor = QBColor(BBC): Screen1.Picture4.Refresh
'Screen1.Picture5.BackColor = QBColor(BBC): Screen1.Picture5.Refresh
'Screen1.Picture6.BackColor = QBColor(BBC): Screen1.Picture6.Refresh
'Screen1.Picture7.BackColor = QBColor(BBC): Screen1.Picture7.Refresh

'Screen1.BackColor = QBColor(BBC)
Pmem(cim) = n
'Exit Function
'End If
Exit Function
End If


' COLOR paletta
If cim = 96 Then Pmem(cim) = n: Exit Function
If cim = 97 Then Pmem(cim) = n: Exit Function
If cim = 98 Then Pmem(cim) = n: Exit Function
If cim = 99 Then Pmem(cim) = n: Exit Function

'b0-b5 64k+ vga lapozas
If cim = 15 Then Pmem(cim) = n: z80mon.List1.AddItem "64k+ Lapozas!": Exit Function

Pmem(cim) = n
End Function

Function Pin(cim As Long) As Long

'keyboard data
If cim = 88 Then: Pin = 255 - Bpuf(Pmem(3) And 15): Exit Function

'pitch counter reset
If cim = 91 Then Pcounter = 0: Exit Function

'color switch
If cim = 89 Then
If Screen1.xScreenBW.Checked = False Then Pmem(89) = Pmem(89) Or 64 Else Pmem(89) = Pmem(89) And 191
End If


Pin = Pmem(cim)
End Function

