Attribute VB_Name = "z80"
Option Explicit
Global PCm As Long
Global IND As Long
'Global PrimoKEY As Long

Global OPcode As Byte
Global Mnemonic As String
Global Tact As Long
Global TactNMI As Integer
Global PREfix As String
Global PrefixM As String
Global n As Long, N1 As Long, N2 As Long, nn As Long, nn1 As Long, nn2 As Long, NH As Long, NL As Long
Global Z80OPCodes As String
'Global RunMode As Long

Global ResetON As Long
Global IntON As Long
Global NmiON As Long
Global Stopped As Long

Global InstCount As Long
Global FPs As Single
Global OPend As Byte

Dim Nzt(15) As Long             'negytet tabla
Dim ParityTable(255) As Byte    'paritas tabla
Dim DAAtable(2048) As Long      'daa tabala
'mem & port
Global Memory() As Byte         '128kb max
Global Pmem() As Byte

'cpu registers
Global H As Long: Global H2 As Long
Global L As Long: Global L2 As Long
Global B As Long: Global B2 As Long
Global C As Long: Global C2 As Long
Global D As Long: Global D2 As Long
Global E As Long: Global E2 As Long
Global a As Long: Global A2 As Long
Global F As Long: Global F2 As Long
Global IX As Long: Global IY As Long
Global SP As Long: Global PC As Long
Global i As Long: Global r As Long

Global IM As Long, IFF1 As Long, IFF2 As Long

Global FS As Byte, FZ As Byte, FY As Byte, FH As Byte, FX As Byte, FP As Byte, FN As Byte, FC As Byte
Global FS2 As Byte, FZ2 As Byte, FY2 As Byte, FH2 As Byte, FX2 As Byte, FP2 As Byte, FN2 As Byte, FC2 As Byte
Global tFS As Byte, tFZ As Byte, tFY As Byte, tFH As Byte, tFX As Byte, tFP As Byte, tFN As Byte, tFC As Byte
Global tA As Byte

Dim cm As Long

Sub load_Z80OPCodes()

Z80OPCodes = LoadResString(101)
End Sub

Sub Reset()

ReDim Memory(131071) As Byte

'bit tala feltoltese
Dim t As Long
For t = 0 To 15
Nzt(t) = 2 ^ t
Next t

'parity table feltoltes
For t = 0 To 255
ParityTable(t) = ParityCalc(t)
Next t

'DAAtable feltoltes
'*********nem kell***********


PCm = 0

'reg to FF
H = 255: L = 255: B = 255: C = 255: D = 255: E = 255
H2 = 255: L2 = 255: B2 = 255: C2 = 255: D2 = 255: E2 = 255
a = 255: A2 = 255: F = 255: F2 = 255
SP = 65535: i = 0: r = 0
PC = 0: IX = 65535: IY = 65535
IFF1 = 0: IFF2 = 0: IM = 0

FS = 1: FZ = 1: FY = 1: FH = 1: FX = 1: FP = 1: FN = 1: FC = 1
FS2 = 1: FZ2 = 1: FY2 = 1: FH2 = 1: FX2 = 1: FP2 = 1: FN2 = 1: FC2 = 1

ReDim Pmem(254)

'********global 0

OPcode = 0: Tact = 0
PREfix = vbNullString
Tact = 0
InstCount = 0

Close #2

End Sub


Function Bit(ByVal Reg As Long, ByVal n As Long) As Long
'Bit = Nzt(n) And Reg
If Nzt(n) And Reg Then Bit = 1 'Else Bit = 0
End Function


Sub ADD_(ByVal n As Long)
nn1 = a And 15
nn2 = n And 15
If nn1 + nn2 > 15 Then FH = 1 Else FH = 0

cm = cmp2(a) + cmp2(n)
a = a + n

If a > 255 Then a = a - 256: FC = 1 Else FC = 0
If a = 0 Then FZ = 1 Else FZ = 0
If Bit(a, 7) Then FS = 1 Else FS = 0

If cm <> cmp2(a) Then FP = 1 Else FP = 0
FN = 0

'FX = Bit(A, 3)  'nem fontos ?
'FY = Bit(A, 5) 'nem fontos ?
End Sub

Sub ADC_(ByVal n As Long) '
'S: 1-es llapotba kerl, ha az eredmny negatv; egybknt trldik
'Z: 1-es llapotba kerl, ha az eredmny nulla; egybknt trldik
'H: 1-es llapotba kerl, ha a 3-as biten tvitel keletkezik; egybknt trldik
'P/V: 1-es llapotba kerl, ha tlcsorduls ll fenn; egybknt trldik
'N: trldik
'C: 1-es llapotba kerl, ha a 7-es biten tvitel keletkezik; egybknt trldik
nn = a
N1 = a And 15
cm = cmp2(a) + cmp2(n) + FC
a = a + n + FC
If a > 255 Then a = a - 256: FC = 1 Else FC = 0
If a = 0 Then FZ = 1 Else FZ = 0
'FH = N1 Xor Bit(A, 4)
N2 = a And 15
If N2 < N1 Then FH = 1 Else FH = 0
If N1 = N2 Then FH = 0

FS = Bit(a, 7)
FN = 0

If cm <> cmp2(a) Then FP = 1 Else FP = 0
'FX = Bit(A, 3) 'nem fontos ?
'FY = Bit(A, 5) 'nem fontos ?
End Sub

Sub ADCHL_(ByVal N2 As Long)
'S: 1-es llapotba kerl, ha az eredmny negatv; egybknt trldik
'Z: 1-es llapotba kerl, ha az eredmny nulla; egybknt trldik
'H: 1-es llapotba kerl, ha a 11-es biten tvitel keletkezik; egybknt trldik
'P/V: 1-es llapotba kerl, ha tlcsorduls ll fenn; egybknt trldik
'N: trldik
'C: 1-es llapotba kerl, ha a 15-s biten tvitel keletkezik; egybknt trldik
If ((H * 256 + L) And 4095) + ((N2 + FC) And 4095) And 4096 Then FH = 1 Else FH = 0

nn = H * 256 + L + N2 + FC
cm = cmp22(H * 256 + L) + cmp22(N2) + FC
If nn > 65535 Then nn = nn - 65536: FC = 1 Else FC = 0
If cmp22(nn) <> cm Then FP = 1 Else FP = 0
'If FP Then RunMode = -1

If nn > 32767 Then FS = 1 Else FS = 0
If nn = 0 Then FZ = 1 Else FZ = 0
'Fh
'FP = FC
H = nn \ 256
L = nn - H * 256
End Sub

Sub SUB_(ByVal n As Long)
'S: 1-es llapotba kerl, ha az eredmny negatv; egybknt trldik
'Z: 1-es llapotba kerl, ha az eredmny nulla; egybknt trldik
'H: 1-es llapotba kerl, ha alulcsorduls trtnt; egybknt trldik ????? hibas
'P/V: 1-es llapotba kerl, ha tlcsorduls ll fenn; egybknt trldik
'N: 1-es llapotba kerl
'C: 1-es llapotba kerl, ha alulcsorduls trtnt; egybknt trldik
nn1 = a And 15
nn2 = n And 15
If nn1 - nn2 < 0 Then FH = 1 Else FH = 0

cm = cmp2(a) - cmp2(n)
a = a - n
If a < 0 Then a = a + 256: FC = 1 Else FC = 0
If cmp2(a) <> cm Then FP = 1 Else FP = 0
If a = 0 Then FZ = 1 Else FZ = 0
If a > 127 Then FS = 1 Else FS = 0
FN = 1
'FX = Bit(A, 3) 'nem fontos ?
'FY = Bit(A, 5) 'nem fontos ?
End Sub

Sub SBC_(ByVal n As Long)
'S: 1-es llapotba kerl, ha az eredmny negatv; egybknt trldik
'Z: 1-es llapotba kerl, ha az eredmny nulla; egybknt trldik
'H: 1-es llapotba kerl, ha alulcsorduls trtnt; egybknt trldik
'P/V: 1-es llapotba kerl, ha tlcsorduls ll fenn; egybknt trldik
'N: 1-es llapotba kerl
'C: 1-es llapotba kerl, ha alulcsorduls trtnt; egybknt trldik

cm = cmp2(a) - cmp2(n + FC)
'FH
nn1 = a And 15
nn2 = n And 15
If nn1 - nn2 - FC < 0 Then FH = 1 Else FH = 0


a = a - n - FC
If a < 0 Then a = a + 256: FC = 1 Else FC = 0
If a = 0 Then FZ = 1 Else FZ = 0
FP = FC
If a > 127 Then FS = 1 Else FS = 0
'FH = FC
FN = 1
If cm <> cmp2(a) Then FP = 1 Else FP = 0
'If Bit(A, 3) Then FX = 1 Else FX = 0 'nem fontos ?
'If Bit(A, 5) Then FY = 1 Else FY = 0 'nem fontos ?
End Sub

Sub SBCHL_(ByVal N2)
'S: 1-es llapotba kerl, ha az eredmny negatv; egybknt trlodik
'Z: 1-es llapotba kerl, ha az eredmny nulla; egybknt trlodik
'H: 1-es llapotba kerl, ha alulcsorduls trtnt; egybknt trlodik
'P/V: 1-es llapotba kerl, ha tlcsorduls ll fenn; egybknt trlodik
'N: 1-es llapotba kerl
'C: 1-es llapotba kerl, ha alulcsorduls trtnt; egybknt trlodik

cm = cmp22(H * 256 + L) - cmp22(N2) - FC
FN = 1
nn = H * 256 + L - N2 - FC

If nn < 0 Then nn = nn + 65536: FC = 1 Else FC = 0
If nn > 32767 Then FS = 1 Else FS = 0
If nn = 0 Then FZ = 1 Else FZ = 0
FH = FC

'FP ?????
H = nn \ 256
L = nn - H * 256

If cm <> cmp22(nn) Then FP = 1 Else FP = 0


End Sub

Sub incHL()
L = L + 1
If L = 256 Then
L = 0: H = H + 1
If H = 256 Then H = 0
End If
End Sub
Sub incBC()
C = C + 1
If C = 256 Then
C = 0: B = B + 1
If B = 256 Then B = 0
End If
End Sub
Sub incDE()
E = E + 1
If E = 256 Then
E = 0: D = D + 1
If D = 256 Then D = 0
End If
End Sub
Sub decBC()
C = C - 1:
If C = -1 Then
C = 255: B = B - 1
If B = -1 Then B = 255
End If
End Sub

Sub decDE()
E = E - 1:
If E = -1 Then
E = 255: D = D - 1
If D = -1 Then D = 255
End If
End Sub
Sub decHL()
L = L - 1
If L = -1 Then
L = 255: H = H - 1
If H = -1 Then H = 255
End If
End Sub
Sub decSP()
SP = SP - 1: If SP = -1 Then SP = 65535
End Sub

Sub decIX()
IX = IX - 1: If IX = -1 Then IX = 65535
End Sub

Sub decIY()
IY = IY - 1: If IY = -1 Then IY = 65535
End Sub

Sub incSP()
SP = SP + 1: If SP = 65536 Then SP = 0
End Sub

Sub incIX()
IX = IX + 1: If IX = 65536 Then IX = 0
End Sub

Sub incIY()
IY = IY + 1: If IY = 65536 Then IY = 0
End Sub

Sub RET_()
NL = peek(SP)
SP = SP + 1 'z80.incSP
NH = peek(SP)
SP = SP + 1 'z80.incSP
PC = NH * 256 + NL
End Sub

Sub OR_(ByVal n As Long)
a = a Or n
If a > 127 Then FS = 1 Else FS = 0
If a = 0 Then FZ = 1 Else FZ = 0
FH = 0
FP = Parity(a)
FN = 0: FC = 0
End Sub

Sub XOR_(ByVal n As Long)
a = a Xor n
If a > 127 Then FS = 1 Else FS = 0
If a = 0 Then FZ = 1 Else FZ = 0
FH = 0
FP = Parity(a)
FN = 0: FC = 0
End Sub

Sub AND_(ByVal n As Long)
a = a And n
If a > 127 Then FS = 1 Else FS = 0
If a = 0 Then FZ = 1 Else FZ = 0
FH = 1
FP = Parity(a)
FN = 0: FC = 0
End Sub

Sub CP_(n As Long)

'S: 1-es llapotba kerl, ha az eredmny negatv; egybknt trldik
'Z: 1-es llapotba kerl, ha az eredmny nulla; egybknt trldik
'H: 1-es llapotba kerl, ha alulcsorduls trtnt; egybknt trldik
'P/V: 1-es llapotba kerl, ha, tlcsorduls ll fenn; egybknt trldik
'N: 1-es llapotba kerl
'C: 1-es llapotba kerl, ha alulcsorduls trtnt; egybknt trldik
'****************

nn1 = a And 15
nn2 = n And 15
If nn1 - nn2 < 0 Then FH = 1 Else FH = 0

Dim cm As Long
cm = cmp2(a) - cmp2(n)
'*********
Dim ered As Long
ered = a - n
If ered < 0 Then ered = ered + 256: FC = 1 Else FC = 0
If ered = 0 Then FZ = 1 Else FZ = 0
If ered > 127 Then FS = 1 Else FS = 0
FN = 1
If cm <> cmp2(ered) Then FP = 1 Else FP = 0
If n = 0 Then FH = 0: FC = 0
'FH = 0
'nn1 = ered And 15
'If nn1 + nn2 > 15 Then FH = 1 Else FH = 0
'FH = 0 '????????


'S: 1-es llapotba kerl, ha az eredmny negatv; egybknt trldik
'Z: 1-es llapotba kerl, ha az eredmny nulla; egybknt trldik
'H: 1-es llapotba kerl, ha alulcsorduls trtnt; egybknt trldik
'P/V: 1-es llapotba kerl, ha, tlcsorduls ll fenn; egybknt trldik
'N: 1-es llapotba kerl
'C: 1-es llapotba kerl, ha alulcsorduls trtnt; egybknt trldik
'****************
'nn1 = A And 15
'nn2 = n And 15
'If nn1 - nn2 < 0 Then FH = 1 Else FH = 0
'If A < n Then FC = 1 Else FC = 0


'Dim cm As Long
'cm = cmp2(A) - cmp2(n)
'*********
'Dim ered As Long
'ered = A - n
'If A < 0 Then A = A + 256

'If ered = 0 Then FZ = 1 Else FZ = 0
'If ered > 127 Then FS = 1 Else FS = 0
'FN = 1
'If cm <> cmp2(ered) Then FP = 1 Else FP = 0
End Sub


Sub ADDHL_(ByVal nn As Long)
'S: vltozatlan marad
'Z: vltozatlan marad
'H: 1-es llapotba kerl, ha a 11-es biten tvitel keletkezik; egybknt trldik
'P/V: vltozatlan marad
'N: trldik
'C: 1-es llapotba kerl, ha a 15-s biten tvitel keletkezik; egybknt trldik
'nn1 = H And 240
'nn2 = (Nn \ 256) And 240
'If nn1 + nn2 > 240 Then FH = 1 Else FH = 0

'v.Z80_FLAG_H = (((ciim & 0x0FFF) + (ciim2 & 0x0FFF)) & 0x1000) != 0; // bit 11 carry
If ((H * 256 + L) And 4095) + (nn And 4095) And 4096 Then FH = 1 Else FH = 0

nn = H * 256 + L + nn
If nn > 65535 Then nn = nn - 65536: FC = 1 Else FC = 0
FN = 0
H = nn \ 256: L = nn - 256 * H
End Sub

Sub ADDIX_(ByVal nn As Long)
'S: vltozatlan marad
'Z: vltozatlan marad
'H: 1-es llapotba kerl, ha a 11-es biten tvitel keletkezik; egybknt trldik
'P/V: vltozatlan marad
'N: trldik
'C: 1-es llapotba kerl, ha a 15-s biten tvitel keletkezik; egybknt trldik
If (IX And 4095) + (nn And 4095) And 4096 Then FH = 1 Else FH = 0

nn = IX + nn
If nn > 65535 Then nn = nn - 65536: FC = 1 Else FC = 0
FN = 0
IX = nn
End Sub

Sub ADDIY_(ByVal nn As Long)

'S: vltozatlan marad
'Z: vltozatlan marad
'H: 1-es llapotba kerl, ha a 11-es biten tvitel keletkezik; egybknt trldik
'P/V: vltozatlan marad
'N: trldik
'C: 1-es llapotba kerl, ha a 15-s biten tvitel keletkezik; egybknt trldik
If (IY And 4095) + (nn And 4095) And 4096 Then FH = 1 Else FH = 0

nn = IY + nn
If nn > 65535 Then nn = nn - 65536: FC = 1 Else FC = 0
FN = 0
IY = nn
End Sub


Sub JR_(ByVal n)
If n > 127 Then PC = PC + n - 254: Exit Sub 'IND = n - 254: Exit Sub
PC = PC + n + 2
'IND = n + 2 ' csak a debughoz kell
End Sub


Function INC_(ByVal n As Long)
'S: 1-es llapotba kerl, ha a beolvasott adat negatv; egybknt trldik
'Z: 1-es llapotba kerl, ha, az eredmny nulla; egybknt trldik
'H: 1-es llapotba kerl, ha a 3-as biten tvitel keletkezik; egybknt trldik
'P/V: 1-es llapotba kerl, ha, a mkds eltt r 7FH volt; egybknt trldik
'N: trldik
'C: vltozatlan marad
'FH = (n And 16) \ 16: If n = 254 Then FH = 0
If n = 127 Then FP = 1 Else FP = 0
n = n + 1: If n = 256 Then n = 0
If n > 127 Then FS = 1 Else FS = 0
If n = 0 Then FZ = 1 Else FZ = 0
FN = 0
INC_ = n

n = n And 15
If n Then FH = 0 Else FH = 1
End Function

Function DEC_(ByVal n As Long)
If n = 128 Then FP = 1 Else FP = 0
n = n - 1: If n = -1 Then n = 255: FH = 1 Else FH = 0
If n > 127 Then FS = 1 Else FS = 0
If n = 0 Then FZ = 1 Else FZ = 0
FN = 1
DEC_ = n
n = n And 15
If n = 15 Then FH = 1 Else FH = 0
End Function

Sub Call_(ByVal nn As Long)
PC = PC + 3
  ' If PC > 65535 Then PC = PC - 65536 'nem fontos
NH = PC \ 256
NL = PC - NH * 256
SP = SP - 1 ' z80.decSP
poke SP, NH
SP = SP - 1 'z80.decSP
poke SP, NL
PC = nn
End Sub

Sub PUSH_(ByVal NH As Long, ByVal NL As Long)
z80.decSP: poke SP, NH
z80.decSP: poke SP, NL
End Sub

Sub PUSHxx_(ByVal nn As Long)
Dim NH As Long
Dim NL As Long
NH = nn \ 256
NL = nn - NH * 256
z80.decSP: poke SP, NH
z80.decSP: poke SP, NL
End Sub

Sub INT38h_()
Dim NH As Long
Dim NL As Long
NH = PC \ 256: NL = PC - NH * 256
z80.decSP: poke SP, NH
z80.decSP: poke SP, NL
PC = 56: Tact = Tact + 11: r = r + 1
End Sub

Function SET_(ByVal Reg As Long, ByVal n As Long)
SET_ = Reg Or Nzt(n)
End Function

Function RES_(ByVal Reg As Long, ByVal n As Long)
nn = 255 - Nzt(n)
RES_ = Reg And nn
End Function



Sub BIT_(ByVal Reg As Long, ByVal n As Long)
'S: ismeretlen
'Z: 1-es llapotba kerl, ha a b operandus ltal specifiklt bit 0; egybknt trldik
'H: 1-es llapotba kerl
'P/V: ismeretlen
'N: trldik
'C: vltozatlan marad
FH = 1: FN = 0: ' FS = 0: FP = 0
If Bit(Reg, n) Then FZ = 0: FS = 1: FP = 0 Else FZ = 1: FS = 0: FP = 1
If Reg > 127 Then FS = 0 Else FS = 1
FP = FZ
If n = 7 And FZ = 0 Then FS = 1 Else FS = 0

End Sub

Function RR_(ByVal n As Long)
'S: 1-es llapotba kerl, ha. a mvelet utn az akkumultor tartalma negatv; egybknt trldik
'Z: 1-es llapotba kerl, ha a mvelet utn az akkumultor tartalma nulla; egybknt trldik
'H: trldik
'P/V: 1-es llapotba kerl pros parits esetben; egybknt trldik
'N: trldik
'C: az m operandus ltal meghatrozott byte 0-s bitjnek tartalmt veszi fel
N1 = FC
If Bit(n, 0) Then
n = n \ 2: FC = 1
Else: n = n \ 2: FC = 0
End If
If N1 Then n = n + 128
If n > 127 Then FS = 1 Else FS = 0
'FP = BitP(n, 0)
If Bit(n, 0) = 0 Then FP = 1 Else FP = 0
If n Then FZ = 0 Else FZ = 1 ': FP = 1
FP = Parity(n)
FH = 0: FN = 0
RR_ = n
End Function

Function RRD_()
'S: 1-es llapotba kerl, ha a mvelet utn az akkumultor tartalma negatv, egybknt trldik
'Z: 1-es llapotba kerl, ha a mvelet utn az akkumultor tartalma nulla; egybknt trldik
'H: trldik
'P/V: 1-es llapotba kerl, ha a mvelet utn az akkumultor tartalma pros parits; egybknt trldik
'N: trldik
'C: vltozatlan marad
Dim aHI As Long: Dim aLO As Long
Dim mHI As Long: Dim mLO As Long
Dim aMEM As Long: Dim mMEM As Long

aMEM = a: mMEM = peek(H * 256 + L)
mMEM = mMEM And 15
a = (a And 240) + mMEM

aMEM = aMEM And 15
mMEM = peek(H * 256 + L) \ 16
poke H * 256 + L, aMEM * 16 + mMEM

FH = 0: FN = 0
If a > 127 Then FS = 1 Else FS = 0
If a = 0 Then FZ = 1 Else FZ = 0
FP = Parity(a)

End Function

Function RLD_()
'S: 1-es llapotba kerl, ha a mvelet utn az akkumultor tartalma negatv, egybknt trldik
'Z: 1-es llapotba kerl, ha a mvelet utn az akkumultor tartalma nulla; egybknt trldik
'H: trldik
'P/V: 1-es llapotba kerl, ha a mvelet utn az akkumultor tartalma pros parits; egybknt trldik
'N: trldik
'C: vltozatlan marad
Dim aHI As Long: Dim aLO As Long
Dim mHI As Long: Dim mLO As Long
Dim aMEM As Long: Dim mMEM As Long

aMEM = a: mMEM = peek(H * 256 + L)
a = a And 240: a = a + mMEM \ 16

aMEM = aMEM And 15
mMEM = (aMEM + (mMEM * 16)) And 255
poke H * 256 + L, mMEM

FH = 0: FN = 0
If a > 127 Then FS = 1 Else FS = 0
If a = 0 Then FZ = 1 Else FZ = 0
FP = Parity(a)

End Function


Function RL_(ByVal n As Long)
'S: 1-es llapotba kerl, ha, az eredmny negatv; egybknt trldik
'Z: 1-es llapotba kerl, ha az eredmny nulla; egybknt trldik
'H: trldik
'P/V: 1-es llapotba kerl pros parits esetn; egybknt trldik
'N: trldik
'C: az m operandus ltal meghatrozott byte 7-es bitjnek tartalmt veszi fel

n = n * 2 + FC
If n > 255 Then n = n - 256: FC = 1 Else FC = 0
If n > 127 Then FS = 1 Else FS = 0
If n = 0 Then FZ = 1 Else FZ = 0
FP = Parity(n)
FH = 0: FN = 0
RL_ = n

'N1 = FC
'If n > 127 Then FC = 1 Else FC = 0
'n = n * 2
'n = n + N1
'If n > 255 Then n = n - 256
'If n > 127 Then FS = 1 Else FS = 0
'If n = 0 Then FZ = 1 Else FZ = 0
'FP = Parity(n)
'FH = 0: FN = 0
'RL_ = n
End Function

Function SRA_(ByVal n As Long)
'S: 1-es llapotba kerl, ha az eredmny negatv; egybknt trldik
'Z: 1-es llapotba kerl, ha az eredmny nulla; egybknt trldik
'H: trldik
'P/V: 1-es llapotba kerl pros parits esetn; egybknt trldik
'N: trldik
'C: az m operandus ltal meghatrozott byte 7-es bitjnek tartalmt veszi fel

Dim N1 As Long
FH = 0: FN = 0
FC = Bit(n, 0)
FS = Bit(n, 7)

n = n \ 2 + FS * 128
If n = 0 Then FZ = 1 Else FZ = 0
FP = Parity(n)
SRA_ = n
End Function

Function SLA_(ByVal n As Long) As Long
FH = 0: FN = 0
If n > 127 Then FC = 1 Else FC = 0
n = n * 2
If n > 255 Then n = n - 256

If n > 127 Then FS = 1 Else FS = 0
If n = 0 Then FZ = 1 Else FZ = 0
If Bit(n, 0) Then FP = 0 Else FP = 1
SLA_ = n
FP = Parity(n)
End Function

Function SRL_(ByVal n As Long) As Long
If n = 0 Then
FS = 0: FZ = 1: FH = 0: FP = 1: FN = 0: FC = 0: SRL_ = 0: Exit Function
End If

If Bit(n, 0) Then FC = 1 Else FC = 0
n = n \ 2
FS = 0
If n = 0 Then FZ = 1 Else FZ = 0
FH = 0: FN = 0
If Bit(n, 0) Then FP = 0 Else FP = 1
SRL_ = n

FP = Parity(n)
End Function


Function RRC_(ByVal n As Long) As Long
'S: 1-es llapotba kerl, ha az eredmny negatv; egybknt trldik
'Z: 1-es llapotba kerl, ha az eredmny nulla, egybknt trldik
'H: trldik
'P/V: 1-es llapotba kerl pros parits esetn; egybknt trldik
'N: trldik
'C: az m operandus ltal meghatrozott byte 0-s bitjnek tartalommt veszi fel

If Bit(n, 0) Then FC = 1 Else FC = 0
n = n \ 2 + FC * 128

FH = 0: FN = 0
If n > 127 Then FS = 1 Else FS = 0
If n = 0 Then FZ = 1 Else FZ = 0
FP = Parity(n)
RRC_ = n

End Function

Function RLC_(ByVal n As Long) As Long
'S: 1-es llapotba kerl, ha az eredmny negatv; egybknt trldik
'Z: 1-es llapotba kerl, ha az eredmny nulla; egybknt trldik
'H: trldik
'P/V: 1-es llapotba kerl pros parits esetn; egybknt trldik
'N: trldik
'C: az r ltal specifiklt regiszter 7-es bitjnek tartalmt veszi fel

n = n * 2
If n > 255 Then FC = 1: n = n - 255 Else FC = 0 ' trukkos +1
If n > 127 Then FS = 1 Else FS = 0
If n Then FZ = 0 Else FZ = 1
FH = 0: FN = 0
RLC_ = n
FP = Parity(n)
If n > 127 Then FS = 1 Else FS = 0

End Function

Sub RST_(ByVal n As Long)
PC = PC + 1
NH = PC \ 256: NL = PC - NH * 256
z80.decSP: poke SP, NH
z80.decSP: poke SP, NL
PC = n
End Sub

Function GetMnemonic2(ByRef OPcodex, ByRef PREfixx) As String
'Mnemonic lekepzese
Dim infox As String
Dim aax As String
Dim aa2x As String
Dim aa1x As String
Dim bbx As String
Dim nnx As Long
infox = ">" & PREfixx & Hex00(OPcodex) & " "
nnx = InStr(1, Z80OPCodes, infox)
If nnx = 0 Then GetMnemonic2 = "NO VALID!": Exit Function
aax = Mid(Z80OPCodes, nnx + 7, 50)
nnx = InStr(1, aax, Chr(13), vbBinaryCompare)
GetMnemonic2 = Trim(Left(aax, nnx - 1))
'nnx = InStr(1, aax, "  ", vbBinaryCompare)
'If nnx Then aax = Left(aax, nnx - 1)

'(pc+e)
'Nn = InStr(1, aa, "(#PC+e)", vbBinaryCompare)
'If Nn Then
'aa1 = "$+" & Hex00(IND) & "H"
'aa2 = Mid(aa, Nn + 6, 255)
'aa = Left(aa, Nn - 1) & aa1 & aa2
'End If

'(nn)
'Nn = InStr(1, aa, "(#nn)", vbBinaryCompare)
'If Nn Then
'aa2 = Mid(aa, Nn + 4, 255)
'aa = Left(aa, Nn - 1) & "(" & Hex(peek(PCm + 2) * 256 + peek(PCm + 1)) & "H" & ")" & aa1 & aa2
'End If


'(IX+d)
'Nn = InStr(1, aa, "(#IX+d)", vbBinaryCompare)
'If Nn Then
'aa1 = "(IX+" & Hex00(IND) & "H"
'aa2 = Mid(aa, Nn + 6, 255) & ")"
'aa = Left(aa, Nn - 1) & aa1 & aa2
'End If

'(IY+d)
'Nn = InStr(1, aa, "(#IY+d)", vbBinaryCompare)
'If Nn Then
'aa1 = "(IY+" & Hex00(IND) & "H"
'aa2 = Mid(aa, Nn + 6, 255) & ")"
'aa = Left(aa, Nn - 1) & aa1 & aa2
'End If

'nn
'Nn = InStr(1, aa, "#nn", vbBinaryCompare)
'If Nn Then
'aa2 = Mid(aa, Nn + 4, 255)
'aa = Left(aa, Nn - 1) & Hex0000(peek(PCm + 2) * 256 + peek(PCm + 1)) & "H" & aa1 & aa2
'End If

'n
'Nn = InStr(1, aa, "#n", vbBinaryCompare)
'If Nn Then
'aa2 = Mid(aa, Nn + 4, 255)
'aa = Left(aa, Nn - 1) & Hex00(peek(PCm + 1)) & "H" & aa1 & aa2
'End If

End Function

Function GetMnemonic(ByRef PC, ByRef PREfix) As String
'Mnemonic lekepzese
Dim infox As String
Dim aax As String
Dim aa2x As String
Dim aa1x As String
Dim bbx As String
Dim nnx As Long
infox = ">" & PREfix & Hex00(OPcode) & " "
nnx = InStr(1, Z80OPCodes, infox)
If nnx = 0 Then GetMnemonic = "Unknown!": Exit Function
aax = Mid(Z80OPCodes, nnx + 7, 50)
nnx = InStr(1, aax, Chr(13), vbBinaryCompare)
GetMnemonic = Trim(Left(aax, nnx - 1))
'nnx = InStr(1, aax, "  ", vbBinaryCompare)
'If nnx Then aax = Left(aax, nnx - 1)

'(pc+e)
'Nn = InStr(1, aa, "(#PC+e)", vbBinaryCompare)
'If Nn Then
'aa1 = "$+" & Hex00(IND) & "H"
'aa2 = Mid(aa, Nn + 6, 255)
'aa = Left(aa, Nn - 1) & aa1 & aa2
'End If

'(nn)
'Nn = InStr(1, aa, "(#nn)", vbBinaryCompare)
'If Nn Then
'aa2 = Mid(aa, Nn + 4, 255)
'aa = Left(aa, Nn - 1) & "(" & Hex(peek(PCm + 2) * 256 + peek(PCm + 1)) & "H" & ")" & aa1 & aa2
'End If


'(IX+d)
'Nn = InStr(1, aa, "(#IX+d)", vbBinaryCompare)
'If Nn Then
'aa1 = "(IX+" & Hex00(IND) & "H"
'aa2 = Mid(aa, Nn + 6, 255) & ")"
'aa = Left(aa, Nn - 1) & aa1 & aa2
'End If

'(IY+d)
'Nn = InStr(1, aa, "(#IY+d)", vbBinaryCompare)
'If Nn Then
'aa1 = "(IY+" & Hex00(IND) & "H"
'aa2 = Mid(aa, Nn + 6, 255) & ")"
'aa = Left(aa, Nn - 1) & aa1 & aa2
'End If

'nn
'Nn = InStr(1, aa, "#nn", vbBinaryCompare)
'If Nn Then
'aa2 = Mid(aa, Nn + 4, 255)
'aa = Left(aa, Nn - 1) & Hex0000(peek(PCm + 2) * 256 + peek(PCm + 1)) & "H" & aa1 & aa2
'End If

'n
'Nn = InStr(1, aa, "#n", vbBinaryCompare)
'If Nn Then
'aa2 = Mid(aa, Nn + 4, 255)
'aa = Left(aa, Nn - 1) & Hex00(peek(PCm + 1)) & "H" & aa1 & aa2
'End If

End Function

Function Hex00(Value)
Hex00 = Hex(Value)
If Len(Hex00) = 1 Then Hex00 = "0" & Hex00
End Function

Function Hex0000(Value)
Dim hossz As Long
Hex0000 = Hex(Value)
hossz = Len(Hex0000)
If Len(Hex0000) < 4 Then Hex0000 = String(4 - hossz, "0") & Hex0000
End Function

Function cmp2(ByVal q As Long) As Long
'kettes komplemens 8bit
If q > 127 Then q = q - 256
cmp2 = q
End Function

Function cmp22(ByVal q As Long) As Long
'kettes komplemens 16bit
If q > 32767 Then q = q - 65536
cmp22 = q
End Function

Private Function ParityCalc(ByVal q As Long) As Long
'Parity = 0

If Bit(q, 7) Then ParityCalc = ParityCalc + 1
If Bit(q, 6) Then ParityCalc = ParityCalc + 1
If Bit(q, 5) Then ParityCalc = ParityCalc + 1
If Bit(q, 4) Then ParityCalc = ParityCalc + 1
If Bit(q, 3) Then ParityCalc = ParityCalc + 1
If Bit(q, 2) Then ParityCalc = ParityCalc + 1
If Bit(q, 1) Then ParityCalc = ParityCalc + 1
If Bit(q, 0) Then ParityCalc = ParityCalc + 1
If Bit(ParityCalc, 0) Then ParityCalc = 0 Else ParityCalc = 1

End Function

Function Parity(ByVal q As Long) As Long
Parity = ParityCalc(q)
End Function

Function IN_C() As Long
'IN r,(C)

'S: 1-es llapotba kerl, ha a beolvasott adat negatv; egybknt trlodik
'Z: 1-es llapotba kerl, ha a beolvasott adat nulla; egybknt trlodik
'H: trlodik
'P/V: 1-es llapotba kerl, pros parits esetn; egybknt trlodik
'N: trlodik
'C: vltozatlan marad
IN_C = Pin(C)
If IN_C > 127 Then FS = 1 Else FS = 0
If IN_C = 0 Then FZ = 1 Else FZ = 0
FH = 0: FN = 0
FP = Parity(IN_C)

End Function

Function DAA_1()

Dim Ah As Long: Dim Al As Long
Dim CORR As Long
'A = 2: FH = 1: FN = 0: FC = 1

''Beep 1000, 2
'Screen1.BackColor = Rnd * QBColor(15)
Ah = a And 240: Ah = Ah \ 16
Al = a And 15
'**********************
'If A = 0 Then A = 160: GoTo correct
'If A = 16 Then A = 176: GoTo correct
'If A = 32 Then A = 176 + 16: GoTo correct
'If A = 48 Then A = 176 + 32: GoTo correct
'If A = 64 Then A = 176 + 48: GoTo correct
'If A = 80 Then A = 176 + 64: GoTo correct
'If A = 96 Then A = 176 + 80: GoTo correct

If FN = 0 Then
If Ah < 10 Then If Al < 10 Then If FC = 0 Then If FH = 0 Then CORR = 0: FC = 0: GoTo w1
If Ah < 9 Then If Al > 9 Then If FC = 0 Then If FH = 0 Then CORR = 6: FC = 0: GoTo w1
If Ah < 10 Then If Al < 4 Then If FC = 0 Then If FH = 1 Then CORR = 6: FC = 0: GoTo w1
If Ah > 9 Then If Al < 10 Then If FC = 0 Then If FH = 0 Then CORR = 96: FC = 1: GoTo w1
If Ah > 8 Then If Al > 9 Then If FC = 0 Then If FH = 0 Then CORR = 102: FC = 1: GoTo w1
If Ah > 9 Then If Al < 4 Then If FC = 0 Then If FH = 1 Then CORR = 102: FC = 1: GoTo w1
If Ah < 3 Then If Al < 10 Then If FC = 1 Then If FH = 0 Then CORR = 96: FC = 1: GoTo w1
If Ah < 3 Then If Al > 9 Then If FC = 1 Then If FH = 0 Then CORR = 102: FC = 1: GoTo w1
If Ah < 4 Then If Al < 4 Then If FC = 1 Then If FH = 1 Then CORR = 102: FC = 1: GoTo w1

'If FH = 0 Then If FC = 1 Then A = A + 96:  GoTo w2
'If FH = 1 Then If FC = 1 Then A = A + 102: GoTo w2
w1:
GoTo correct
End If

If FN = 1 Then
If Ah < 10 Then If Al < 10 Then If FC = 0 Then If FH = 0 Then CORR = 0: FC = 0: GoTo w2
If Ah < 9 Then If Al > 5 Then If FC = 0 Then If FH = 1 Then CORR = 250: FC = 0: GoTo w2
If Ah > 6 Then If Al < 10 Then If FC = 1 Then If FH = 0 Then CORR = 160: FC = 1: GoTo w2
If Ah > 5 Then If Al > 5 Then If FC = 1 Then If FH = 1 Then CORR = 154: FC = 1: GoTo w2
'If FH Then If FC Then A = A + 154:  GoTo w2
w2:
GoTo correct
End If

correct:
a = a + CORR
If a > 255 Then a = a - 256
If a < 0 Then a = 256 + a
If a > 255 Then a = a - 256
If a < 0 Then a = 256 + a

If a > 255 Then MsgBox "hibaaa+"
If a < 0 Then MsgBox "hibaaa-"

'MsgBox "DAA"
If Bit(a, 7) Then FS = 1 Else FS = 0
If a = 0 Then FZ = 1 Else FZ = 0
FP = Parity(a)

End Function

Function DAA_2()
Dim Ah As Long: Dim Al As Long
Dim CORR As Long
'A = 2: FH = 1: FN = 0: FC = 1

''Beep 1000, 2
'Screen1.BackColor = Rnd * QBColor(15)
Ah = a And 240: Ah = Ah \ 16
Al = a And 15


'***********************************************************
'Flags set   Byte (0..9)(0..9)
' * --------------------------------------------
' * (None)   + &00
' * Carry:+ &60
' * Subtract:+ &00
' * Subtract+Carry:+ &A0
' * Half-carry:+ &06
' * Half-carry+Carry:+ &66
' * Half-carry+Subtract:+ &FA
' * Half-carry+Subtract+Carry:+ &9A
' *
If Ah < 10 Then
If Al < 10 Then
CORR = 0
If FC Then CORR = 96
If FN Then CORR = 0
If FN And FC Then CORR = 160
If FH Then CORR = 6
If FH And FC Then CORR = 102
If FH And FN Then CORR = 250
If FH And FN And FC Then CORR = 154
GoTo correct
End If
End If

'***********************************************************
'* Flags set   Byte (0..9)(A..F)
'* --------------------------------------------
'* (None)   + &06
'* Carry:+ &66
'* Subtract:+ &00
'* Subtract+Carry:+ &a0
'* Half-carry:+ &06
'* Half-carry+Carry:+ &66
'* Half-carry+Subtract:+ &fa
'* Half-carry+Subtract+Carry:+ &9A
If Ah < 10 Then
If Al > 9 Then
'102
CORR = 6
If FC Then CORR = 102
If FN Then CORR = 0
If FN And FC Then CORR = 160
If FH Then CORR = 6
If FH And FC Then CORR = 102
If FH And FN Then CORR = 250
If FH And FN And FC Then CORR = 154
'If Ah = 9 Then Corr = 102


GoTo correct
End If
End If

'***********************************************************
'* Flags set   Byte (A..F)(0..9)
' * --------------------------------------------
' * (None)   + &60
' * Carry:+ &60
' * Subtract:+ &00
' * Subtract+Carry:+ &A0
' * Half-carry:+ &66
' * Half-carry+Carry:+ &66
' * Half-carry+Subtract:+ &fa
' * Half-carry+Subtract+Carry:+ &9A
If Ah > 9 Then
If Al < 10 Then
CORR = 96
If FC Then CORR = 96
If FN Then CORR = 0
If FN And FC Then CORR = 160
If FH Then CORR = 102
If FH And FC Then CORR = 102
If FH And FN Then CORR = 250
If FH And FN And FC Then CORR = 154
GoTo correct
End If
End If

'***********************************************************
' * Flags set   Byte (A..F)(A..F)
' * --------------------------------------------
' * (None)   + &66
' * Carry:+ &66
' * Subtract:+ &00
' * Subtract+Carry:+ &a0
' * Half-carry:+ &66
' * Half-carry+Carry:+ &66
' * Half-carry+Subtract:+ &fa
' * Half-carry+Subtract+Carry:+ &9A
If Ah > 9 Then
If Al > 9 Then
CORR = 102
If FC Then CORR = 102
If FN Then CORR = 0
If FN And FC Then CORR = 160
If FH Then CORR = 102
If FH And FC Then CORR = 102
If FH And FN Then CORR = 250
If FH And FN And FC Then CORR = 154
GoTo correct
End If
End If

correct:
DAA_2 = CORR
End Function



Function DAA_5() As Long
Dim Index As Long
'n = DAAtable(0)

 ' int index = v.Z80_A;
 '   if (v.Z80_FLAG_C) index |= 256;
 '   if (v.Z80_FLAG_H) index |= 512;
 '   if (v.Z80_FLAG_N) index |= 1024;
 '   v.Z80_A=(DAATable[index]>>8)&0xFF;
 '   index=DAATable[index];
 '   v.Z80_FLAG_S=((index&128)!=0);
 '   v.Z80_FLAG_Z=((index&64)!=0);
 '   v.Z80_FLAG_5=((index&32)!=0);
 '   v.Z80_FLAG_H=((index&16)!=0);
 '   v.Z80_FLAG_3=((index&8)!=0);
 '   v.Z80_FLAG_PV=((index&4)!=0);
 '   v.Z80_FLAG_N=((index&2)!=0);
 '   v.Z80_FLAG_C=((index&1)!=0);
 
 Index = a
 If FC Then Index = Index + 256
 If FH Then Index = Index + 512
 If FN Then Index = Index + 1024
 
a = DAAtable(Index)
a = (a \ 256) 'And 255 ' ? and 255 felesleges??


If DAAtable(Index) And 128 Then FS = 1 Else FS = 0
If DAAtable(Index) And 64 Then FZ = 1 Else FZ = 0
If DAAtable(Index) And 32 Then FY = 1 Else FY = 0
If DAAtable(Index) And 16 Then FH = 1 Else FH = 0
If DAAtable(Index) And 8 Then FX = 1 Else FX = 0
If DAAtable(Index) And 4 Then FP = 1 Else FP = 0
If DAAtable(Index) And 2 Then FN = 1 Else FN = 0
If DAAtable(Index) And 1 Then FC = 1 Else FC = 0

End Function


