/*
 * Decompiled with CFR 0.152.
 */
package emulator.tvc;

public class Keyboard {
    public static final int MATRIX_ROWS = 10;
    public static final int MATRIX_COLS = 8;
    private boolean AltPressed;
    private boolean AltGrPressed;
    private boolean CtrlPressed;
    private int[] matrix = new int[10];
    private static int[] keyMatrixHU = new int[]{52, 49, 16777453, 54, 48, 50, 51, 53, 55, 16777430, 16777459, 106, 16777468, 57, 56, 514, 82, 81, 512, 90, 59, 87, 69, 84, 85, 80, 16777466, 91, 0x1000151, 79, 73, 93, 70, 65, 111, 72, 92, 83, 68, 71, 74, 16777449, 0x1000171, 10, 0x10000E1, 76, 75, 8, 86, 89, 20, 78, 16, 88, 67, 66, 77, 45, 32, 17, 27, 46, 44, 18, 0, 37, 39, 33, 34, 40, 38, 155, 0, 100, 102, 109, 107, 98, 104};
    private static int[][] AltGrLUT = new int[][]{{44, 20, 0}, {16777453, 34, 0}, {89, 34, 1}, {88, 11, 1}, {67, 4, 1}, {86, 18, 0}, {66, 27, 1}, {78, 31, 1}, {45, 11, 0}, {49, 15, 1}, {51, 15, 0}, {81, 36, 0}, {87, 36, 1}, {70, 27, 0}, {71, 31, 0}, {16777449, 20, 1}};
    private static int[] ShiftNumLUT = new int[]{1, 5, 6, 0, 3, 8, 14, 13};

    public Keyboard() {
        this.clearMatrix();
    }

    public void clearMatrix() {
        for (int i = 0; i < 10; ++i) {
            this.matrix[i] = 255;
        }
        this.AltPressed = false;
        this.CtrlPressed = false;
        this.AltGrPressed = false;
    }

    public int getMatrixAt(int n) {
        return n < 10 ? this.matrix[n] : 255;
    }

    public void setMatrix(int n, boolean bl) {
        int n2 = -1;
        block0 : switch (n) {
            case 18: {
                if (this.AltGrPressed && !bl) {
                    this.clearMatrix();
                }
                this.AltPressed = bl;
                this.AltGrPressed = this.AltPressed && this.CtrlPressed;
                n2 = 63;
                break;
            }
            case 17: {
                if (this.AltGrPressed && !bl) {
                    this.clearMatrix();
                }
                this.CtrlPressed = bl;
                this.AltGrPressed = this.AltPressed && this.CtrlPressed;
                n2 = 59;
                break;
            }
            case 65406: {
                if (this.AltGrPressed && !bl) {
                    this.clearMatrix();
                }
                this.AltGrPressed = bl;
                n2 = 63;
                break;
            }
            case 35: {
                n2 = 60;
                break;
            }
            case 127: {
                n2 = 47;
                break;
            }
            case 522: {
                ++n2;
            }
            case 519: {
                ++n2;
            }
            case 61: {
                ++n2;
            }
            case 47: {
                ++n2;
            }
            case 517: {
                ++n2;
            }
            case 521: {
                ++n2;
            }
            case 152: {
                ++n2;
            }
            case 222: {
                ++n2;
                this.matrix[6] = bl ? this.matrix[6] & 0xFFFFFFF7 : this.matrix[6] | 8;
                n2 = ShiftNumLUT[n2];
                break;
            }
            default: {
                if (this.AltGrPressed) {
                    this.matrix[7] = this.matrix[7] | 0x11;
                    for (n2 = AltGrLUT.length - 1; n2 > -1; --n2) {
                        if (n != AltGrLUT[n2][0]) continue;
                        if (AltGrLUT[n2][2] > 0) {
                            this.matrix[6] = bl ? this.matrix[6] & 0xFFFFFFF7 : this.matrix[6] | 8;
                        }
                        n2 = AltGrLUT[n2][1];
                        break block0;
                    }
                } else {
                    for (n2 = keyMatrixHU.length - 1; n2 > -1 && n != keyMatrixHU[n2]; --n2) {
                    }
                }
            }
        }
        if (n2 > -1) {
            int n3 = n2 >> 3;
            int n4 = 7 - (n2 & 7);
            if (bl) {
                int n5 = n3;
                this.matrix[n5] = this.matrix[n5] & ~(1 << n4);
            } else {
                int n6 = n3;
                this.matrix[n6] = this.matrix[n6] | 1 << n4;
            }
        }
    }
}

