/*
 * Decompiled with CFR 0.152.
 */
package emulator.tvc;

import emulator.tvc.GUI;
import emulator.tvc.Keyboard;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;

public class KeyboardListener
implements KeyListener,
FocusListener {
    Keyboard keyboard;
    GUI gui;

    public KeyboardListener(Keyboard keyboard, GUI gUI) {
        this.keyboard = keyboard;
        this.gui = gUI;
    }

    @Override
    public void keyTyped(KeyEvent keyEvent) {
    }

    @Override
    public void keyPressed(KeyEvent keyEvent) {
        this.keyHandling(keyEvent, true);
    }

    @Override
    public void keyReleased(KeyEvent keyEvent) {
        this.keyHandling(keyEvent, false);
    }

    public void keyHandling(KeyEvent keyEvent, boolean bl) {
        int n = keyEvent.getExtendedKeyCode();
        switch (n) {
            case 118: {
                if (!bl) break;
                this.gui.tvc.WarmReset = true;
                break;
            }
            case 119: {
                if (!bl) break;
                this.gui.tvc.ColdReset = true;
                break;
            }
            case 122: {
                if (!bl) break;
                this.gui.SwitchFullScreen();
                break;
            }
            default: {
                this.keyboard.setMatrix(n, bl);
            }
        }
    }

    @Override
    public void focusGained(FocusEvent focusEvent) {
    }

    @Override
    public void focusLost(FocusEvent focusEvent) {
        this.keyboard.clearMatrix();
    }
}

