/*
 * Decompiled with CFR 0.152.
 */
package emulator.tvc;

public class MC6845 {
    public static final int HORIZONTAL_TOTAL_REG = 0;
    public static final int HORIZONTAL_DISPLAYED_REG = 1;
    public static final int SYNC_POSITION_REG = 2;
    public static final int HORIZONTAL_SYNC_WIDTH_REG = 3;
    public static final int VERTICAL_TOTAL_REG = 4;
    public static final int VERTICAL_TOTAL_ADJUST_REG = 5;
    public static final int VERTICAL_DISPLAYED_REG = 6;
    public static final int VERTICAL_SYNC_POSITION_REG = 7;
    public static final int INTERLACE_MODE_REG = 8;
    public static final int MAX_SCAN_LINE_ADDRESS_REG = 9;
    public static final int CURSOR_START_REG = 10;
    public static final int CURSOR_END_REG = 11;
    public static final int START_ADDRESS_REG1 = 12;
    public static final int START_ADDRESS_REG2 = 13;
    public static final int CURSOR_ADDRESS_REG1 = 14;
    public static final int CURSOR_ADDRESS_REG2 = 15;
    public static final int LIGHT_PEN_REG1 = 16;
    public static final int LIGHT_PEN_REG2 = 17;
    private int[] registers;
    private int address;
    private int r10_cursorMode;
    private boolean r08_interlacedMode;
    private boolean r08_interlacedMode2;
    private int h_counter = 0;
    private int line_counter = 0;
    private int row_counter = 0;
    private int field_counter = 0;
    private int ma_row_start = 0;
    private boolean odd_field = false;
    private int h_sync_counter = 0;
    private int v_sync_counter = 0;
    private boolean h_display = false;
    private boolean v_display = false;
    private boolean cursor_i = false;
    private boolean cursor_line = false;
    private boolean lpstb_i = false;
    public int RA = 0;
    public int MA = 0;
    public boolean HSYNC = false;
    public boolean VSYNC = false;
    public boolean DE = false;
    public boolean CURSOR = false;
    public boolean LPSTB = false;

    private void initRegisters() {
        this.address = 0;
        this.registers = new int[18];
    }

    public void writeReg(int n) {
        if (this.address < this.registers.length) {
            this.writeReg(this.address, n);
        }
    }

    public int readReg() {
        if (this.address < this.registers.length) {
            return this.readReg(this.address);
        }
        return this.registers[0];
    }

    private int readReg(int n) {
        if (n > 11) {
            return this.registers[n];
        }
        return 255;
    }

    private void writeReg(int n, int n2) {
        if (n < 16) {
            this.registers[n] = n2;
        }
        switch (n) {
            case 8: {
                this.r08_interlacedMode = (n2 & 1) == 1;
                this.r08_interlacedMode2 = (n2 & 3) == 3;
                break;
            }
            case 10: {
                this.r10_cursorMode = n2 >> 5 & 3;
                break;
            }
        }
    }

    public int readAddress() {
        return this.address;
    }

    public void writeAddress(int n) {
        this.address = n & 0x1F;
    }

    public MC6845() {
        this.initRegisters();
    }

    public void reset() {
        this.registers[0] = 0;
        this.registers[1] = 0;
        this.registers[2] = 0;
        this.registers[3] = 0;
        this.registers[4] = 0;
        this.registers[5] = 0;
        this.registers[6] = 0;
        this.registers[7] = 0;
        this.registers[8] = 0;
        this.registers[9] = 0;
        this.registers[10] = 0;
        this.registers[11] = 0;
        this.registers[12] = 0;
        this.registers[13] = 0;
        this.registers[14] = 0;
        this.registers[15] = 0;
        this.registers[16] = 0;
        this.registers[17] = 0;
        this.r08_interlacedMode = false;
        this.r08_interlacedMode2 = false;
        this.r10_cursorMode = 0;
        this.h_counter = 0;
        this.line_counter = 0;
        this.row_counter = 0;
        this.odd_field = false;
        this.field_counter = 0;
        this.ma_row_start = 0;
        this.h_display = false;
        this.h_sync_counter = 0;
        this.v_display = false;
        this.v_sync_counter = 0;
        this.RA = 0;
        this.MA = 0;
        this.cursor_i = false;
        this.cursor_line = false;
        this.lpstb_i = false;
        this.LPSTB = false;
        this.HSYNC = false;
        this.VSYNC = false;
        this.DE = this.h_display && this.v_display;
        this.CURSOR = false;
    }

    public void run() {
        boolean bl;
        if ((this.h_counter & 0xFF) == this.registers[0]) {
            this.h_counter = 0;
            int n = this.r08_interlacedMode2 ? this.registers[9] & 0x1E : this.registers[9];
            if ((this.row_counter & 0x7F) == this.registers[4]) {
                n += this.registers[5];
            }
            if ((this.line_counter & 0x3F) == n) {
                this.line_counter = 0;
                if ((this.row_counter & 0x7F) == this.registers[4]) {
                    this.odd_field = this.r08_interlacedMode ? !this.odd_field : false;
                    this.ma_row_start = (this.registers[12] << 8) + this.registers[13];
                    this.row_counter = 0;
                    ++this.field_counter;
                } else {
                    this.ma_row_start += this.registers[1];
                    ++this.row_counter;
                }
            } else if (this.r08_interlacedMode2) {
                this.line_counter += 2;
                this.line_counter &= 0x7E;
            } else {
                ++this.line_counter;
            }
            this.MA = this.ma_row_start;
        } else {
            ++this.h_counter;
            ++this.MA;
        }
        boolean bl2 = this.h_counter == 0;
        boolean bl3 = bl = this.h_counter == this.registers[0] >> 1;
        if (bl2) {
            this.h_display = true;
        }
        if (this.h_counter == this.registers[1]) {
            this.h_display = false;
        }
        if (this.h_counter == this.registers[2]) {
            this.HSYNC = true;
        }
        if ((this.h_sync_counter & 0xF) == (this.registers[3] & 0xF)) {
            this.HSYNC = false;
        }
        int n = this.h_sync_counter = this.HSYNC ? this.h_sync_counter + 1 : 0;
        if ((this.row_counter & 0x7F) == 0) {
            this.v_display = true;
        }
        if ((this.row_counter & 0x7F) == this.registers[6]) {
            this.v_display = false;
        }
        boolean bl4 = this.DE = this.h_display && this.v_display;
        if (!this.odd_field && bl2 || this.odd_field && bl) {
            if ((this.row_counter & 0x7F) == this.registers[7] && (this.line_counter & 0x7F) == 0 || this.VSYNC) {
                this.VSYNC = true;
                ++this.v_sync_counter;
            } else {
                this.v_sync_counter = 0;
            }
            if ((this.v_sync_counter & 0xF) == this.registers[3] >> 4 && this.VSYNC) {
                this.VSYNC = false;
            }
        }
        this.RA = this.r08_interlacedMode2 ? (this.odd_field ? this.line_counter | 1 : this.line_counter) : this.line_counter;
        if (this.DE && this.MA == (this.registers[14] << 8) + this.registers[15]) {
            if ((this.line_counter & 0x7F) == 0) {
                this.cursor_line = false;
            }
            if ((this.line_counter & 0x7F) == this.registers[10]) {
                this.cursor_line = true;
            }
            this.cursor_i = this.cursor_line;
            if ((this.line_counter & 0x7F) == this.registers[11]) {
                this.cursor_line = false;
            }
        } else {
            this.cursor_i = false;
        }
        boolean bl5 = this.r10_cursorMode == 0 ? this.cursor_i : (this.r10_cursorMode == 1 ? false : (this.r10_cursorMode == 2 ? this.cursor_i && (this.field_counter & 0x10) != 0 : (this.CURSOR = this.cursor_i && (this.field_counter & 0x20) != 0)));
        if (this.LPSTB && !this.lpstb_i) {
            this.registers[16] = this.MA >> 8 & 0x3F;
            this.registers[17] = this.MA & 0xFF;
        }
        this.lpstb_i = this.LPSTB;
    }
}

