/*
 * Decompiled with CFR 0.152.
 */
package emulator.tvc;

import emulator.tvc.GUI;
import emulator.tvc.Log;
import emulator.tvc.Memory;
import emulator.tvc.SDcartridge;
import emulator.tvc.Screen;
import java.awt.Dimension;
import java.awt.RenderingHints;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.File;
import java.io.IOException;
import java.text.ParseException;
import java.util.prefs.BackingStoreException;
import java.util.prefs.Preferences;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JFormattedTextField;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JTextPane;
import javax.swing.JToggleButton;
import javax.swing.filechooser.FileNameExtensionFilter;
import javax.swing.text.MaskFormatter;

public class MenuController
implements ActionListener,
ItemListener {
    public static final String MEMSAVE_DEFAULT = "save.jtvc";
    public static final String CAS_DIR_KEY = "cas_file_path";
    public static final String MEM_DIR_KEY = "mem_file_path";
    private Preferences prefs;
    private GUI gui;
    private Log log;

    public MenuController(GUI gUI) {
        this.gui = gUI;
        this.log = Log.getInstance();
        this.prefs = Preferences.userRoot();
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        this.log.write(actionEvent.getActionCommand());
        if ("ACTIONCOMMAND_EXIT".equals(actionEvent.getActionCommand())) {
            this.gui.tvc.shutdown();
        } else if ("ACTIONCOMMAND_SCALE_FAST".equals(actionEvent.getActionCommand())) {
            this.gui.screen.setScalingQuality(RenderingHints.VALUE_INTERPOLATION_NEAREST_NEIGHBOR);
        } else if ("ACTIONCOMMAND_SCALE_SMOOTH".equals(actionEvent.getActionCommand())) {
            this.gui.screen.setScalingQuality(RenderingHints.VALUE_INTERPOLATION_BILINEAR);
        } else if ("ACTIONCOMMAND_COLORKILL_ON".equals(actionEvent.getActionCommand())) {
            this.gui.screen.setColorKillEnable(0);
        } else if ("ACTIONCOMMAND_COLORKILL_OFF".equals(actionEvent.getActionCommand())) {
            this.gui.screen.setColorKillEnable(1);
        } else if ("ACTIONCOMMAND_SCREENSIZE_05X".equals(actionEvent.getActionCommand())) {
            Screen cfr_ignored_0 = this.gui.screen;
            Screen cfr_ignored_1 = this.gui.screen;
            Dimension dimension = new Dimension(592 / 2, 512 / 2);
            this.gui.screen.setPreferredSize(dimension);
            this.gui.mainFrame.pack();
        } else if ("ACTIONCOMMAND_SCREENSIZE_1X".equals(actionEvent.getActionCommand())) {
            Screen cfr_ignored_2 = this.gui.screen;
            Screen cfr_ignored_3 = this.gui.screen;
            Dimension dimension = new Dimension(592, 512);
            this.gui.screen.setPreferredSize(dimension);
            this.gui.mainFrame.pack();
        } else if ("ACTIONCOMMAND_SCREENSIZE_2X".equals(actionEvent.getActionCommand())) {
            Screen cfr_ignored_4 = this.gui.screen;
            Screen cfr_ignored_5 = this.gui.screen;
            Dimension dimension = new Dimension(2 * 592, 2 * 512);
            this.gui.screen.setPreferredSize(dimension);
            this.gui.mainFrame.pack();
        } else if ("ACTIONCOMMAND_FULLSCREEN".equals(actionEvent.getActionCommand())) {
            this.gui.SwitchFullScreen();
        } else if ("ACTIONCOMMAND_SAVE_BIN".equals(actionEvent.getActionCommand())) {
            this.actionCommandSaveBinary();
        } else if ("ACTIONCOMMAND_LOAD_BIN".equals(actionEvent.getActionCommand())) {
            this.actionCommandLoadBinary();
        } else if ("ACTIONCOMMAND_LOAD_CAS".equals(actionEvent.getActionCommand())) {
            this.actionCommandLoadCas();
        } else if ("ACTIONCOMMAND_OPEN_SD0".equals(actionEvent.getActionCommand())) {
            this.actionCommandOpenSD(0);
        } else if ("ACTIONCOMMAND_OPEN_SD1".equals(actionEvent.getActionCommand())) {
            this.actionCommandOpenSD(1);
        } else if ("ACTIONCOMMAND_RESET_COLD".equals(actionEvent.getActionCommand())) {
            this.gui.tvc.ColdReset = true;
        } else if ("ACTIONCOMMAND_RESET_WARM".equals(actionEvent.getActionCommand())) {
            this.gui.tvc.WarmReset = true;
        } else if ("ACTIONCOMMAND_TRACE_ENABLE".equals(actionEvent.getActionCommand())) {
            this.gui.TraceButtonsEnable();
        } else if ("ACTIONCOMMAND_ABOUT".equals(actionEvent.getActionCommand())) {
            this.actionCommandAbout();
        }
    }

    private void actionCommandAbout() {
        JTextPane jTextPane = new JTextPane();
        jTextPane.setContentType("text/html");
        jTextPane.setText("<html>Java TVC Emulator<br/>Version 0.2.0<br/>&copy;2003-2005 Hoffer G&aacute;bor<br/>&copy;2013 Szabados Ern&ouml;<br/>&copy;2018 Sebesty&eacute;n P&aacute;l<br/></html>");
        JOptionPane.showMessageDialog(this.gui.mainFrame, jTextPane, "About", 1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void actionCommandSaveBinary() {
        this.log.write("actionCommandSaveBinary");
        try {
            this.gui.tvc.stop();
            MaskFormatter maskFormatter = new MaskFormatter("HHHH");
            JFormattedTextField jFormattedTextField = new JFormattedTextField(maskFormatter);
            jFormattedTextField.setColumns(5);
            jFormattedTextField.setValue("0000");
            JFormattedTextField jFormattedTextField2 = new JFormattedTextField(maskFormatter);
            jFormattedTextField2.setColumns(5);
            jFormattedTextField2.setValue("4000");
            String[] stringArray = new String[]{"U0", "U1", "U2", "U3", "VID"};
            JComboBox<String> jComboBox = new JComboBox<String>(stringArray);
            JComponent[] jComponentArray = new JComponent[]{new JLabel("Memory Page"), jComboBox, new JLabel("Offset (0x)"), jFormattedTextField, new JLabel("Size (0x)"), jFormattedTextField2};
            int n = JOptionPane.showOptionDialog(null, jComponentArray, "Save Memory contents to file...", 2, -1, null, null, null);
            this.log.write("C:" + n);
            if (n == 0) {
                String string = this.prefs.get(MEM_DIR_KEY, System.getProperty("user.home"));
                this.log.write("Save binary:" + string);
                JFileChooser jFileChooser = new JFileChooser(new File(string));
                jFileChooser.setApproveButtonText("Save");
                jFileChooser.setDialogTitle("Enter filename to save binary data...");
                jFileChooser.setFileSelectionMode(0);
                int n2 = jFileChooser.showOpenDialog(this.gui.mainFrame);
                if (n2 == 0) {
                    int n3 = Integer.parseInt(jFormattedTextField2.getText(), 16);
                    int n4 = Integer.parseInt(jFormattedTextField.getText(), 16);
                    String string2 = (String)jComboBox.getSelectedObjects()[0];
                    Memory.Page page = this.gui.tvc.getMemory().getPageByName(string2);
                    File file = jFileChooser.getSelectedFile();
                    this.gui.tvc.getFileIO().saveBinary(file.getAbsolutePath(), page, n4, n3);
                    string = file.getParent();
                    this.prefs.put(MEM_DIR_KEY, string);
                    this.prefs.flush();
                }
            }
        }
        catch (ParseException parseException) {
        }
        catch (IOException iOException) {
            JOptionPane.showMessageDialog(this.gui.screen, "Save failed", iOException.getLocalizedMessage(), 0);
        }
        catch (BackingStoreException backingStoreException) {
            this.log.write(backingStoreException.getMessage());
        }
        finally {
            this.gui.tvc.start();
            this.gui.screen.requestFocusInWindow();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void actionCommandLoadBinary() {
        this.log.write("actionCommandLoadBinary");
        try {
            this.gui.tvc.stop();
            String string = this.prefs.get(MEM_DIR_KEY, System.getProperty("user.home"));
            this.log.write("Load Binary:" + string);
            JFileChooser jFileChooser = new JFileChooser(new File(string));
            jFileChooser.setApproveButtonText("Load");
            jFileChooser.setDialogTitle("Select file to load binary data...");
            jFileChooser.setFileSelectionMode(0);
            int n = jFileChooser.showOpenDialog(this.gui.mainFrame);
            if (n == 0) {
                MaskFormatter maskFormatter = new MaskFormatter("HHHH");
                JFormattedTextField jFormattedTextField = new JFormattedTextField(maskFormatter);
                jFormattedTextField.setColumns(5);
                jFormattedTextField.setValue("0000");
                String[] stringArray = new String[]{"U0", "U1", "U2", "U3", "VID"};
                JComboBox<String> jComboBox = new JComboBox<String>(stringArray);
                JComponent[] jComponentArray = new JComponent[]{new JLabel("Page"), jComboBox, new JLabel("Offset (0x)"), jFormattedTextField};
                int n2 = JOptionPane.showOptionDialog(null, jComponentArray, "Load Memory contents from file...", 2, -1, null, null, null);
                this.log.write("C:" + n2);
                if (n2 == 0) {
                    int n3 = Integer.parseInt(jFormattedTextField.getText(), 16);
                    String string2 = (String)jComboBox.getSelectedObjects()[0];
                    Memory.Page page = this.gui.tvc.getMemory().getPageByName(string2);
                    File file = jFileChooser.getSelectedFile();
                    this.gui.tvc.getFileIO().loadBinary(file.getAbsolutePath(), page, n3);
                    string = file.getParent();
                    this.prefs.put(MEM_DIR_KEY, string);
                    this.prefs.flush();
                }
            }
        }
        catch (ParseException parseException) {
        }
        catch (IOException iOException) {
            JOptionPane.showMessageDialog(this.gui.screen, "Load error", iOException.getLocalizedMessage(), 0);
        }
        catch (BackingStoreException backingStoreException) {
            this.log.write(backingStoreException.getMessage());
        }
        finally {
            this.gui.tvc.start();
            this.gui.screen.requestFocusInWindow();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void actionCommandLoadCas() {
        try {
            this.gui.tvc.stop();
            String string = this.prefs.get(CAS_DIR_KEY, System.getProperty("user.home"));
            this.log.write("Load CAS:" + string);
            JFileChooser jFileChooser = new JFileChooser(new File(string));
            jFileChooser.setFileSelectionMode(0);
            jFileChooser.setDialogTitle("Select CAS file for direct load.");
            jFileChooser.setApproveButtonText("Load");
            FileNameExtensionFilter fileNameExtensionFilter = new FileNameExtensionFilter("Casette files (*.cas)", "CAS", "cas");
            jFileChooser.addChoosableFileFilter(fileNameExtensionFilter);
            jFileChooser.setFileFilter(fileNameExtensionFilter);
            int n = jFileChooser.showOpenDialog(this.gui.mainFrame);
            if (n == 0) {
                File file = jFileChooser.getSelectedFile();
                this.gui.tvc.getFileIO().loadCAS(file.getCanonicalPath());
                string = file.getParent();
                this.prefs.put(CAS_DIR_KEY, string);
                this.prefs.flush();
            }
        }
        catch (IOException iOException) {
            this.log.write("Could not load CAS file: " + iOException.getMessage());
        }
        catch (BackingStoreException backingStoreException) {
            this.log.write("Could not save last used path: " + backingStoreException.getMessage());
        }
        finally {
            this.gui.tvc.start();
            this.gui.screen.requestFocusInWindow();
        }
    }

    private String getExtension(String string) {
        int n;
        if (string == null) {
            return null;
        }
        int n2 = string.lastIndexOf(".");
        int n3 = string.lastIndexOf("/");
        int n4 = Math.max(n3, n = string.lastIndexOf("\\"));
        return n4 > n2 ? "" : string.substring(n2 + 1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void actionCommandOpenSD(int n) {
        try {
            this.gui.tvc.stop();
            String string = this.prefs.get(CAS_DIR_KEY, System.getProperty("user.home"));
            this.log.write("Open SD image:" + string);
            JFileChooser jFileChooser = new JFileChooser(new File(string));
            jFileChooser.setFileSelectionMode(0);
            jFileChooser.setDialogTitle("Select SD card image " + n);
            jFileChooser.setApproveButtonText("Open");
            FileNameExtensionFilter fileNameExtensionFilter = new FileNameExtensionFilter("Disk image files (*.dsk, *.img)", "DSK", "dsk", "IMG", "img");
            jFileChooser.addChoosableFileFilter(fileNameExtensionFilter);
            jFileChooser.setFileFilter(fileNameExtensionFilter);
            fileNameExtensionFilter = new FileNameExtensionFilter("Binary files (*.bin)", "BIN", "bin");
            jFileChooser.addChoosableFileFilter(fileNameExtensionFilter);
            int n2 = jFileChooser.showOpenDialog(this.gui.mainFrame);
            if (n2 == 0) {
                File file = jFileChooser.getSelectedFile();
                String string2 = file.getCanonicalPath();
                String string3 = this.getExtension(file.getName());
                int n3 = string3.equals("dsk") || string3.equals("DSK") ? 1 : 2;
                SDcartridge sDcartridge = (SDcartridge)this.gui.tvc.getMemory().CART;
                sDcartridge.OpenDiskImage(string2, n3, n);
                string = file.getParent();
                this.prefs.put(CAS_DIR_KEY, string);
                this.prefs.flush();
            }
        }
        catch (IOException iOException) {
            this.log.write("Could not open image file: " + iOException.getMessage());
        }
        catch (BackingStoreException backingStoreException) {
            this.log.write("Could not save last used path: " + backingStoreException.getMessage());
        }
        finally {
            this.gui.tvc.start();
            this.gui.screen.requestFocusInWindow();
        }
    }

    @Override
    public void itemStateChanged(ItemEvent itemEvent) {
        JToggleButton jToggleButton = (JToggleButton)itemEvent.getSource();
        if ("ACTIONCOMMAND_PAUSE".equals(jToggleButton.getActionCommand())) {
            if (jToggleButton.isSelected()) {
                this.gui.tvc.stop();
            } else if (!this.gui.tvc.running) {
                this.gui.tvc.start();
            }
        } else if ("ACTIONCOMMAND_TRACE".equals(jToggleButton.getActionCommand())) {
            this.gui.z80.traceCPU = jToggleButton.isSelected() ? 10 : 0;
        }
    }
}

