/*
 * Decompiled with CFR 0.152.
 */
package emulator.tvc;

import emulator.tvc.Log;
import java.io.IOException;
import java.io.RandomAccessFile;

public class SDcard {
    public static final int SD_STATE_NOCARD = 0;
    public static final int SD_STATE_IMG_NONSTD = 1;
    public static final int SD_STATE_INSERTED = 2;
    public static final int CMD0 = 64;
    public static final int CMD1 = 65;
    public static final int CMD8 = 72;
    public static final int CMD9 = 73;
    public static final int CMD10 = 74;
    public static final int CMD12 = 76;
    public static final int CMD16 = 80;
    public static final int CMD17 = 81;
    public static final int CMD18 = 82;
    public static final int CMD24 = 88;
    public static final int CMD25 = 89;
    public static final int CMD55 = 119;
    public static final int CMD58 = 122;
    public static final int ACMD41 = 105;
    public static final int MAX_BLOCKLEN = 2048;
    public static final byte SD_RDY = -1;
    public static final byte START_RD_TOKEN = -2;
    public static final byte STOP_TRAN_TOKEN = -3;
    public static final byte START_MWR_TOKEN = -4;
    public static final byte RD_ERROR_TOKEN = 9;
    public static final byte R1_NOERROR = 0;
    public static final byte R1_IDLE = 1;
    public static final byte R1_ERASRESET = 2;
    public static final byte R1_ILLEGALCMD = 4;
    public static final byte R1_CRCERROR = 8;
    public static final byte R1_ERASERROR = 16;
    public static final byte R1_ADDRERROR = 32;
    public static final byte R1_PARAMERROR = 64;
    public static final byte DATA_ACCEPTED = 5;
    public static final byte DATA_WRERROR = 13;
    public static final byte[] CSD1v0 = new byte[]{0, 21, 0, 90, 95, 90, -128, 0, 62, -8, 79, -1, -110, -128, 64, -1};
    public static final byte[] CSD2v0 = new byte[]{64, 14, 0, 90, 91, 89, 0, 0, 1, 1, 127, -128, 10, 64, 0, -1};
    private byte[] SD_OCR = new byte[]{-128, -1, -1, 0};
    private byte[] SD_CID = new byte[]{3, 83, 68, 83, 68, 69, 77, 85, 16, 1, 2, 3, 4, 1, 9, -1};
    private byte[] SD_RespR7 = new byte[]{0, 0, 1, 0};
    private int SD_DataPtr;
    private byte[] SD_Data;
    private byte[] SD_DataBuff;
    private byte[] SD_CSD = new byte[16];
    private byte SD_RespR1;
    private byte SD_DataResponse;
    private int SD_DataLen;
    private int SD_BlockLen;
    private int SD_DataAddr;
    private int SD_CardSize;
    private boolean bSD_VERSION2;
    private boolean bSD_HC;
    private boolean bFirstData;
    private boolean bSD_MultiBlock;
    private boolean bNonStdFAT;
    private byte sdcmd;
    private byte[] cmd_array = new byte[6];
    private int cmd_counter;
    private SDCARDSTATES SDcard_state;
    private SDCARDSTATES StateAfterACMD;
    private SDCARDSTATES StateAfterR1;
    private SDCARDSTATES StateAfterR7;
    private RandomAccessFile SDImgFile = null;
    public boolean bInserted;
    public boolean bWrProt;
    public boolean bSPI_CS;
    public boolean bSPI_CS_Prev;
    public byte SPIdatain;

    public SDcard() {
        this.SD_DataBuff = new byte[2052];
    }

    private void CalcCardParams(int n) {
        if (n > 0x400000) {
            this.bSD_VERSION2 = true;
            this.bSD_HC = true;
            this.SD_OCR[0] = -64;
            for (int i = 0; i < 16; ++i) {
                this.SD_CSD[i] = CSD2v0[i];
            }
            int n2 = n / 1024 - 1;
            this.SD_CSD[8] = (byte)(n2 >> 8);
            this.SD_CSD[9] = (byte)(n2 & 0xFF);
            this.SD_BlockLen = 512;
        } else {
            this.bSD_VERSION2 = false;
            this.bSD_HC = false;
            this.SD_OCR[0] = -128;
            for (int i = 0; i < 16; ++i) {
                this.SD_CSD[i] = CSD1v0[i];
            }
            this.SD_BlockLen = n > 0x200000 ? 1024 : 512;
            int n3 = n / (this.SD_BlockLen / 512);
            int n4 = 2;
            int n5 = n3 / (1 << n4);
            while (n5 > 4096 && n4 < 9) {
                n5 = n3 / (1 << ++n4);
            }
            n5 = n5 - 1 & 0xFFF;
            this.SD_CSD[5] = n > 0x200000 ? 90 : 89;
            this.SD_CSD[6] = (byte)(this.SD_CSD[6] & 0xFC | n5 >> 10);
            this.SD_CSD[7] = (byte)(n5 >> 2 & 0xFF);
            this.SD_CSD[8] = (byte)(n5 << 6 & 0xC0 | this.SD_CSD[8] & 0x3F);
            this.SD_CSD[9] = (byte)(this.SD_CSD[9] & 0xFC | (n4 -= 2) >> 1 & 3);
            this.SD_CSD[10] = (byte)(n4 << 7 & 0x80 | this.SD_CSD[10] & 0x7F);
            this.SD_CSD[13] = n > 0x200000 ? -128 : 64;
        }
    }

    public void OpenDiskImage(String string, int n) {
        this.bInserted = false;
        this.bWrProt = true;
        if (this.SDImgFile != null) {
            try {
                this.SDImgFile.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        if (n != 0) {
            try {
                this.SDImgFile = new RandomAccessFile(string, "rw");
                this.SD_CardSize = (int)(this.SDImgFile.length() / 512L);
                this.CalcCardParams(this.SD_CardSize);
                this.SDcard_state = SDCARDSTATES.IDLE;
                this.bNonStdFAT = n == 1;
                this.bInserted = true;
                this.bWrProt = false;
            }
            catch (IOException iOException) {
                Log.getInstance().write("SD image can not open!");
            }
        }
    }

    private void RdDiskImage(int n, int n2, int n3, byte[] byArray) {
        try {
            long l = ((long)n << 9) + (long)n2;
            this.SDImgFile.seek(l);
            this.SDImgFile.read(byArray, 0, n3);
            if (n == 0 && this.bNonStdFAT && n2 < 511 && n2 + n3 > 511) {
                byArray[510 - n2] = 85;
                byArray[511 - n2] = -86;
            }
        }
        catch (IOException iOException) {
            Log.getInstance().write("SD image can not read!");
        }
    }

    private void WrDiskImage(int n, int n2, byte[] byArray) {
        try {
            long l = (long)n << 9;
            this.SDImgFile.seek(l);
            this.SDImgFile.write(byArray, 0, n2);
        }
        catch (IOException iOException) {
            Log.getInstance().write("SD image can not write!");
        }
    }

    private boolean ReceiveCMD(byte by) {
        if (this.cmd_counter == 0 && (by & 0xC0) != 64) {
            return false;
        }
        this.cmd_array[this.cmd_counter++] = by;
        if (this.cmd_counter == 6) {
            this.sdcmd = this.cmd_array[0];
            this.cmd_counter = 0;
            return true;
        }
        return false;
    }

    /*
     * Enabled aggressive block sorting
     */
    public void Send(byte by) {
        if (!this.bInserted) {
            return;
        }
        if (this.bSPI_CS) {
            if (!this.bSPI_CS_Prev) {
                this.cmd_counter = 0;
                if (this.SDcard_state != SDCARDSTATES.IDLE) {
                    this.SDcard_state = SDCARDSTATES.INITIALIZED;
                }
            }
            this.SPIdatain = (byte)-1;
            block0 : switch (this.SDcard_state) {
                case IDLE: {
                    if (!this.ReceiveCMD(by)) break;
                    this.SD_RespR1 = 1;
                    this.SDcard_state = SDCARDSTATES.SEND_R1;
                    switch (this.sdcmd) {
                        case 65: {
                            this.StateAfterR1 = SDCARDSTATES.INITIALIZED;
                            break block0;
                        }
                        case 72: {
                            if (this.bSD_VERSION2) {
                                this.SD_RespR7[3] = this.cmd_array[4];
                                this.SD_DataLen = 0;
                                this.SDcard_state = SDCARDSTATES.SEND_R1;
                                this.StateAfterR1 = SDCARDSTATES.SEND_R7;
                                this.StateAfterR7 = SDCARDSTATES.IDLE;
                                break block0;
                            }
                            this.SDcard_state = SDCARDSTATES.IDLE;
                            break block0;
                        }
                        case 119: {
                            this.StateAfterR1 = SDCARDSTATES.APPCMD;
                            this.StateAfterACMD = SDCARDSTATES.IDLE;
                            break block0;
                        }
                    }
                    this.StateAfterR1 = SDCARDSTATES.IDLE;
                    break;
                }
                case INITIALIZED: {
                    if (!this.ReceiveCMD(by)) break;
                    this.bSD_MultiBlock = false;
                    this.bFirstData = true;
                    this.SD_RespR1 = 0;
                    this.SDcard_state = SDCARDSTATES.SEND_R1;
                    this.StateAfterR1 = SDCARDSTATES.INITIALIZED;
                    switch (this.sdcmd) {
                        case 64: {
                            this.SD_RespR1 = 1;
                            this.StateAfterR1 = SDCARDSTATES.IDLE;
                            break;
                        }
                        case 65: {
                            this.StateAfterR1 = SDCARDSTATES.INITIALIZED;
                            break;
                        }
                        case 73: {
                            this.SD_Data = this.SD_CSD;
                            this.SD_DataPtr = 0;
                            this.SD_DataLen = 16;
                            this.StateAfterR1 = SDCARDSTATES.SEND_DATA;
                            break;
                        }
                        case 74: {
                            this.SD_Data = this.SD_CID;
                            this.SD_DataPtr = 0;
                            this.SD_DataLen = 16;
                            this.StateAfterR1 = SDCARDSTATES.SEND_DATA;
                            break;
                        }
                        case 76: {
                            this.StateAfterR1 = SDCARDSTATES.INITIALIZED;
                            break;
                        }
                        case 80: {
                            this.SD_BlockLen = ((this.cmd_array[1] & 0xFF) << 24) + ((this.cmd_array[2] & 0xFF) << 16) + ((this.cmd_array[3] & 0xFF) << 8) + (this.cmd_array[4] & 0xFF);
                            this.StateAfterR1 = SDCARDSTATES.INITIALIZED;
                            break;
                        }
                        case 82: {
                            this.bSD_MultiBlock = true;
                        }
                        case 81: {
                            int n;
                            this.SD_Data = this.SD_DataBuff;
                            this.SD_DataPtr = 0;
                            this.SD_DataAddr = ((this.cmd_array[1] & 0xFF) << 24) + ((this.cmd_array[2] & 0xFF) << 16) + ((this.cmd_array[3] & 0xFF) << 8) + (this.cmd_array[4] & 0xFF);
                            if (this.bSD_HC) {
                                this.SD_DataLen = 512;
                                n = 0;
                            } else {
                                this.SD_DataLen = this.SD_BlockLen <= 2048 ? this.SD_BlockLen : 2048;
                                n = this.SD_DataAddr % 512;
                                this.SD_DataAddr /= 512;
                            }
                            if (this.SD_DataAddr + this.SD_DataLen / 512 > this.SD_CardSize || this.SD_DataAddr + this.SD_DataLen / 512 == this.SD_CardSize && n != 0) {
                                this.SD_RespR1 = (byte)64;
                                this.StateAfterR1 = SDCARDSTATES.INITIALIZED;
                                break;
                            }
                            this.RdDiskImage(this.SD_DataAddr, n, this.SD_DataLen, this.SD_DataBuff);
                            this.StateAfterR1 = SDCARDSTATES.SEND_DATA;
                            break;
                        }
                        case 89: {
                            this.bSD_MultiBlock = true;
                        }
                        case 88: {
                            this.SD_DataAddr = ((this.cmd_array[1] & 0xFF) << 24) + ((this.cmd_array[2] & 0xFF) << 16) + ((this.cmd_array[3] & 0xFF) << 8) + (this.cmd_array[4] & 0xFF);
                            if (this.bSD_HC) {
                                this.SD_DataLen = 512;
                            } else {
                                int n = this.SD_DataLen = this.SD_BlockLen <= 2048 ? this.SD_BlockLen : 2048;
                                if (this.SD_DataAddr % this.SD_BlockLen != 0) {
                                    this.SD_RespR1 = (byte)32;
                                    this.StateAfterR1 = SDCARDSTATES.INITIALIZED;
                                }
                                this.SD_DataAddr /= 512;
                            }
                            if (this.SD_RespR1 == 32) break;
                            if (this.SD_DataAddr + this.SD_DataLen / 512 > this.SD_CardSize) {
                                this.SD_RespR1 = (byte)64;
                                this.StateAfterR1 = SDCARDSTATES.INITIALIZED;
                                break;
                            }
                            this.StateAfterR1 = SDCARDSTATES.RECEIVE_DATA;
                            break;
                        }
                        case 119: {
                            this.StateAfterR1 = SDCARDSTATES.APPCMD;
                            this.StateAfterACMD = SDCARDSTATES.INITIALIZED;
                            break;
                        }
                        case 122: {
                            this.SD_DataLen = 0;
                            this.StateAfterR1 = SDCARDSTATES.SEND_R3;
                            break;
                        }
                        default: {
                            this.SD_RespR1 = (byte)4;
                            break;
                        }
                    }
                    break;
                }
                case APPCMD: {
                    if (!this.ReceiveCMD(by)) break;
                    this.SDcard_state = SDCARDSTATES.SEND_R1;
                    if (this.sdcmd == 105) {
                        this.SD_RespR1 = 0;
                        this.StateAfterR1 = SDCARDSTATES.INITIALIZED;
                        break;
                    }
                    this.SD_RespR1 = (byte)4;
                    this.StateAfterR1 = this.StateAfterACMD;
                    break;
                }
                case RECEIVE_DATA: {
                    if (this.bFirstData) {
                        if (by == -3) {
                            this.SDcard_state = SDCARDSTATES.INITIALIZED;
                        }
                        if (by != -2 && by != -4) break;
                        this.SD_DataResponse = (byte)(!this.bSD_HC && this.SD_BlockLen != 512 || this.SD_DataAddr + 1 > this.SD_CardSize ? 13 : 5);
                        this.SD_Data = this.SD_DataBuff;
                        this.SD_DataPtr = 0;
                        this.SD_DataLen = 512;
                        this.bFirstData = false;
                        break;
                    }
                    if (this.SD_DataLen > 0) {
                        this.SD_Data[this.SD_DataPtr] = by;
                        ++this.SD_DataPtr;
                        --this.SD_DataLen;
                        break;
                    }
                    if (this.SD_DataLen > -2) {
                        --this.SD_DataLen;
                        break;
                    }
                    this.SPIdatain = this.SD_DataResponse;
                    if (this.SD_DataResponse != 13) {
                        this.WrDiskImage(this.SD_DataAddr, 512, this.SD_DataBuff);
                        ++this.SD_DataAddr;
                    }
                    this.bFirstData = true;
                    this.SDcard_state = this.bSD_MultiBlock ? SDCARDSTATES.RECEIVE_DATA : SDCARDSTATES.INITIALIZED;
                    break;
                }
                case SEND_DATA: {
                    if (this.ReceiveCMD(by) && this.sdcmd == 76) {
                        this.SD_RespR1 = 0;
                        this.SDcard_state = SDCARDSTATES.SEND_R1;
                        this.StateAfterR1 = SDCARDSTATES.INITIALIZED;
                        break;
                    }
                    if (this.bFirstData) {
                        this.SPIdatain = (byte)-2;
                        this.bFirstData = false;
                        break;
                    }
                    if (this.SD_DataLen > 0) {
                        this.SPIdatain = this.SD_Data[this.SD_DataPtr];
                        ++this.SD_DataPtr;
                        --this.SD_DataLen;
                        break;
                    }
                    if (this.SD_DataLen > -2) {
                        this.SPIdatain = 0;
                        --this.SD_DataLen;
                        break;
                    }
                    if (!this.bSD_MultiBlock) {
                        this.SDcard_state = SDCARDSTATES.INITIALIZED;
                        break;
                    }
                    this.SD_DataLen = this.bSD_HC ? 512 : (this.SD_BlockLen <= 2048 ? this.SD_BlockLen : 2048);
                    int n = this.SD_DataLen % 512;
                    this.SD_DataAddr += this.SD_DataLen / 512;
                    if (this.SD_DataAddr + this.SD_DataLen / 512 > this.SD_CardSize || this.SD_DataAddr + this.SD_DataLen / 512 == this.SD_CardSize && n != 0) {
                        this.SPIdatain = (byte)9;
                        this.SDcard_state = SDCARDSTATES.INITIALIZED;
                        break;
                    }
                    this.RdDiskImage(this.SD_DataAddr, n, this.SD_DataLen, this.SD_DataBuff);
                    this.SD_Data = this.SD_DataBuff;
                    this.SD_DataPtr = 0;
                    this.bFirstData = true;
                    break;
                }
                case SEND_R1: {
                    this.SPIdatain = this.SD_RespR1;
                    this.SDcard_state = this.StateAfterR1;
                    break;
                }
                case SEND_R3: {
                    this.SPIdatain = this.SD_OCR[this.SD_DataLen++];
                    if (this.SD_DataLen != 4) break;
                    this.SDcard_state = SDCARDSTATES.INITIALIZED;
                    break;
                }
                case SEND_R7: {
                    this.SPIdatain = this.SD_RespR7[this.SD_DataLen++];
                    if (this.SD_DataLen != 4) break;
                    this.SDcard_state = this.StateAfterR7;
                    break;
                }
                default: {
                    this.SDcard_state = SDCARDSTATES.IDLE;
                    break;
                }
            }
        } else {
            this.SPIdatain = (byte)-1;
        }
        this.bSPI_CS_Prev = this.bSPI_CS;
    }

    public static enum SDCARDSTATES {
        IDLE,
        INITIALIZED,
        APPCMD,
        RECEIVE_DATA,
        SEND_DATA,
        SEND_R1,
        SEND_R3,
        SEND_R7;

    }
}

