/*
 * Decompiled with CFR 0.152.
 */
package emulator.tvc;

import emulator.tvc.FileIO;
import emulator.tvc.GUI;
import emulator.tvc.Keyboard;
import emulator.tvc.KeyboardListener;
import emulator.tvc.Log;
import emulator.tvc.Memory;
import emulator.tvc.Port;
import emulator.tvc.Screen;
import emulator.tvc.Sound;
import emulator.tvc.Z80;

public class TVC
implements Runnable {
    private Memory memory;
    private Z80 z80;
    private Port port;
    private Screen screen;
    private Keyboard keyboard;
    private FileIO fileIO;
    private Log log = Log.getInstance();
    private Sound soundhw;
    private static TVC instance = null;
    public boolean running;
    public boolean SoundINT;
    public boolean WarmReset;
    public boolean ColdReset;

    public Screen getScreen() {
        return this.screen;
    }

    public Z80 getZ80() {
        return this.z80;
    }

    public Memory getMemory() {
        return this.memory;
    }

    public FileIO getFileIO() {
        return this.fileIO;
    }

    public void start() {
        this.running = true;
        new Thread(this).start();
        this.screen.transferFocus();
    }

    public void stop() {
        this.running = false;
    }

    public void shutdown() {
        this.log.write("Shutting down.");
        this.log.close();
        System.exit(0);
    }

    public TVC(GUI gUI) {
        this.log.write("Videoton TV-Computer Emulator started.");
        this.log.write("(C) Hoffer Gabor, 2003");
        this.keyboard = new Keyboard();
        this.memory = new Memory();
        this.screen = new Screen(this, this.memory);
        this.soundhw = new Sound();
        this.fileIO = new FileIO(this.memory);
        this.screen.requestFocus();
        KeyboardListener keyboardListener = new KeyboardListener(this.keyboard, gUI);
        this.screen.addKeyListener(keyboardListener);
        this.screen.addFocusListener(keyboardListener);
        this.port = new Port(this.keyboard, this.memory, this.screen, this.soundhw);
        this.z80 = new Z80(this.memory, this.port);
        this.z80.traceCPU = 0;
        this.fileIO.loadRomSet();
        this.SoundINT = false;
    }

    private void reset(boolean bl) {
        if (bl) {
            this.getMemory().U0.set(2849, 255);
        } else {
            this.getMemory().U0.set(2849, 0);
        }
        this.port.setPort(2, 0);
        this.screen.Reset();
        this.soundhw.Reset();
        this.z80.reset();
    }

    @Override
    public void run() {
        long l;
        Thread.currentThread().setPriority(1);
        this.soundhw.Open();
        this.z80.t = 0L;
        long l2 = 0L;
        long l3 = 0L;
        long l4 = l = System.currentTimeMillis();
        while (this.running) {
            if (this.ColdReset || this.WarmReset) {
                this.reset(this.ColdReset);
                this.ColdReset = false;
                this.WarmReset = false;
            }
            long l5 = this.z80.t;
            if (this.screen.getCursorInt() == 0) {
                this.z80.interrupt();
            }
            this.running = this.z80.run();
            ++l2;
            int n = (int)(this.z80.t - l5);
            this.SoundINT = this.soundhw.run(n);
            boolean bl = this.screen.run(n);
        }
        l4 = System.currentTimeMillis() - l4;
        this.log.write("Elapsed time: " + Long.toString(l4));
        this.log.write("Executed instuctions: " + Long.toString(l2));
        this.log.write("T Cycles:" + Long.toString(this.z80.t));
        double d = this.z80.t;
        double d2 = (double)l4 / 1000.0;
        this.log.write("Frequency: " + Double.toString(d / d2 / 1000000.0));
        this.soundhw.Close();
    }
}

