/*
 * Decompiled with CFR 0.152.
 */
package emulator.tvc;

import emulator.tvc.Log;
import emulator.tvc.Memory;
import java.io.DataOutputStream;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;

public class FileIO {
    public static final String ROM_TVC12_D4BIN = "/rom/TVC12_D4.BIN";
    public static final String ROM_TVC12_D3BIN = "/rom/TVC12_D3.BIN";
    public static final String ROM_TVC12_D7BIN = "/rom/TVC12_D7.BIN";
    public static final String ROM_VTDOS_CRBIN = "/rom/VTDOS_CR.BIN";
    public static final int UPM_HEADER_SIZE = 128;
    public static final int UPM_NONBUFFERED_HEADER_SIZE = 16;
    public static final int UPM_HEADER_FILETYPE_OFFSET = 0;
    public static final int UPM_HEADER_COPYPROTECT_OFFSET = 1;
    public static final int UPM_HEADER_BLOCK_NUMBER_OFFSET_LO = 2;
    public static final int UPM_HEADER_BLOCK_NUMBER_OFFSET_HI = 3;
    public static final int UPM_HEADER_LAST_BLOCK_BYTES = 4;
    public static final int UPM_HEADER_NONBUFFERED_ID = 128;
    public static final int UPM_HEADER_NONBUFFERED_TYPE = 129;
    public static final int UPM_HEADER_NONBUFFERED_SIZE_LO = 130;
    public static final int UPM_HEADER_NONBUFFERED_SIZE_HI = 131;
    public static final int UPM_HEADER_NONBUFFERED_AUTORUN = 132;
    public static final int UPM_HEADER_NONBUFFERED_VERSION = 143;
    public static final int UPM_HEADER_NONBUFFERED_DATA_START = 144;
    public static final int FILETYPE_BUFFERED = 1;
    public static final int FILETYPE_NONBUFFERED = 17;
    public static final int NONBUFFERED_AUTOSTART = 255;
    public static final int UPM_BLOCK_SIZE = 128;
    public static final int BASIC_OFFSET_START = 6639;
    private Log log = Log.getInstance();
    private Memory memory;

    public FileIO(Memory memory) {
        this.memory = memory;
    }

    public void loadCAS(String string) throws FileNotFoundException, IOException {
        int n;
        FileInputStream fileInputStream = new FileInputStream(string);
        int n2 = (int)fileInputStream.getChannel().size();
        if (n2 < 128) {
            throw new IOException("File smaller than UPM header:" + string);
        }
        int n3 = 144;
        int n4 = n2 - n3;
        fileInputStream.getChannel().position(n3);
        byte[] byArray = new byte[n4];
        fileInputStream.read(byArray);
        fileInputStream.close();
        int n5 = 0;
        Memory.Page page = this.memory.getPageByName("U0");
        for (n = 6639; n < 16384 && n5 < n4; ++n) {
            page.set(n, byArray[n5++] & 0xFF);
        }
        page = this.memory.getPageByName("U1");
        for (n = 0; n < 16384 && n5 < n4; ++n) {
            page.set(n, byArray[n5++] & 0xFF);
        }
        page = this.memory.getPageByName("U2");
        for (n = 0; n < 16384 && n5 < n4; ++n) {
            page.set(n, byArray[n5++] & 0xFF);
        }
        page = this.memory.getPageByName("U3");
        for (n = 0; n < 16384 && n5 < n4; ++n) {
            page.set(n, byArray[n5++] & 0xFF);
        }
        if ((n4 -= n5) != 0) {
            this.log.write("Memory full, D:" + n4);
        }
    }

    private void loadRom(String string, Memory.Page page, int n, int n2) throws FileNotFoundException, IOException {
        byte[] byArray = new byte[n];
        InputStream inputStream = this.getClass().getResourceAsStream(string);
        int n3 = 0;
        int n4 = 0;
        while (n4 != -1 && n3 != n) {
            n4 = inputStream.read(byArray, n3, n - n3);
            if (n4 <= 0) continue;
            n3 += n4;
        }
        inputStream.close();
        if (n3 != byArray.length) {
            throw new IOException("ROM file read error:" + string + " at:" + n3);
        }
        for (int i = 0; i < n; ++i) {
            page.setrom(i + n2, byArray[i] & 0xFF);
        }
        this.log.write("ROM " + string + " has been loaded into " + page.name + ":" + n2);
    }

    public void loadBinary(String string, Memory.Page page, int n) throws FileNotFoundException, IOException {
        FileInputStream fileInputStream = new FileInputStream(string);
        int n2 = (int)fileInputStream.getChannel().size();
        n2 = Math.min(n2, 16384 - n);
        byte[] byArray = new byte[n2];
        fileInputStream.read(byArray);
        for (int i = 0; i < n2; ++i) {
            page.set(i + n, byArray[i] & 0xFF);
        }
    }

    public void saveBinary(String string, Memory.Page page, int n, int n2) throws IOException {
        FileOutputStream fileOutputStream = new FileOutputStream(string);
        DataOutputStream dataOutputStream = new DataOutputStream(fileOutputStream);
        if (n + n2 > 16384) {
            throw new IllegalArgumentException("offset:size exceeeds page size:" + n2);
        }
        for (int i = 0; i < n2; ++i) {
            dataOutputStream.writeByte(page.get(i + n) & 0xFF);
        }
        dataOutputStream.flush();
        dataOutputStream.close();
        ((OutputStream)fileOutputStream).close();
        Log.getInstance().write("Binary data saved.");
    }

    public void loadUserMem(String string) throws FileNotFoundException, IOException {
        FileInputStream fileInputStream = new FileInputStream(string);
        byte[] byArray = new byte[6];
        int n = ((InputStream)fileInputStream).read(byArray);
        ByteBuffer byteBuffer = ByteBuffer.wrap(byArray);
        byte[] byArray2 = new byte[4];
        byteBuffer.get(byArray2);
        String string2 = new String(byArray2);
        if (!string2.equals("JTVC")) {
            throw new IOException("Magic not found:" + string2 + "]");
        }
        byte[] byArray3 = new byte[2];
        byteBuffer.get(byArray3);
        Log.getInstance().write("Version:" + byArray3[0] + "." + byArray3[1]);
        byte[] byArray4 = new byte[81920];
        n = ((InputStream)fileInputStream).read(byArray4);
        ((InputStream)fileInputStream).close();
        if (n != byArray4.length) {
            throw new IOException("File read error:" + string + " at:" + n);
        }
        for (int i = 0; i < 16384; ++i) {
            this.memory.U0.set(i, byArray4[i] & 0xFF);
            this.memory.U1.set(i, byArray4[i + 16384] & 0xFF);
            this.memory.U2.set(i, byArray4[i + 32768] & 0xFF);
            this.memory.U3.set(i, byArray4[i + 49152] & 0xFF);
            this.memory.VID.set(i, byArray4[i + 65536] & 0xFF);
        }
        Log.getInstance().write("RAM loaded.");
    }

    public void saveUserMem(String string) throws IOException {
        int n;
        FileOutputStream fileOutputStream = new FileOutputStream(string);
        DataOutputStream dataOutputStream = new DataOutputStream(fileOutputStream);
        dataOutputStream.write("JTVC".getBytes());
        dataOutputStream.write(Memory.VERSION);
        for (n = 0; n < 16384; ++n) {
            dataOutputStream.writeByte(this.memory.U0.get(n) & 0xFF);
        }
        for (n = 0; n < 16384; ++n) {
            dataOutputStream.writeByte(this.memory.U1.get(n) & 0xFF);
        }
        for (n = 0; n < 16384; ++n) {
            dataOutputStream.writeByte(this.memory.U2.get(n) & 0xFF);
        }
        for (n = 0; n < 16384; ++n) {
            dataOutputStream.writeByte(this.memory.U3.get(n) & 0xFF);
        }
        for (n = 0; n < 16384; ++n) {
            dataOutputStream.writeByte(this.memory.VID.get(n) & 0xFF);
        }
        dataOutputStream.flush();
        dataOutputStream.close();
        ((OutputStream)fileOutputStream).close();
        Log.getInstance().write("RAM dumped.");
    }

    public boolean loadRomSet() {
        try {
            this.loadRom(ROM_TVC12_D4BIN, this.memory.SYS, 8192, 0);
            this.loadRom(ROM_TVC12_D3BIN, this.memory.SYS, 8192, 8192);
            this.loadRom(ROM_TVC12_D7BIN, this.memory.EXT, 8192, 8192);
            this.loadRom(ROM_VTDOS_CRBIN, this.memory.CART, 40960, 0);
        }
        catch (FileNotFoundException fileNotFoundException) {
            this.log.write(fileNotFoundException.getMessage());
            return false;
        }
        catch (IOException iOException) {
            this.log.write(iOException.getMessage());
            return false;
        }
        this.memory.setPages(0);
        return true;
    }
}

