/*
 * Decompiled with CFR 0.152.
 */
package emulator.tvc;

import emulator.tvc.Log;
import emulator.tvc.Memory;
import emulator.tvc.MenuController;
import emulator.tvc.Screen;
import emulator.tvc.TVC;
import emulator.tvc.Z80;
import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.GridBagConstraints;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.image.BufferedImage;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JToggleButton;

public class GUI {
    public static final String FRAME_TITLE = "Videoton TV-Computer Emulator";
    public static final String ACTIONCOMMAND_TRACE = "ACTIONCOMMAND_TRACE";
    public static final String ACTIONCOMMAND_PAUSE = "ACTIONCOMMAND_PAUSE";
    public static final String ACTIONCOMMAND_SAVE_BIN = "ACTIONCOMMAND_SAVE_BIN";
    public static final String ACTIONCOMMAND_LOAD_BIN = "ACTIONCOMMAND_LOAD_BIN";
    public static final String ACTIONCOMMAND_LOAD_CAS = "ACTIONCOMMAND_LOAD_CAS";
    public static final String ACTIONCOMMAND_OPEN_SD0 = "ACTIONCOMMAND_OPEN_SD0";
    public static final String ACTIONCOMMAND_OPEN_SD1 = "ACTIONCOMMAND_OPEN_SD1";
    public static final String ACTIONCOMMAND_RESET_COLD = "ACTIONCOMMAND_RESET_COLD";
    public static final String ACTIONCOMMAND_RESET_WARM = "ACTIONCOMMAND_RESET_WARM";
    public static final String ACTIONCOMMAND_EXIT = "ACTIONCOMMAND_EXIT";
    public static final String ACTIONCOMMAND_SCALE_FAST = "ACTIONCOMMAND_SCALE_FAST";
    public static final String ACTIONCOMMAND_SCALE_SMOOTH = "ACTIONCOMMAND_SCALE_SMOOTH";
    public static final String ACTIONCOMMAND_COLORKILL_ON = "ACTIONCOMMAND_COLORKILL_ON";
    public static final String ACTIONCOMMAND_COLORKILL_OFF = "ACTIONCOMMAND_COLORKILL_OFF";
    public static final String ACTIONCOMMAND_SCREENSIZE_05X = "ACTIONCOMMAND_SCREENSIZE_05X";
    public static final String ACTIONCOMMAND_SCREENSIZE_1X = "ACTIONCOMMAND_SCREENSIZE_1X";
    public static final String ACTIONCOMMAND_SCREENSIZE_2X = "ACTIONCOMMAND_SCREENSIZE_2X";
    public static final String ACTIONCOMMAND_FULLSCREEN = "ACTIONCOMMAND_FULLSCREEN";
    public static final String ACTIONCOMMAND_TRACE_ENABLE = "ACTIONCOMMAND_TRACE_ENABLE";
    public static final String ACTIONCOMMAND_ABOUT = "ACTIONCOMMAND_ABOUT";
    public JFrame mainFrame;
    public JFrame fullFrame;
    public Button start;
    public Button stop;
    public Button trace;
    public BorderLayout layout;
    public GridBagConstraints c;
    public TVC tvc = new TVC(this);
    public Z80 z80 = this.tvc.getZ80();
    public Screen screen = this.tvc.getScreen();
    public Memory mem;
    private MenuController menuController;
    private JMenuBar menuBar;
    private JMenuItem itemEnableButtons;
    private JPanel footer;
    private JToggleButton pauseButton;
    private JToggleButton traceButton;
    private boolean FullScreen;

    public GUI() {
        this.initialize();
        this.tvc.start();
    }

    private void initialize() {
        this.menuController = new MenuController(this);
        this.menuBar = new JMenuBar();
        JMenu jMenu = new JMenu("File");
        JMenuItem jMenuItem = new JMenuItem("Save Binary");
        jMenuItem.setActionCommand(ACTIONCOMMAND_SAVE_BIN);
        jMenuItem.addActionListener(this.menuController);
        JMenuItem jMenuItem2 = new JMenuItem("Load Binary");
        jMenuItem2.setActionCommand(ACTIONCOMMAND_LOAD_BIN);
        jMenuItem2.addActionListener(this.menuController);
        jMenu.add(jMenuItem);
        jMenu.add(jMenuItem2);
        jMenu.addSeparator();
        JMenuItem jMenuItem3 = new JMenuItem("Load CAS");
        jMenuItem3.setActionCommand(ACTIONCOMMAND_LOAD_CAS);
        jMenuItem3.addActionListener(this.menuController);
        jMenu.add(jMenuItem3);
        jMenu.addSeparator();
        JMenuItem jMenuItem4 = new JMenuItem("Open SD image 0");
        jMenuItem4.setActionCommand(ACTIONCOMMAND_OPEN_SD0);
        jMenuItem4.addActionListener(this.menuController);
        jMenu.add(jMenuItem4);
        JMenuItem jMenuItem5 = new JMenuItem("Open SD image 1");
        jMenuItem5.setActionCommand(ACTIONCOMMAND_OPEN_SD1);
        jMenuItem5.addActionListener(this.menuController);
        jMenu.add(jMenuItem5);
        jMenu.addSeparator();
        JMenuItem jMenuItem6 = new JMenuItem("Exit");
        jMenuItem6.setActionCommand(ACTIONCOMMAND_EXIT);
        jMenuItem6.addActionListener(this.menuController);
        jMenu.add(jMenuItem6);
        JMenu jMenu2 = new JMenu("Machine");
        JMenuItem jMenuItem7 = new JMenuItem("Cold Reset");
        jMenuItem7.setActionCommand(ACTIONCOMMAND_RESET_COLD);
        jMenuItem7.addActionListener(this.menuController);
        JMenuItem jMenuItem8 = new JMenuItem("Warm Reset");
        jMenuItem8.setActionCommand(ACTIONCOMMAND_RESET_WARM);
        jMenuItem8.addActionListener(this.menuController);
        jMenu2.add(jMenuItem7);
        jMenu2.add(jMenuItem8);
        JMenu jMenu3 = new JMenu("Screen");
        JMenuItem jMenuItem9 = new JMenuItem("Scaling:Fast");
        jMenuItem9.setActionCommand(ACTIONCOMMAND_SCALE_FAST);
        jMenuItem9.addActionListener(this.menuController);
        JMenuItem jMenuItem10 = new JMenuItem("Scaling:Smooth");
        jMenuItem10.setActionCommand(ACTIONCOMMAND_SCALE_SMOOTH);
        jMenuItem10.addActionListener(this.menuController);
        jMenu3.add(jMenuItem9);
        jMenu3.add(jMenuItem10);
        jMenu3.addSeparator();
        JMenuItem jMenuItem11 = new JMenuItem("Color Off");
        jMenuItem11.setActionCommand(ACTIONCOMMAND_COLORKILL_ON);
        jMenuItem11.addActionListener(this.menuController);
        JMenuItem jMenuItem12 = new JMenuItem("Color On");
        jMenuItem12.setActionCommand(ACTIONCOMMAND_COLORKILL_OFF);
        jMenuItem12.addActionListener(this.menuController);
        jMenu3.add(jMenuItem11);
        jMenu3.add(jMenuItem12);
        jMenu3.addSeparator();
        JMenuItem jMenuItem13 = new JMenuItem("Size 0.5");
        jMenuItem13.setActionCommand(ACTIONCOMMAND_SCREENSIZE_05X);
        jMenuItem13.addActionListener(this.menuController);
        JMenuItem jMenuItem14 = new JMenuItem("Size x1");
        jMenuItem14.setActionCommand(ACTIONCOMMAND_SCREENSIZE_1X);
        jMenuItem14.addActionListener(this.menuController);
        JMenuItem jMenuItem15 = new JMenuItem("Size x2");
        jMenuItem15.setActionCommand(ACTIONCOMMAND_SCREENSIZE_2X);
        jMenuItem15.addActionListener(this.menuController);
        jMenu3.add(jMenuItem13);
        jMenu3.add(jMenuItem14);
        jMenu3.add(jMenuItem15);
        jMenu3.addSeparator();
        JMenuItem jMenuItem16 = new JMenuItem("Full screen");
        jMenuItem16.setActionCommand(ACTIONCOMMAND_FULLSCREEN);
        jMenuItem16.addActionListener(this.menuController);
        jMenu3.add(jMenuItem16);
        JMenu jMenu4 = new JMenu("Trace");
        this.itemEnableButtons = new JMenuItem("Enable buttons");
        jMenu4.add(this.itemEnableButtons);
        this.itemEnableButtons.setActionCommand(ACTIONCOMMAND_TRACE_ENABLE);
        this.itemEnableButtons.addActionListener(this.menuController);
        JMenu jMenu5 = new JMenu("Help");
        JMenuItem jMenuItem17 = new JMenuItem("About");
        jMenu5.add(jMenuItem17);
        jMenuItem17.setActionCommand(ACTIONCOMMAND_ABOUT);
        jMenuItem17.addActionListener(this.menuController);
        this.menuBar.add(jMenu);
        this.menuBar.add(jMenu3);
        this.menuBar.add(jMenu2);
        this.menuBar.add(jMenu4);
        this.menuBar.add(jMenu5);
        this.footer = new JPanel(new FlowLayout(2));
        this.pauseButton = new JToggleButton("Pause");
        this.pauseButton.addItemListener(this.menuController);
        this.pauseButton.setActionCommand(ACTIONCOMMAND_PAUSE);
        this.footer.add(this.pauseButton);
        this.traceButton = new JToggleButton("Trace");
        this.traceButton.addItemListener(this.menuController);
        this.traceButton.setActionCommand(ACTIONCOMMAND_TRACE);
        this.footer.add(this.traceButton);
        this.pauseButton.setEnabled(false);
        this.traceButton.setEnabled(false);
        this.mainFrame = new JFrame();
        this.layout = new BorderLayout();
        this.mainFrame.setJMenuBar(this.menuBar);
        this.mainFrame.setMinimumSize(new Dimension(320, 300));
        this.mainFrame.addComponentListener(this.tvc.getScreen());
        this.mainFrame.addWindowFocusListener(new WindowAdapter(){

            @Override
            public void windowGainedFocus(WindowEvent windowEvent) {
                GUI.this.screen.requestFocusInWindow();
            }
        });
        this.mainFrame.setLayout(this.layout);
        this.mainFrame.setTitle(FRAME_TITLE);
        this.mainFrame.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent windowEvent) {
                System.exit(0);
            }
        });
        this.mainFrame.add((Component)this.screen, "Center");
        this.screen.requestFocusInWindow();
        this.mainFrame.add((Component)this.footer, "South");
        this.mainFrame.pack();
        this.mainFrame.setSize(this.mainFrame.getPreferredSize());
        this.mainFrame.setVisible(true);
        this.FullScreen = false;
    }

    public void TraceButtonsEnable() {
        boolean bl = !this.pauseButton.isEnabled();
        this.pauseButton.setEnabled(bl);
        this.traceButton.setEnabled(bl);
        this.itemEnableButtons.setText(bl ? "Disable buttons" : "Enable buttons");
    }

    public void SwitchFullScreen() {
        GraphicsDevice graphicsDevice = GraphicsEnvironment.getLocalGraphicsEnvironment().getScreenDevices()[0];
        if (!this.FullScreen) {
            if (!graphicsDevice.isFullScreenSupported()) {
                Log.getInstance().write("Full screen mode not supported");
            } else {
                this.mainFrame.setVisible(false);
                this.mainFrame.remove(this.screen);
                this.fullFrame = new JFrame();
                this.fullFrame.setUndecorated(true);
                this.fullFrame.add((Component)this.screen, "Center");
                this.fullFrame.setTitle(FRAME_TITLE);
                graphicsDevice.setFullScreenWindow(this.fullFrame);
                this.HideMouseCursor(this.fullFrame);
                this.FullScreen = true;
            }
        } else {
            graphicsDevice.setFullScreenWindow(null);
            this.fullFrame.remove(this.screen);
            this.fullFrame.dispose();
            this.mainFrame.add((Component)this.screen, "Center");
            this.mainFrame.setVisible(true);
            this.FullScreen = false;
        }
    }

    private void HideMouseCursor(JFrame jFrame) {
        BufferedImage bufferedImage = new BufferedImage(1, 1, 2);
        Cursor cursor = Toolkit.getDefaultToolkit().createCustomCursor(bufferedImage, new Point(0, 0), "blank cursor");
        jFrame.getContentPane().setCursor(cursor);
    }
}

