/*
 * Decompiled with CFR 0.152.
 */
package emulator.tvc;

import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.text.MessageFormat;
import java.util.Date;

public class Log {
    public static final String TVC_LOGFILE = "tvc.log";
    public static FileOutputStream logFile;
    public static PrintStream pStream;
    public static MessageFormat formatter;
    private static Log instance;

    public static Log getInstance() {
        if (null == instance) {
            instance = new Log();
        }
        return instance;
    }

    private Log() {
    }

    public void open() {
        try {
            logFile = new FileOutputStream(TVC_LOGFILE);
            pStream = new PrintStream(logFile);
        }
        catch (IOException iOException) {
            System.err.println(iOException);
        }
    }

    public void write(String string) {
        Object[] objectArray = new Object[]{new Date(System.currentTimeMillis()), string};
        pStream.println(formatter.format(objectArray));
        System.out.println(formatter.format(objectArray));
    }

    public void close() {
        try {
            pStream.close();
            logFile.close();
        }
        catch (IOException iOException) {
            System.err.println(iOException);
        }
    }

    static {
        formatter = new MessageFormat("{0,time,HH:MM:ss:SSS} {1}");
    }
}

