/*
 * Decompiled with CFR 0.152.
 */
package emulator.tvc;

import emulator.tvc.Log;
import emulator.tvc.SDcartridge;
import java.util.Arrays;

public class Memory {
    public static final int ROM_SIZE = 8192;
    public static final int PAGE_SIZE = 16384;
    public static final String MAGIC = "JTVC";
    public static final byte[] VERSION = new byte[]{1, 1};
    Page SYS;
    Page EXT;
    Page VID;
    Page CART;
    Page U0;
    Page U1;
    Page U2;
    Page U3;
    Page[] PAGES;
    private Log log = Log.getInstance();

    public Memory() {
        this.SYS = new Page("SYS", true);
        this.EXT = new Page("EXT", true);
        this.VID = new Page("VID", false);
        this.CART = new SDcartridge(this, "SDCART");
        this.U0 = new Page("U0", false);
        this.U1 = new Page("U1", false);
        this.U2 = new Page("U2", false);
        this.U3 = new Page("U3", false);
        this.PAGES = new Page[4];
    }

    public Page getPageByName(String string) {
        if (this.U0.name.equals(string)) {
            return this.U0;
        }
        if (this.U1.name.equals(string)) {
            return this.U1;
        }
        if (this.U2.name.equals(string)) {
            return this.U2;
        }
        if (this.U3.name.equals(string)) {
            return this.U3;
        }
        if (this.VID.name.equals(string)) {
            return this.VID;
        }
        throw new IllegalArgumentException("Could not retrieve page by name: " + string);
    }

    public final int getByte(int n) {
        int n2 = n >> 14 & 3;
        int n3 = n & 0x3FFF;
        return this.PAGES[n2].get(n3);
    }

    public final void setByte(int n, int n2) {
        int n3 = n >> 14 & 3;
        int n4 = n & 0x3FFF;
        this.PAGES[n3].set(n4, n2);
    }

    public final int getWord(int n) {
        return this.getByte(n) | this.getByte(n + 1) << 8;
    }

    public final void setWord(int n, int n2) {
        this.setByte(n, n2 & 0xFF);
        this.setByte(n + 1, n2 >> 8);
    }

    public void setPages(int n) {
        switch (n & 0x18) {
            case 0: {
                this.PAGES[0] = this.SYS;
                break;
            }
            case 8: {
                this.PAGES[0] = this.CART;
                break;
            }
            case 16: {
                this.PAGES[0] = this.U0;
                break;
            }
            case 24: {
                this.PAGES[0] = this.U3;
                break;
            }
        }
        this.PAGES[1] = this.U1;
        switch (n & 0x20) {
            case 0: {
                this.PAGES[2] = this.VID;
                break;
            }
            case 32: {
                this.PAGES[2] = this.U2;
                break;
            }
        }
        switch (n & 0xC0) {
            case 0: {
                this.PAGES[3] = this.CART;
                break;
            }
            case 64: {
                this.PAGES[3] = this.SYS;
                break;
            }
            case 128: {
                this.PAGES[3] = this.U3;
                break;
            }
            case 192: {
                this.PAGES[3] = this.EXT;
                break;
            }
        }
    }

    public void dump(int n, int n2) {
        String string = new String("");
        String string2 = new String("");
        String string3 = new String("");
        this.log.write("Memory dump");
        for (int i = 0; i < n2; ++i) {
            if (i % 16 == 0) {
                if (i != 0) {
                    this.log.write(string + "  " + string3);
                }
                string2 = "0000" + Integer.toHexString(n + i);
                string2 = string2.substring(string2.length() - 4);
                string = "0x" + string2 + " : ";
                string3 = "";
            }
            int n3 = this.getByte(n + i);
            string2 = "00" + Integer.toHexString(n3);
            string2 = string2.substring(string2.length() - 2);
            string = i % 8 == 0 && i % 16 != 0 ? string + "- " + string2 + " " : string + string2 + " ";
            string3 = string3 + (char)n3;
        }
        this.log.write(string);
    }

    class Page {
        int[] mem = new int[16384];
        String name;
        boolean rom;

        public Page(String string, boolean bl) {
            Arrays.fill(this.mem, 0);
            this.name = string;
            this.rom = bl;
        }

        public int get(int n) {
            return this.mem[n];
        }

        public void set(int n, int n2) {
            if (!this.rom) {
                this.mem[n] = n2;
            }
        }

        public void setrom(int n, int n2) {
            this.mem[n] = n2;
        }
    }
}

