/*
 * Decompiled with CFR 0.152.
 */
package emulator.tvc;

import emulator.tvc.Keyboard;
import emulator.tvc.Log;
import emulator.tvc.Memory;
import emulator.tvc.Screen;
import emulator.tvc.Sound;

public class Port {
    public static final int PORT_MAX = 256;
    public int[] port_out;
    public int[] port_in;
    public static final boolean tracePort = false;
    Memory memory;
    Screen screen;
    Sound soundctrl;
    Keyboard keyboard;
    private Log log = Log.getInstance();

    public Port(Keyboard keyboard, Memory memory, Screen screen, Sound sound) {
        this.keyboard = keyboard;
        this.memory = memory;
        this.screen = screen;
        this.soundctrl = sound;
        this.port_out = new int[256];
        this.port_in = new int[256];
        this.port_in[90] = 255;
        this.port_in[94] = 255;
    }

    public void setPort(int n, int n2) {
        switch (n) {
            case 0: {
                this.screen.setBorderRegister(n2);
                break;
            }
            case 2: {
                this.memory.setPages(n2);
                break;
            }
            case 3: {
                this.port_out[n] = n2;
                break;
            }
            case 4: {
                this.soundctrl.setPitchLow(n2);
                break;
            }
            case 5: {
                this.soundctrl.setPitchHigh(n2);
                break;
            }
            case 6: {
                this.screen.setModeRegister(n2 & 3);
                this.soundctrl.setAmp(n2);
                break;
            }
            case 7: {
                this.screen.clearCursorInt();
                break;
            }
            case 80: 
            case 81: 
            case 82: 
            case 83: 
            case 84: 
            case 85: 
            case 86: 
            case 87: {
                break;
            }
            case 96: 
            case 97: 
            case 98: 
            case 99: 
            case 100: 
            case 101: 
            case 102: 
            case 103: 
            case 104: 
            case 105: 
            case 106: 
            case 107: 
            case 108: 
            case 109: 
            case 110: 
            case 111: {
                this.screen.setPaletteRegister(n & 3, n2);
                break;
            }
            case 112: 
            case 114: 
            case 116: 
            case 118: 
            case 120: 
            case 122: 
            case 124: 
            case 126: {
                this.screen.getMc6845().writeAddress(n2);
                break;
            }
            case 113: 
            case 115: 
            case 117: 
            case 119: 
            case 121: 
            case 123: 
            case 125: 
            case 127: {
                this.screen.getMc6845().writeReg(n2);
                break;
            }
            default: {
                this.port_out[n] = n2;
            }
        }
    }

    public int getPort(int n) {
        int n2 = 0;
        switch (n) {
            case 88: 
            case 92: {
                n2 = this.keyboard.getMatrixAt(this.port_out[3] & 0xF);
                break;
            }
            case 89: 
            case 93: {
                n2 = this.screen.getCursorInt() | this.screen.getColorKillEnable();
                n2 |= 0xF;
                break;
            }
            case 90: 
            case 94: {
                n2 = this.port_in[90];
                break;
            }
            case 91: 
            case 95: {
                break;
            }
            case 112: 
            case 114: 
            case 116: 
            case 118: 
            case 120: 
            case 122: 
            case 124: 
            case 126: {
                n2 = this.screen.getMc6845().readAddress();
                break;
            }
            case 113: 
            case 115: 
            case 117: 
            case 119: 
            case 121: 
            case 123: 
            case 125: 
            case 127: {
                n2 = this.screen.getMc6845().readReg();
                break;
            }
            default: {
                n2 = 255;
            }
        }
        return n2;
    }

    private String toHexString(int n, int n2) {
        String string = "0000000" + Integer.toHexString(n);
        return string.substring(string.length() - n2);
    }
}

