/*
 * Decompiled with CFR 0.152.
 */
package emulator.tvc;

import emulator.tvc.Memory;
import emulator.tvc.SDcard;

public class SDcartridge
extends Memory.Page {
    public static final byte PIN_CS0 = -128;
    public static final byte PIN_CS1 = 64;
    public static final byte CLR_DSKCHNG = 32;
    public static final byte PIN_WPROT = -128;
    public static final byte PIN_INSRT = 64;
    public static final byte PIN_DSKCHNG = 32;
    public static final int ROM_SIZE = 40960;
    public static final int RAM_SIZE = 8192;
    public SDcard SD_Card0;
    public SDcard SD_Card1;
    private int ROMpage;
    private int RAMpage;
    private byte SPIdatain;
    private byte IFstatus;
    private byte[] SD_ROM;
    private byte[] SD_RAM;
    private boolean bHiSpeed;

    public void OpenDiskImage(String string, int n, int n2) {
        SDcard sDcard = n2 == 0 ? this.SD_Card0 : this.SD_Card1;
        sDcard.OpenDiskImage(string, n);
        this.IFstatus = (byte)-32;
        if (this.SD_Card0.bInserted || this.SD_Card1.bInserted) {
            this.IFstatus = (byte)(this.IFstatus & 0xFFFFFFBF);
        }
        if (!this.SD_Card0.bWrProt) {
            this.IFstatus = (byte)(this.IFstatus & 0x7F);
        }
    }

    private byte SD_IOread(int n) {
        switch (n & 3) {
            case 0: {
                return this.SD_Card0.bSPI_CS ? this.SD_Card0.SPIdatain : this.SD_Card1.SPIdatain;
            }
            case 1: {
                return this.IFstatus;
            }
        }
        return 0;
    }

    private void SD_IOwrite(int n, byte by) {
        switch (n & 3) {
            case 0: {
                this.SD_Card0.Send(by);
                this.SD_Card1.Send(by);
                break;
            }
            case 1: {
                this.SD_Card0.bSPI_CS_Prev = this.SD_Card0.bSPI_CS;
                this.SD_Card1.bSPI_CS_Prev = this.SD_Card1.bSPI_CS;
                this.SD_Card0.bSPI_CS = (by & 0xFFFFFF80) != 0;
                boolean bl = this.SD_Card1.bSPI_CS = (by & 0x40) != 0;
                if ((by & 0x20) == 0) break;
                this.IFstatus = (byte)(this.IFstatus & 0xFFFFFFDF);
                break;
            }
            case 2: {
                this.ROMpage = by & 0xF0;
                break;
            }
            case 3: {
                this.RAMpage = by & 0x18;
            }
        }
    }

    @Override
    public int get(int n) {
        byte by;
        if ((n & 0x2000) == 0) {
            by = this.SD_ROM[(this.ROMpage & 0xE0) << 8 | n & 0x1FFF];
        } else if ((n & 0x3C00) != 15360) {
            by = this.SD_RAM[n & 0x1FFF];
        } else if (this.bHiSpeed) {
            if (this.SD_Card0.bSPI_CS) {
                by = this.SD_Card0.SPIdatain;
                this.SD_Card0.Send((byte)-1);
            } else {
                by = this.SD_Card1.SPIdatain;
                this.SD_Card1.Send((byte)-1);
            }
        } else {
            by = this.SD_IOread(n);
        }
        return by & 0xFF;
    }

    @Override
    public void set(int n, int n2) {
        if ((n & 0x2000) == 0) {
            return;
        }
        if ((n & 0x3C00) != 15360) {
            this.SD_RAM[n & 0x1FFF] = (byte)n2;
        } else if ((n & 3) == 3) {
            this.bHiSpeed = (n2 & 0x80) == 128;
        } else {
            this.SD_IOwrite(n, (byte)n2);
        }
    }

    @Override
    public void setrom(int n, int n2) {
        this.SD_ROM[n] = (byte)n2;
    }

    public SDcartridge(Memory memory, String string) {
        Memory memory2 = memory;
        memory2.getClass();
        super(string, false);
        this.SD_ROM = new byte[40960];
        this.SD_RAM = new byte[8192];
        this.IFstatus = (byte)-64;
        this.bHiSpeed = false;
        this.SD_Card0 = new SDcard();
        this.SD_Card0.bSPI_CS_Prev = false;
        this.SD_Card0.bSPI_CS = false;
        this.SD_Card1 = new SDcard();
        this.SD_Card1.bSPI_CS_Prev = false;
        this.SD_Card1.bSPI_CS = false;
    }
}

