/*
 * Decompiled with CFR 0.152.
 */
package emulator.tvc;

import emulator.tvc.Log;
import emulator.tvc.MC6845;
import emulator.tvc.Memory;
import emulator.tvc.TVC;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import java.awt.image.IndexColorModel;
import java.awt.image.WritableRaster;
import javax.swing.JPanel;

public class Screen
extends JPanel
implements ComponentListener {
    private int[] paletteRegisters;
    private int borderRegister;
    private int modeRegister;
    private int videoPageRegister;
    private int colorKillEnable;
    private MC6845 mc6845;
    public static final int CANVAS_XRES = 640;
    public static final int CANVAS_YRES = 480;
    public static final int IMG_XRES = 592;
    public static final int IMG_YRES = 512;
    private static final int IMG_YRES_H = 256;
    private static final int DISPLAY_X_START = 152;
    private static final int DISPLAY_Y_START = 39;
    private static final int DISPLAY_X_STOP = 737;
    private static final int DISPLAY_Y_STOP = 294;
    public static final int GRAPHICS2 = 0;
    public static final int GRAPHICS4 = 1;
    public static final int GRAPHICS16 = 2;
    public static final int BLACK = 0;
    public static final int DARK_BLUE = 1;
    public static final int DARK_RED = 4;
    public static final int DARK_MAGENTA = 5;
    public static final int DARK_GREEN = 16;
    public static final int DARK_CYAN = 17;
    public static final int DARK_YELLOW = 20;
    public static final int DARK_GRAY = 21;
    public static final int LIGHT_BLACK = 64;
    public static final int BLUE = 65;
    public static final int RED = 68;
    public static final int MAGENTA = 69;
    public static final int GREEN = 80;
    public static final int CYAN = 81;
    public static final int YELLOW = 84;
    public static final int WHITE = 85;
    public static final int[] colorMap = new int[]{0, 1, 16, 17, 4, 5, 20, 21, 64, 65, 80, 81, 68, 69, 84, 85};
    private static byte[][] colors = new byte[][]{{0, 0, 0}, {0, 0, 127}, {127, 0, 0}, {127, 0, 127}, {0, 127, 0}, {0, 127, 127}, {127, 127, 0}, {127, 127, 127}, {0, 0, 0}, {0, 0, -1}, {-1, 0, 0}, {-1, 0, -1}, {0, -1, 0}, {0, -1, -1}, {-1, -1, 0}, {-1, -1, -1}};
    private TVC tvc;
    private Memory memory;
    private BufferedImage img;
    private BufferedImage img_work;
    private BufferedImage img_16;
    private BufferedImage img_bw;
    private WritableRaster raster;
    private int DisplayCycles;
    private int HPos;
    private int VPos;
    private boolean CPprev;
    private boolean CursorInt;
    private Object scalingQuality;

    public Screen(TVC tVC, Memory memory) {
        this.memory = memory;
        this.tvc = tVC;
        this.DisplayCycles = 0;
        this.HPos = 0;
        this.VPos = 0;
        this.CPprev = false;
        this.scalingQuality = RenderingHints.VALUE_INTERPOLATION_NEAREST_NEIGHBOR;
        this.mc6845 = new MC6845();
        this.paletteRegisters = new int[4];
        this.paletteRegisters[0] = 0;
        this.paletteRegisters[1] = 0;
        this.paletteRegisters[2] = 0;
        this.paletteRegisters[3] = 0;
        this.borderRegister = 0;
        this.modeRegister = 0;
        this.videoPageRegister = 63;
        this.colorKillEnable = 64;
        IndexColorModel indexColorModel = this.createPalette16(colors);
        this.img_work = this.img_16 = new BufferedImage(592, 256, 13, indexColorModel);
        this.raster = this.img_work.getRaster();
        byte[][] byArray = new byte[16][3];
        for (int i = 0; i < 16; ++i) {
            byte by;
            byArray[i][0] = by = (byte)(0.3 * (double)(colors[i][0] & 0xFF) + 0.59 * (double)(colors[i][1] & 0xFF) + 0.11 * (double)(colors[i][2] & 0xFF));
            byArray[i][1] = by;
            byArray[i][2] = by;
        }
        IndexColorModel indexColorModel2 = this.createPalette16(byArray);
        this.img_bw = new BufferedImage(592, 256, 13, indexColorModel2);
        this.setSize(640, 480);
        this.setFocusable(true);
        this.setRequestFocusEnabled(true);
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                Screen.this.requestFocus();
                super.mouseClicked(mouseEvent);
            }
        });
    }

    public MC6845 getMc6845() {
        return this.mc6845;
    }

    public void Reset() {
        this.borderRegister = 0;
    }

    public void setScalingQuality(Object object) {
        this.scalingQuality = object;
    }

    private IndexColorModel createPalette16(byte[][] byArray) {
        byte[] byArray2 = new byte[16];
        byte[] byArray3 = new byte[16];
        byte[] byArray4 = new byte[16];
        for (int i = 0; i < 16; ++i) {
            byArray2[i] = byArray[i][0];
            byArray3[i] = byArray[i][1];
            byArray4[i] = byArray[i][2];
        }
        return new IndexColorModel(4, 16, byArray2, byArray3, byArray4);
    }

    @Override
    public void paint(Graphics graphics) {
        Graphics2D graphics2D = (Graphics2D)graphics;
        graphics2D.setRenderingHint(RenderingHints.KEY_INTERPOLATION, this.scalingQuality);
        graphics2D.drawImage(this.img, 0, 0, this.getWidth(), this.getHeight(), null);
    }

    @Override
    public void update(Graphics graphics) {
        this.paint(graphics);
    }

    public final void setPaletteRegister(int n, int n2) {
        int n3;
        this.paletteRegisters[n] = n3 = (n2 & 0x40) >> 3 | (n2 & 0x10) >> 2 | (n2 & 4) >> 1 | n2 & 1;
    }

    public final int getPaletteRegister(int n) {
        int n2 = this.paletteRegisters[n];
        int n3 = (n2 & 8) << 3 | (n2 & 4) << 2 | (n2 & 2) << 1 | n2 & 1;
        return n3;
    }

    public final void setBorderRegister(int n) {
        int n2;
        this.borderRegister = n2 = (n & 0x80) >> 4 | (n & 0x20) >> 3 | (n & 8) >> 2 | (n & 2) >> 1;
    }

    public final int getBorderRegister() {
        int n = this.borderRegister;
        int n2 = (n & 8) << 4 | (n & 4) << 3 | (n & 2) << 2 | n & 1;
        return n2;
    }

    public final void setModeRegister(int n) {
        this.modeRegister = n;
    }

    public final int getModeRegister() {
        return this.modeRegister;
    }

    public final void setColorKillEnable(int n) {
        this.colorKillEnable = n << 6 & 0x40;
    }

    public final int getColorKillEnable() {
        return this.colorKillEnable;
    }

    public final void clearCursorInt() {
        this.CursorInt = false;
    }

    public final int getCursorInt() {
        return this.CursorInt ? 0 : 16;
    }

    public final boolean run(int n) {
        int[] nArray = this.memory.VID.mem;
        boolean bl = false;
        this.DisplayCycles += n;
        while (this.DisplayCycles > 1) {
            block11: {
                int[] nArray2;
                block13: {
                    block12: {
                        this.DisplayCycles -= 2;
                        this.mc6845.run();
                        if (this.mc6845.HSYNC) {
                            if (this.HPos > 0) {
                                ++this.VPos;
                            }
                            this.HPos = 0;
                        } else {
                            this.HPos += 8;
                        }
                        if (this.mc6845.VSYNC) {
                            if (this.VPos > 50) {
                                bl = true;
                                this.img_work.setData(this.raster);
                                this.img = this.img_work;
                                this.repaint();
                                this.img_work = this.colorKillEnable == 0 ? this.img_bw : this.img_16;
                                this.raster = this.img_work.getRaster();
                            }
                            this.VPos = 0;
                        }
                        if (this.HPos < 152 || this.HPos >= 737 || this.VPos < 39 || this.VPos >= 294) break block11;
                        nArray2 = new int[8];
                        if (!this.mc6845.DE) break block12;
                        int n2 = (this.mc6845.MA & 0xFC0) << 2 | (this.mc6845.RA & 3) << 6 | this.mc6845.MA & 0x3F;
                        int n3 = nArray[n2];
                        switch (this.modeRegister) {
                            case 0: {
                                for (int i = 7; i >= 0; --i) {
                                    nArray2[i] = this.paletteRegisters[n3 & 1];
                                    n3 >>= 1;
                                }
                                break block13;
                            }
                            case 1: {
                                nArray2[0] = this.paletteRegisters[(n3 & 0x80) >> 7 | (n3 & 8) >> 2];
                                nArray2[1] = nArray2[0];
                                nArray2[2] = this.paletteRegisters[(n3 & 0x40) >> 6 | (n3 & 4) >> 1];
                                nArray2[3] = nArray2[2];
                                nArray2[4] = this.paletteRegisters[(n3 & 0x20) >> 5 | n3 & 2];
                                nArray2[5] = nArray2[4];
                                nArray2[6] = this.paletteRegisters[(n3 & 0x10) >> 4 | (n3 & 1) << 1];
                                nArray2[7] = nArray2[6];
                                break;
                            }
                            default: {
                                nArray2[0] = (n3 & 0x80) >> 4 | (n3 & 0x20) >> 3 | (n3 & 8) >> 2 | (n3 & 2) >> 1;
                                nArray2[1] = nArray2[0];
                                nArray2[2] = nArray2[0];
                                nArray2[3] = nArray2[0];
                                nArray2[4] = (n3 & 0x40) >> 3 | (n3 & 0x10) >> 2 | (n3 & 4) >> 1 | n3 & 1;
                                nArray2[5] = nArray2[4];
                                nArray2[6] = nArray2[4];
                                nArray2[7] = nArray2[4];
                            }
                        }
                        break block13;
                    }
                    nArray2[0] = this.borderRegister;
                    nArray2[1] = nArray2[0];
                    nArray2[2] = nArray2[0];
                    nArray2[3] = nArray2[0];
                    nArray2[4] = nArray2[0];
                    nArray2[5] = nArray2[0];
                    nArray2[6] = nArray2[0];
                    nArray2[7] = nArray2[0];
                }
                this.raster.setPixels(this.HPos - 152, this.VPos - 39, 8, 1, nArray2);
            }
            boolean bl2 = !this.mc6845.CURSOR && !this.tvc.SoundINT;
            this.CursorInt = this.CursorInt || bl2 && !this.CPprev;
            this.CPprev = bl2;
        }
        return bl;
    }

    @Override
    public void componentResized(ComponentEvent componentEvent) {
        Log.getInstance().write("parent resized");
        this.setSize(this.getParent().getSize());
        this.revalidate();
    }

    @Override
    public void componentMoved(ComponentEvent componentEvent) {
    }

    @Override
    public void componentShown(ComponentEvent componentEvent) {
    }

    @Override
    public void componentHidden(ComponentEvent componentEvent) {
    }
}

