/*
 * Decompiled with CFR 0.152.
 */
package emulator.tvc;

import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.DataLine;
import javax.sound.sampled.SourceDataLine;

public class Sound {
    private int counter12bit;
    private int counter4bit;
    private int pitch;
    private int amp;
    private int sampler = 0;
    private int sindx = 0;
    private boolean SoundIntEn = false;
    private boolean SoundEn = true;
    private SourceDataLine line;
    private byte[] buffer = new byte[100];
    private final int SAMPLING_RATE = 22050;
    private final int AUDIO_BUFF_SIZE = 4410;
    private final int SAMPLE_BUFF_SIZE = 100;
    private final int SAMPLE_SIZE = 1;
    private final int NSAMPLE = 142;
    public static final boolean AudioPlay = true;

    public void setAmp(int n) {
        this.amp = n & 0x3C;
    }

    public void setPitchHigh(int n) {
        this.pitch = this.pitch & 0xFF | (n & 0xF) << 8;
        this.SoundEn = (n & 0x10) != 0;
        this.SoundIntEn = (n & 0x20) != 0;
    }

    public void setPitchLow(int n) {
        this.pitch = this.pitch & 0xF00 | n & 0xFF;
    }

    public void Reset() {
        this.amp = 0;
        this.pitch &= 0xFF;
        this.SoundEn = false;
        this.SoundIntEn = false;
    }

    public void Open() {
        AudioFormat audioFormat = new AudioFormat(22050.0f, 8, 1, true, true);
        DataLine.Info info = new DataLine.Info(SourceDataLine.class, audioFormat);
        if (!AudioSystem.isLineSupported(info)) {
            System.out.println("Line matching " + info + " is not supported.");
        }
        try {
            this.line = (SourceDataLine)AudioSystem.getLine(info);
            this.line.open(audioFormat, 4410);
            this.line.start();
        }
        catch (Exception exception) {
            System.out.println("Can not access audio line.");
            return;
        }
        int n = this.line.getBufferSize();
        String string = String.format("Audio buffer size: %d", n);
        System.out.println(string);
    }

    public void Close() {
        this.line.stop();
        this.line.flush();
        this.line.close();
    }

    public final boolean run(int n) {
        boolean bl = false;
        for (int i = n; i > 0; --i) {
            ++this.counter12bit;
            if (this.counter12bit >= 4096) {
                this.counter12bit = this.pitch;
                if (this.pitch != 4095) {
                    this.counter4bit = this.counter4bit + 1 & 0xF;
                }
            }
            if ((this.counter4bit & 8) != 0 && this.SoundIntEn) {
                bl = true;
            }
            ++this.sampler;
            if (this.sampler != 142) continue;
            this.sampler = 0;
            byte by = this.SoundEn ? ((this.counter4bit & 8) != 0 ? (byte)this.amp : (byte)0) : (byte)this.amp;
            this.buffer[this.sindx++] = by;
            if (this.sindx != 100) continue;
            int n2 = 0;
            do {
                int n3;
                if ((n3 = this.line.available()) > 0) {
                    int n4 = n3 > this.sindx ? this.sindx : n3;
                    this.sindx -= n4;
                    try {
                        this.line.write(this.buffer, n2, n4);
                        n2 += n4;
                    }
                    catch (Exception exception) {
                        System.out.println("Can not write audio line.");
                    }
                    continue;
                }
                try {
                    Thread.sleep(1L);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            } while (this.sindx != 0);
        }
        return bl;
    }
}

