/*
 * Decompiled with CFR 0.152.
 */
package emulator.tvc;

import emulator.tvc.Log;
import emulator.tvc.Memory;
import emulator.tvc.Port;
import emulator.tvc.Reg16;
import emulator.tvc.Reg8;

public class Z80 {
    public Reg8 A = new Reg8("A");
    public Reg8 B = new Reg8("B");
    public Reg8 C = new Reg8("C");
    public Reg8 D = new Reg8("D");
    public Reg8 E = new Reg8("E");
    public Reg8 F = new Reg8("F");
    public Reg8 H = new Reg8("H");
    public Reg8 L = new Reg8("L");
    public Reg8 IM;
    public Reg8 I;
    public Reg8 R;
    public Reg8 IXh = new Reg8("IXh");
    public Reg8 IXl = new Reg8("IXl");
    public Reg8 IYh = new Reg8("IYh");
    public Reg8 IYl = new Reg8("IYl");
    public Reg16 AF = new Reg16("AF", this.A, this.F);
    public Reg16 BC = new Reg16("BC", this.B, this.C);
    public Reg16 DE = new Reg16("DE", this.D, this.E);
    public Reg16 HL = new Reg16("HL", this.H, this.L);
    public Reg16 IX;
    public Reg16 IY;
    public Reg16 PC = new Reg16("PC");
    public Reg16 SP = new Reg16("SP");
    public int AF1;
    public int BC1;
    public int DE1;
    public int HL1;
    public boolean IFF1;
    public boolean IFF2;
    private Reg8[] r8;
    private Reg8[] p8;
    private Reg16[] r16;
    private Reg16[] r16AF;
    private Reg16[] r16SP;
    private Reg16[] r16IND;
    private Reg16 IND;
    public int opcode;
    public boolean halt = false;
    public boolean prevEI = false;
    public long t;
    private int[] pPC;
    private int ppi = 0;
    static String[] flagNames = new String[]{"NZ", "Z", "NC", "C", "PO", "PE", "P", "N"};
    static int[] SZTable = new int[]{64, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128};
    static int[] PSZTable = new int[]{68, 0, 0, 4, 0, 4, 4, 0, 0, 4, 4, 0, 4, 0, 0, 4, 0, 4, 4, 0, 4, 0, 0, 4, 4, 0, 0, 4, 0, 4, 4, 0, 0, 4, 4, 0, 4, 0, 0, 4, 4, 0, 0, 4, 0, 4, 4, 0, 4, 0, 0, 4, 0, 4, 4, 0, 0, 4, 4, 0, 4, 0, 0, 4, 0, 4, 4, 0, 4, 0, 0, 4, 4, 0, 0, 4, 0, 4, 4, 0, 4, 0, 0, 4, 0, 4, 4, 0, 0, 4, 4, 0, 4, 0, 0, 4, 4, 0, 0, 4, 0, 4, 4, 0, 0, 4, 4, 0, 4, 0, 0, 4, 0, 4, 4, 0, 4, 0, 0, 4, 4, 0, 0, 4, 0, 4, 4, 0, 128, 132, 132, 128, 132, 128, 128, 132, 132, 128, 128, 132, 128, 132, 132, 128, 132, 128, 128, 132, 128, 132, 132, 128, 128, 132, 132, 128, 132, 128, 128, 132, 132, 128, 128, 132, 128, 132, 132, 128, 128, 132, 132, 128, 132, 128, 128, 132, 128, 132, 132, 128, 132, 128, 128, 132, 132, 128, 128, 132, 128, 132, 132, 128, 132, 128, 128, 132, 128, 132, 132, 128, 128, 132, 132, 128, 132, 128, 128, 132, 128, 132, 132, 128, 132, 128, 128, 132, 132, 128, 128, 132, 128, 132, 132, 128, 128, 132, 132, 128, 132, 128, 128, 132, 132, 128, 128, 132, 128, 132, 132, 128, 132, 128, 128, 132, 128, 132, 132, 128, 128, 132, 132, 128, 132, 128, 128, 132};
    static int SET_S = 128;
    static int SET_Z = 64;
    static int SET_5 = 32;
    static int SET_H = 16;
    static int SET_3 = 8;
    static int SET_PV = 4;
    static int SET_N = 2;
    static int SET_C = 1;
    public int traceCPU;
    static int TRC_GP = 1;
    static int TRC_CRR = 2;
    static int TRC_J = 3;
    static int TRC_Jcc = 4;
    static int TRC_ALL = 5;
    Memory memory;
    Port port;
    Log log;
    public static int[] DAATable = new int[]{68, 256, 512, 772, 1024, 1284, 1540, 1792, 2056, 2316, 4112, 4372, 4628, 4880, 5140, 5392, 4096, 4356, 4612, 4864, 5124, 5376, 5632, 5892, 6156, 6408, 8240, 8500, 8756, 9008, 9268, 9520, 8224, 8484, 8740, 8992, 9252, 9504, 9760, 10020, 10284, 10536, 12340, 12592, 12848, 13108, 13360, 13620, 12324, 12576, 12832, 13092, 13344, 13604, 13860, 14112, 14376, 14636, 16400, 16660, 16916, 17168, 17428, 17680, 16384, 16644, 16900, 17152, 17412, 17664, 17920, 18180, 18444, 18696, 20500, 20752, 21008, 21268, 21520, 21780, 20484, 20736, 20992, 21252, 21504, 21764, 22020, 22272, 22536, 22796, 24628, 24880, 25136, 25396, 25648, 25908, 24612, 24864, 25120, 25380, 25632, 25892, 26148, 26400, 26664, 26924, 28720, 28980, 29236, 29488, 29748, 30000, 28704, 28964, 29220, 29472, 29732, 29984, 30240, 30500, 30764, 31016, 32912, 33172, 33428, 33680, 33940, 34192, 32896, 33156, 33412, 33664, 33924, 34176, 34432, 34692, 34956, 35208, 37012, 37264, 37520, 37780, 38032, 38292, 36996, 37248, 37504, 37764, 38016, 38276, 38532, 38784, 39048, 39308, 85, 273, 529, 789, 1041, 1301, 69, 257, 513, 773, 1025, 1285, 1541, 1793, 2057, 2317, 4113, 4373, 4629, 4881, 5141, 5393, 4097, 4357, 4613, 4865, 5125, 5377, 5633, 5893, 6157, 6409, 8241, 8501, 8757, 9009, 9269, 9521, 8225, 8485, 8741, 8993, 9253, 9505, 9761, 10021, 10285, 10537, 12341, 12593, 12849, 13109, 13361, 13621, 12325, 12577, 12833, 13093, 13345, 13605, 13861, 14113, 14377, 14637, 16401, 16661, 16917, 17169, 17429, 17681, 16385, 16645, 16901, 17153, 17413, 17665, 17921, 18181, 18445, 18697, 20501, 20753, 21009, 21269, 21521, 21781, 20485, 20737, 20993, 21253, 21505, 21765, 22021, 22273, 22537, 22797, 24629, 24881, 25137, 25397, 25649, 25909, 24613, 24865, 25121, 25381, 25633, 25893, 26149, 26401, 26665, 26925, 28721, 28981, 29237, 29489, 29749, 30001, 28705, 28965, 29221, 29473, 29733, 29985, 30241, 30501, 30765, 31017, 32913, 33173, 33429, 33681, 33941, 34193, 32897, 33157, 33413, 33665, 33925, 34177, 34433, 34693, 34957, 35209, 37013, 37265, 37521, 37781, 38033, 38293, 36997, 37249, 37505, 37765, 38017, 38277, 38533, 38785, 39049, 39309, 41141, 41393, 41649, 41909, 42161, 42421, 41125, 41377, 41633, 41893, 42145, 42405, 42661, 42913, 43177, 43437, 45233, 45493, 45749, 46001, 46261, 46513, 45217, 45477, 45733, 45985, 46245, 46497, 46753, 47013, 47277, 47529, 49301, 49553, 49809, 50069, 50321, 50581, 49285, 49537, 49793, 50053, 50305, 50565, 50821, 51073, 51337, 51597, 53393, 53653, 53909, 54161, 54421, 54673, 53377, 53637, 53893, 54145, 54405, 54657, 54913, 55173, 55437, 55689, 57521, 57781, 58037, 58289, 58549, 58801, 57505, 57765, 58021, 58273, 58533, 58785, 59041, 59301, 59565, 59817, 61621, 61873, 62129, 62389, 62641, 62901, 61605, 61857, 62113, 62373, 62625, 62885, 63141, 63393, 63657, 63917, 85, 273, 529, 789, 1041, 1301, 69, 257, 513, 773, 1025, 1285, 1541, 1793, 2057, 2317, 4113, 4373, 4629, 4881, 5141, 5393, 4097, 4357, 4613, 4865, 5125, 5377, 5633, 5893, 6157, 6409, 8241, 8501, 8757, 9009, 9269, 9521, 8225, 8485, 8741, 8993, 9253, 9505, 9761, 10021, 10285, 10537, 12341, 12593, 12849, 13109, 13361, 13621, 12325, 12577, 12833, 13093, 13345, 13605, 13861, 14113, 14377, 14637, 16401, 16661, 16917, 17169, 17429, 17681, 16385, 16645, 16901, 17153, 17413, 17665, 17921, 18181, 18445, 18697, 20501, 20753, 21009, 21269, 21521, 21781, 20485, 20737, 20993, 21253, 21505, 21765, 22021, 22273, 22537, 22797, 24629, 24881, 25137, 25397, 25649, 25909, 1540, 1792, 2056, 2316, 2572, 2824, 3084, 3336, 3592, 3852, 4112, 4372, 4628, 4880, 5140, 5392, 5632, 5892, 6156, 6408, 6664, 6924, 7176, 7436, 7692, 7944, 8240, 8500, 8756, 9008, 9268, 9520, 9760, 10020, 10284, 10536, 10792, 11052, 11304, 11564, 11820, 12072, 12340, 12592, 12848, 13108, 13360, 13620, 13860, 14112, 14376, 14636, 14892, 15144, 15404, 15656, 15912, 16172, 16400, 16660, 16916, 17168, 17428, 17680, 17920, 18180, 18444, 18696, 18952, 19212, 19464, 19724, 19980, 20232, 20500, 20752, 21008, 21268, 21520, 21780, 22020, 22272, 22536, 22796, 23052, 23304, 23564, 23816, 24072, 24332, 24628, 24880, 25136, 25396, 25648, 25908, 26148, 26400, 26664, 26924, 27180, 27432, 27692, 27944, 28200, 28460, 28720, 28980, 29236, 29488, 29748, 30000, 30240, 30500, 30764, 31016, 31272, 31532, 31784, 32044, 32300, 32552, 32912, 33172, 33428, 33680, 33940, 34192, 34432, 34692, 34956, 35208, 35464, 35724, 35976, 36236, 36492, 36744, 37012, 37264, 37520, 37780, 38032, 38292, 38532, 38784, 39048, 39308, 39564, 39816, 40076, 40328, 40584, 40844, 85, 273, 529, 789, 1041, 1301, 1541, 1793, 2057, 2317, 2573, 2825, 3085, 3337, 3593, 3853, 4113, 4373, 4629, 4881, 5141, 5393, 5633, 5893, 6157, 6409, 6665, 6925, 7177, 7437, 7693, 7945, 8241, 8501, 8757, 9009, 9269, 9521, 9761, 10021, 10285, 10537, 10793, 11053, 11305, 11565, 11821, 12073, 12341, 12593, 12849, 13109, 13361, 13621, 13861, 14113, 14377, 14637, 14893, 15145, 15405, 15657, 15913, 16173, 16401, 16661, 16917, 17169, 17429, 17681, 17921, 18181, 18445, 18697, 18953, 19213, 19465, 19725, 19981, 20233, 20501, 20753, 21009, 21269, 21521, 21781, 22021, 22273, 22537, 22797, 23053, 23305, 23565, 23817, 24073, 24333, 24629, 24881, 25137, 25397, 25649, 25909, 26149, 26401, 26665, 26925, 27181, 27433, 27693, 27945, 28201, 28461, 28721, 28981, 29237, 29489, 29749, 30001, 30241, 30501, 30765, 31017, 31273, 31533, 31785, 32045, 32301, 32553, 32913, 33173, 33429, 33681, 33941, 34193, 34433, 34693, 34957, 35209, 35465, 35725, 35977, 36237, 36493, 36745, 37013, 37265, 37521, 37781, 38033, 38293, 38533, 38785, 39049, 39309, 39565, 39817, 40077, 40329, 40585, 40845, 41141, 41393, 41649, 41909, 42161, 42421, 42661, 42913, 43177, 43437, 43693, 43945, 44205, 44457, 44713, 44973, 45233, 45493, 45749, 46001, 46261, 46513, 46753, 47013, 47277, 47529, 47785, 48045, 48297, 48557, 48813, 49065, 49301, 49553, 49809, 50069, 50321, 50581, 50821, 51073, 51337, 51597, 51853, 52105, 52365, 52617, 52873, 53133, 53393, 53653, 53909, 54161, 54421, 54673, 54913, 55173, 55437, 55689, 55945, 56205, 56457, 56717, 56973, 57225, 57521, 57781, 58037, 58289, 58549, 58801, 59041, 59301, 59565, 59817, 60073, 60333, 60585, 60845, 61101, 61353, 61621, 61873, 62129, 62389, 62641, 62901, 63141, 63393, 63657, 63917, 64173, 64425, 64685, 64937, 65193, 65453, 85, 273, 529, 789, 1041, 1301, 1541, 1793, 2057, 2317, 2573, 2825, 3085, 3337, 3593, 3853, 4113, 4373, 4629, 4881, 5141, 5393, 5633, 5893, 6157, 6409, 6665, 6925, 7177, 7437, 7693, 7945, 8241, 8501, 8757, 9009, 9269, 9521, 9761, 10021, 10285, 10537, 10793, 11053, 11305, 11565, 11821, 12073, 12341, 12593, 12849, 13109, 13361, 13621, 13861, 14113, 14377, 14637, 14893, 15145, 15405, 15657, 15913, 16173, 16401, 16661, 16917, 17169, 17429, 17681, 17921, 18181, 18445, 18697, 18953, 19213, 19465, 19725, 19981, 20233, 20501, 20753, 21009, 21269, 21521, 21781, 22021, 22273, 22537, 22797, 23053, 23305, 23565, 23817, 24073, 24333, 24629, 24881, 25137, 25397, 25649, 25909, 70, 258, 514, 774, 1026, 1286, 1542, 1794, 2058, 2318, 1026, 1286, 1542, 1794, 2058, 2318, 4098, 4358, 4614, 4866, 5126, 5378, 5634, 5894, 6158, 6410, 5126, 5378, 5634, 5894, 6158, 6410, 8226, 8486, 8742, 8994, 9254, 9506, 9762, 10022, 10286, 10538, 9254, 9506, 9762, 10022, 10286, 10538, 12326, 12578, 12834, 13094, 13346, 13606, 13862, 14114, 14378, 14638, 13346, 13606, 13862, 14114, 14378, 14638, 16386, 16646, 16902, 17154, 17414, 17666, 17922, 18182, 18446, 18698, 17414, 17666, 17922, 18182, 18446, 18698, 20486, 20738, 20994, 21254, 21506, 21766, 22022, 22274, 22538, 22798, 21506, 21766, 22022, 22274, 22538, 22798, 24614, 24866, 25122, 25382, 25634, 25894, 26150, 26402, 26666, 26926, 25634, 25894, 26150, 26402, 26666, 26926, 28706, 28966, 29222, 29474, 29734, 29986, 30242, 30502, 30766, 31018, 29734, 29986, 30242, 30502, 30766, 31018, 32898, 33158, 33414, 33666, 33926, 34178, 34434, 34694, 34958, 35210, 33926, 34178, 34434, 34694, 34958, 35210, 36998, 37250, 37506, 37766, 38018, 38278, 38534, 38786, 39050, 39310, 13347, 13607, 13863, 14115, 14379, 14639, 16387, 16647, 16903, 17155, 17415, 17667, 17923, 18183, 18447, 18699, 17415, 17667, 17923, 18183, 18447, 18699, 20487, 20739, 20995, 21255, 21507, 21767, 22023, 22275, 22539, 22799, 21507, 21767, 22023, 22275, 22539, 22799, 24615, 24867, 25123, 25383, 25635, 25895, 26151, 26403, 26667, 26927, 25635, 25895, 26151, 26403, 26667, 26927, 28707, 28967, 29223, 29475, 29735, 29987, 30243, 30503, 30767, 31019, 29735, 29987, 30243, 30503, 30767, 31019, 32899, 33159, 33415, 33667, 33927, 34179, 34435, 34695, 34959, 35211, 33927, 34179, 34435, 34695, 34959, 35211, 36999, 37251, 37507, 37767, 38019, 38279, 38535, 38787, 39051, 39311, 38019, 38279, 38535, 38787, 39051, 39311, 41127, 41379, 41635, 41895, 42147, 42407, 42663, 42915, 43179, 43439, 42147, 42407, 42663, 42915, 43179, 43439, 45219, 45479, 45735, 45987, 46247, 46499, 46755, 47015, 47279, 47531, 46247, 46499, 46755, 47015, 47279, 47531, 49287, 49539, 49795, 50055, 50307, 50567, 50823, 51075, 51339, 51599, 50307, 50567, 50823, 51075, 51339, 51599, 53379, 53639, 53895, 54147, 54407, 54659, 54915, 55175, 55439, 55691, 54407, 54659, 54915, 55175, 55439, 55691, 57507, 57767, 58023, 58275, 58535, 58787, 59043, 59303, 59567, 59819, 58535, 58787, 59043, 59303, 59567, 59819, 61607, 61859, 62115, 62375, 62627, 62887, 63143, 63395, 63659, 63919, 62627, 62887, 63143, 63395, 63659, 63919, 71, 259, 515, 775, 1027, 1287, 1543, 1795, 2059, 2319, 1027, 1287, 1543, 1795, 2059, 2319, 4099, 4359, 4615, 4867, 5127, 5379, 5635, 5895, 6159, 6411, 5127, 5379, 5635, 5895, 6159, 6411, 8227, 8487, 8743, 8995, 9255, 9507, 9763, 10023, 10287, 10539, 9255, 9507, 9763, 10023, 10287, 10539, 12327, 12579, 12835, 13095, 13347, 13607, 13863, 14115, 14379, 14639, 13347, 13607, 13863, 14115, 14379, 14639, 16387, 16647, 16903, 17155, 17415, 17667, 17923, 18183, 18447, 18699, 17415, 17667, 17923, 18183, 18447, 18699, 20487, 20739, 20995, 21255, 21507, 21767, 22023, 22275, 22539, 22799, 21507, 21767, 22023, 22275, 22539, 22799, 24615, 24867, 25123, 25383, 25635, 25895, 26151, 26403, 26667, 26927, 25635, 25895, 26151, 26403, 26667, 26927, 28707, 28967, 29223, 29475, 29735, 29987, 30243, 30503, 30767, 31019, 29735, 29987, 30243, 30503, 30767, 31019, 32899, 33159, 33415, 33667, 33927, 34179, 34435, 34695, 34959, 35211, 33927, 34179, 34435, 34695, 34959, 35211, 36999, 37251, 37507, 37767, 38019, 38279, 38535, 38787, 39051, 39311, 38019, 38279, 38535, 38787, 39051, 39311, 64190, 64442, 64702, 64954, 65210, 65470, 70, 258, 514, 774, 1026, 1286, 1542, 1794, 2058, 2318, 2590, 2842, 3102, 3354, 3610, 3870, 4098, 4358, 4614, 4866, 5126, 5378, 5634, 5894, 6158, 6410, 6682, 6942, 7194, 7454, 7710, 7962, 8226, 8486, 8742, 8994, 9254, 9506, 9762, 10022, 10286, 10538, 10810, 11070, 11322, 11582, 11838, 12090, 12326, 12578, 12834, 13094, 13346, 13606, 13862, 14114, 14378, 14638, 14910, 15162, 15422, 15674, 15930, 16190, 16386, 16646, 16902, 17154, 17414, 17666, 17922, 18182, 18446, 18698, 18970, 19230, 19482, 19742, 19998, 20250, 20486, 20738, 20994, 21254, 21506, 21766, 22022, 22274, 22538, 22798, 23070, 23322, 23582, 23834, 24090, 24350, 24614, 24866, 25122, 25382, 25634, 25894, 26150, 26402, 26666, 26926, 27198, 27450, 27710, 27962, 28218, 28478, 28706, 28966, 29222, 29474, 29734, 29986, 30242, 30502, 30766, 31018, 31290, 31550, 31802, 32062, 32318, 32570, 32898, 33158, 33414, 33666, 33926, 34178, 34434, 34694, 34958, 35210, 35482, 35742, 35994, 36254, 36510, 36762, 36998, 37250, 37506, 37766, 13347, 13607, 13863, 14115, 14379, 14639, 14911, 15163, 15423, 15675, 15931, 16191, 16387, 16647, 16903, 17155, 17415, 17667, 17923, 18183, 18447, 18699, 18971, 19231, 19483, 19743, 19999, 20251, 20487, 20739, 20995, 21255, 21507, 21767, 22023, 22275, 22539, 22799, 23071, 23323, 23583, 23835, 24091, 24351, 24615, 24867, 25123, 25383, 25635, 25895, 26151, 26403, 26667, 26927, 27199, 27451, 27711, 27963, 28219, 28479, 28707, 28967, 29223, 29475, 29735, 29987, 30243, 30503, 30767, 31019, 31291, 31551, 31803, 32063, 32319, 32571, 32899, 33159, 33415, 33667, 33927, 34179, 34435, 34695, 34959, 35211, 35483, 35743, 35995, 36255, 36511, 36763, 36999, 37251, 37507, 37767, 38019, 38279, 38535, 38787, 39051, 39311, 39583, 39835, 40095, 40347, 40603, 40863, 41127, 41379, 41635, 41895, 42147, 42407, 42663, 42915, 43179, 43439, 43711, 43963, 44223, 44475, 44731, 44991, 45219, 45479, 45735, 45987, 46247, 46499, 46755, 47015, 47279, 47531, 47803, 48063, 48315, 48575, 48831, 49083, 49287, 49539, 49795, 50055, 50307, 50567, 50823, 51075, 51339, 51599, 51871, 52123, 52383, 52635, 52891, 53151, 53379, 53639, 53895, 54147, 54407, 54659, 54915, 55175, 55439, 55691, 55963, 56223, 56475, 56735, 56991, 57243, 57507, 57767, 58023, 58275, 58535, 58787, 59043, 59303, 59567, 59819, 60091, 60351, 60603, 60863, 61119, 61371, 61607, 61859, 62115, 62375, 62627, 62887, 63143, 63395, 63659, 63919, 64191, 64443, 64703, 64955, 65211, 65471, 71, 259, 515, 775, 1027, 1287, 1543, 1795, 2059, 2319, 2591, 2843, 3103, 3355, 3611, 3871, 4099, 4359, 4615, 4867, 5127, 5379, 5635, 5895, 6159, 6411, 6683, 6943, 7195, 7455, 7711, 7963, 8227, 8487, 8743, 8995, 9255, 9507, 9763, 10023, 10287, 10539, 10811, 11071, 11323, 11583, 11839, 12091, 12327, 12579, 12835, 13095, 13347, 13607, 13863, 14115, 14379, 14639, 14911, 15163, 15423, 15675, 15931, 16191, 16387, 16647, 16903, 17155, 17415, 17667, 17923, 18183, 18447, 18699, 18971, 19231, 19483, 19743, 19999, 20251, 20487, 20739, 20995, 21255, 21507, 21767, 22023, 22275, 22539, 22799, 23071, 23323, 23583, 23835, 24091, 24351, 24615, 24867, 25123, 25383, 25635, 25895, 26151, 26403, 26667, 26927, 27199, 27451, 27711, 27963, 28219, 28479, 28707, 28967, 29223, 29475, 29735, 29987, 30243, 30503, 30767, 31019, 31291, 31551, 31803, 32063, 32319, 32571, 32899, 33159, 33415, 33667, 33927, 34179, 34435, 34695, 34959, 35211, 35483, 35743, 35995, 36255, 36511, 36763, 36999, 37251, 37507, 37767, 38019, 38279, 38535, 38787, 39051, 39311};

    public Z80(Memory memory, Port port) {
        this.IX = new Reg16("IX", this.IXh, this.IXl);
        this.IY = new Reg16("IY", this.IYh, this.IYl);
        this.IM = new Reg8("IM");
        this.I = new Reg8("I");
        this.R = new Reg8("R");
        this.IND = this.IX;
        this.r8 = new Reg8[8];
        this.r8[0] = this.B;
        this.r8[1] = this.C;
        this.r8[2] = this.D;
        this.r8[3] = this.E;
        this.r8[4] = this.H;
        this.r8[5] = this.L;
        this.r8[6] = null;
        this.r8[7] = this.A;
        this.p8 = new Reg8[8];
        this.p8[0] = this.B;
        this.p8[1] = this.C;
        this.p8[2] = this.D;
        this.p8[3] = this.E;
        this.p8[4] = this.IND.rh;
        this.p8[5] = this.IND.rl;
        this.p8[6] = null;
        this.p8[7] = this.A;
        this.r16 = new Reg16[4];
        this.r16[0] = this.BC;
        this.r16[1] = this.DE;
        this.r16[2] = this.HL;
        this.r16[3] = this.SP;
        this.r16AF = new Reg16[4];
        this.r16AF[0] = this.BC;
        this.r16AF[1] = this.DE;
        this.r16AF[2] = this.HL;
        this.r16AF[3] = this.AF;
        this.r16IND = new Reg16[4];
        this.r16IND[0] = this.BC;
        this.r16IND[1] = this.DE;
        this.r16IND[3] = this.SP;
        this.pPC = new int[1024];
        this.t = 0L;
        this.log = Log.getInstance();
        this.memory = memory;
        this.port = port;
    }

    public final void reset() {
        this.PC.r = 0;
        this.IM.r = 0;
        this.AF.set(65535);
        this.SP.r = 65535;
        this.IFF1 = false;
        this.IFF2 = false;
        this.halt = false;
        this.prevEI = false;
    }

    public final void interrupt() {
        if (this.prevEI) {
            return;
        }
        if (!this.IFF1) {
            return;
        }
        if (this.halt) {
            this.PC.add(1);
            this.halt = false;
        }
        if (this.traceCPU >= TRC_ALL) {
            this.traceCPU(1, "irq accepted");
        }
        switch (this.IM.r) {
            case 0: {
                this.t += 13L;
                break;
            }
            case 1: {
                this.SP.r = this.SP.r - 2 & 0xFFFF;
                this.memory.setWord(this.SP.r, this.PC.r);
                this.IFF1 = false;
                this.IFF2 = false;
                this.PC.r = 56;
                this.t += 13L;
                return;
            }
            case 2: {
                this.SP.r = this.SP.r - 2 & 0xFFFF;
                this.memory.setWord(this.SP.r, this.PC.r);
                this.IFF1 = false;
                this.IFF2 = false;
                int n = this.I.r << 8 | 0xFF;
                this.PC.r = this.memory.getWord(n);
                this.t += 19L;
                return;
            }
        }
    }

    public final boolean run() {
        boolean bl = true;
        this.pPC[this.ppi] = this.PC.r;
        this.ppi = this.ppi + 1 & 0x3FF;
        this.prevEI = false;
        this.opcode = this.memory.getByte(this.PC.r);
        this.R.r = this.R.r & 0x80 | this.R.r + 1 & 0x7F;
        block0 : switch (this.opcode) {
            case 64: 
            case 65: 
            case 66: 
            case 67: 
            case 68: 
            case 69: 
            case 71: 
            case 72: 
            case 73: 
            case 74: 
            case 75: 
            case 76: 
            case 77: 
            case 79: 
            case 80: 
            case 81: 
            case 82: 
            case 83: 
            case 84: 
            case 85: 
            case 87: 
            case 88: 
            case 89: 
            case 90: 
            case 91: 
            case 92: 
            case 93: 
            case 95: 
            case 96: 
            case 97: 
            case 98: 
            case 99: 
            case 100: 
            case 101: 
            case 103: 
            case 104: 
            case 105: 
            case 106: 
            case 107: 
            case 108: 
            case 109: 
            case 111: 
            case 120: 
            case 121: 
            case 122: 
            case 123: 
            case 124: 
            case 125: 
            case 127: {
                this.instLD_r8_r8();
                break;
            }
            case 6: 
            case 14: 
            case 22: 
            case 30: 
            case 38: 
            case 46: 
            case 62: {
                this.instLD_r8_n8();
                break;
            }
            case 70: 
            case 78: 
            case 86: 
            case 94: 
            case 102: 
            case 110: 
            case 126: {
                this.instLD_r8_iHL();
                break;
            }
            case 112: 
            case 113: 
            case 114: 
            case 115: 
            case 116: 
            case 117: 
            case 119: {
                this.instLD_iHL_r8();
                break;
            }
            case 1: 
            case 17: 
            case 33: 
            case 49: {
                this.instLD_r16_n16();
                break;
            }
            case 54: {
                this.instLD_iHL_n8();
                break;
            }
            case 58: {
                this.instLD_A_in16();
                break;
            }
            case 50: {
                this.instLD_in16_A();
                break;
            }
            case 10: {
                this.instLD_A_iBC();
                break;
            }
            case 26: {
                this.instLD_A_iDE();
                break;
            }
            case 34: {
                this.instLD_in16_HL();
                break;
            }
            case 42: {
                this.instLD_HL_in16();
                break;
            }
            case 18: {
                this.instLD_iDE_A();
                break;
            }
            case 2: {
                this.instLD_iBC_A();
                break;
            }
            case 249: {
                this.instLD_SP_HL();
                break;
            }
            case 211: {
                this.instOUT_n_A();
                break;
            }
            case 219: {
                this.instIN_A_n();
                break;
            }
            case 0: {
                this.instNOP();
                break;
            }
            case 8: {
                this.instEX_AF_AF();
                break;
            }
            case 15: {
                this.instRRCA();
                break;
            }
            case 7: {
                this.instRLCA();
                break;
            }
            case 23: {
                this.instRLA();
                break;
            }
            case 31: {
                this.instRRA();
                break;
            }
            case 32: {
                this.instJR_NZ_n8();
                break;
            }
            case 40: {
                this.instJR_Z_n8();
                break;
            }
            case 48: {
                this.instJR_NC_n8();
                break;
            }
            case 56: {
                this.instJR_C_n8();
                break;
            }
            case 16: {
                this.instDJNZ();
                break;
            }
            case 184: 
            case 185: 
            case 186: 
            case 187: 
            case 188: 
            case 189: 
            case 191: {
                this.instCP_r8();
                break;
            }
            case 254: {
                this.instCP_n8();
                break;
            }
            case 190: {
                this.instCP_iHL();
                break;
            }
            case 24: {
                this.instJR_n8();
                break;
            }
            case 195: {
                this.instJP();
                break;
            }
            case 233: {
                this.instJP_HL();
                break;
            }
            case 194: 
            case 202: 
            case 210: 
            case 218: 
            case 226: 
            case 234: 
            case 242: 
            case 250: {
                this.instJP_cc_n16();
                break;
            }
            case 196: 
            case 204: 
            case 212: 
            case 220: 
            case 228: 
            case 236: 
            case 244: 
            case 252: {
                this.instCALL_cc_n16();
                break;
            }
            case 205: {
                this.instCALL_n16();
                break;
            }
            case 201: {
                this.instRET();
                break;
            }
            case 192: 
            case 200: 
            case 208: 
            case 216: 
            case 224: 
            case 232: 
            case 240: 
            case 248: {
                this.instRET_cc();
                break;
            }
            case 199: 
            case 207: 
            case 215: 
            case 223: 
            case 231: 
            case 239: 
            case 247: 
            case 255: {
                this.instRST_p();
                break;
            }
            case 217: {
                this.instEXX();
                break;
            }
            case 227: {
                this.instEX_iSP_HL();
                break;
            }
            case 235: {
                this.instEX_DE_HL();
                break;
            }
            case 243: {
                this.instDI();
                break;
            }
            case 251: {
                this.instEI();
                this.prevEI = true;
                break;
            }
            case 118: {
                this.instHALT();
                break;
            }
            case 3: 
            case 19: 
            case 35: 
            case 51: {
                this.instINC_r16();
                break;
            }
            case 11: 
            case 27: 
            case 43: 
            case 59: {
                this.instDEC_r16();
                break;
            }
            case 128: 
            case 129: 
            case 130: 
            case 131: 
            case 132: 
            case 133: 
            case 135: {
                this.instADD_r8();
                break;
            }
            case 134: {
                this.instADD_iHL();
                break;
            }
            case 198: {
                this.instADD_n8();
                break;
            }
            case 136: 
            case 137: 
            case 138: 
            case 139: 
            case 140: 
            case 141: 
            case 143: {
                this.instADC_r8();
                break;
            }
            case 206: {
                this.instADC_n8();
                break;
            }
            case 142: {
                this.instADC_iHL();
                break;
            }
            case 9: 
            case 25: 
            case 41: 
            case 57: {
                this.instADD_HL_r16();
                break;
            }
            case 39: {
                this.instDAA();
                break;
            }
            case 144: 
            case 145: 
            case 146: 
            case 147: 
            case 148: 
            case 149: 
            case 151: {
                this.instSUB_r8();
                break;
            }
            case 214: {
                this.instSUB_n8();
                break;
            }
            case 150: {
                this.instSUB_iHL();
                break;
            }
            case 152: 
            case 153: 
            case 154: 
            case 155: 
            case 156: 
            case 157: 
            case 159: {
                this.instSBC_r8();
                break;
            }
            case 222: {
                this.instSBC_n8();
                break;
            }
            case 158: {
                this.instSBC_iHL();
                break;
            }
            case 176: 
            case 177: 
            case 178: 
            case 179: 
            case 180: 
            case 181: 
            case 183: {
                this.instOR_r8();
                break;
            }
            case 246: {
                this.instOR_n8();
                break;
            }
            case 182: {
                this.instOR_iHL();
                break;
            }
            case 160: 
            case 161: 
            case 162: 
            case 163: 
            case 164: 
            case 165: 
            case 167: {
                this.instAND_r8();
                break;
            }
            case 230: {
                this.instAND_n8();
                break;
            }
            case 166: {
                this.instAND_iHL();
                break;
            }
            case 168: 
            case 169: 
            case 170: 
            case 171: 
            case 172: 
            case 173: 
            case 175: {
                this.instXOR_r8();
                break;
            }
            case 238: {
                this.instXOR_n8();
                break;
            }
            case 174: {
                this.instXOR_iHL();
                break;
            }
            case 4: 
            case 12: 
            case 20: 
            case 28: 
            case 36: 
            case 44: 
            case 60: {
                this.instINC_r8();
                break;
            }
            case 52: {
                this.instINC_iHL();
                break;
            }
            case 5: 
            case 13: 
            case 21: 
            case 29: 
            case 37: 
            case 45: 
            case 61: {
                this.instDEC_r8();
                break;
            }
            case 53: {
                this.instDEC_iHL();
                break;
            }
            case 193: 
            case 209: 
            case 225: 
            case 241: {
                this.instPOP_r16();
                break;
            }
            case 197: 
            case 213: 
            case 229: 
            case 245: {
                this.instPUSH_r16();
                break;
            }
            case 47: {
                this.instCPL();
                break;
            }
            case 55: {
                this.instSCF();
                break;
            }
            case 63: {
                this.instCCF();
                break;
            }
            case 203: {
                this.opcode = this.memory.getByte(this.PC.r + 1);
                this.R.r = this.R.r & 0x80 | this.R.r + 1 & 0x7F;
                switch (this.opcode) {
                    case 0: 
                    case 1: 
                    case 2: 
                    case 3: 
                    case 4: 
                    case 5: 
                    case 7: {
                        this.instRLC_r8();
                        break block0;
                    }
                    case 6: {
                        this.instRLC_iHL();
                        break block0;
                    }
                    case 8: 
                    case 9: 
                    case 10: 
                    case 11: 
                    case 12: 
                    case 13: 
                    case 15: {
                        this.instRRC_r8();
                        break block0;
                    }
                    case 14: {
                        this.instRRC_iHL();
                        break block0;
                    }
                    case 16: 
                    case 17: 
                    case 18: 
                    case 19: 
                    case 20: 
                    case 21: 
                    case 23: {
                        this.instRL_r8();
                        break block0;
                    }
                    case 22: {
                        this.instRL_iHL();
                        break block0;
                    }
                    case 24: 
                    case 25: 
                    case 26: 
                    case 27: 
                    case 28: 
                    case 29: 
                    case 31: {
                        this.instRR_r8();
                        break block0;
                    }
                    case 30: {
                        this.instRR_iHL();
                        break block0;
                    }
                    case 32: 
                    case 33: 
                    case 34: 
                    case 35: 
                    case 36: 
                    case 37: 
                    case 39: {
                        this.instSLA_r8();
                        break block0;
                    }
                    case 38: {
                        this.instSLA_iHL();
                        break block0;
                    }
                    case 40: 
                    case 41: 
                    case 42: 
                    case 43: 
                    case 44: 
                    case 45: 
                    case 47: {
                        this.instSRA_r8();
                        break block0;
                    }
                    case 46: {
                        this.instSRA_iHL();
                        break block0;
                    }
                    case 48: 
                    case 49: 
                    case 50: 
                    case 51: 
                    case 52: 
                    case 53: 
                    case 55: {
                        this.instSLL_r8();
                        break block0;
                    }
                    case 54: {
                        this.instSLL_iHL();
                        break block0;
                    }
                    case 56: 
                    case 57: 
                    case 58: 
                    case 59: 
                    case 60: 
                    case 61: 
                    case 63: {
                        this.instSRL_r8();
                        break block0;
                    }
                    case 62: {
                        this.instSRL_iHL();
                        break block0;
                    }
                    case 64: 
                    case 65: 
                    case 66: 
                    case 67: 
                    case 68: 
                    case 69: 
                    case 71: 
                    case 72: 
                    case 73: 
                    case 74: 
                    case 75: 
                    case 76: 
                    case 77: 
                    case 79: 
                    case 80: 
                    case 81: 
                    case 82: 
                    case 83: 
                    case 84: 
                    case 85: 
                    case 87: 
                    case 88: 
                    case 89: 
                    case 90: 
                    case 91: 
                    case 92: 
                    case 93: 
                    case 95: 
                    case 96: 
                    case 97: 
                    case 98: 
                    case 99: 
                    case 100: 
                    case 101: 
                    case 103: 
                    case 104: 
                    case 105: 
                    case 106: 
                    case 107: 
                    case 108: 
                    case 109: 
                    case 111: 
                    case 112: 
                    case 113: 
                    case 114: 
                    case 115: 
                    case 116: 
                    case 117: 
                    case 119: 
                    case 120: 
                    case 121: 
                    case 122: 
                    case 123: 
                    case 124: 
                    case 125: 
                    case 127: {
                        this.instBIT_b_r8();
                        break block0;
                    }
                    case 70: 
                    case 78: 
                    case 86: 
                    case 94: 
                    case 102: 
                    case 110: 
                    case 118: 
                    case 126: {
                        this.instBIT_b_iHL();
                        break block0;
                    }
                    case 192: 
                    case 193: 
                    case 194: 
                    case 195: 
                    case 196: 
                    case 197: 
                    case 199: 
                    case 200: 
                    case 201: 
                    case 202: 
                    case 203: 
                    case 204: 
                    case 205: 
                    case 207: 
                    case 208: 
                    case 209: 
                    case 210: 
                    case 211: 
                    case 212: 
                    case 213: 
                    case 215: 
                    case 216: 
                    case 217: 
                    case 218: 
                    case 219: 
                    case 220: 
                    case 221: 
                    case 223: 
                    case 224: 
                    case 225: 
                    case 226: 
                    case 227: 
                    case 228: 
                    case 229: 
                    case 231: 
                    case 232: 
                    case 233: 
                    case 234: 
                    case 235: 
                    case 236: 
                    case 237: 
                    case 239: 
                    case 240: 
                    case 241: 
                    case 242: 
                    case 243: 
                    case 244: 
                    case 245: 
                    case 247: 
                    case 248: 
                    case 249: 
                    case 250: 
                    case 251: 
                    case 252: 
                    case 253: 
                    case 255: {
                        this.instSET_b_r8();
                        break block0;
                    }
                    case 198: 
                    case 206: 
                    case 214: 
                    case 222: 
                    case 230: 
                    case 238: 
                    case 246: 
                    case 254: {
                        this.instSET_b_iHL();
                        break block0;
                    }
                    case 128: 
                    case 129: 
                    case 130: 
                    case 131: 
                    case 132: 
                    case 133: 
                    case 135: 
                    case 136: 
                    case 137: 
                    case 138: 
                    case 139: 
                    case 140: 
                    case 141: 
                    case 143: 
                    case 144: 
                    case 145: 
                    case 146: 
                    case 147: 
                    case 148: 
                    case 149: 
                    case 151: 
                    case 152: 
                    case 153: 
                    case 154: 
                    case 155: 
                    case 156: 
                    case 157: 
                    case 159: 
                    case 160: 
                    case 161: 
                    case 162: 
                    case 163: 
                    case 164: 
                    case 165: 
                    case 167: 
                    case 168: 
                    case 169: 
                    case 170: 
                    case 171: 
                    case 172: 
                    case 173: 
                    case 175: 
                    case 176: 
                    case 177: 
                    case 178: 
                    case 179: 
                    case 180: 
                    case 181: 
                    case 183: 
                    case 184: 
                    case 185: 
                    case 186: 
                    case 187: 
                    case 188: 
                    case 189: 
                    case 191: {
                        this.instRES_b_r8();
                        break block0;
                    }
                    case 134: 
                    case 142: 
                    case 150: 
                    case 158: 
                    case 166: 
                    case 174: 
                    case 182: 
                    case 190: {
                        this.instRES_b_iHL();
                        break block0;
                    }
                }
                this.traceCPU = 10;
                this.traceCPU(2, "Unknown instruction!!!");
                this.prevPCs();
                bl = false;
                break;
            }
            case 237: {
                this.opcode = this.memory.getByte(this.PC.r + 1);
                this.R.r = this.R.r & 0x80 | this.R.r + 1 & 0x7F;
                switch (this.opcode) {
                    case 70: {
                        this.instIM_0();
                        break block0;
                    }
                    case 86: {
                        this.instIM_1();
                        break block0;
                    }
                    case 94: {
                        this.instIM_2();
                        break block0;
                    }
                    case 161: {
                        this.instCPI();
                        break block0;
                    }
                    case 177: {
                        this.instCPIR();
                        break block0;
                    }
                    case 169: {
                        this.instCPD();
                        break block0;
                    }
                    case 185: {
                        this.instCPDR();
                        break block0;
                    }
                    case 160: {
                        this.instLDI();
                        break block0;
                    }
                    case 176: {
                        this.instLDIR();
                        break block0;
                    }
                    case 168: {
                        this.instLDD();
                        break block0;
                    }
                    case 184: {
                        this.instLDDR();
                        break block0;
                    }
                    case 68: {
                        this.instNEG();
                        break block0;
                    }
                    case 64: 
                    case 72: 
                    case 80: 
                    case 88: 
                    case 96: 
                    case 104: 
                    case 112: 
                    case 120: {
                        this.instIN_r8_C();
                        break block0;
                    }
                    case 162: {
                        this.instINI();
                        break block0;
                    }
                    case 178: {
                        this.instINIR();
                        break block0;
                    }
                    case 170: {
                        this.instIND();
                        break block0;
                    }
                    case 186: {
                        this.instINDR();
                        break block0;
                    }
                    case 65: 
                    case 73: 
                    case 81: 
                    case 89: 
                    case 97: 
                    case 105: 
                    case 121: {
                        this.instOUT_C_r8();
                        break block0;
                    }
                    case 113: {
                        this.instOUT_C_0();
                        break block0;
                    }
                    case 163: {
                        this.instOUTI();
                        break block0;
                    }
                    case 179: {
                        this.instOTIR();
                        break block0;
                    }
                    case 171: {
                        this.instOUTD();
                        break block0;
                    }
                    case 187: {
                        this.instOTDR();
                        break block0;
                    }
                    case 67: 
                    case 83: 
                    case 99: 
                    case 115: {
                        this.instLD_in16_r16();
                        break block0;
                    }
                    case 66: 
                    case 82: 
                    case 98: 
                    case 114: {
                        this.instSBC_HL_r16();
                        break block0;
                    }
                    case 75: 
                    case 91: 
                    case 107: 
                    case 123: {
                        this.instLD_r16_in16();
                        break block0;
                    }
                    case 74: 
                    case 90: 
                    case 106: 
                    case 122: {
                        this.instADC_HL_r16();
                        break block0;
                    }
                    case 69: 
                    case 77: {
                        this.instRETI();
                        break block0;
                    }
                    case 111: {
                        this.instRLD();
                        break block0;
                    }
                    case 103: {
                        this.instRRD();
                        break block0;
                    }
                    case 71: {
                        this.instLD_I_A();
                        break block0;
                    }
                    case 87: {
                        this.instLD_A_I();
                        break block0;
                    }
                    case 79: {
                        this.instLD_R_A();
                        break block0;
                    }
                    case 95: {
                        this.instLD_A_R();
                        break block0;
                    }
                }
                this.traceCPU = 10;
                this.traceCPU(2, "Unknown instruction!!!");
                this.prevPCs();
                bl = false;
                break;
            }
            case 221: 
            case 253: {
                this.IND = this.opcode == 221 ? this.IX : this.IY;
                this.r16IND[2] = this.IND;
                this.opcode = this.memory.getByte(this.PC.r + 1);
                this.R.r = this.R.r & 0x80 | this.R.r + 1 & 0x7F;
                switch (this.opcode) {
                    case 33: {
                        this.instLD_IND_n16();
                        break block0;
                    }
                    case 34: {
                        this.instLD_in16_IND();
                        break block0;
                    }
                    case 36: 
                    case 44: {
                        this.instINC_p8();
                        break block0;
                    }
                    case 37: 
                    case 45: {
                        this.instDEC_p8();
                        break block0;
                    }
                    case 225: {
                        this.instPOP_IND();
                        break block0;
                    }
                    case 227: {
                        this.instEX_iSP_IND();
                        break block0;
                    }
                    case 229: {
                        this.instPUSH_IND();
                        break block0;
                    }
                    case 233: {
                        this.instJP_IND();
                        break block0;
                    }
                    case 9: 
                    case 25: 
                    case 41: 
                    case 57: {
                        this.instADD_IND_r16();
                        break block0;
                    }
                    case 42: {
                        this.instLD_IND_in16();
                        break block0;
                    }
                    case 52: {
                        this.instINC_iINDd();
                        break block0;
                    }
                    case 53: {
                        this.instDEC_iINDd();
                        break block0;
                    }
                    case 54: {
                        this.instLD_iINDd_n8();
                        break block0;
                    }
                    case 35: {
                        this.instINC_IND();
                        break block0;
                    }
                    case 43: {
                        this.instDEC_IND();
                        break block0;
                    }
                    case 68: 
                    case 69: 
                    case 76: 
                    case 77: 
                    case 84: 
                    case 85: 
                    case 92: 
                    case 93: 
                    case 96: 
                    case 97: 
                    case 98: 
                    case 99: 
                    case 100: 
                    case 101: 
                    case 103: 
                    case 104: 
                    case 105: 
                    case 106: 
                    case 107: 
                    case 108: 
                    case 109: 
                    case 111: 
                    case 124: 
                    case 125: {
                        this.instLD_p8_p8();
                        break block0;
                    }
                    case 38: 
                    case 46: {
                        this.instLD_p8_n8();
                        break block0;
                    }
                    case 70: 
                    case 78: 
                    case 86: 
                    case 94: 
                    case 102: 
                    case 110: 
                    case 126: {
                        this.instLD_r8_iINDd();
                        break block0;
                    }
                    case 112: 
                    case 113: 
                    case 114: 
                    case 115: 
                    case 116: 
                    case 117: 
                    case 119: {
                        this.instLD_iINDd_r8();
                        break block0;
                    }
                    case 132: 
                    case 133: {
                        this.instADD_p8();
                        break block0;
                    }
                    case 140: 
                    case 141: {
                        this.instADC_p8();
                        break block0;
                    }
                    case 148: 
                    case 149: {
                        this.instSUB_p8();
                        break block0;
                    }
                    case 156: 
                    case 157: {
                        this.instSBC_p8();
                        break block0;
                    }
                    case 164: 
                    case 165: {
                        this.instAND_p8();
                        break block0;
                    }
                    case 172: 
                    case 173: {
                        this.instXOR_p8();
                        break block0;
                    }
                    case 180: 
                    case 181: {
                        this.instOR_p8();
                        break block0;
                    }
                    case 134: {
                        this.instADD_iINDd();
                        break block0;
                    }
                    case 142: {
                        this.instADC_iINDd();
                        break block0;
                    }
                    case 150: {
                        this.instSUB_iINDd();
                        break block0;
                    }
                    case 158: {
                        this.instSBC_iINDd();
                        break block0;
                    }
                    case 166: {
                        this.instAND_iINDd();
                        break block0;
                    }
                    case 174: {
                        this.instXOR_iINDd();
                        break block0;
                    }
                    case 182: {
                        this.instOR_iINDd();
                        break block0;
                    }
                    case 190: {
                        this.instCP_iINDd();
                        break block0;
                    }
                    case 249: {
                        this.instLD_SP_IND();
                        break block0;
                    }
                    case 203: {
                        this.opcode = this.memory.getByte(this.PC.r + 3);
                        switch (this.opcode) {
                            case 6: {
                                this.instRLC_iINDd();
                                break block0;
                            }
                            case 14: {
                                this.instRRC_iINDd();
                                break block0;
                            }
                            case 22: {
                                this.instRL_iINDd();
                                break block0;
                            }
                            case 30: {
                                this.instRR_iINDd();
                                break block0;
                            }
                            case 38: {
                                this.instSLA_iINDd();
                                break block0;
                            }
                            case 46: {
                                this.instSRA_iINDd();
                                break block0;
                            }
                            case 54: {
                                this.instSLL_iINDd();
                                break block0;
                            }
                            case 62: {
                                this.instSRL_iINDd();
                                break block0;
                            }
                            case 70: 
                            case 78: 
                            case 86: 
                            case 94: 
                            case 102: 
                            case 110: 
                            case 118: 
                            case 126: {
                                this.instBIT_b_iINDd();
                                break block0;
                            }
                            case 134: 
                            case 142: 
                            case 150: 
                            case 158: 
                            case 166: 
                            case 174: 
                            case 182: 
                            case 190: {
                                this.instRES_b_iINDd();
                                break block0;
                            }
                            case 198: 
                            case 206: 
                            case 214: 
                            case 222: 
                            case 230: 
                            case 238: 
                            case 246: 
                            case 254: {
                                this.instSET_b_iINDd();
                                break block0;
                            }
                        }
                        this.traceCPU = 1;
                        this.traceCPU(4, "Unknown instruction!!!");
                        this.prevPCs();
                        bl = false;
                        break block0;
                    }
                }
                this.traceCPU = 1;
                this.traceCPU(2, "Unknown instruction!!!");
                this.prevPCs();
                bl = false;
                break;
            }
            default: {
                this.traceCPU = 10;
                this.traceCPU(1, "Unknown instruction!!!");
                this.prevPCs();
                bl = false;
            }
        }
        return bl;
    }

    public final void setFlagS(boolean bl) {
        this.F.r = bl ? (this.F.r |= SET_S) : (this.F.r &= ~SET_S);
    }

    public final void setFlagZ(boolean bl) {
        this.F.r = bl ? (this.F.r |= SET_Z) : (this.F.r &= ~SET_Z);
    }

    public final void setFlagH(boolean bl) {
        this.F.r = bl ? (this.F.r |= SET_H) : (this.F.r &= ~SET_H);
    }

    public final void setFlagPV(boolean bl) {
        this.F.r = bl ? (this.F.r |= SET_PV) : (this.F.r &= ~SET_PV);
    }

    public final void setFlagN(boolean bl) {
        this.F.r = bl ? (this.F.r |= SET_N) : (this.F.r &= ~SET_N);
    }

    public final void setFlagC(boolean bl) {
        this.F.r = bl ? (this.F.r |= SET_C) : (this.F.r &= ~SET_C);
    }

    public final void setFlag3(boolean bl) {
        this.F.r = bl ? (this.F.r |= SET_3) : (this.F.r &= ~SET_3);
    }

    public final void setFlag5(boolean bl) {
        this.F.r = bl ? (this.F.r |= SET_5) : (this.F.r &= ~SET_5);
    }

    public final boolean getFlagS() {
        return (this.F.r & SET_S) != 0;
    }

    public final boolean getFlagZ() {
        return (this.F.r & SET_Z) != 0;
    }

    public final boolean getFlagH() {
        return (this.F.r & SET_H) != 0;
    }

    public final boolean getFlagPV() {
        return (this.F.r & SET_PV) != 0;
    }

    public final boolean getFlagN() {
        return (this.F.r & SET_N) != 0;
    }

    public final boolean getFlagC() {
        return (this.F.r & SET_C) != 0;
    }

    public final boolean getFlag3() {
        return (this.F.r & SET_3) != 0;
    }

    public final boolean getFlag5() {
        return (this.F.r & SET_5) != 0;
    }

    public final boolean getccValue(int n) {
        switch (n) {
            case 0: {
                return !this.getFlagZ();
            }
            case 1: {
                return this.getFlagZ();
            }
            case 2: {
                return !this.getFlagC();
            }
            case 3: {
                return this.getFlagC();
            }
            case 4: {
                return !this.getFlagPV();
            }
            case 5: {
                return this.getFlagPV();
            }
            case 6: {
                return !this.getFlagS();
            }
            case 7: {
                return this.getFlagS();
            }
        }
        return false;
    }

    public final String getccName(int n) {
        return flagNames[n];
    }

    public final void instLD_r8_r8() {
        Reg8 reg8 = this.r8[(this.opcode & 0x38) >> 3];
        Reg8 reg82 = this.r8[this.opcode & 7];
        if (this.traceCPU >= TRC_ALL) {
            this.traceCPU(1, "LD    " + reg8.name + "," + reg82.name);
        }
        reg8.r = reg82.r;
        this.addPC_T(1, 4);
    }

    public final void instLD_p8_p8() {
        Reg8 reg8 = this.p8[(this.opcode & 0x38) >> 3];
        Reg8 reg82 = this.p8[this.opcode & 7];
        if (this.traceCPU >= TRC_ALL) {
            this.traceCPU(2, "LD    " + reg8.name + "," + reg82.name);
        }
        reg8.r = reg82.r;
        this.addPC_T(2, 8);
    }

    public final void instLD_r8_n8() {
        int n = this.memory.getByte(this.PC.r + 1);
        Reg8 reg8 = this.r8[(this.opcode & 0x38) >> 3];
        if (this.traceCPU >= TRC_ALL) {
            this.traceCPU(2, "LD    " + reg8.name + "," + this.b2hds(n));
        }
        reg8.r = n;
        this.addPC_T(2, 7);
    }

    public final void instLD_p8_n8() {
        int n = this.memory.getByte(this.PC.r + 1);
        Reg8 reg8 = this.p8[(this.opcode & 0x38) >> 3];
        if (this.traceCPU >= TRC_ALL) {
            this.traceCPU(3, "LD    " + reg8.name + "," + this.b2hds(n));
        }
        reg8.r = n;
        this.addPC_T(3, 11);
    }

    public final void instLD_r8_iHL() {
        int n = this.memory.getByte(this.HL.get());
        Reg8 reg8 = this.r8[(this.opcode & 0x38) >> 3];
        if (this.traceCPU >= TRC_ALL) {
            this.traceCPU(1, "LD    " + reg8.name + ",(HL)" + "  ; (HL)=" + this.w2hds(n));
        }
        reg8.r = n;
        this.addPC_T(1, 7);
    }

    public final void instLD_iHL_r8() {
        Reg8 reg8 = this.r8[this.opcode & 7];
        if (this.traceCPU >= TRC_ALL) {
            this.traceCPU(1, "LD    (HL)," + reg8.name);
        }
        this.memory.setByte(this.HL.get(), reg8.r);
        this.addPC_T(1, 7);
    }

    public final void instLD_iHL_n8() {
        int n = this.memory.getByte(this.PC.r + 1);
        if (this.traceCPU >= TRC_ALL) {
            this.traceCPU(2, "LD    (HL)," + this.toHexString(n, 2) + "   ; (HL)=" + this.w2hds(this.HL.get()));
        }
        this.memory.setByte(this.HL.get(), n);
        this.addPC_T(2, 10);
    }

    public final void instLD_r8_iINDd() {
        int n = this.memory.getByte(this.PC.r + 2);
        int n2 = this.memory.getByte(this.IND.get() + (byte)n & 0xFFFF);
        Reg8 reg8 = this.r8[(this.opcode & 0x38) >> 3];
        if (this.traceCPU >= TRC_ALL) {
            this.traceCPU(3, "LD    " + reg8.name + ",(IY+d)");
        }
        reg8.r = n2;
        this.addPC_T(3, 19);
    }

    public final void instLD_iINDd_r8() {
        int n = this.memory.getByte(this.PC.r + 2);
        Reg8 reg8 = this.r8[this.opcode & 7];
        if (this.traceCPU >= TRC_ALL) {
            this.traceCPU(3, "LD    (" + this.IND.name + "+d)," + reg8.name);
        }
        this.memory.setByte(this.IND.get() + (byte)n & 0xFFFF, reg8.r);
        this.addPC_T(3, 19);
    }

    public final void instLD_iINDd_n8() {
        int n = this.memory.getByte(this.PC.r + 2);
        int n2 = this.memory.getByte(this.PC.r + 3);
        if (this.traceCPU >= TRC_ALL) {
            this.traceCPU(4, "LD    (" + this.IND.name + "+d)," + this.b2hds(n2));
        }
        this.memory.setByte(this.IND.get() + (byte)n & 0xFFFF, n2);
        this.addPC_T(4, 19);
    }

    public final void instLD_A_iBC() {
        int n = this.memory.getByte(this.BC.get());
        if (this.traceCPU >= TRC_ALL) {
            this.traceCPU(1, "LD    A,(BC)  ; (BC)=" + this.b2hds(n));
        }
        this.A.r = n;
        this.addPC_T(1, 7);
    }

    public final void instLD_A_iDE() {
        int n = this.memory.getByte(this.DE.get());
        if (this.traceCPU >= TRC_ALL) {
            this.traceCPU(1, "LD    A,(DE)  ; (DE)=" + this.b2hds(n));
        }
        this.A.r = n;
        this.addPC_T(1, 7);
    }

    public final void instLD_A_in16() {
        int n = this.memory.getWord(this.PC.r + 1);
        int n2 = this.memory.getByte(n);
        if (this.traceCPU >= TRC_ALL) {
            this.traceCPU(3, "LD    A,(" + this.toHexString(n, 4) + ")    ; (" + this.toHexString(n, 4) + ")=" + this.b2hds(n2));
        }
        this.A.r = n2;
        this.addPC_T(3, 13);
    }

    public final void instLD_iBC_A() {
        if (this.traceCPU >= TRC_ALL) {
            this.traceCPU(1, "LD    (BC),A");
        }
        this.memory.setByte(this.BC.get(), this.A.r);
        this.addPC_T(1, 7);
    }

    public final void instLD_iDE_A() {
        if (this.traceCPU >= TRC_ALL) {
            this.traceCPU(1, "LD    (DE),A");
        }
        this.memory.setByte(this.DE.get(), this.A.r);
        this.addPC_T(1, 7);
    }

    public final void instLD_in16_A() {
        int n = this.memory.getWord(this.PC.r + 1);
        if (this.traceCPU >= TRC_ALL) {
            this.traceCPU(3, "LD    (" + this.toHexString(n, 4) + "),A");
        }
        this.memory.setByte(n, this.A.r);
        this.addPC_T(3, 13);
    }

    public final void instLD_A_I() {
        this.A.r = this.I.r;
        if (this.traceCPU >= TRC_ALL) {
            this.traceCPU(2, "LD    " + this.A.name + "," + this.I.name);
        }
        this.setFlagS(this.I.r < 0);
        this.setFlagZ(this.I.r == 0);
        this.setFlagH(false);
        this.setFlagPV(this.IFF2);
        this.setFlagN(false);
        this.addPC_T(2, 9);
    }

    public final void instLD_A_R() {
        this.A.r = this.R.r;
        if (this.traceCPU >= TRC_ALL) {
            this.traceCPU(2, "LD    " + this.A.name + "," + this.R.name);
        }
        this.setFlagS(this.IM.r < 0);
        this.setFlagZ(this.IM.r == 0);
        this.setFlagH(false);
        this.setFlagPV(this.IFF2);
        this.setFlagN(false);
        this.addPC_T(2, 9);
    }

    public final void instLD_I_A() {
        if (this.traceCPU >= TRC_ALL) {
            this.traceCPU(2, "LD    " + this.I.name + "," + this.A.name);
        }
        this.I.r = this.A.r;
        this.addPC_T(2, 9);
    }

    public final void instLD_R_A() {
        if (this.traceCPU >= TRC_ALL) {
            this.traceCPU(2, "LD    " + this.R.name + "," + this.A.name);
        }
        this.R.r = this.A.r;
        this.addPC_T(2, 9);
    }

    public final void instLD_r16_n16() {
        int n = this.memory.getWord(this.PC.r + 1);
        Reg16 reg16 = this.r16[(this.opcode & 0x30) >> 4];
        if (this.traceCPU >= TRC_ALL) {
            this.traceCPU(3, "LD    " + reg16.name + "," + this.w2hds(n));
        }
        reg16.set(n);
        this.addPC_T(3, 10);
    }

    public final void instLD_IND_n16() {
        this.IND.set(this.memory.getWord(this.PC.r + 2));
        if (this.traceCPU >= TRC_ALL) {
            this.traceCPU(4, "LD    " + this.IND.name + "," + this.w2hds(this.IND.get()));
        }
        this.addPC_T(4, 14);
    }

    public final void instLD_HL_in16() {
        int n = this.memory.getWord(this.PC.r + 1);
        if (this.traceCPU >= TRC_ALL) {
            this.traceCPU(3, "LD    HL,(" + this.toHexString(n, 4) + ")");
        }
        this.HL.set(this.memory.getWord(n));
        this.addPC_T(3, 16);
    }

    public final void instLD_r16_in16() {
        Reg16 reg16 = this.r16[(this.opcode & 0x30) >> 4];
        int n = this.memory.getWord(this.PC.r + 2);
        if (this.traceCPU >= TRC_ALL) {
            this.traceCPU(4, "LD    " + reg16.name + ",(" + this.toHexString(n, 4) + ")");
        }
        reg16.set(this.memory.getWord(n));
        this.addPC_T(4, 20);
    }

    public final void instLD_IND_in16() {
        int n = this.memory.getWord(this.PC.r + 2);
        if (this.traceCPU >= TRC_ALL) {
            this.traceCPU(4, "LD    " + this.IND.name + ",(" + this.toHexString(n, 4) + ")");
        }
        this.IND.set(this.memory.getWord(n));
        this.addPC_T(4, 20);
    }

    public final void instLD_in16_HL() {
        int n = this.memory.getWord(this.PC.r + 1);
        if (this.traceCPU >= TRC_ALL) {
            this.traceCPU(3, "LD    (" + this.toHexString(n, 4) + "),HL");
        }
        this.memory.setWord(n, this.HL.get());
        this.addPC_T(3, 16);
    }

    public final void instLD_in16_r16() {
        Reg16 reg16 = this.r16[(this.opcode & 0x30) >> 4];
        int n = this.memory.getWord(this.PC.r + 2);
        if (this.traceCPU >= TRC_ALL) {
            this.traceCPU(4, "LD    (" + this.toHexString(n, 4) + ")," + reg16.name);
        }
        this.memory.setWord(n, reg16.get());
        this.addPC_T(4, 20);
    }

    public final void instLD_in16_IND() {
        int n = this.memory.getWord(this.PC.r + 2);
        if (this.traceCPU >= TRC_ALL) {
            this.traceCPU(4, "LD    (" + this.toHexString(n, 4) + ")," + this.IND.name);
        }
        this.memory.setWord(n, this.IND.get());
        this.addPC_T(4, 20);
    }

    public final void instLD_SP_HL() {
        this.SP.r = this.HL.get();
        if (this.traceCPU >= TRC_ALL) {
            this.traceCPU(1, "LD    " + this.SP.name + "," + this.HL.name);
        }
        this.addPC_T(1, 6);
    }

    public final void instLD_SP_IND() {
        this.SP.r = this.IND.get();
        if (this.traceCPU >= TRC_ALL) {
            this.traceCPU(2, "LD    " + this.SP.name + "," + this.IND.name);
        }
        this.addPC_T(2, 10);
    }

    public final void instPUSH_r16() {
        Reg16 reg16 = this.r16AF[(this.opcode & 0x30) >> 4];
        if (this.traceCPU >= TRC_ALL) {
            this.traceCPU(1, "PUSH  " + reg16.name);
        }
        this.SP.sub(2);
        this.memory.setWord(this.SP.r, reg16.get());
        this.addPC_T(1, 11);
    }

    public final void instPUSH_IND() {
        if (this.traceCPU >= TRC_ALL) {
            this.traceCPU(2, "PUSH  " + this.IND.name);
        }
        this.SP.sub(2);
        this.memory.setWord(this.SP.r, this.IND.get());
        this.addPC_T(2, 14);
    }

    public final void instPOP_r16() {
        Reg16 reg16 = this.r16AF[(this.opcode & 0x30) >> 4];
        if (this.traceCPU >= TRC_ALL) {
            this.traceCPU(1, "POP   " + reg16.name);
        }
        reg16.set(this.memory.getWord(this.SP.r));
        this.SP.add(2);
        this.addPC_T(1, 14);
    }

    public final void instPOP_IND() {
        if (this.traceCPU >= TRC_ALL) {
            this.traceCPU(2, "POP   " + this.IND.name);
        }
        this.IND.set(this.memory.getWord(this.SP.r));
        this.SP.add(2);
        this.addPC_T(2, 14);
    }

    public final void instEX_DE_HL() {
        if (this.traceCPU >= TRC_ALL) {
            this.traceCPU(1, "EX    DE,HL");
        }
        int n = this.HL.get();
        this.HL.set(this.DE.get());
        this.DE.set(n);
        this.addPC_T(1, 4);
    }

    public final void instEX_AF_AF() {
        if (this.traceCPU >= TRC_ALL) {
            this.traceCPU(1, "EX    AF,AF'");
        }
        int n = this.AF.get();
        this.AF.set(this.AF1);
        this.AF1 = n;
        this.addPC_T(1, 4);
    }

    public final void instEXX() {
        if (this.traceCPU >= TRC_ALL) {
            this.traceCPU(1, "EXX");
        }
        int n = this.BC.get();
        this.BC.set(this.BC1);
        this.BC1 = n;
        n = this.DE.get();
        this.DE.set(this.DE1);
        this.DE1 = n;
        n = this.HL.get();
        this.HL.set(this.HL1);
        this.HL1 = n;
        this.addPC_T(1, 4);
    }

    public final void instEX_iSP_HL() {
        if (this.traceCPU >= TRC_ALL) {
            this.traceCPU(1, "EX    (SP),HL");
        }
        int n = this.memory.getWord(this.SP.r);
        this.memory.setWord(this.SP.r, this.HL.get());
        this.HL.set(n);
        this.addPC_T(1, 19);
    }

    public final void instEX_iSP_IND() {
        if (this.traceCPU >= TRC_ALL) {
            this.traceCPU(2, "EX    (SP)," + this.IND.name);
        }
        int n = this.memory.getWord(this.SP.r);
        this.memory.setWord(this.SP.r, this.IND.get());
        this.IND.set(n);
        this.addPC_T(2, 23);
    }

    public final void instLDI() {
        if (this.traceCPU >= TRC_ALL) {
            this.traceCPU(2, "LDI");
        }
        this.memory.setByte(this.DE.get(), this.memory.getByte(this.HL.get()));
        this.DE.add(1);
        this.HL.add(1);
        this.BC.sub(1);
        this.setFlagH(false);
        this.setFlagPV(this.BC.get() != 0);
        this.setFlagN(false);
        this.addPC_T(2, 16);
    }

    public final void instLDIR() {
        if (this.traceCPU >= TRC_ALL) {
            this.traceCPU(2, "LDIR");
        }
        this.memory.setByte(this.DE.get(), this.memory.getByte(this.HL.get()));
        this.DE.add(1);
        this.HL.add(1);
        this.BC.sub(1);
        this.setFlagH(false);
        this.setFlagPV(this.BC.get() != 0);
        this.setFlagN(false);
        if (this.BC.get() != 0) {
            this.addPC_T(0, 21);
        } else {
            this.addPC_T(2, 16);
        }
    }

    public final void instLDD() {
        if (this.traceCPU >= TRC_ALL) {
            this.traceCPU(2, "LDD");
        }
        this.memory.setByte(this.DE.get(), this.memory.getByte(this.HL.get()));
        this.DE.sub(1);
        this.HL.sub(1);
        this.BC.sub(1);
        this.setFlagH(false);
        this.setFlagPV(this.BC.get() != 0);
        this.setFlagN(false);
        this.addPC_T(2, 16);
    }

    public final void instLDDR() {
        if (this.traceCPU >= TRC_ALL) {
            this.traceCPU(2, "LDDR");
        }
        this.memory.setByte(this.DE.get(), this.memory.getByte(this.HL.get()));
        this.DE.sub(1);
        this.HL.sub(1);
        this.BC.sub(1);
        this.setFlagH(false);
        this.setFlagPV(this.BC.get() != 0);
        this.setFlagN(false);
        if (this.BC.get() != 0) {
            this.addPC_T(0, 21);
        } else {
            this.addPC_T(2, 16);
        }
    }

    public final void instCPI() {
        int n = this.memory.getByte(this.HL.get());
        boolean bl = this.getFlagC();
        if (this.traceCPU >= TRC_ALL) {
            this.traceCPU(2, "CPI     ; (HL)=" + this.b2hds(n));
        }
        this.cp_a(n);
        this.HL.add(1);
        this.BC.sub(1);
        this.setFlagPV(this.BC.get() != 0);
        this.setFlagC(bl);
        this.addPC_T(2, 16);
    }

    public final void instCPIR() {
        int n = this.memory.getByte(this.HL.get());
        boolean bl = this.getFlagC();
        if (this.traceCPU >= TRC_ALL) {
            this.traceCPU(2, "CPIR    ; (HL)=" + this.b2hds(n));
        }
        this.cp_a(n);
        this.HL.add(1);
        this.BC.sub(1);
        this.setFlagPV(this.BC.get() != 0);
        this.setFlagC(bl);
        if (this.BC.get() != 0 && this.A.r != n) {
            this.addPC_T(0, 21);
        } else {
            this.addPC_T(2, 18);
        }
    }

    public final void instCPD() {
        int n = this.memory.getByte(this.HL.get());
        boolean bl = this.getFlagC();
        if (this.traceCPU >= TRC_ALL) {
            this.traceCPU(2, "CPD     ; (HL)=" + this.b2hds(n));
        }
        this.cp_a(n);
        this.HL.sub(1);
        this.BC.sub(1);
        this.setFlagPV(this.BC.get() != 0);
        this.setFlagC(bl);
        this.addPC_T(2, 16);
    }

    public final void instCPDR() {
        int n = this.memory.getByte(this.HL.get());
        boolean bl = this.getFlagC();
        if (this.traceCPU >= TRC_ALL) {
            this.traceCPU(2, "CPDR    ; (HL)=" + this.b2hds(n));
        }
        this.cp_a(n);
        this.HL.sub(1);
        this.BC.sub(1);
        this.setFlagPV(this.BC.get() != 0);
        this.setFlagC(bl);
        if (this.BC.get() != 0 && this.A.r != n) {
            this.addPC_T(0, 21);
        } else {
            this.addPC_T(2, 18);
        }
    }

    public final void instADD_r8() {
        Reg8 reg8 = this.r8[this.opcode & 7];
        if (this.traceCPU >= TRC_ALL) {
            this.traceCPU(1, "ADD   " + reg8.name);
        }
        this.add_a(reg8.r);
        this.addPC_T(1, 4);
    }

    public final void instADD_p8() {
        Reg8 reg8 = this.p8[this.opcode & 7];
        if (this.traceCPU >= TRC_ALL) {
            this.traceCPU(2, "ADD   " + reg8.name);
        }
        this.add_a(reg8.r);
        this.addPC_T(2, 8);
    }

    public final void instADD_n8() {
        int n = this.memory.getByte(this.PC.r + 1);
        if (this.traceCPU >= TRC_ALL) {
            this.traceCPU(2, "ADD   A," + this.b2hds(n));
        }
        this.add_a(n);
        this.addPC_T(2, 7);
    }

    public final void instADD_iHL() {
        int n = this.memory.getByte(this.HL.get());
        if (this.traceCPU >= TRC_ALL) {
            this.traceCPU(1, "ADD   A,(HL)  ; (HL)=" + this.b2hds(n));
        }
        this.add_a(n);
        this.addPC_T(1, 7);
    }

    public final void instADD_iINDd() {
        int n = this.memory.getByte(this.PC.r + 2);
        int n2 = this.IND.get() + (byte)n & 0xFFFF;
        int n3 = this.memory.getByte(n2);
        if (this.traceCPU >= TRC_ALL) {
            this.traceCPU(3, "ADD   A,(" + this.IND.name + "+" + this.b2hds(n3) + ")");
        }
        this.add_a(n3);
        this.addPC_T(3, 19);
    }

    public final void instADC_r8() {
        Reg8 reg8 = this.r8[this.opcode & 7];
        if (this.traceCPU >= TRC_ALL) {
            this.traceCPU(1, "ADC   " + reg8.name);
        }
        this.adc_a(reg8.r);
        this.addPC_T(1, 4);
    }

    public final void instADC_p8() {
        Reg8 reg8 = this.p8[this.opcode & 7];
        if (this.traceCPU >= TRC_ALL) {
            this.traceCPU(2, "ADC   " + reg8.name);
        }
        this.adc_a(reg8.r);
        this.addPC_T(2, 8);
    }

    public final void instADC_n8() {
        int n = this.memory.getByte(this.PC.r + 1);
        if (this.traceCPU >= TRC_ALL) {
            this.traceCPU(2, "ADC   " + this.b2hds(n));
        }
        this.adc_a(n);
        this.addPC_T(2, 7);
    }

    public final void instADC_iHL() {
        int n = this.memory.getByte(this.HL.get());
        if (this.traceCPU >= TRC_ALL) {
            this.traceCPU(1, "ADC   (HL)  ; (HL)=" + this.b2hds(n));
        }
        this.adc_a(n);
        this.addPC_T(1, 7);
    }

    public final void instADC_iINDd() {
        int n = this.memory.getByte(this.PC.r + 2);
        int n2 = this.IND.get() + (byte)n & 0xFFFF;
        int n3 = this.memory.getByte(n2);
        if (this.traceCPU >= TRC_ALL) {
            this.traceCPU(3, "ADC   A,(" + this.IND.name + "+" + this.b2hds(n3) + ")");
        }
        this.adc_a(n3);
        this.addPC_T(3, 19);
    }

    public final void instSUB_r8() {
        Reg8 reg8 = this.r8[this.opcode & 7];
        if (this.traceCPU >= TRC_ALL) {
            this.traceCPU(1, "SUB   " + reg8.name);
        }
        this.sub_a(reg8.r);
        this.addPC_T(1, 4);
    }

    public final void instSUB_p8() {
        Reg8 reg8 = this.p8[this.opcode & 7];
        if (this.traceCPU >= TRC_ALL) {
            this.traceCPU(2, "SUB   " + reg8.name);
        }
        this.sub_a(reg8.r);
        this.addPC_T(2, 8);
    }

    public final void instSUB_n8() {
        int n = this.memory.getByte(this.PC.r + 1);
        if (this.traceCPU >= TRC_ALL) {
            this.traceCPU(2, "SUB   " + this.b2hds(n));
        }
        this.sub_a(n);
        this.addPC_T(2, 7);
    }

    public final void instSUB_iHL() {
        int n = this.memory.getByte(this.HL.get());
        if (this.traceCPU >= TRC_ALL) {
            this.traceCPU(1, "SUB   (HL)  ; (HL)=" + this.b2hds(n));
        }
        this.sub_a(n);
        this.addPC_T(1, 7);
    }

    public final void instSUB_iINDd() {
        int n = this.memory.getByte(this.PC.r + 2);
        int n2 = this.IND.get() + (byte)n & 0xFFFF;
        int n3 = this.memory.getByte(n2);
        if (this.traceCPU >= TRC_ALL) {
            this.traceCPU(3, "SUB   (" + this.IND.name + "+" + this.b2hds(n3) + ")");
        }
        this.sub_a(n3);
        this.addPC_T(3, 19);
    }

    public final void instSBC_r8() {
        Reg8 reg8 = this.r8[this.opcode & 7];
        if (this.traceCPU >= TRC_ALL) {
            this.traceCPU(1, "SBC   " + reg8.name);
        }
        this.sbc_a(reg8.r);
        this.addPC_T(1, 4);
    }

    public final void instSBC_p8() {
        Reg8 reg8 = this.p8[this.opcode & 7];
        if (this.traceCPU >= TRC_ALL) {
            this.traceCPU(2, "SBC   " + reg8.name);
        }
        this.sbc_a(reg8.r);
        this.addPC_T(2, 8);
    }

    public final void instSBC_n8() {
        int n = this.memory.getByte(this.PC.r + 1);
        if (this.traceCPU >= TRC_ALL) {
            this.traceCPU(2, "SBC   " + this.b2hds(n));
        }
        this.sbc_a(n);
        this.addPC_T(2, 7);
    }

    public final void instSBC_iHL() {
        int n = this.memory.getByte(this.HL.get());
        if (this.traceCPU >= TRC_ALL) {
            this.traceCPU(1, "SBC   (HL)  ; (HL) = " + this.b2hds(n));
        }
        this.sbc_a(n);
        this.addPC_T(1, 4);
    }

    public final void instSBC_iINDd() {
        int n = this.memory.getByte(this.PC.r + 2);
        int n2 = this.IND.get() + (byte)n & 0xFFFF;
        int n3 = this.memory.getByte(n2);
        if (this.traceCPU >= TRC_ALL) {
            this.traceCPU(3, "SBC   (" + this.IND.name + "+" + this.b2hds(n3) + ")");
        }
        this.sbc_a(n3);
        this.addPC_T(3, 19);
    }

    public final void instCP_n8() {
        int n = this.memory.getByte(this.PC.r + 1);
        if (this.traceCPU >= TRC_ALL) {
            this.traceCPU(2, "CP    " + this.b2hds(n));
        }
        this.cp_a(n);
        this.addPC_T(2, 7);
    }

    public final void instCP_r8() {
        Reg8 reg8 = this.r8[this.opcode & 7];
        if (this.traceCPU >= TRC_ALL) {
            this.traceCPU(1, "CP    " + reg8.name);
        }
        this.cp_a(reg8.r);
        this.addPC_T(1, 4);
    }

    public final void instCP_p8() {
        Reg8 reg8 = this.p8[this.opcode & 7];
        if (this.traceCPU >= TRC_ALL) {
            this.traceCPU(2, "CP    " + reg8.name);
        }
        this.cp_a(reg8.r);
        this.addPC_T(2, 8);
    }

    public final void instCP_iHL() {
        int n = this.memory.getByte(this.HL.get());
        if (this.traceCPU >= TRC_ALL) {
            this.traceCPU(1, "CP    (HL) ; (HL)=" + this.b2hds(n));
        }
        this.cp_a(n);
        this.addPC_T(1, 7);
    }

    public final void instCP_iINDd() {
        int n = this.memory.getByte(this.PC.r + 2);
        int n2 = this.IND.get() + (byte)n & 0xFFFF;
        int n3 = this.memory.getByte(n2);
        if (this.traceCPU >= TRC_ALL) {
            this.traceCPU(3, "CP   (" + this.IND.name + "+" + this.b2hds(n3) + ")");
        }
        this.cp_a(n3);
        this.addPC_T(3, 19);
    }

    public final void instAND_r8() {
        Reg8 reg8 = this.r8[this.opcode & 7];
        if (this.traceCPU >= TRC_ALL) {
            this.traceCPU(1, "AND   " + reg8.name);
        }
        this.and_a(reg8.r);
        this.addPC_T(1, 4);
    }

    public final void instAND_p8() {
        Reg8 reg8 = this.p8[this.opcode & 7];
        if (this.traceCPU >= TRC_ALL) {
            this.traceCPU(2, "AND   " + reg8.name);
        }
        this.and_a(reg8.r);
        this.addPC_T(2, 8);
    }

    public final void instAND_n8() {
        int n = this.memory.getByte(this.PC.r + 1);
        if (this.traceCPU >= TRC_ALL) {
            this.traceCPU(2, "AND   " + this.b2hds(n));
        }
        this.and_a(n);
        this.addPC_T(2, 7);
    }

    public final void instAND_iHL() {
        int n = this.memory.getByte(this.HL.get());
        if (this.traceCPU >= TRC_ALL) {
            this.traceCPU(1, "AND   (HL) ; (HL)=" + this.b2hds(n));
        }
        this.and_a(n);
        this.addPC_T(1, 7);
    }

    public final void instAND_iINDd() {
        int n = this.memory.getByte(this.PC.r + 2);
        int n2 = this.IND.get() + (byte)n & 0xFFFF;
        int n3 = this.memory.getByte(n2);
        if (this.traceCPU >= TRC_ALL) {
            this.traceCPU(3, "AND   (" + this.IND.name + "+" + this.b2hds(n3) + ")");
        }
        this.and_a(n3);
        this.addPC_T(3, 19);
    }

    public final void instOR_r8() {
        Reg8 reg8 = this.r8[this.opcode & 7];
        if (this.traceCPU >= TRC_ALL) {
            this.traceCPU(1, "OR    " + reg8.name);
        }
        this.or_a(reg8.r);
        this.addPC_T(1, 4);
    }

    public final void instOR_p8() {
        Reg8 reg8 = this.p8[this.opcode & 7];
        if (this.traceCPU >= TRC_ALL) {
            this.traceCPU(2, "OR    " + reg8.name);
        }
        this.or_a(reg8.r);
        this.addPC_T(2, 8);
    }

    public final void instOR_n8() {
        int n = this.memory.getByte(this.PC.r + 1);
        if (this.traceCPU >= TRC_ALL) {
            this.traceCPU(2, "OR    " + this.b2hds(n));
        }
        this.or_a(n);
        this.addPC_T(2, 7);
    }

    public final void instOR_iHL() {
        int n = this.memory.getByte(this.HL.get());
        if (this.traceCPU >= TRC_ALL) {
            this.traceCPU(1, "OR    (HL)  ; (HL)=" + this.b2hds(n));
        }
        this.or_a(n);
        this.addPC_T(1, 7);
    }

    public final void instOR_iINDd() {
        int n = this.memory.getByte(this.PC.r + 2);
        int n2 = this.IND.get() + (byte)n & 0xFFFF;
        int n3 = this.memory.getByte(n2);
        if (this.traceCPU >= TRC_ALL) {
            this.traceCPU(3, "OR    (" + this.IND.name + "+" + this.b2hds(n3) + ")");
        }
        this.or_a(n3);
        this.addPC_T(3, 19);
    }

    public final void instXOR_r8() {
        Reg8 reg8 = this.r8[this.opcode & 7];
        if (this.traceCPU >= TRC_ALL) {
            this.traceCPU(1, "XOR   " + reg8.name);
        }
        this.xor_a(reg8.r);
        this.addPC_T(1, 4);
    }

    public final void instXOR_p8() {
        Reg8 reg8 = this.p8[this.opcode & 7];
        if (this.traceCPU >= TRC_ALL) {
            this.traceCPU(2, "XOR   " + reg8.name);
        }
        this.xor_a(reg8.r);
        this.addPC_T(2, 8);
    }

    public final void instXOR_n8() {
        int n = this.memory.getByte(this.PC.r + 1);
        if (this.traceCPU >= TRC_ALL) {
            this.traceCPU(2, "XOR   " + this.b2hds(n));
        }
        this.xor_a(n);
        this.addPC_T(2, 7);
    }

    public final void instXOR_iHL() {
        int n = this.memory.getByte(this.HL.get());
        if (this.traceCPU >= TRC_ALL) {
            this.traceCPU(1, "XOR   (HL)  ; (HL)=" + this.b2hds(n));
        }
        this.xor_a(n);
        this.addPC_T(1, 7);
    }

    public final void instXOR_iINDd() {
        int n = this.memory.getByte(this.PC.r + 2);
        int n2 = this.IND.get() + (byte)n & 0xFFFF;
        int n3 = this.memory.getByte(n2);
        if (this.traceCPU >= TRC_ALL) {
            this.traceCPU(3, "XOR   (" + this.IND.name + "+" + this.b2hds(n3) + ")");
        }
        this.xor_a(n3);
        this.addPC_T(3, 19);
    }

    public final void instINC_r8() {
        Reg8 reg8 = this.r8[(this.opcode & 0x38) >> 3];
        if (this.traceCPU >= TRC_ALL) {
            this.traceCPU(1, "INC   " + reg8.name);
        }
        reg8.r = this.inc8(reg8.r);
        this.addPC_T(1, 4);
    }

    public final void instINC_p8() {
        Reg8 reg8 = this.p8[(this.opcode & 0x38) >> 3];
        if (this.traceCPU >= TRC_ALL) {
            this.traceCPU(2, "INC   " + reg8.name);
        }
        reg8.r = this.inc8(reg8.r);
        this.addPC_T(2, 8);
    }

    public final void instINC_iHL() {
        int n = this.HL.get();
        if (this.traceCPU >= TRC_ALL) {
            this.traceCPU(1, "INC   (HL)");
        }
        int n2 = this.memory.getByte(n);
        n2 = this.inc8(n2);
        this.memory.setByte(n, n2);
        this.addPC_T(1, 11);
    }

    public final void instINC_iINDd() {
        int n = this.memory.getByte(this.PC.r + 2);
        int n2 = this.IND.get() + (byte)n & 0xFFFF;
        int n3 = this.memory.getByte(n2);
        if (this.traceCPU >= TRC_ALL) {
            this.traceCPU(3, "INC   (" + this.IND.name + "+" + this.b2hds(n3) + ")");
        }
        this.memory.setByte(n2, this.inc8(n3));
        this.addPC_T(3, 23);
    }

    public final void instDEC_r8() {
        Reg8 reg8 = this.r8[(this.opcode & 0x38) >> 3];
        if (this.traceCPU >= TRC_ALL) {
            this.traceCPU(1, "DEC   " + reg8.name);
        }
        reg8.r = this.dec8(reg8.r);
        this.addPC_T(1, 4);
    }

    public final void instDEC_p8() {
        Reg8 reg8 = this.p8[(this.opcode & 0x38) >> 3];
        if (this.traceCPU >= TRC_ALL) {
            this.traceCPU(2, "DEC   " + reg8.name);
        }
        reg8.r = this.dec8(reg8.r);
        this.addPC_T(2, 8);
    }

    public final void instDEC_iHL() {
        int n = this.HL.get();
        if (this.traceCPU >= TRC_ALL) {
            this.traceCPU(1, "DEC   (HL)");
        }
        this.memory.setByte(n, this.dec8(this.memory.getByte(n)));
        this.addPC_T(1, 11);
    }

    public final void instDEC_iINDd() {
        int n = this.memory.getByte(this.PC.r + 2);
        int n2 = this.IND.get() + (byte)n & 0xFFFF;
        int n3 = this.memory.getByte(n2);
        if (this.traceCPU >= TRC_ALL) {
            this.traceCPU(3, "DEC   (" + this.IND.name + "+" + this.b2hds(n3) + ")");
        }
        this.memory.setByte(n2, this.dec8(n3));
        this.addPC_T(3, 23);
    }

    public final void instDAA() {
        if (this.traceCPU >= TRC_ALL) {
            this.traceCPU(1, "DAA   ");
        }
        this.daa_a();
        this.addPC_T(1, 4);
    }

    public final void instNEG() {
        if (this.traceCPU >= TRC_ALL) {
            this.traceCPU(2, "NEG");
        }
        int n = this.A.r;
        this.A.r = 0;
        this.sub_a(n);
        this.addPC_T(2, 8);
    }

    public final void instCPL() {
        if (this.traceCPU >= TRC_ALL) {
            this.traceCPU(1, "CPL");
        }
        this.A.r ^= 0xFF;
        this.A.r &= 0xFF;
        this.F.r |= SET_N | SET_H;
        this.addPC_T(1, 4);
    }

    public final void instSCF() {
        if (this.traceCPU >= TRC_ALL) {
            this.traceCPU(1, "SCF");
        }
        this.F.r |= SET_C;
        this.F.r &= ~(SET_H | SET_N);
        this.addPC_T(1, 4);
    }

    public final void instCCF() {
        if (this.traceCPU >= TRC_ALL) {
            this.traceCPU(1, "CCF");
        }
        this.setFlagH(this.getFlagC());
        this.F.r ^= SET_C;
        this.F.r &= ~SET_N;
        this.addPC_T(1, 4);
    }

    public final void instNOP() {
        if (this.traceCPU >= TRC_ALL) {
            this.traceCPU(1, "NOP");
        }
        this.addPC_T(1, 4);
    }

    public final void instHALT() {
        if (this.traceCPU >= TRC_GP) {
            this.traceCPU(1, "HALT");
        }
        this.addPC_T(0, 4);
        this.halt = true;
    }

    public final void instDI() {
        if (this.traceCPU >= TRC_GP) {
            this.traceCPU(1, "DI");
        }
        this.IFF2 = false;
        this.IFF1 = false;
        this.addPC_T(1, 4);
    }

    public final void instEI() {
        if (this.traceCPU >= TRC_GP) {
            this.traceCPU(1, "EI");
        }
        this.IFF2 = true;
        this.IFF1 = true;
        this.addPC_T(1, 4);
    }

    public final void instIM_0() {
        if (this.traceCPU >= TRC_GP) {
            this.traceCPU(2, "IM    0");
        }
        this.IM.r = 0;
        this.addPC_T(2, 8);
    }

    public final void instIM_1() {
        if (this.traceCPU >= TRC_GP) {
            this.traceCPU(2, "IM    1");
        }
        this.IM.r = 1;
        this.addPC_T(2, 8);
    }

    public final void instIM_2() {
        if (this.traceCPU >= TRC_GP) {
            this.traceCPU(2, "IM    2");
        }
        this.IM.r = 2;
        this.addPC_T(2, 8);
    }

    public final void instADD_HL_r16() {
        Reg16 reg16 = this.r16[(this.opcode & 0x30) >> 4];
        if (this.traceCPU >= TRC_ALL) {
            this.traceCPU(1, "ADD   HL," + reg16.name);
        }
        this.HL.set(this.add16(this.HL.get(), reg16.get()));
        this.addPC_T(1, 11);
    }

    public final void instADD_IND_r16() {
        Reg16 reg16 = this.r16IND[(this.opcode & 0x30) >> 4];
        if (this.traceCPU >= TRC_ALL) {
            this.traceCPU(2, "ADD   " + this.IND.name + "," + reg16.name);
        }
        this.IND.set(this.add16(this.IND.get(), reg16.get()));
        this.addPC_T(2, 15);
    }

    public final void instADC_HL_r16() {
        Reg16 reg16 = this.r16[(this.opcode & 0x30) >> 4];
        if (this.traceCPU >= TRC_ALL) {
            this.traceCPU(2, "ADC   HL," + reg16.name);
        }
        this.HL.set(this.adc16(this.HL.get(), reg16.get()));
        this.addPC_T(2, 11);
    }

    public final void instSBC_HL_r16() {
        Reg16 reg16 = this.r16[(this.opcode & 0x30) >> 4];
        if (this.traceCPU >= TRC_ALL) {
            this.traceCPU(2, "SBC   HL," + reg16.name);
        }
        this.HL.set(this.sbc16(this.HL.get(), reg16.get()));
        this.addPC_T(2, 15);
    }

    public final void instINC_r16() {
        Reg16 reg16 = this.r16[(this.opcode & 0x30) >> 4];
        if (this.traceCPU >= TRC_ALL) {
            this.traceCPU(1, "INC   " + reg16.name);
        }
        reg16.set(reg16.get() + 1 & 0xFFFF);
        this.addPC_T(1, 6);
    }

    public final void instINC_IND() {
        if (this.traceCPU >= TRC_ALL) {
            this.traceCPU(2, "INC   " + this.IND.name);
        }
        this.IND.set(this.IND.get() + 1 & 0xFFFF);
        this.addPC_T(2, 10);
    }

    public final void instDEC_r16() {
        Reg16 reg16 = this.r16[(this.opcode & 0x30) >> 4];
        if (this.traceCPU >= TRC_ALL) {
            this.traceCPU(1, "DEC   " + reg16.name);
        }
        reg16.set(reg16.get() - 1 & 0xFFFF);
        this.addPC_T(1, 6);
    }

    public final void instDEC_IND() {
        if (this.traceCPU >= TRC_ALL) {
            this.traceCPU(2, "DEC   " + this.IND.name);
        }
        this.IND.set(this.IND.get() - 1 & 0xFFFF);
        this.addPC_T(2, 10);
    }

    public final void instRLCA() {
        if (this.traceCPU >= TRC_ALL) {
            this.traceCPU(1, "RLCA");
        }
        this.rlc_a();
        this.addPC_T(1, 4);
    }

    public final void instRLA() {
        if (this.traceCPU >= TRC_ALL) {
            this.traceCPU(1, "RLA");
        }
        this.rl_a();
        this.addPC_T(1, 4);
    }

    public final void instRRCA() {
        if (this.traceCPU >= TRC_ALL) {
            this.traceCPU(1, "RRCA");
        }
        this.rrc_a();
        this.addPC_T(1, 4);
    }

    public final void instRRA() {
        if (this.traceCPU >= TRC_ALL) {
            this.traceCPU(1, "RRA");
        }
        this.rr_a();
        this.addPC_T(1, 4);
    }

    public final void instRR_r8() {
        Reg8 reg8 = this.r8[this.opcode & 7];
        if (this.traceCPU >= TRC_ALL) {
            this.traceCPU(2, "RR    " + reg8.name);
        }
        reg8.r = this.rr(reg8.r);
        this.addPC_T(2, 8);
    }

    public final void instRR_iHL() {
        int n = this.HL.get();
        int n2 = this.memory.getByte(n);
        if (this.traceCPU >= TRC_ALL) {
            this.traceCPU(2, "RR    (HL)  ; (HL) = " + this.b2hds(n2));
        }
        n2 = this.rr(n2);
        this.memory.setByte(n, n2);
        this.addPC_T(2, 15);
    }

    public final void instRR_iINDd() {
        int n = this.memory.getByte(this.PC.r + 2);
        int n2 = this.IND.get() + (byte)n & 0xFFFF;
        int n3 = this.memory.getByte(n2);
        if (this.traceCPU >= TRC_ALL) {
            this.traceCPU(4, "RR    (" + this.IND.name + "+" + this.b2hds(n3) + ")");
        }
        n3 = this.rr(n3);
        this.memory.setByte(n2, n3);
        this.addPC_T(4, 23);
    }

    public final void instRL_r8() {
        Reg8 reg8 = this.r8[this.opcode & 7];
        if (this.traceCPU >= TRC_ALL) {
            this.traceCPU(2, "RL    " + reg8.name);
        }
        reg8.r = this.rl(reg8.r);
        this.addPC_T(2, 8);
    }

    public final void instRL_iHL() {
        int n = this.HL.get();
        int n2 = this.memory.getByte(n);
        if (this.traceCPU >= TRC_ALL) {
            this.traceCPU(2, "RL    (HL)  ; (HL) = " + this.b2hds(n2));
        }
        n2 = this.rl(n2);
        this.memory.setByte(n, n2);
        this.addPC_T(2, 15);
    }

    public final void instRL_iINDd() {
        int n = this.memory.getByte(this.PC.r + 2);
        int n2 = this.IND.get() + (byte)n & 0xFFFF;
        int n3 = this.memory.getByte(n2);
        if (this.traceCPU >= TRC_ALL) {
            this.traceCPU(4, "RL    (" + this.IND.name + "+" + this.b2hds(n3) + ")");
        }
        n3 = this.rl(n3);
        this.memory.setByte(n2, n3);
        this.addPC_T(4, 23);
    }

    public final void instRLC_r8() {
        Reg8 reg8 = this.r8[this.opcode];
        if (this.traceCPU >= TRC_ALL) {
            this.traceCPU(2, "RLC   " + reg8.name);
        }
        reg8.r = this.rlc(reg8.r);
        this.addPC_T(2, 8);
    }

    public final void instRLC_iHL() {
        int n = this.HL.get();
        int n2 = this.memory.getByte(n);
        if (this.traceCPU >= TRC_ALL) {
            this.traceCPU(2, "RLC   (HL)  ; (HL) = " + this.b2hds(n2));
        }
        n2 = this.rlc(n2);
        this.memory.setByte(n, n2);
        this.addPC_T(2, 15);
    }

    public final void instRLC_iINDd() {
        int n = this.memory.getByte(this.PC.r + 2);
        int n2 = this.IND.get() + (byte)n & 0xFFFF;
        int n3 = this.memory.getByte(n2);
        if (this.traceCPU >= TRC_ALL) {
            this.traceCPU(4, "RLC   (" + this.IND.name + "+" + this.b2hds(n3) + ")");
        }
        n3 = this.rlc(n3);
        this.memory.setByte(n2, n3);
        this.addPC_T(4, 23);
    }

    public final void instRRC_r8() {
        Reg8 reg8 = this.r8[this.opcode & 7];
        if (this.traceCPU >= TRC_ALL) {
            this.traceCPU(2, "RRC   " + reg8.name);
        }
        reg8.r = this.rrc(reg8.r);
        this.addPC_T(2, 8);
    }

    public final void instRRC_iHL() {
        int n = this.HL.get();
        int n2 = this.memory.getByte(n);
        if (this.traceCPU >= TRC_ALL) {
            this.traceCPU(2, "RRC   (HL)  ; (HL) = " + this.b2hds(n2));
        }
        n2 = this.rrc(n2);
        this.memory.setByte(n, n2);
        this.addPC_T(2, 15);
    }

    public final void instRRC_iINDd() {
        int n = this.memory.getByte(this.PC.r + 2);
        int n2 = this.IND.get() + (byte)n & 0xFFFF;
        int n3 = this.memory.getByte(n2);
        if (this.traceCPU >= TRC_ALL) {
            this.traceCPU(4, "RRC   (" + this.IND.name + "+" + this.b2hds(n3) + ")");
        }
        n3 = this.rrc(n3);
        this.memory.setByte(n2, n3);
        this.addPC_T(4, 23);
    }

    public final void instSRL_r8() {
        Reg8 reg8 = this.r8[this.opcode & 7];
        if (this.traceCPU >= TRC_ALL) {
            this.traceCPU(2, "SRL   " + reg8.name);
        }
        reg8.r = this.srl(reg8.r);
        this.addPC_T(2, 8);
    }

    public final void instSRL_iHL() {
        int n = this.HL.get();
        int n2 = this.memory.getByte(n);
        if (this.traceCPU >= TRC_ALL) {
            this.traceCPU(2, "SRL   (HL)  ; (HL) = " + this.b2hds(n2));
        }
        n2 = this.srl(n2);
        this.memory.setByte(n, n2);
        this.addPC_T(2, 15);
    }

    public final void instSRL_iINDd() {
        int n = this.memory.getByte(this.PC.r + 2);
        int n2 = this.IND.get() + (byte)n & 0xFFFF;
        int n3 = this.memory.getByte(n2);
        if (this.traceCPU >= TRC_ALL) {
            this.traceCPU(4, "SRL   (" + this.IND.name + "+" + this.b2hds(n3) + ")");
        }
        n3 = this.srl(n3);
        this.memory.setByte(n2, n3);
        this.addPC_T(4, 23);
    }

    public final void instSRA_r8() {
        Reg8 reg8 = this.r8[this.opcode & 7];
        if (this.traceCPU >= TRC_ALL) {
            this.traceCPU(2, "SRA   " + reg8.name);
        }
        reg8.r = this.sra(reg8.r);
        this.addPC_T(2, 8);
    }

    public final void instSRA_iHL() {
        int n = this.HL.get();
        int n2 = this.memory.getByte(n);
        if (this.traceCPU >= TRC_ALL) {
            this.traceCPU(2, "SRA   (HL)  ; (HL) = " + this.b2hds(n2));
        }
        n2 = this.sra(n2);
        this.memory.setByte(n, n2);
        this.addPC_T(2, 15);
    }

    public final void instSRA_iINDd() {
        int n = this.memory.getByte(this.PC.r + 2);
        int n2 = this.IND.get() + (byte)n & 0xFFFF;
        int n3 = this.memory.getByte(n2);
        if (this.traceCPU >= TRC_ALL) {
            this.traceCPU(4, "SRA   (" + this.IND.name + "+" + this.b2hds(n3) + ")");
        }
        n3 = this.sra(n3);
        this.memory.setByte(n2, n3);
        this.addPC_T(4, 23);
    }

    public final void instSLL_r8() {
        Reg8 reg8 = this.r8[this.opcode & 7];
        if (this.traceCPU >= TRC_ALL) {
            this.traceCPU(2, "SLL   " + reg8.name);
        }
        reg8.r = this.sll(reg8.r);
        this.addPC_T(2, 8);
    }

    public final void instSLL_iHL() {
        int n = this.HL.get();
        int n2 = this.memory.getByte(n);
        if (this.traceCPU >= TRC_ALL) {
            this.traceCPU(2, "SLL   (HL)  ; (HL) = " + this.b2hds(n2));
        }
        n2 = this.sll(n2);
        this.memory.setByte(n, n2);
        this.addPC_T(2, 15);
    }

    public final void instSLL_iINDd() {
        int n = this.memory.getByte(this.PC.r + 2);
        int n2 = this.IND.get() + (byte)n & 0xFFFF;
        int n3 = this.memory.getByte(n2);
        if (this.traceCPU >= TRC_ALL) {
            this.traceCPU(4, "SLL   (" + this.IND.name + "+" + this.b2hds(n3) + ")");
        }
        n3 = this.sll(n3);
        this.memory.setByte(n2, n3);
        this.addPC_T(4, 23);
    }

    public final void instSLA_r8() {
        Reg8 reg8 = this.r8[this.opcode & 7];
        if (this.traceCPU >= TRC_ALL) {
            this.traceCPU(2, "SLA   " + reg8.name);
        }
        reg8.r = this.sla(reg8.r);
        this.addPC_T(2, 8);
    }

    public final void instSLA_iHL() {
        int n = this.HL.get();
        int n2 = this.memory.getByte(n);
        if (this.traceCPU >= TRC_ALL) {
            this.traceCPU(2, "SLA   (HL)  ; (HL) = " + this.b2hds(n2));
        }
        n2 = this.sla(n2);
        this.memory.setByte(n, n2);
        this.addPC_T(2, 15);
    }

    public final void instSLA_iINDd() {
        int n = this.memory.getByte(this.PC.r + 2);
        int n2 = this.IND.get() + (byte)n & 0xFFFF;
        int n3 = this.memory.getByte(n2);
        if (this.traceCPU >= TRC_ALL) {
            this.traceCPU(4, "SLA   (" + this.IND.name + "+" + this.b2hds(n3) + ")");
        }
        n3 = this.sla(n3);
        this.memory.setByte(n2, n3);
        this.addPC_T(4, 23);
    }

    public final void instRLD() {
        if (this.traceCPU >= TRC_ALL) {
            this.traceCPU(2, "RLD");
        }
        this.rld_a();
        this.addPC_T(2, 18);
    }

    public final void instRRD() {
        if (this.traceCPU >= TRC_ALL) {
            this.traceCPU(2, "RRD");
        }
        this.rrd_a();
        this.addPC_T(2, 18);
    }

    public final void instBIT_b_r8() {
        Reg8 reg8 = this.r8[this.opcode & 7];
        int n = (this.opcode & 0x38) >> 3;
        if (this.traceCPU >= TRC_ALL) {
            this.traceCPU(2, "BIT   " + Integer.toString(n) + "," + reg8.name);
        }
        this.bit(n, reg8.r);
        this.addPC_T(2, 8);
    }

    public final void instBIT_b_iHL() {
        int n = (this.opcode & 0x38) >> 3;
        int n2 = this.memory.getByte(this.HL.get());
        if (this.traceCPU >= TRC_ALL) {
            this.traceCPU(2, "BIT   " + Integer.toString(n) + ",(HL)  ; (HL)=" + this.b2hds(n2));
        }
        this.bit(n, n2);
        this.addPC_T(2, 12);
    }

    public final void instBIT_b_iINDd() {
        int n = this.memory.getByte(this.PC.r + 2);
        int n2 = (this.opcode & 0x38) >> 3;
        int n3 = this.IND.get() + (byte)n & 0xFFFF;
        if (this.traceCPU >= TRC_ALL) {
            this.traceCPU(4, "BIT   " + Integer.toString(n2) + ",(" + this.IND.name + "+" + this.b2hds(n).trim() + ")  ; " + this.IND.name + "+" + this.b2hds(n).trim() + " => " + Integer.toHexString(n3));
        }
        this.bit(n2, this.memory.getByte(n3));
        this.addPC_T(4, 20);
    }

    public final void instSET_b_r8() {
        Reg8 reg8 = this.r8[this.opcode & 7];
        int n = (this.opcode & 0x38) >> 3;
        if (this.traceCPU >= TRC_ALL) {
            this.traceCPU(2, "SET   " + Integer.toString(n) + "," + reg8.name);
        }
        reg8.r |= 1 << n;
        this.addPC_T(2, 8);
    }

    public final void instSET_b_iHL() {
        int n = (this.opcode & 0x38) >> 3;
        int n2 = this.HL.get();
        int n3 = this.memory.getByte(n2);
        if (this.traceCPU >= TRC_ALL) {
            this.traceCPU(2, "SET   " + Integer.toString(n) + ",(HL) ; (HL)=" + this.b2hds(n3));
        }
        this.memory.setByte(n2, n3 |= 1 << n);
        this.addPC_T(2, 15);
    }

    public final void instSET_b_iINDd() {
        int n = this.memory.getByte(this.PC.r + 2);
        int n2 = (this.opcode & 0x38) >> 3;
        int n3 = this.IND.get() + (byte)n & 0xFFFF;
        if (this.traceCPU >= TRC_ALL) {
            this.traceCPU(4, "SET   " + Integer.toString(n2) + ",(" + this.IND.name + "+" + this.b2hds(n).trim() + ")  ; " + this.IND.name + "+" + this.b2hds(n).trim() + " => " + Integer.toHexString(n3));
        }
        this.memory.setByte(n3, this.memory.getByte(n3) | 1 << n2);
        this.addPC_T(4, 20);
    }

    public final void instRES_b_r8() {
        Reg8 reg8 = this.r8[this.opcode & 7];
        int n = (this.opcode & 0x38) >> 3;
        if (this.traceCPU >= TRC_ALL) {
            this.traceCPU(2, "RES   " + Integer.toString(n) + "," + reg8.name);
        }
        reg8.r &= ~(1 << n);
        this.addPC_T(2, 8);
    }

    public final void instRES_b_iHL() {
        int n = (this.opcode & 0x38) >> 3;
        int n2 = this.HL.get();
        int n3 = this.memory.getByte(n2);
        if (this.traceCPU >= TRC_ALL) {
            this.traceCPU(2, "RES   " + Integer.toString(n) + ",(HL) ; (HL)=" + this.b2hds(n3));
        }
        this.memory.setByte(n2, n3 &= ~(1 << n));
        this.addPC_T(2, 15);
    }

    public final void instRES_b_iINDd() {
        int n = this.memory.getByte(this.PC.r + 2);
        int n2 = (this.opcode & 0x38) >> 3;
        int n3 = this.IND.get() + (byte)n & 0xFFFF;
        if (this.traceCPU >= TRC_ALL) {
            this.traceCPU(4, "RES   " + Integer.toString(n2) + ",(" + this.IND.name + "+" + this.b2hds(n).trim() + ")  ; " + this.IND.name + "+" + this.b2hds(n).trim() + " => " + Integer.toHexString(n3));
        }
        this.memory.setByte(n3, this.memory.getByte(n3) & ~(1 << n2));
        this.addPC_T(4, 20);
    }

    public final void instJP() {
        int n = this.memory.getWord(this.PC.r + 1);
        if (this.traceCPU >= TRC_J) {
            this.traceCPU(3, "JP    " + this.toHexString(n, 4));
        }
        this.PC.r = n;
        this.t += 10L;
    }

    public final void instJP_cc_n16() {
        int n = (this.opcode & 0x38) >> 3;
        int n2 = this.memory.getWord(this.PC.r + 1);
        if (this.traceCPU >= TRC_Jcc) {
            this.traceCPU(3, "JP    " + this.getccName(n) + (this.getccValue(n) ? "(1)" : "(0)") + "," + this.w2hds(n2));
        }
        if (this.getccValue(n)) {
            this.PC.r = n2;
        } else {
            this.PC.add(3);
        }
        this.t += 10L;
    }

    public final void instJR_n8() {
        int n = this.memory.getByte(this.PC.r + 1);
        if (this.traceCPU >= TRC_J) {
            this.traceCPU(2, "JR    " + this.toHexString(this.PC.r + 2 + (byte)n, 4));
        }
        this.PC.r = this.PC.r + 2 + (byte)n & 0xFFFF;
        this.t += 12L;
    }

    public final void instJR_NZ_n8() {
        int n = this.memory.getByte(this.PC.r + 1);
        if (this.traceCPU >= TRC_Jcc) {
            this.traceCPU(2, "JR    NZ" + (!this.getFlagZ() ? "(1)" : "(0)") + "," + this.toHexString(this.PC.r + 2 + (byte)n, 4));
        }
        this.addPC_T(2, 7);
        if (!this.getFlagZ()) {
            this.PC.r += (byte)n;
            this.t += 5L;
        }
    }

    public final void instJR_Z_n8() {
        int n = this.memory.getByte(this.PC.r + 1);
        if (this.traceCPU >= TRC_Jcc) {
            this.traceCPU(2, "JR    Z" + (this.getFlagZ() ? "(1)" : "(0)") + "," + this.toHexString(this.PC.r + 2 + (byte)n, 4));
        }
        this.addPC_T(2, 7);
        if (this.getFlagZ()) {
            this.PC.r = this.PC.r + (byte)n & 0xFFFF;
            this.t += 5L;
        }
    }

    public final void instJR_C_n8() {
        int n = this.memory.getByte(this.PC.r + 1);
        if (this.traceCPU >= TRC_Jcc) {
            this.traceCPU(2, "JR    C" + (this.getFlagC() ? "(1)" : "(0)") + "," + this.toHexString(this.PC.r + 2 + (byte)n, 4));
        }
        this.addPC_T(2, 7);
        if (this.getFlagC()) {
            this.PC.r = this.PC.r + (byte)n & 0xFFFF;
            this.t += 5L;
        }
    }

    public final void instJR_NC_n8() {
        int n = this.memory.getByte(this.PC.r + 1);
        if (this.traceCPU >= TRC_Jcc) {
            this.traceCPU(2, "JR    NC" + (!this.getFlagC() ? "(1)" : "(0)") + "," + this.toHexString(this.PC.r + 2 + (byte)n, 4));
        }
        this.addPC_T(2, 7);
        if (!this.getFlagC()) {
            this.PC.r = this.PC.r + (byte)n & 0xFFFF;
            this.t += 5L;
        }
    }

    public final void instJP_HL() {
        int n = this.HL.get();
        if (this.traceCPU >= TRC_J) {
            this.traceCPU(1, "JP    HL");
        }
        this.PC.r = n;
        this.t += 4L;
    }

    public final void instJP_IND() {
        if (this.traceCPU >= TRC_J) {
            this.traceCPU(2, "JP    (" + this.IND.name + ")");
        }
        this.PC.r = this.IND.get();
        this.t += 8L;
    }

    public final void instDJNZ() {
        int n = this.memory.getByte(this.PC.r + 1);
        if (this.traceCPU >= TRC_Jcc) {
            this.traceCPU(2, "DJNZ  " + this.toHexString(this.PC.r + 2 + (byte)n, 4));
        }
        --this.B.r;
        this.B.r &= 0xFF;
        this.addPC_T(2, 8);
        if (this.B.r != 0) {
            this.PC.r = this.PC.r + (byte)n & 0xFFFF;
            this.t += 5L;
        }
    }

    public final void instCALL_n16() {
        int n = this.memory.getWord(this.PC.r + 1);
        int n2 = this.SP.r - 2 & 0xFFFF;
        this.memory.setWord(n2, this.PC.r + 3 & 0xFFFF);
        if (this.traceCPU >= TRC_CRR) {
            this.traceCPU(3, "CALL  " + this.toHexString(n, 4) + "  ; (SP) <= " + this.toHexString(this.PC.r + 3 & 0xFFFF, 4));
            this.memory.dump(n2, 8);
        }
        this.PC.r = n;
        this.SP.r = n2;
        this.t += 17L;
    }

    public final void instCALL_cc_n16() {
        int n = (this.opcode & 0x38) >> 3;
        int n2 = this.memory.getWord(this.PC.r + 1);
        if (this.traceCPU >= TRC_CRR) {
            this.traceCPU(3, "CALL  " + this.getccName(n) + (this.getccValue(n) ? "(1)" : "(0)") + "," + this.toHexString(n2, 4) + "  ; (SP) <= " + this.toHexString(this.PC.r + 3 & 0xFFFF, 4));
        }
        this.PC.r = this.PC.r + 3 & 0xFFFF;
        this.t += 10L;
        if (this.getccValue(n)) {
            this.SP.r = this.SP.r - 2 & 0xFFFF;
            this.memory.setWord(this.SP.r, this.PC.r);
            this.PC.r = n2;
            this.t += 7L;
        }
    }

    public final void instRET() {
        int n = this.memory.getWord(this.SP.r);
        if (this.traceCPU >= TRC_CRR) {
            this.traceCPU(1, "RET     ; PC <= " + this.toHexString(n, 4));
            this.memory.dump(this.SP.r, 8);
        }
        this.SP.r = this.SP.r + 2 & 0xFFFF;
        this.PC.r = n;
        this.t += 10L;
    }

    public final void instRET_cc() {
        int n = (this.opcode & 0x38) >> 3;
        int n2 = this.SP.r + 2 & 0xFFFF;
        int n3 = this.memory.getWord(this.SP.r);
        if (this.traceCPU >= TRC_CRR) {
            this.traceCPU(1, "RET   " + this.getccName(n) + (this.getccValue(n) ? "(1)" : "(0)") + "  ; PC <= " + this.toHexString(n3, 4));
            this.memory.dump(this.SP.r, 8);
        }
        if (this.getccValue(n)) {
            this.SP.r = n2;
            this.PC.r = n3;
            this.t += 11L;
        } else {
            this.addPC_T(1, 5);
        }
    }

    public final void instRETI() {
        int n = this.memory.getWord(this.SP.r);
        if (this.traceCPU >= TRC_CRR) {
            this.traceCPU(2, "RETI    ; PC <= " + this.toHexString(n, 4));
            this.memory.dump(this.SP.r, 8);
        }
        this.IFF1 = this.IFF2;
        this.SP.r = this.SP.r + 2 & 0xFFFF;
        this.PC.r = n;
        this.t += 14L;
    }

    public final void instRST_p() {
        int n = this.opcode & 0x38;
        if (this.traceCPU >= TRC_CRR) {
            this.traceCPU(1, "RST   " + this.toHexString(n, 2));
        }
        this.SP.r = this.SP.r - 2 & 0xFFFF;
        this.memory.setWord(this.SP.r, this.PC.r + 1 & 0xFFFF);
        this.PC.r = n;
        this.t += 11L;
    }

    public final void instIN_A_n() {
        int n = this.memory.getByte(this.PC.r + 1);
        if (this.traceCPU >= TRC_ALL) {
            this.traceCPU(2, "IN    A,(" + this.toHexString(n, 2) + ")");
        }
        this.A.r = this.port.getPort(n);
        this.addPC_T(2, 11);
    }

    public final void instIN_r8_C() {
        int n;
        int n2 = (this.opcode & 0x38) >> 3;
        int n3 = n = this.port.getPort(this.C.r);
        n3 ^= n3 >> 4;
        n3 ^= n3 >> 2;
        n3 ^= n3 >> 1;
        this.setFlagS((n & SET_S) != 0);
        this.setFlagZ(n == 0);
        this.setFlagPV((n3 &= 1) == 1);
        this.setFlagH(false);
        this.setFlagN(false);
        if (6 == n2) {
            if (this.traceCPU >= TRC_ALL) {
                this.traceCPU(2, "IN    C,(?)");
            }
        } else {
            Reg8 reg8 = this.r8[n2];
            reg8.r = n;
            if (this.traceCPU >= TRC_ALL) {
                this.traceCPU(2, "IN    C,(" + reg8.name + ")");
            }
        }
        this.addPC_T(2, 12);
    }

    public final void instINI() {
        int n = this.port.getPort(this.C.r);
        if (this.traceCPU >= TRC_ALL) {
            this.traceCPU(2, "INI");
        }
        this.memory.setByte(this.HL.get(), n);
        this.HL.add(1);
        this.B.r = this.B.r - 1 & 0xFF;
        this.setFlagS((this.B.r & SET_S) != 0);
        this.setFlagZ(this.B.r == 0);
        this.setFlag5((this.B.r & SET_5) != 0);
        this.setFlag3((this.B.r & SET_3) != 0);
        this.setFlagN((n & SET_S) != 0);
        this.addPC_T(2, 16);
    }

    public final void instINIR() {
        int n = this.port.getPort(this.C.r);
        if (this.traceCPU >= TRC_ALL) {
            this.traceCPU(2, "INIR");
        }
        this.memory.setByte(this.HL.get(), n);
        this.HL.add(1);
        this.B.r = this.B.r - 1 & 0xFF;
        this.setFlagS(false);
        this.setFlagZ(true);
        this.setFlag5(false);
        this.setFlag3(false);
        this.setFlagN((n & SET_S) != 0);
        this.addPC_T(2, 16);
    }

    public final void instIND() {
        int n = this.port.getPort(this.C.r);
        if (this.traceCPU >= TRC_ALL) {
            this.traceCPU(2, "IND");
        }
        this.memory.setByte(this.HL.get(), n);
        this.HL.sub(1);
        this.B.r = this.B.r - 1 & 0xFF;
        this.setFlagS((this.B.r & SET_S) != 0);
        this.setFlagZ(this.B.r == 0);
        this.setFlag5((this.B.r & SET_5) != 0);
        this.setFlag3((this.B.r & SET_3) != 0);
        this.setFlagN((n & SET_S) != 0);
        this.addPC_T(2, 16);
    }

    public final void instINDR() {
        int n = this.port.getPort(this.C.r);
        if (this.traceCPU >= TRC_ALL) {
            this.traceCPU(2, "INDR");
        }
        this.memory.setByte(this.HL.get(), n);
        this.HL.sub(1);
        this.B.r = this.B.r - 1 & 0xFF;
        this.setFlagS(false);
        this.setFlagZ(true);
        this.setFlag5(false);
        this.setFlag3(false);
        this.setFlagN((n & SET_S) != 0);
        this.addPC_T(2, 16);
    }

    public final void instOUT_n_A() {
        int n = this.memory.getByte(this.PC.r + 1);
        if (this.traceCPU >= TRC_ALL) {
            this.traceCPU(2, "OUT   (" + this.toHexString(n, 2) + "),A");
        }
        this.port.setPort(n, this.A.r);
        this.addPC_T(2, 11);
    }

    public final void instOUT_C_r8() {
        Reg8 reg8 = this.r8[(this.memory.getByte(this.PC.r + 1) & 0x38) >> 3];
        if (this.traceCPU >= TRC_ALL) {
            this.traceCPU(2, "OUT   (C)," + reg8.name);
        }
        this.port.setPort(this.C.r, reg8.r);
        this.addPC_T(2, 12);
    }

    public final void instOUT_C_0() {
        if (this.traceCPU >= TRC_ALL) {
            this.traceCPU(2, "OUT   (C),0");
        }
        this.port.setPort(this.C.r, 0);
        this.addPC_T(2, 12);
    }

    public final void instOUTI() {
        int n = this.memory.getByte(this.HL.get());
        if (this.traceCPU >= TRC_ALL) {
            this.traceCPU(2, "OUTI");
        }
        this.port.setPort(this.C.r, n);
        this.HL.add(1);
        this.B.r = this.B.r - 1 & 0xFF;
        this.setFlagS((this.B.r & SET_S) != 0);
        this.setFlagZ(this.B.r == 0);
        this.setFlag5((this.B.r & SET_5) != 0);
        this.setFlagH(this.L.r + n > 255);
        this.setFlag3((this.B.r & SET_3) != 0);
        this.setFlagN((n & SET_S) != 0);
        this.setFlagC(this.L.r + n > 255);
        this.addPC_T(2, 16);
    }

    public final void instOTIR() {
        int n = this.memory.getByte(this.HL.get());
        if (this.traceCPU >= TRC_ALL) {
            this.traceCPU(2, "OTIR");
        }
        this.port.setPort(this.C.r, n);
        this.HL.add(1);
        this.B.r = this.B.r - 1 & 0xFF;
        this.setFlagS(false);
        this.setFlagZ(true);
        this.setFlag5(false);
        this.setFlagH(this.L.r + n > 255);
        this.setFlag3(false);
        this.setFlagN((n & SET_S) != 0);
        this.setFlagC(this.L.r + n > 255);
        if (this.B.r != 0) {
            this.addPC_T(0, 21);
        } else {
            this.addPC_T(2, 16);
        }
    }

    public final void instOUTD() {
        int n = this.memory.getByte(this.HL.get());
        if (this.traceCPU >= TRC_ALL) {
            this.traceCPU(2, "OUTD");
        }
        this.port.setPort(this.C.r, n);
        this.HL.sub(1);
        this.B.r = this.B.r - 1 & 0xFF;
        this.setFlagS((this.B.r & SET_S) != 0);
        this.setFlagZ(this.B.r == 0);
        this.setFlag5((this.B.r & SET_5) != 0);
        this.setFlagH(this.L.r + n > 255);
        this.setFlag3((this.B.r & SET_3) != 0);
        this.setFlagN((n & SET_S) != 0);
        this.setFlagC(this.L.r + n > 255);
        this.addPC_T(2, 16);
    }

    public final void instOTDR() {
        int n = this.memory.getByte(this.HL.get());
        if (this.traceCPU >= TRC_ALL) {
            this.traceCPU(2, "OTDR");
        }
        this.port.setPort(this.C.r, n);
        this.HL.sub(1);
        this.B.r = this.B.r - 1 & 0xFF;
        this.setFlagS(false);
        this.setFlagZ(true);
        this.setFlag5(false);
        this.setFlagH(this.L.r + n > 255);
        this.setFlag3(false);
        this.setFlagN((n & SET_S) != 0);
        this.setFlagC(this.L.r + n > 255);
        if (this.B.r != 0) {
            this.addPC_T(0, 21);
        } else {
            this.addPC_T(2, 16);
        }
    }

    private final int add16(int n, int n2) {
        int n3 = n + n2;
        int n4 = n3 & 0xFFFF;
        this.setFlagC((n3 & 0x10000) != 0);
        this.setFlagH(((n & 0xFFF) + (n2 & 0xFFF) & 0x1000) != 0);
        this.setFlagN(false);
        return n4;
    }

    private final int adc16(int n, int n2) {
        int n3 = this.F.r & SET_C;
        int n4 = n + n2 + n3;
        int n5 = n4 & 0xFFFF;
        this.setFlagS((n5 & SET_S << 8) != 0);
        this.setFlagZ(n5 == 0);
        this.setFlagC((n4 & 0x10000) != 0);
        this.setFlagPV(((n ^ ~n2) & (n ^ n5) & 0x8000) != 0);
        this.setFlagH(((n & 0xFFF) + (n2 & 0xFFF) + n3 & 0x1000) != 0);
        this.setFlagN(false);
        return n5;
    }

    private final int sbc16(int n, int n2) {
        int n3 = this.F.r & SET_C;
        int n4 = n - n2 - n3;
        int n5 = n4 & 0xFFFF;
        this.setFlagS((n5 & SET_S << 8) != 0);
        this.setFlagZ(n5 == 0);
        this.setFlagC((n4 & 0x10000) != 0);
        this.setFlagPV(((n ^ n2) & (n ^ n5) & 0x8000) != 0);
        this.setFlagH(((n & 0xFFF) - (n2 & 0xFFF) - n3 & 0x1000) != 0);
        this.setFlagN(true);
        return n5;
    }

    private final void add_a(int n) {
        int n2 = this.A.r;
        int n3 = n2 + n;
        int n4 = n3 & 0xFF;
        this.F.r = SZTable[n4];
        this.setFlagC((n3 & 0x100) != 0);
        this.setFlagPV(((n2 ^ ~n) & (n2 ^ n4) & 0x80) != 0);
        this.setFlagH(((n2 & 0xF) + (n & 0xF) & SET_H) != 0);
        this.setFlagN(false);
        this.A.r = n4;
    }

    private final void adc_a(int n) {
        int n2 = this.A.r;
        int n3 = this.F.r & SET_C;
        int n4 = n2 + n + n3;
        int n5 = n4 & 0xFF;
        this.F.r = SZTable[n5];
        this.setFlagC((n4 & 0x100) != 0);
        this.setFlagPV(((n2 ^ ~n) & (n2 ^ n5) & 0x80) != 0);
        this.setFlagH(((n2 & 0xF) + (n & 0xF) + n3 & SET_H) != 0);
        this.setFlagN(false);
        this.A.r = n5;
    }

    private final void sub_a(int n) {
        int n2 = this.A.r;
        int n3 = n2 - n;
        int n4 = n3 & 0xFF;
        this.F.r = SZTable[n4] | SET_N;
        this.setFlagC((n3 & 0x100) != 0);
        this.setFlagPV(((n2 ^ n) & (n2 ^ n4) & 0x80) != 0);
        this.setFlagH(((n2 & 0xF) - (n & 0xF) & SET_H) != 0);
        this.A.r = n4;
    }

    private final void sbc_a(int n) {
        int n2 = this.A.r;
        int n3 = this.F.r & SET_C;
        int n4 = n2 - n - n3;
        int n5 = n4 & 0xFF;
        this.F.r = SZTable[n5] | SET_N;
        this.setFlagC((n4 & 0x100) != 0);
        this.setFlagPV(((n2 ^ n) & (n2 ^ n5) & 0x80) != 0);
        this.setFlagH(((n2 & 0xF) - (n & 0xF) - n3 & SET_H) != 0);
        this.A.r = n5;
    }

    private final void cp_a(int n) {
        int n2 = this.A.r;
        int n3 = n2 - n;
        int n4 = n3 & 0xFF;
        this.F.r = SZTable[n4] | SET_N;
        this.setFlagC((n3 & 0x100) != 0);
        this.setFlagH(((n2 & 0xF) - (n & 0xF) & SET_H) != 0);
        this.setFlagPV(((n2 ^ n) & (n2 ^ n4) & 0x80) != 0);
    }

    private final void and_a(int n) {
        this.A.r &= n;
        this.F.r = PSZTable[this.A.r] | SET_H;
    }

    private final void or_a(int n) {
        this.A.r |= n;
        this.F.r = PSZTable[this.A.r];
    }

    private final void xor_a(int n) {
        this.A.r = (this.A.r ^ n) & 0xFF;
        this.F.r = PSZTable[this.A.r];
    }

    private final void daa_a() {
        int n = this.A.r;
        if (this.getFlagC()) {
            n |= 0x100;
        }
        if (this.getFlagH()) {
            n |= 0x200;
        }
        if (this.getFlagN()) {
            n |= 0x400;
        }
        this.AF.set(DAATable[n]);
    }

    private final int inc8(int n) {
        boolean bl = n == 127;
        boolean bl2 = ((n & 0xF) + 1 & SET_H) != 0;
        n = n + 1 & 0xFF;
        this.setFlagS((n & SET_S) != 0);
        this.setFlagZ(n == 0);
        this.setFlagPV(bl);
        this.setFlagH(bl2);
        this.setFlagN(false);
        return n;
    }

    private final int dec8(int n) {
        boolean bl = n == 128;
        boolean bl2 = ((n & 0xF) - 1 & SET_H) != 0;
        n = n - 1 & 0xFF;
        this.setFlagS((n & SET_S) != 0);
        this.setFlagZ(n == 0);
        this.setFlagPV(bl);
        this.setFlagH(bl2);
        this.setFlagN(true);
        return n;
    }

    private final void rrd_a() {
        int n;
        int n2 = this.A.r;
        int n3 = this.HL.get();
        int n4 = n = this.memory.getByte(n3);
        n = n >> 4 | n2 << 4;
        n2 = n2 & 0xF0 | n4 & 0xF;
        this.memory.setByte(n3, n);
        this.F.r = this.F.r & SET_C | PSZTable[n2];
        this.A.r = n2;
    }

    private final void rld_a() {
        int n;
        int n2 = this.A.r;
        int n3 = this.HL.get();
        int n4 = n = this.memory.getByte(n3);
        n = n << 4 | n2 & 0xF;
        n2 = n2 & 0xF0 | n4 >> 4;
        this.memory.setByte(n3, n & 0xFF);
        this.F.r = this.F.r & SET_C | PSZTable[n2];
        this.A.r = n2;
    }

    private final int sll(int n) {
        this.F.r = n >> 7;
        n = (n << 1) + 1 & 0xFF;
        this.F.r |= PSZTable[n];
        return n;
    }

    private final int sla(int n) {
        this.F.r = n >> 7;
        n = n << 1 & 0xFF;
        this.F.r |= PSZTable[n];
        return n;
    }

    private final int sra(int n) {
        this.F.r = n & SET_C;
        n = n >> 1 | n & 0x80;
        this.F.r |= PSZTable[n];
        return n;
    }

    private final int rlc(int n) {
        boolean bl;
        boolean bl2 = bl = (n & 0x80) != 0;
        n = bl ? n << 1 | 1 : (n <<= 1);
        this.F.r = PSZTable[n &= 0xFF];
        this.setFlagC(bl);
        return n;
    }

    private final int rrc(int n) {
        boolean bl;
        boolean bl2 = bl = (n & 1) != 0;
        n = bl ? n >> 1 | 0x80 : (n >>= 1);
        this.F.r = PSZTable[n];
        this.setFlagC(bl);
        return n;
    }

    private final int rl(int n) {
        int n2 = n >> 7;
        n <<= 1;
        if (this.getFlagC()) {
            n |= 1;
        }
        this.F.r = PSZTable[n &= 0xFF] | n2;
        return n;
    }

    private final int rr(int n) {
        int n2 = n & SET_C;
        n >>= 1;
        if (this.getFlagC()) {
            n |= 0x80;
        }
        this.F.r = PSZTable[n] | n2;
        return n;
    }

    private final void rlc_a() {
        int n = this.A.r;
        boolean bl = (n & 0x80) != 0;
        n <<= 1;
        if (bl) {
            n |= 1;
        }
        this.setFlagN(false);
        this.setFlagH(false);
        this.setFlagC(bl);
        this.A.r = n &= 0xFF;
    }

    private final void rl_a() {
        boolean bl;
        int n = this.A.r;
        boolean bl2 = bl = (n & 0x80) != 0;
        n = this.getFlagC() ? n << 1 | 1 : (n <<= 1);
        this.setFlagN(false);
        this.setFlagH(false);
        this.setFlagC(bl);
        this.A.r = n &= 0xFF;
    }

    private final void rrc_a() {
        int n = this.A.r;
        boolean bl = (n & 1) != 0;
        n >>= 1;
        if (bl) {
            n |= 0x80;
        }
        this.setFlagN(false);
        this.setFlagH(false);
        this.setFlagC(bl);
        this.A.r = n;
    }

    private final void rr_a() {
        int n = this.A.r;
        boolean bl = (n & SET_C) != 0;
        n >>= 1;
        if (this.getFlagC()) {
            n |= 0x80;
        }
        this.setFlagN(false);
        this.setFlagH(false);
        this.setFlagC(bl);
        this.A.r = n;
    }

    private final int srl(int n) {
        this.F.r = n & SET_C;
        this.F.r |= PSZTable[n >>= 1] & ~SET_S;
        return n;
    }

    private final void bit(int n, int n2) {
        this.F.r = this.F.r & SET_C | SET_H | PSZTable[n2 & 1 << n];
    }

    public void addPC_T(int n, int n2) {
        this.PC.r = this.PC.r + n & 0xFFFF;
        this.t += (long)n2;
    }

    public void registerTrace() {
        this.log.write("AF= " + this.w2hds(this.AF.get()) + "(" + (this.getFlagS() ? "S=1 " : "S=0 ") + (this.getFlagZ() ? "Z=1 " : "Z=0 ") + (this.getFlagH() ? "H=1 " : "H=0 ") + (this.getFlagPV() ? "P/V=1 " : "P/V=0 ") + (this.getFlagN() ? "N=1 " : "N=0 ") + (this.getFlagC() ? "C=1)" : "C=0)"));
        this.log.write("BC= " + this.w2hds(this.BC.get()) + "DE= " + this.w2hds(this.DE.get()) + "HL= " + this.w2hds(this.HL.get()) + "IFF1= " + (this.IFF1 ? "1" : "0"));
        this.log.write("IX= " + this.w2hds(this.IX.get()) + "IY= " + this.w2hds(this.IY.get()) + "SP= " + this.w2hds(this.SP.get()) + "IFF2= " + (this.IFF2 ? "1" : "0"));
    }

    public void traceCPU(int n, String string) {
        this.log.write("------------------------------------------------------------| " + this.toHexString(this.PC.r, 4) + ": " + this.tracePCBytes(n) + string);
        this.registerTrace();
    }

    public String w2hds(int n) {
        return "0x" + this.toHexString(n, 4) + "    ";
    }

    public String b2hds(int n) {
        return "0x" + this.toHexString(n, 2) + "    ";
    }

    public String toHexString(int n, int n2) {
        String string = "0000000" + Integer.toHexString(n);
        return string.substring(string.length() - n2);
    }

    public final String tracePCBytes(int n) {
        String string = "";
        for (int i = 0; i < n; ++i) {
            string = string + this.toHexString(this.memory.getByte(this.PC.r + i), 2) + " ";
        }
        return (string + "            ").substring(0, 12);
    }

    public final void prevPCs() {
        String string = "";
        for (int i = 0; i < 1024; ++i) {
            string = string + this.toHexString(this.pPC[this.ppi + i & 0x3FF], 4) + "/";
        }
        this.log.write("PrevPCs: " + string);
    }
}

