/*
 * Decompiled with CFR 0.152.
 */
public class Keyboard {
    public int[] matrix;
    public static String[] kbdMatrix = new String[]{"4", "1", "\u00cd", "6", "0", "2", "3", "5", "7", "\u00d6", "\u00d3", "*", "\u00dc", "9", "8", "^", "R", "Q", "@", "Z", ";", "W", "E", "T", "U", "P", "\u00da", "[", "?", "O", "I", "]", "F", "A", "<", "H", "\\", "S", "D", "G", "J", "\u00c9", "?", "Enter", "A", "L", "K", "Backspace", "V", "Y", "Lock", "N", "Shift", "X", "C", "B", "M", "=", "Space", "Ctrl", "Escape", ".", ",", "Alt", "N/A", "Left", "Right", "Acc", "Fire", "Down", "Up", "Insert", "N/A", "Left", "Right", "Acc", "Fire", "Down", "Up", "N/A"};
    TVC tvc;
    Log log;

    public Keyboard(TVC tvc) {
        this.tvc = tvc;
        this.matrix = new int[10];
    }

    public void initialize() {
        this.log = this.tvc.log;
        int i = 0;
        while (i < 10) {
            this.matrix[i] = 255;
            ++i;
        }
    }

    public void setMatrix(String kbd, boolean pressed) {
        int i = 0;
        while (i < 80 && !kbd.equalsIgnoreCase(kbdMatrix[i])) {
            ++i;
        }
        if (i < 80) {
            int row = i / 8;
            int column = 7 - i % 8;
            if (pressed) {
                int n = row;
                this.matrix[n] = this.matrix[n] & ~(1 << column);
            } else {
                int n = row;
                this.matrix[n] = this.matrix[n] | 1 << column;
            }
            this.log.write("ROW" + row + " -> " + this.matrix[row]);
        }
    }
}

