/*
 * Decompiled with CFR 0.152.
 */
public class Port {
    public int[] port_out = new int[256];
    public int[] port_in = new int[256];
    public boolean tracePORT = false;
    TVC tvc;
    Memory mem;
    Utils utils;
    Screen scr;
    Log log;

    public Port(TVC tvc) {
        this.tvc = tvc;
    }

    public void initialize() {
        this.mem = this.tvc.mem;
        this.scr = this.tvc.surface.scr;
        this.log = this.tvc.log;
        this.port_in[90] = 255;
        this.port_in[89] = 255;
    }

    public void setPort(int num, int p) {
        if (this.tracePORT) {
            this.log.write("Port write: " + Utils.toHexString(num, 2) + " <== 0x" + Utils.toHexString(p, 2));
        }
        this.port_out[num] = p;
        switch (num) {
            case 2: {
                this.mem.setPages(p);
                break;
            }
            case 6: {
                this.tvc.surface.scr.setMode(p);
                break;
            }
            case 7: {
                this.port_in[89] = this.port_in[89] | 0x10;
                break;
            }
            case 96: 
            case 97: 
            case 98: 
            case 99: {
                this.tvc.surface.scr.setPalette(num & 3, p);
            }
            default: {
                this.port_out[num] = p;
            }
        }
    }

    public int getPort(int num) {
        int rslt;
        switch (num) {
            case 88: {
                rslt = this.tvc.kbd.matrix[this.port_out[3] & 0xF];
                break;
            }
            default: {
                rslt = this.port_in[num];
            }
        }
        if (this.tracePORT) {
            this.log.write("Port read:  " + Utils.toHexString(num, 2) + " ==> 0x" + Utils.toHexString(rslt, 2));
        }
        return rslt;
    }
}

