/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Canvas;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.image.BufferedImage;
import java.awt.image.IndexColorModel;
import java.awt.image.MemoryImageSource;

class Screen
extends Canvas
implements Runnable {
    public int videomode = 16;
    public int ref = 0;
    public boolean changed = true;
    public int nofRepaint;
    public int minx;
    public int maxx;
    public int maxy;
    public int miny;
    public int maxY;
    public int minY;
    Image i2;
    Image i4;
    Image i16;
    Image i;
    Graphics screenGraphics;
    MemoryImageSource mis2;
    MemoryImageSource mis4;
    MemoryImageSource mis16;
    IndexColorModel icm2;
    IndexColorModel icm4;
    IndexColorModel icm16;
    int[] pix2;
    int[] pix4;
    int[] pix16;
    public int[] r4;
    public int[] g4;
    public int[] b4;
    public static int[] r16;
    public static int[] g16;
    public static int[] b16;
    public int screenX = 512;
    public int screenY = 480;
    public Color[] c16;
    public Color[] c4;
    public BufferedImage[] img16;
    public BufferedImage[] img4;
    public BufferedImage[] img2;
    public MyKeyListener kbdl;
    TVC tvc;

    static {
        int[] nArray = new int[16];
        nArray[2] = 127;
        nArray[3] = 127;
        nArray[6] = 127;
        nArray[7] = 127;
        nArray[10] = 255;
        nArray[11] = 255;
        nArray[14] = 255;
        nArray[15] = 255;
        r16 = nArray;
        int[] nArray2 = new int[16];
        nArray2[4] = 127;
        nArray2[5] = 127;
        nArray2[6] = 127;
        nArray2[7] = 127;
        nArray2[12] = 255;
        nArray2[13] = 255;
        nArray2[14] = 255;
        nArray2[15] = 255;
        g16 = nArray2;
        int[] nArray3 = new int[16];
        nArray3[1] = 127;
        nArray3[3] = 127;
        nArray3[5] = 127;
        nArray3[7] = 127;
        nArray3[9] = 255;
        nArray3[11] = 255;
        nArray3[13] = 255;
        nArray3[15] = 255;
        b16 = nArray3;
    }

    public Screen(TVC tvc) {
        this.tvc = tvc;
        this.c16 = new Color[16];
        this.c4 = new Color[4];
        this.r4 = new int[4];
        this.g4 = new int[4];
        this.b4 = new int[4];
        int i = 0;
        while (i < 4) {
            this.r4[i] = r16[i * 4 + 1];
            this.g4[i] = g16[i * 4 + 1];
            this.b4[i] = b16[i * 4];
            ++i;
        }
        i = 0;
        while (i < 16) {
            this.c16[i] = new Color(r16[i], g16[i], b16[i]);
            ++i;
        }
        this.img2 = new BufferedImage[256];
        this.img4 = new BufferedImage[256];
        i = 0;
        while (i < 256) {
            this.img2[i] = new BufferedImage(8, 1, 1);
            this.img4[i] = new BufferedImage(4, 1, 1);
            ++i;
        }
        this.img16 = new BufferedImage[256];
        i = 0;
        while (i < 256) {
            this.img16[i] = new BufferedImage(2, 1, 1);
            Graphics g = this.img16[i].getGraphics();
            g.setColor(this.c16[i >> 4]);
            g.drawLine(0, 0, 0, 0);
            g.setColor(this.c16[i & 0xF]);
            g.drawLine(1, 0, 1, 0);
            ++i;
        }
        this.i2 = new BufferedImage(512, 240, 1);
        this.i4 = new BufferedImage(256, 240, 1);
        this.i16 = new BufferedImage(128, 240, 1);
        this.setSize(this.screenX, this.screenY);
        this.kbdl = new MyKeyListener(tvc);
        this.addKeyListener(this.kbdl);
    }

    public void initialize() {
        this.setMode(1);
        this.setPalette(0, 0);
        this.setPalette(1, 1);
        this.setPalette(2, 2);
        this.setPalette(3, 3);
        this.kbdl.initialize();
    }

    public void paint(Graphics g) {
        g.drawImage(this.i, 0, 0, this.screenX, this.screenY, 0, 0, this.i.getWidth(this), this.i.getHeight(this), this);
    }

    public void update(Graphics g) {
        this.paint(g);
    }

    public void setMode(int mode) {
        switch (mode & 3) {
            case 0: {
                this.i = this.i2;
                this.videomode = 2;
                break;
            }
            case 1: {
                this.i = this.i4;
                this.videomode = 4;
                break;
            }
            default: {
                this.i = this.i16;
                this.videomode = 16;
            }
        }
        this.screenGraphics = this.i.getGraphics();
        this.redrawScreen();
    }

    public void writeVideo(int a, int v) {
        int x = 0;
        int y = 0;
        switch (this.videomode) {
            case 2: {
                x = (a & 0x3F) << 3;
                y = a >> 6;
                this.screenGraphics.drawImage(this.img2[v], x, y, this);
                break;
            }
            case 4: {
                x = (a & 0x3F) << 2;
                y = a >> 6;
                this.screenGraphics.drawImage(this.img4[v], x, y, this);
                break;
            }
            case 16: {
                x = (a & 0x3F) << 1;
                y = a >> 6;
                this.screenGraphics.drawImage(this.img16[v], x, y, this);
            }
        }
        if (x > this.maxx) {
            this.maxx = x;
        }
        if (x < this.minx) {
            this.minx = x;
        }
        if (y > this.maxx) {
            this.maxy = y;
        }
        if (y < this.minx) {
            this.miny = y;
        }
        this.changed = true;
    }

    public void run() {
        int[] m = this.tvc.mem.VID.mem;
        boolean[] changed = this.tvc.mem.VID.changed;
        Thread.currentThread().setPriority(1);
        this.nofRepaint = 0;
        while (true) {
            ++this.nofRepaint;
            if (this.changed) {
                int minY = this.tvc.mem.VID.minA >> 6;
                int maxY = this.tvc.mem.VID.maxA >> 6;
                this.tvc.mem.VID.minA = 16384;
                this.tvc.mem.VID.maxA = 0;
                int a = minY << 6;
                int y = minY;
                while (y <= maxY) {
                    int x = 0;
                    while (x < 256) {
                        if (changed[a]) {
                            this.screenGraphics.drawImage(this.img4[m[a]], x, y, this);
                            changed[a] = false;
                        }
                        ++a;
                        x += 4;
                    }
                    ++y;
                }
                this.repaint();
                this.changed = false;
            }
            try {
                Thread.sleep(40L);
            }
            catch (Exception exception) {
                continue;
            }
            break;
        }
    }

    public void setPalette(int n, int v) {
        Graphics g;
        int i = (v & 0x40) >> 3 | (v & 0x10) >> 3 | v & 4 | v & 1;
        this.c4[n] = this.c16[i];
        i = 0;
        while (i < 256) {
            g = this.img2[i].getGraphics();
            g.setColor(this.c4[i >> 7 & 1]);
            g.drawLine(0, 0, 0, 0);
            g.setColor(this.c4[i >> 6 & 1]);
            g.drawLine(1, 0, 1, 0);
            g.setColor(this.c4[i >> 5 & 1]);
            g.drawLine(2, 0, 2, 0);
            g.setColor(this.c4[i >> 4 & 1]);
            g.drawLine(3, 0, 3, 0);
            g.setColor(this.c4[i >> 3 & 1]);
            g.drawLine(4, 0, 4, 0);
            g.setColor(this.c4[i >> 2 & 1]);
            g.drawLine(5, 0, 5, 0);
            g.setColor(this.c4[i >> 1 & 1]);
            g.drawLine(6, 0, 6, 0);
            g.setColor(this.c4[i & 1]);
            g.drawLine(7, 0, 7, 0);
            ++i;
        }
        i = 0;
        while (i < 256) {
            g = this.img4[i].getGraphics();
            g.setColor(this.c4[(i & 0x80) >> 6 | (i & 8) >> 3]);
            g.drawLine(0, 0, 0, 0);
            g.setColor(this.c4[(i & 0x40) >> 5 | (i & 4) >> 2]);
            g.drawLine(1, 0, 1, 0);
            g.setColor(this.c4[(i & 0x20) >> 4 | (i & 2) >> 1]);
            g.drawLine(2, 0, 2, 0);
            g.setColor(this.c4[(i & 0x10) >> 3 | i & 1]);
            g.drawLine(3, 0, 3, 0);
            ++i;
        }
        this.redrawScreen();
    }

    public void redrawScreen() {
        boolean[] changed = this.tvc.mem.VID.changed;
        int i = 0;
        while (i < 15630) {
            changed[i] = true;
            ++i;
        }
        this.tvc.mem.VID.maxA = 15615;
        this.tvc.mem.VID.minA = 0;
    }

    public class MyKeyListener
    implements KeyListener {
        TVC tvc;
        Log log;
        Keyboard kbd;

        public MyKeyListener(TVC tvc) {
            this.tvc = tvc;
        }

        public void initialize() {
            this.log = this.tvc.log;
            this.kbd = this.tvc.kbd;
        }

        public void keyTyped(KeyEvent e) {
        }

        public void keyPressed(KeyEvent e) {
            this.keyHandling(e, true);
        }

        public void keyReleased(KeyEvent e) {
            this.keyHandling(e, false);
        }

        public void keyHandling(KeyEvent e, boolean pressed) {
            String t = KeyEvent.getKeyText(e.getKeyCode());
            char c = e.getKeyChar();
            this.tvc.kbd.setMatrix(t, pressed);
            this.log.write("Keyboard: " + (pressed ? "pressed  - |" : "released - |") + t + "| " + c);
        }
    }
}

