/*
 * Decompiled with CFR 0.152.
 */
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;

public class Memory {
    Screen scr;
    Log log;
    Page SYS;
    Page EXT;
    Page VID;
    Page CART;
    Page U0;
    Page U1;
    Page U2;
    Page U3;
    Page[] M;
    TVC tvc;

    public Memory(TVC tvc) {
        this.tvc = tvc;
        this.SYS = new Page("System", false);
        this.EXT = new Page("Ext", false);
        this.VID = new Page("Video", true);
        this.CART = new Page("Cart", false);
        this.U0 = new Page("U0", false);
        this.U1 = new Page("U1", false);
        this.U2 = new Page("U2", false);
        this.U3 = new Page("U3", false);
        this.M = new Page[4];
    }

    public void initialize() {
        this.scr = this.tvc.surface.scr;
        this.log = this.tvc.log;
    }

    public boolean LoadROM() {
        FileInputStream ROMFile;
        byte[] workSYS = new byte[8192];
        try {
            ROMFile = new FileInputStream("rom/TVC12_D4.BIN");
            ROMFile.read(workSYS);
            ROMFile.close();
        }
        catch (FileNotFoundException e) {
            this.log.write(e.getMessage());
            return false;
        }
        catch (IOException ee) {
            this.log.write(ee.getMessage());
            return false;
        }
        int i = 0;
        while (i < 8192) {
            this.SYS.set(i, workSYS[i] & 0xFF);
            ++i;
        }
        this.log.write("TVC12_D4.BIN has been loaded into SYS_1");
        try {
            ROMFile = new FileInputStream("rom/TVC12_D3.BIN");
            ROMFile.read(workSYS);
            ROMFile.close();
        }
        catch (FileNotFoundException e) {
            this.log.write(e.getMessage());
            return false;
        }
        catch (IOException ee) {
            this.log.write(ee.getMessage());
            return false;
        }
        i = 0;
        while (i < 8192) {
            this.SYS.set(i + 8192, workSYS[i] & 0xFF);
            ++i;
        }
        this.log.write("TVC12_D3.BIN has been loaded into SYS_2");
        try {
            ROMFile = new FileInputStream("rom/TVC12_D7.BIN");
            ROMFile.read(workSYS);
            ROMFile.close();
        }
        catch (FileNotFoundException e) {
            this.log.write(e.getMessage());
            return false;
        }
        catch (IOException ee) {
            this.log.write(ee.getMessage());
            return false;
        }
        i = 0;
        while (i < 8192) {
            this.EXT.set(i + 8192, workSYS[i] & 0xFF);
            ++i;
        }
        this.log.write("TVC12_D7.BIN has been loaded into EXT");
        this.setPages(0);
        return true;
    }

    public final int getByte(int addr) {
        int page = addr >> 14;
        int offset = addr & 0x3FFF;
        switch (addr) {
            case 1029866: {
                this.log.write("Memory read trace:" + Integer.toHexString(addr) + "-" + Integer.toHexString(this.M[page].mem[offset]) + " PC: 0x" + Integer.toHexString(this.tvc.z80.PC.r));
            }
        }
        return this.M[page].mem[offset];
    }

    public final void setByte(int addr, int p) {
        int page = addr >> 14;
        int offset = addr & 0x3FFF;
        switch (addr) {
            case 46266: {
                this.log.write("Memory write trace:" + Integer.toHexString(addr) + "-" + Integer.toHexString(p) + " PC: 0x" + Integer.toHexString(this.tvc.z80.PC.r));
            }
        }
        this.M[page].set(offset, p);
    }

    public final void setWord(int addr, int p) {
        this.setByte(addr, p & 0xFF);
        this.setByte(addr + 1, p >> 8);
    }

    public final int getWord(int addr) {
        return this.getByte(addr) | this.getByte(addr + 1) << 8;
    }

    public void setPages(int p) {
        String s = "";
        switch (p & 0x18) {
            case 0: {
                this.M[0] = this.SYS;
                s = String.valueOf(s) + "SYS";
                break;
            }
            case 8: {
                this.M[0] = this.CART;
                s = String.valueOf(s) + "CART";
                break;
            }
            case 16: {
                this.M[0] = this.U0;
                s = String.valueOf(s) + "U0";
            }
        }
        this.M[1] = this.U1;
        s = String.valueOf(s) + "-U1";
        switch (p & 0x20) {
            case 0: {
                this.M[2] = this.VID;
                s = String.valueOf(s) + "-VID";
                break;
            }
            case 32: {
                this.M[2] = this.U2;
                s = String.valueOf(s) + "-U2";
            }
        }
        switch (p & 0xC0) {
            case 0: {
                this.M[3] = this.CART;
                s = String.valueOf(s) + "-CART";
                break;
            }
            case 64: {
                this.M[3] = this.SYS;
                s = String.valueOf(s) + "-SYS";
                break;
            }
            case 128: {
                this.M[3] = this.U3;
                s = String.valueOf(s) + "-U3";
                break;
            }
            case 192: {
                this.M[3] = this.EXT;
                s = String.valueOf(s) + "-EXT";
            }
        }
    }

    public void dump(int pAddr, int pSize) {
        String s1 = new String("");
        String s2 = new String("");
        String s3 = new String("");
        this.log.write("Memory dump");
        this.log.write("Address: 00 01 02 03 04 05 06 07 - 08 09 0a 0b 0c 0d 0e 0f");
        this.log.write("----------------------------------------------------------");
        int i = 0;
        while (i < pSize) {
            if (i % 16 == 0) {
                if (i != 0) {
                    this.log.write(String.valueOf(s1) + "  " + s3);
                }
                s2 = "0000" + Integer.toHexString(pAddr + i);
                s2 = s2.substring(s2.length() - 4);
                s1 = "0x" + s2 + " : ";
                s3 = "";
            }
            int wByte = this.getByte(pAddr + i);
            s2 = "00" + Integer.toHexString(wByte);
            s2 = s2.substring(s2.length() - 2);
            s1 = i % 8 == 0 && i % 16 != 0 ? String.valueOf(s1) + "- " + s2 + " " : String.valueOf(s1) + s2 + " ";
            s3 = String.valueOf(s3) + (char)wByte;
            ++i;
        }
        this.log.write(s1);
    }

    class Page {
        int[] mem = new int[16384];
        boolean video;
        String name;

        public Page(String name, boolean video) {
            int i = 0;
            while (i < 1024) {
                this.mem[i] = 0;
                ++i;
            }
            this.video = video;
            this.name = name;
        }

        public final int get(int addr) {
            return this.mem[addr];
        }

        public final void set(int addr, int p) {
            this.mem[addr] = p;
            if (this.video) {
                Memory.this.tvc.surface.scr.writeVideo(addr, p);
            }
        }
    }
}

