/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Canvas;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.image.BufferedImage;
import java.awt.image.IndexColorModel;
import java.awt.image.MemoryImageSource;

class Screen
extends Canvas
implements Runnable {
    public int videomode = 16;
    public int ref = 0;
    public boolean changed = true;
    public int nofRepaint;
    public int minx;
    public int maxx;
    public int maxy;
    public int miny;
    Image i2;
    Image i4;
    Image i16;
    Image i;
    Graphics screenGraphics;
    MemoryImageSource mis2;
    MemoryImageSource mis4;
    MemoryImageSource mis16;
    IndexColorModel icm2;
    IndexColorModel icm4;
    IndexColorModel icm16;
    int[] pix2;
    int[] pix4;
    int[] pix16;
    public int[] r4;
    public int[] g4;
    public int[] b4;
    public static int[] r16;
    public static int[] g16;
    public static int[] b16;
    public int screenX = 256;
    public int screenY = 240;
    public Color[] c16;
    public Color[] c4;
    public BufferedImage[] img16;
    public BufferedImage[] img4;
    public BufferedImage[] img2;
    public MyKeyListener kbdl;
    TVC tvc;

    static {
        int[] nArray = new int[16];
        nArray[2] = 127;
        nArray[3] = 127;
        nArray[6] = 127;
        nArray[7] = 127;
        nArray[10] = 255;
        nArray[11] = 255;
        nArray[14] = 255;
        nArray[15] = 255;
        r16 = nArray;
        int[] nArray2 = new int[16];
        nArray2[4] = 127;
        nArray2[5] = 127;
        nArray2[6] = 127;
        nArray2[7] = 127;
        nArray2[12] = 255;
        nArray2[13] = 255;
        nArray2[14] = 255;
        nArray2[15] = 255;
        g16 = nArray2;
        int[] nArray3 = new int[16];
        nArray3[1] = 127;
        nArray3[3] = 127;
        nArray3[5] = 127;
        nArray3[7] = 127;
        nArray3[9] = 255;
        nArray3[11] = 255;
        nArray3[13] = 255;
        nArray3[15] = 255;
        b16 = nArray3;
    }

    public Screen(TVC tvc) {
        this.tvc = tvc;
        this.c16 = new Color[16];
        this.c4 = new Color[4];
        this.r4 = new int[4];
        this.g4 = new int[4];
        this.b4 = new int[4];
        int i = 0;
        while (i < 4) {
            this.r4[i] = r16[i * 4 + 1];
            this.g4[i] = g16[i * 4 + 1];
            this.b4[i] = b16[i * 4];
            ++i;
        }
        i = 0;
        while (i < 16) {
            this.c16[i] = new Color(r16[i], g16[i], b16[i]);
            ++i;
        }
        this.img2 = new BufferedImage[256];
        this.img4 = new BufferedImage[256];
        i = 0;
        while (i < 256) {
            this.img2[i] = new BufferedImage(8, 1, 1);
            this.img4[i] = new BufferedImage(4, 1, 1);
            ++i;
        }
        this.img16 = new BufferedImage[256];
        i = 0;
        while (i < 256) {
            this.img16[i] = new BufferedImage(2, 1, 1);
            Graphics g = this.img16[i].getGraphics();
            g.setColor(this.c16[i >> 4]);
            g.drawLine(0, 0, 0, 0);
            g.setColor(this.c16[i & 0xF]);
            g.drawLine(1, 0, 1, 0);
            ++i;
        }
        this.i2 = new BufferedImage(128, 240, 1);
        this.i4 = new BufferedImage(256, 240, 1);
        this.i16 = new BufferedImage(128, 240, 1);
        this.setSize(this.screenX, this.screenY);
        this.kbdl = new MyKeyListener(tvc);
        this.addKeyListener(this.kbdl);
    }

    public void initialize() {
        this.setMode(1);
        this.setPalette(0, 0);
        this.setPalette(1, 1);
        this.setPalette(2, 2);
        this.setPalette(3, 3);
        this.kbdl.initialize();
    }

    public void paint(Graphics g) {
        g.drawImage(this.i, 0, 0, this.screenX, this.screenY, 0, 0, this.i.getWidth(this), this.i.getHeight(this), this);
    }

    public void update(Graphics g) {
        this.paint(g);
    }

    public void setMode(int mode) {
        switch (mode & 3) {
            case 0: {
                this.i = this.i2;
                this.videomode = 2;
                break;
            }
            case 1: {
                this.i = this.i4;
                this.videomode = 4;
                break;
            }
            default: {
                this.i = this.i16;
                this.videomode = 16;
            }
        }
        this.tvc.log.write("Video mode: " + Integer.toString(mode) + "==> " + Integer.toString(this.videomode));
        this.screenGraphics = this.i.getGraphics();
        this.redrawScreen();
    }

    public void writeVideo(int a, int v) {
        int x = 0;
        int y = 0;
        switch (this.videomode) {
            case 2: {
                break;
            }
            case 4: {
                x = (a & 0x3F) << 2;
                y = a >> 6;
                this.screenGraphics.drawImage(this.img4[v], x, y, this);
                break;
            }
            case 16: {
                x = (a & 0x3F) << 1;
                y = a >> 6;
                this.screenGraphics.drawImage(this.img16[v], x, y, this);
            }
        }
        if (x > this.maxx) {
            this.maxx = x;
        }
        if (x < this.minx) {
            this.minx = x;
        }
        if (y > this.maxx) {
            this.maxy = y;
        }
        if (y < this.minx) {
            this.miny = y;
        }
        this.changed = true;
    }

    public void run() {
        Thread.currentThread().setPriority(1);
        this.nofRepaint = 0;
        while (true) {
            ++this.nofRepaint;
            if (this.changed) {
                this.repaint();
                this.changed = false;
            }
            try {
                Thread.sleep(150L);
            }
            catch (Exception exception) {
            }
        }
    }

    public void setPalette(int n, int v) {
        int i = (v & 0x40) >> 3 | (v & 0x10) >> 3 | v & 4 | v & 1;
        this.c4[n] = this.c16[i];
        i = 0;
        while (i < 256) {
            Graphics g = this.img4[i].getGraphics();
            g.setColor(this.c4[(i & 0x80) >> 6 | (i & 8) >> 3]);
            g.drawLine(0, 0, 0, 0);
            g.setColor(this.c4[(i & 0x40) >> 5 | (i & 4) >> 2]);
            g.drawLine(1, 0, 1, 0);
            g.setColor(this.c4[(i & 0x20) >> 4 | (i & 2) >> 1]);
            g.drawLine(2, 0, 2, 0);
            g.setColor(this.c4[(i & 0x10) >> 3 | i & 1]);
            g.drawLine(3, 0, 3, 0);
            ++i;
        }
        this.tvc.log.write("SET PALETTE: " + n + " <== " + v + " PC: 0x" + Integer.toHexString(this.tvc.z80.PC.r));
        this.redrawScreen();
    }

    public void redrawScreen() {
        int i = 0;
        while (i < 15630) {
            this.writeVideo(i, this.tvc.mem.VID.mem[i]);
            ++i;
        }
    }

    public class MyKeyListener
    implements KeyListener {
        TVC tvc;
        Log log;
        Keyboard kbd;

        public MyKeyListener(TVC tvc) {
            this.tvc = tvc;
        }

        public void initialize() {
            this.log = this.tvc.log;
            this.kbd = this.tvc.kbd;
        }

        public void keyTyped(KeyEvent e) {
        }

        public void keyPressed(KeyEvent e) {
            this.keyHandling(e, true);
        }

        public void keyReleased(KeyEvent e) {
            this.keyHandling(e, false);
        }

        public void keyHandling(KeyEvent e, boolean pressed) {
            String t = KeyEvent.getKeyText(e.getKeyCode());
            char c = e.getKeyChar();
            this.log.write("Keyboard: " + (pressed ? "pressed  - |" : "released - |") + t + "| " + c);
            if (t.compareToIgnoreCase("Shift") == 0) {
                this.tvc.kbd.setMatrix(6, 3, pressed);
            }
            if (t.compareToIgnoreCase("Enter") == 0) {
                this.tvc.kbd.setMatrix(5, 4, pressed);
            }
            if (t.compareToIgnoreCase("Backspace") == 0) {
                this.tvc.kbd.setMatrix(5, 0, pressed);
            }
            if (t.compareToIgnoreCase("Left") == 0) {
                this.tvc.kbd.setMatrix(8, 6, pressed);
            }
            if (t.compareToIgnoreCase("Right") == 0) {
                this.tvc.kbd.setMatrix(8, 5, pressed);
            }
            if (t.compareToIgnoreCase("Down") == 0) {
                this.tvc.kbd.setMatrix(8, 2, pressed);
            }
            if (t.compareToIgnoreCase("Up") == 0) {
                this.tvc.kbd.setMatrix(8, 1, pressed);
            }
            switch (c) {
                case ' ': {
                    this.tvc.kbd.setMatrix(7, 5, pressed);
                    break;
                }
                case 'a': {
                    this.tvc.kbd.setMatrix(4, 6, pressed);
                    break;
                }
                case 'b': {
                    this.tvc.kbd.setMatrix(6, 0, pressed);
                    break;
                }
                case 'c': {
                    this.tvc.kbd.setMatrix(6, 1, pressed);
                    break;
                }
                case 'd': {
                    this.tvc.kbd.setMatrix(4, 1, pressed);
                    break;
                }
                case 'e': {
                    this.tvc.kbd.setMatrix(2, 1, pressed);
                    break;
                }
                case 'f': {
                    this.tvc.kbd.setMatrix(4, 7, pressed);
                    break;
                }
                case 'g': {
                    this.tvc.kbd.setMatrix(4, 0, pressed);
                    break;
                }
                case 'h': {
                    this.tvc.kbd.setMatrix(4, 4, pressed);
                    break;
                }
                case 'i': {
                    this.tvc.kbd.setMatrix(3, 1, pressed);
                    break;
                }
                case 'j': {
                    this.tvc.kbd.setMatrix(5, 7, pressed);
                    break;
                }
                case 'k': {
                    this.tvc.kbd.setMatrix(5, 1, pressed);
                    break;
                }
                case 'l': {
                    this.tvc.kbd.setMatrix(5, 2, pressed);
                    break;
                }
                case 'm': {
                    this.tvc.kbd.setMatrix(7, 7, pressed);
                    break;
                }
                case 'n': {
                    this.tvc.kbd.setMatrix(6, 4, pressed);
                    break;
                }
                case 'o': {
                    this.tvc.kbd.setMatrix(3, 2, pressed);
                    break;
                }
                case 'p': {
                    this.tvc.kbd.setMatrix(3, 6, pressed);
                    break;
                }
                case 'q': {
                    this.tvc.kbd.setMatrix(2, 6, pressed);
                    break;
                }
                case 'r': {
                    this.tvc.kbd.setMatrix(2, 7, pressed);
                    break;
                }
                case 's': {
                    this.tvc.kbd.setMatrix(4, 2, pressed);
                    break;
                }
                case 't': {
                    this.tvc.kbd.setMatrix(2, 0, pressed);
                    break;
                }
                case 'u': {
                    this.tvc.kbd.setMatrix(3, 7, pressed);
                    break;
                }
                case 'v': {
                    this.tvc.kbd.setMatrix(6, 7, pressed);
                    break;
                }
                case 'w': {
                    this.tvc.kbd.setMatrix(2, 2, pressed);
                    break;
                }
                case 'x': {
                    this.tvc.kbd.setMatrix(6, 2, pressed);
                    break;
                }
                case 'y': {
                    this.tvc.kbd.setMatrix(6, 6, pressed);
                    break;
                }
                case 'z': {
                    this.tvc.kbd.setMatrix(2, 4, pressed);
                    break;
                }
                case '0': {
                    this.tvc.kbd.setMatrix(0, 3, pressed);
                    break;
                }
                case '1': {
                    this.tvc.kbd.setMatrix(0, 6, pressed);
                    break;
                }
                case '2': {
                    this.tvc.kbd.setMatrix(0, 2, pressed);
                    break;
                }
                case '3': {
                    this.tvc.kbd.setMatrix(0, 1, pressed);
                    break;
                }
                case '4': {
                    this.tvc.kbd.setMatrix(0, 7, pressed);
                    break;
                }
                case '5': {
                    this.tvc.kbd.setMatrix(0, 0, pressed);
                    break;
                }
                case '6': {
                    this.tvc.kbd.setMatrix(0, 4, pressed);
                    break;
                }
                case '7': {
                    this.tvc.kbd.setMatrix(1, 7, pressed);
                    break;
                }
                case '8': {
                    this.tvc.kbd.setMatrix(1, 1, pressed);
                    break;
                }
                case '9': {
                    this.tvc.kbd.setMatrix(1, 2, pressed);
                }
            }
        }
    }
}

