/*
 * Decompiled with CFR 0.152.
 */
public class Z80
implements Runnable {
    public Reg8 A;
    public Reg8 B;
    public Reg8 C;
    public Reg8 D;
    public Reg8 E;
    public Reg8 F;
    public Reg8 H;
    public Reg8 L;
    public Reg8 IM;
    public Reg8 I;
    public Reg16 AF;
    public Reg16 BC;
    public Reg16 DE;
    public Reg16 HL;
    public Reg16 IX;
    public Reg16 IY;
    public Reg16 PC;
    public Reg16 SP;
    public int AF1;
    public int BC1;
    public int DE1;
    public int HL1;
    public boolean IFF1;
    public boolean IFF2;
    private Reg8[] r8;
    private Reg8 r1;
    private Reg8 r2;
    private Reg16[] r16;
    private Reg16[] r16AF;
    private Reg16[] r16SP;
    private Reg16[] r16IND;
    private Reg16 IND;
    private Reg16 R1;
    private Reg16 R2;
    int[] pPC;
    int ppi = 0;
    public long instCount;
    public long t;
    public boolean running;
    public int opcode;
    public int n16;
    public int addr;
    public boolean interrupt;
    static String[] flagNames = new String[]{"NZ", "Z", "NC", "C", "PO", "PE", "P", "N"};
    static int IM0 = 0;
    static int IM1 = 1;
    static int IM2 = 2;
    static int[] SZTable;
    static int[] PSZTable;
    static int SET_S;
    static int SET_Z;
    static int SET_5;
    static int SET_H;
    static int SET_3;
    static int SET_PV;
    static int SET_N;
    static int SET_C;
    public int traceCPU;
    static int TRC_SUB;
    static int TRC_GP;
    static int TRC_CRR;
    static int TRC_J;
    static int TRC_Jcc;
    static int TRC_ALL;
    Memory mem;
    Port port;
    TVC tvc;
    Log log;

    static {
        int[] nArray = new int[256];
        nArray[0] = 64;
        nArray[128] = 128;
        nArray[129] = 128;
        nArray[130] = 128;
        nArray[131] = 128;
        nArray[132] = 128;
        nArray[133] = 128;
        nArray[134] = 128;
        nArray[135] = 128;
        nArray[136] = 128;
        nArray[137] = 128;
        nArray[138] = 128;
        nArray[139] = 128;
        nArray[140] = 128;
        nArray[141] = 128;
        nArray[142] = 128;
        nArray[143] = 128;
        nArray[144] = 128;
        nArray[145] = 128;
        nArray[146] = 128;
        nArray[147] = 128;
        nArray[148] = 128;
        nArray[149] = 128;
        nArray[150] = 128;
        nArray[151] = 128;
        nArray[152] = 128;
        nArray[153] = 128;
        nArray[154] = 128;
        nArray[155] = 128;
        nArray[156] = 128;
        nArray[157] = 128;
        nArray[158] = 128;
        nArray[159] = 128;
        nArray[160] = 128;
        nArray[161] = 128;
        nArray[162] = 128;
        nArray[163] = 128;
        nArray[164] = 128;
        nArray[165] = 128;
        nArray[166] = 128;
        nArray[167] = 128;
        nArray[168] = 128;
        nArray[169] = 128;
        nArray[170] = 128;
        nArray[171] = 128;
        nArray[172] = 128;
        nArray[173] = 128;
        nArray[174] = 128;
        nArray[175] = 128;
        nArray[176] = 128;
        nArray[177] = 128;
        nArray[178] = 128;
        nArray[179] = 128;
        nArray[180] = 128;
        nArray[181] = 128;
        nArray[182] = 128;
        nArray[183] = 128;
        nArray[184] = 128;
        nArray[185] = 128;
        nArray[186] = 128;
        nArray[187] = 128;
        nArray[188] = 128;
        nArray[189] = 128;
        nArray[190] = 128;
        nArray[191] = 128;
        nArray[192] = 128;
        nArray[193] = 128;
        nArray[194] = 128;
        nArray[195] = 128;
        nArray[196] = 128;
        nArray[197] = 128;
        nArray[198] = 128;
        nArray[199] = 128;
        nArray[200] = 128;
        nArray[201] = 128;
        nArray[202] = 128;
        nArray[203] = 128;
        nArray[204] = 128;
        nArray[205] = 128;
        nArray[206] = 128;
        nArray[207] = 128;
        nArray[208] = 128;
        nArray[209] = 128;
        nArray[210] = 128;
        nArray[211] = 128;
        nArray[212] = 128;
        nArray[213] = 128;
        nArray[214] = 128;
        nArray[215] = 128;
        nArray[216] = 128;
        nArray[217] = 128;
        nArray[218] = 128;
        nArray[219] = 128;
        nArray[220] = 128;
        nArray[221] = 128;
        nArray[222] = 128;
        nArray[223] = 128;
        nArray[224] = 128;
        nArray[225] = 128;
        nArray[226] = 128;
        nArray[227] = 128;
        nArray[228] = 128;
        nArray[229] = 128;
        nArray[230] = 128;
        nArray[231] = 128;
        nArray[232] = 128;
        nArray[233] = 128;
        nArray[234] = 128;
        nArray[235] = 128;
        nArray[236] = 128;
        nArray[237] = 128;
        nArray[238] = 128;
        nArray[239] = 128;
        nArray[240] = 128;
        nArray[241] = 128;
        nArray[242] = 128;
        nArray[243] = 128;
        nArray[244] = 128;
        nArray[245] = 128;
        nArray[246] = 128;
        nArray[247] = 128;
        nArray[248] = 128;
        nArray[249] = 128;
        nArray[250] = 128;
        nArray[251] = 128;
        nArray[252] = 128;
        nArray[253] = 128;
        nArray[254] = 128;
        nArray[255] = 128;
        SZTable = nArray;
        int[] nArray2 = new int[256];
        nArray2[0] = 68;
        nArray2[3] = 4;
        nArray2[5] = 4;
        nArray2[6] = 4;
        nArray2[9] = 4;
        nArray2[10] = 4;
        nArray2[12] = 4;
        nArray2[15] = 4;
        nArray2[17] = 4;
        nArray2[18] = 4;
        nArray2[20] = 4;
        nArray2[23] = 4;
        nArray2[24] = 4;
        nArray2[27] = 4;
        nArray2[29] = 4;
        nArray2[30] = 4;
        nArray2[33] = 4;
        nArray2[34] = 4;
        nArray2[36] = 4;
        nArray2[39] = 4;
        nArray2[40] = 4;
        nArray2[43] = 4;
        nArray2[45] = 4;
        nArray2[46] = 4;
        nArray2[48] = 4;
        nArray2[51] = 4;
        nArray2[53] = 4;
        nArray2[54] = 4;
        nArray2[57] = 4;
        nArray2[58] = 4;
        nArray2[60] = 4;
        nArray2[63] = 4;
        nArray2[65] = 4;
        nArray2[66] = 4;
        nArray2[68] = 4;
        nArray2[71] = 4;
        nArray2[72] = 4;
        nArray2[75] = 4;
        nArray2[77] = 4;
        nArray2[78] = 4;
        nArray2[80] = 4;
        nArray2[83] = 4;
        nArray2[85] = 4;
        nArray2[86] = 4;
        nArray2[89] = 4;
        nArray2[90] = 4;
        nArray2[92] = 4;
        nArray2[95] = 4;
        nArray2[96] = 4;
        nArray2[99] = 4;
        nArray2[101] = 4;
        nArray2[102] = 4;
        nArray2[105] = 4;
        nArray2[106] = 4;
        nArray2[108] = 4;
        nArray2[111] = 4;
        nArray2[113] = 4;
        nArray2[114] = 4;
        nArray2[116] = 4;
        nArray2[119] = 4;
        nArray2[120] = 4;
        nArray2[123] = 4;
        nArray2[125] = 4;
        nArray2[126] = 4;
        nArray2[128] = 128;
        nArray2[129] = 132;
        nArray2[130] = 132;
        nArray2[131] = 128;
        nArray2[132] = 132;
        nArray2[133] = 128;
        nArray2[134] = 128;
        nArray2[135] = 132;
        nArray2[136] = 132;
        nArray2[137] = 128;
        nArray2[138] = 128;
        nArray2[139] = 132;
        nArray2[140] = 128;
        nArray2[141] = 132;
        nArray2[142] = 132;
        nArray2[143] = 128;
        nArray2[144] = 132;
        nArray2[145] = 128;
        nArray2[146] = 128;
        nArray2[147] = 132;
        nArray2[148] = 128;
        nArray2[149] = 132;
        nArray2[150] = 132;
        nArray2[151] = 128;
        nArray2[152] = 128;
        nArray2[153] = 132;
        nArray2[154] = 132;
        nArray2[155] = 128;
        nArray2[156] = 132;
        nArray2[157] = 128;
        nArray2[158] = 128;
        nArray2[159] = 132;
        nArray2[160] = 132;
        nArray2[161] = 128;
        nArray2[162] = 128;
        nArray2[163] = 132;
        nArray2[164] = 128;
        nArray2[165] = 132;
        nArray2[166] = 132;
        nArray2[167] = 128;
        nArray2[168] = 128;
        nArray2[169] = 132;
        nArray2[170] = 132;
        nArray2[171] = 128;
        nArray2[172] = 132;
        nArray2[173] = 128;
        nArray2[174] = 128;
        nArray2[175] = 132;
        nArray2[176] = 128;
        nArray2[177] = 132;
        nArray2[178] = 132;
        nArray2[179] = 128;
        nArray2[180] = 132;
        nArray2[181] = 128;
        nArray2[182] = 128;
        nArray2[183] = 132;
        nArray2[184] = 132;
        nArray2[185] = 128;
        nArray2[186] = 128;
        nArray2[187] = 132;
        nArray2[188] = 128;
        nArray2[189] = 132;
        nArray2[190] = 132;
        nArray2[191] = 128;
        nArray2[192] = 132;
        nArray2[193] = 128;
        nArray2[194] = 128;
        nArray2[195] = 132;
        nArray2[196] = 128;
        nArray2[197] = 132;
        nArray2[198] = 132;
        nArray2[199] = 128;
        nArray2[200] = 128;
        nArray2[201] = 132;
        nArray2[202] = 132;
        nArray2[203] = 128;
        nArray2[204] = 132;
        nArray2[205] = 128;
        nArray2[206] = 128;
        nArray2[207] = 132;
        nArray2[208] = 128;
        nArray2[209] = 132;
        nArray2[210] = 132;
        nArray2[211] = 128;
        nArray2[212] = 132;
        nArray2[213] = 128;
        nArray2[214] = 128;
        nArray2[215] = 132;
        nArray2[216] = 132;
        nArray2[217] = 128;
        nArray2[218] = 128;
        nArray2[219] = 132;
        nArray2[220] = 128;
        nArray2[221] = 132;
        nArray2[222] = 132;
        nArray2[223] = 128;
        nArray2[224] = 128;
        nArray2[225] = 132;
        nArray2[226] = 132;
        nArray2[227] = 128;
        nArray2[228] = 132;
        nArray2[229] = 128;
        nArray2[230] = 128;
        nArray2[231] = 132;
        nArray2[232] = 132;
        nArray2[233] = 128;
        nArray2[234] = 128;
        nArray2[235] = 132;
        nArray2[236] = 128;
        nArray2[237] = 132;
        nArray2[238] = 132;
        nArray2[239] = 128;
        nArray2[240] = 132;
        nArray2[241] = 128;
        nArray2[242] = 128;
        nArray2[243] = 132;
        nArray2[244] = 128;
        nArray2[245] = 132;
        nArray2[246] = 132;
        nArray2[247] = 128;
        nArray2[248] = 128;
        nArray2[249] = 132;
        nArray2[250] = 132;
        nArray2[251] = 128;
        nArray2[252] = 132;
        nArray2[253] = 128;
        nArray2[254] = 128;
        nArray2[255] = 132;
        PSZTable = nArray2;
        SET_S = 128;
        SET_Z = 64;
        SET_5 = 32;
        SET_H = 16;
        SET_3 = 8;
        SET_PV = 4;
        SET_N = 2;
        SET_C = 1;
        TRC_SUB = 1;
        TRC_GP = 2;
        TRC_CRR = 3;
        TRC_J = 4;
        TRC_Jcc = 5;
        TRC_ALL = 6;
    }

    public Z80(TVC tvc) {
        this.tvc = tvc;
        this.A = new Reg8("A");
        this.B = new Reg8("B");
        this.C = new Reg8("C");
        this.D = new Reg8("D");
        this.E = new Reg8("E");
        this.F = new Reg8("F");
        this.H = new Reg8("H");
        this.L = new Reg8("L");
        this.AF = new Reg16("AF", this.A, this.F);
        this.BC = new Reg16("BC", this.B, this.C);
        this.DE = new Reg16("DE", this.D, this.E);
        this.HL = new Reg16("HL", this.H, this.L);
        this.PC = new Reg16("PC");
        this.SP = new Reg16("SP");
        this.IX = new Reg16("IX");
        this.IY = new Reg16("IY");
        this.IM = new Reg8("IM");
        this.I = new Reg8("I");
        this.r8 = new Reg8[8];
        this.r8[0] = this.B;
        this.r8[1] = this.C;
        this.r8[2] = this.D;
        this.r8[3] = this.E;
        this.r8[4] = this.H;
        this.r8[5] = this.L;
        this.r8[6] = null;
        this.r8[7] = this.A;
        this.r16 = new Reg16[4];
        this.r16[0] = this.BC;
        this.r16[1] = this.DE;
        this.r16[2] = this.HL;
        this.r16[3] = this.SP;
        this.r16AF = new Reg16[4];
        this.r16AF[0] = this.BC;
        this.r16AF[1] = this.DE;
        this.r16AF[2] = this.HL;
        this.r16AF[3] = this.AF;
        this.r16IND = new Reg16[4];
        this.r16IND[0] = this.BC;
        this.r16IND[1] = this.DE;
        this.r16IND[3] = this.SP;
        this.pPC = new int[1024];
    }

    public void initialize() {
        this.mem = this.tvc.mem;
        this.port = this.tvc.port;
        this.log = this.tvc.log;
    }

    public void run() {
        Thread.currentThread().setPriority(1);
        long m1 = System.currentTimeMillis();
        this.running = true;
        this.interrupt = false;
        new Thread(new IntCursor(this)).start();
        while (this.running) {
            if (this.traceCPU >= TRC_SUB) {
                this.traceSubroutine();
            }
            switch (this.PC.r) {
                case 827210: 
                case 866810: {
                    this.prevPCs();
                    this.traceCPU = 10;
                }
            }
            this.pPC[this.ppi] = this.PC.r;
            this.ppi = this.ppi + 1 & 0x3FF;
            if (this.interrupt) {
                this.interrupt();
            }
            this.opcode = this.mem.getByte(this.PC.r);
            block3 : switch (this.opcode) {
                case 64: 
                case 65: 
                case 66: 
                case 67: 
                case 68: 
                case 69: 
                case 71: 
                case 72: 
                case 73: 
                case 74: 
                case 75: 
                case 76: 
                case 77: 
                case 79: 
                case 80: 
                case 81: 
                case 82: 
                case 83: 
                case 84: 
                case 85: 
                case 87: 
                case 88: 
                case 89: 
                case 90: 
                case 91: 
                case 92: 
                case 93: 
                case 95: 
                case 96: 
                case 97: 
                case 98: 
                case 99: 
                case 100: 
                case 101: 
                case 103: 
                case 104: 
                case 105: 
                case 106: 
                case 107: 
                case 108: 
                case 109: 
                case 111: 
                case 120: 
                case 121: 
                case 122: 
                case 123: 
                case 124: 
                case 125: 
                case 127: {
                    this.instLD_r8_r8();
                    break;
                }
                case 6: 
                case 14: 
                case 22: 
                case 30: 
                case 38: 
                case 46: 
                case 62: {
                    this.instLD_r8_n8();
                    break;
                }
                case 70: 
                case 78: 
                case 86: 
                case 94: 
                case 102: 
                case 110: 
                case 126: {
                    this.instLD_r8_iHL();
                    break;
                }
                case 112: 
                case 113: 
                case 114: 
                case 115: 
                case 116: 
                case 117: 
                case 119: {
                    this.instLD_iHL_r8();
                    break;
                }
                case 1: 
                case 17: 
                case 33: 
                case 49: {
                    this.instLD_r16_n16();
                    break;
                }
                case 54: {
                    this.instLD_iHL_n8();
                    break;
                }
                case 58: {
                    this.instLD_A_in16();
                    break;
                }
                case 50: {
                    this.instLD_in16_A();
                    break;
                }
                case 26: {
                    this.instLD_A_iDE();
                    break;
                }
                case 34: {
                    this.instLD_in16_HL();
                    break;
                }
                case 42: {
                    this.instLD_HL_in16();
                    break;
                }
                case 18: {
                    this.instLD_iDE_A();
                    break;
                }
                case 2: {
                    this.instLD_iBC_A();
                    break;
                }
                case 211: {
                    this.instOUT_n_A();
                    break;
                }
                case 219: {
                    this.instIN_A_n();
                    break;
                }
                case 0: {
                    this.instNOP();
                    break;
                }
                case 8: {
                    this.instEX_AF_AF();
                    break;
                }
                case 15: {
                    this.instRRCA();
                    break;
                }
                case 7: {
                    this.instRLCA();
                    break;
                }
                case 23: {
                    this.instRLA();
                    break;
                }
                case 31: {
                    this.instRRA();
                    break;
                }
                case 32: {
                    this.instJR_NZ_n8();
                    break;
                }
                case 40: {
                    this.instJR_Z_n8();
                    break;
                }
                case 48: {
                    this.instJR_NC_n8();
                    break;
                }
                case 56: {
                    this.instJR_C_n8();
                    break;
                }
                case 16: {
                    this.instDJNZ();
                    break;
                }
                case 184: 
                case 185: 
                case 186: 
                case 187: 
                case 188: 
                case 189: 
                case 191: {
                    this.instCP_r8();
                    break;
                }
                case 254: {
                    this.instCP_n8();
                    break;
                }
                case 190: {
                    this.instCP_iHL();
                    break;
                }
                case 24: {
                    this.instJR_n8();
                    break;
                }
                case 195: {
                    this.instJP();
                    break;
                }
                case 233: {
                    this.instJP_HL();
                    break;
                }
                case 194: 
                case 202: 
                case 210: 
                case 218: 
                case 226: 
                case 234: 
                case 242: 
                case 250: {
                    this.instJP_cc_n16();
                    break;
                }
                case 196: 
                case 204: 
                case 212: 
                case 220: 
                case 228: 
                case 236: 
                case 244: 
                case 252: {
                    this.instCALL_cc_n16();
                    break;
                }
                case 205: {
                    this.instCALL_n16();
                    break;
                }
                case 201: {
                    this.instRET();
                    break;
                }
                case 192: 
                case 200: 
                case 208: 
                case 216: 
                case 224: 
                case 232: 
                case 248: {
                    this.instRET_cc();
                    break;
                }
                case 199: 
                case 207: 
                case 215: 
                case 223: 
                case 231: 
                case 239: 
                case 247: 
                case 255: {
                    this.instRST_p();
                    break;
                }
                case 217: {
                    this.instEXX();
                    break;
                }
                case 227: {
                    this.instEX_iSP_HL();
                    break;
                }
                case 235: {
                    this.instEX_DE_HL();
                    break;
                }
                case 243: {
                    this.instDI();
                    break;
                }
                case 251: {
                    this.instEI();
                    break;
                }
                case 3: 
                case 19: 
                case 35: 
                case 51: {
                    this.instINC_r16();
                    break;
                }
                case 11: 
                case 27: 
                case 43: 
                case 59: {
                    this.instDEC_r16();
                    break;
                }
                case 128: 
                case 129: 
                case 130: 
                case 131: 
                case 132: 
                case 133: 
                case 135: {
                    this.instADD_r8();
                    break;
                }
                case 198: {
                    this.instADD_n8();
                    break;
                }
                case 136: 
                case 137: 
                case 138: 
                case 139: 
                case 140: 
                case 141: 
                case 143: {
                    this.instADC_r8();
                    break;
                }
                case 206: {
                    this.instADC_n8();
                    break;
                }
                case 142: {
                    this.instADC_iHL();
                    break;
                }
                case 9: 
                case 25: 
                case 41: 
                case 57: {
                    this.instADD_HL_r16();
                    break;
                }
                case 39: {
                    this.instDAA();
                    break;
                }
                case 144: 
                case 145: 
                case 146: 
                case 147: 
                case 148: 
                case 149: 
                case 151: {
                    this.instSUB_r8();
                    break;
                }
                case 214: {
                    this.instSUB_n8();
                    break;
                }
                case 150: {
                    this.instSUB_iHL();
                    break;
                }
                case 152: 
                case 153: 
                case 154: 
                case 155: 
                case 156: 
                case 157: 
                case 159: {
                    this.instSBC_r8();
                    break;
                }
                case 176: 
                case 177: 
                case 178: 
                case 179: 
                case 180: 
                case 181: 
                case 183: {
                    this.instOR_r8();
                    break;
                }
                case 246: {
                    this.instOR_n8();
                    break;
                }
                case 182: {
                    this.instOR_iHL();
                    break;
                }
                case 160: 
                case 161: 
                case 162: 
                case 163: 
                case 164: 
                case 165: 
                case 167: {
                    this.instAND_r8();
                    break;
                }
                case 230: {
                    this.instAND_n8();
                    break;
                }
                case 166: {
                    this.instAND_iHL();
                    break;
                }
                case 168: 
                case 169: 
                case 170: 
                case 171: 
                case 172: 
                case 173: 
                case 175: {
                    this.instXOR_r8();
                    break;
                }
                case 238: {
                    this.instXOR_n8();
                    break;
                }
                case 174: {
                    this.instXOR_iHL();
                    break;
                }
                case 4: 
                case 12: 
                case 20: 
                case 28: 
                case 36: 
                case 44: 
                case 60: {
                    this.instINC_r8();
                    break;
                }
                case 52: {
                    this.instINC_iHL();
                    break;
                }
                case 5: 
                case 13: 
                case 21: 
                case 29: 
                case 37: 
                case 45: 
                case 61: {
                    this.instDEC_r8();
                    break;
                }
                case 53: {
                    this.instDEC_iHL();
                    break;
                }
                case 193: 
                case 209: 
                case 225: 
                case 241: {
                    this.instPOP_r16();
                    break;
                }
                case 197: 
                case 213: 
                case 229: 
                case 245: {
                    this.instPUSH_r16();
                    break;
                }
                case 47: {
                    this.instCPL();
                    break;
                }
                case 55: {
                    this.instSCF();
                    break;
                }
                case 63: {
                    this.instCCF();
                    break;
                }
                case 203: {
                    this.opcode = this.mem.getByte(this.PC.r + 1);
                    switch (this.opcode) {
                        case 0: 
                        case 1: 
                        case 2: 
                        case 3: 
                        case 4: 
                        case 5: 
                        case 7: {
                            this.instRLC_r8();
                            break block3;
                        }
                        case 8: 
                        case 9: 
                        case 10: 
                        case 11: 
                        case 12: 
                        case 13: 
                        case 15: {
                            this.instRRC_r8();
                            break block3;
                        }
                        case 24: 
                        case 25: 
                        case 26: 
                        case 27: 
                        case 28: 
                        case 29: 
                        case 31: {
                            this.instRR_r8();
                            break block3;
                        }
                        case 16: 
                        case 17: 
                        case 18: 
                        case 19: 
                        case 20: 
                        case 21: 
                        case 23: {
                            this.instRL_r8();
                            break block3;
                        }
                        case 40: 
                        case 41: 
                        case 42: 
                        case 43: 
                        case 44: 
                        case 45: 
                        case 47: {
                            this.instSRA_r8();
                            break block3;
                        }
                        case 56: 
                        case 57: 
                        case 58: 
                        case 59: 
                        case 60: 
                        case 61: 
                        case 63: {
                            this.instSRL_r8();
                            break block3;
                        }
                        case 32: 
                        case 33: 
                        case 34: 
                        case 35: 
                        case 36: 
                        case 37: 
                        case 39: {
                            this.instSLA_r8();
                            break block3;
                        }
                        case 64: 
                        case 65: 
                        case 66: 
                        case 67: 
                        case 68: 
                        case 69: 
                        case 71: 
                        case 72: 
                        case 73: 
                        case 74: 
                        case 75: 
                        case 76: 
                        case 77: 
                        case 79: 
                        case 80: 
                        case 81: 
                        case 82: 
                        case 83: 
                        case 84: 
                        case 85: 
                        case 87: 
                        case 88: 
                        case 89: 
                        case 90: 
                        case 91: 
                        case 92: 
                        case 93: 
                        case 95: 
                        case 96: 
                        case 97: 
                        case 98: 
                        case 99: 
                        case 100: 
                        case 101: 
                        case 103: 
                        case 104: 
                        case 105: 
                        case 106: 
                        case 107: 
                        case 108: 
                        case 109: 
                        case 111: 
                        case 112: 
                        case 113: 
                        case 114: 
                        case 115: 
                        case 116: 
                        case 117: 
                        case 119: 
                        case 120: 
                        case 121: 
                        case 122: 
                        case 123: 
                        case 124: 
                        case 125: 
                        case 127: {
                            this.instBIT_b_r8();
                            break block3;
                        }
                        case 70: 
                        case 78: 
                        case 86: 
                        case 94: 
                        case 102: 
                        case 110: 
                        case 118: 
                        case 126: {
                            this.instBIT_b_iHL();
                            break block3;
                        }
                        case 192: 
                        case 193: 
                        case 194: 
                        case 195: 
                        case 196: 
                        case 197: 
                        case 199: 
                        case 200: 
                        case 201: 
                        case 202: 
                        case 203: 
                        case 204: 
                        case 205: 
                        case 207: 
                        case 208: 
                        case 209: 
                        case 210: 
                        case 211: 
                        case 212: 
                        case 213: 
                        case 215: 
                        case 216: 
                        case 217: 
                        case 218: 
                        case 219: 
                        case 220: 
                        case 221: 
                        case 223: 
                        case 224: 
                        case 225: 
                        case 226: 
                        case 227: 
                        case 228: 
                        case 229: 
                        case 231: 
                        case 232: 
                        case 233: 
                        case 234: 
                        case 235: 
                        case 236: 
                        case 237: 
                        case 239: 
                        case 240: 
                        case 241: 
                        case 242: 
                        case 243: 
                        case 244: 
                        case 245: 
                        case 247: 
                        case 248: 
                        case 249: 
                        case 250: 
                        case 251: 
                        case 252: 
                        case 253: 
                        case 255: {
                            this.instSET_b_r8();
                            break block3;
                        }
                        case 198: 
                        case 206: 
                        case 214: 
                        case 222: 
                        case 230: 
                        case 238: 
                        case 246: 
                        case 254: {
                            this.instSET_b_iHL();
                            break block3;
                        }
                        case 128: 
                        case 129: 
                        case 130: 
                        case 131: 
                        case 132: 
                        case 133: 
                        case 135: 
                        case 136: 
                        case 137: 
                        case 138: 
                        case 139: 
                        case 140: 
                        case 141: 
                        case 143: 
                        case 144: 
                        case 145: 
                        case 146: 
                        case 147: 
                        case 148: 
                        case 149: 
                        case 151: 
                        case 152: 
                        case 153: 
                        case 154: 
                        case 155: 
                        case 156: 
                        case 157: 
                        case 159: 
                        case 160: 
                        case 161: 
                        case 162: 
                        case 163: 
                        case 164: 
                        case 165: 
                        case 167: 
                        case 168: 
                        case 169: 
                        case 170: 
                        case 171: 
                        case 172: 
                        case 173: 
                        case 175: 
                        case 176: 
                        case 177: 
                        case 178: 
                        case 179: 
                        case 180: 
                        case 181: 
                        case 183: 
                        case 184: 
                        case 185: 
                        case 186: 
                        case 187: 
                        case 188: 
                        case 189: 
                        case 191: {
                            this.instRES_b_r8();
                            break block3;
                        }
                        case 134: 
                        case 142: 
                        case 150: 
                        case 158: 
                        case 166: 
                        case 174: 
                        case 182: 
                        case 190: {
                            this.instRES_b_iHL();
                            break block3;
                        }
                    }
                    this.traceCPU = 10;
                    this.traceCPU(2, "Unknown instruction!!!");
                    this.prevPCs();
                    this.running = false;
                    break;
                }
                case 237: {
                    this.opcode = this.mem.getByte(this.PC.r + 1);
                    switch (this.opcode) {
                        case 86: {
                            this.instIM_1();
                            break block3;
                        }
                        case 161: {
                            this.instCPI();
                            break block3;
                        }
                        case 176: {
                            this.instLDIR();
                            break block3;
                        }
                        case 68: {
                            this.instNEG();
                            break block3;
                        }
                        case 65: 
                        case 73: 
                        case 81: 
                        case 89: 
                        case 97: 
                        case 105: 
                        case 121: {
                            this.instOUT_C_r8();
                            break block3;
                        }
                        case 67: 
                        case 83: 
                        case 99: 
                        case 115: {
                            this.instLD_in16_r16();
                            break block3;
                        }
                        case 66: 
                        case 82: 
                        case 98: 
                        case 114: {
                            this.instSBC_HL_r16();
                            break block3;
                        }
                        case 75: 
                        case 91: 
                        case 107: 
                        case 123: {
                            this.instLD_r16_in16();
                            break block3;
                        }
                        case 160: {
                            this.instLDI();
                            break block3;
                        }
                        case 74: 
                        case 90: 
                        case 106: 
                        case 122: {
                            this.instADC_HL_r16();
                            break block3;
                        }
                        case 77: {
                            this.instRETI();
                            break block3;
                        }
                        case 111: {
                            this.instRLD();
                            break block3;
                        }
                        case 103: {
                            this.instRRD();
                            break block3;
                        }
                    }
                    this.traceCPU = 10;
                    this.traceCPU(2, "Unknown instruction!!!");
                    this.prevPCs();
                    this.running = false;
                    break;
                }
                case 221: 
                case 253: {
                    this.r16IND[2] = this.opcode == 221 ? (this.IND = this.IX) : (this.IND = this.IY);
                    this.opcode = this.mem.getByte(this.PC.r + 1);
                    switch (this.opcode) {
                        case 33: {
                            this.instLD_IND_n16();
                            break block3;
                        }
                        case 34: {
                            this.instLD_in16_IND();
                            break block3;
                        }
                        case 225: {
                            this.instPOP_IND();
                            break block3;
                        }
                        case 227: {
                            this.instEX_iSP_IND();
                            break block3;
                        }
                        case 229: {
                            this.instPUSH_IND();
                            break block3;
                        }
                        case 233: {
                            this.instJP_IND();
                            break block3;
                        }
                        case 9: 
                        case 25: 
                        case 41: 
                        case 57: {
                            this.instADD_IND_r16();
                            break block3;
                        }
                        case 42: {
                            this.instLD_IND_in16();
                            break block3;
                        }
                        case 53: {
                            this.instDEC_iINDd();
                            break block3;
                        }
                        case 54: {
                            this.instLD_iINDd_n8();
                            break block3;
                        }
                        case 35: {
                            this.instINC_IND();
                            break block3;
                        }
                        case 43: {
                            this.instDEC_IND();
                            break block3;
                        }
                        case 174: {
                            this.instXOR_iINDd();
                            break block3;
                        }
                        case 70: 
                        case 78: 
                        case 86: 
                        case 94: 
                        case 102: 
                        case 110: 
                        case 126: {
                            this.instLD_r8_iINDd();
                            break block3;
                        }
                        case 112: 
                        case 113: 
                        case 114: 
                        case 115: 
                        case 116: 
                        case 117: 
                        case 119: {
                            this.instLD_iINDd_r8();
                            break block3;
                        }
                        case 203: {
                            this.opcode = this.mem.getByte(this.PC.r + 3);
                            switch (this.opcode) {
                                case 70: 
                                case 78: 
                                case 86: 
                                case 94: 
                                case 102: 
                                case 110: 
                                case 118: 
                                case 126: {
                                    this.instBIT_b_iINDd();
                                    break block3;
                                }
                                case 134: 
                                case 142: 
                                case 150: 
                                case 158: 
                                case 166: 
                                case 174: 
                                case 182: 
                                case 190: {
                                    this.instRES_b_iINDd();
                                    break block3;
                                }
                            }
                            this.traceCPU = 1;
                            this.traceCPU(4, "Unknown instruction!!!");
                            this.prevPCs();
                            this.running = false;
                            break block3;
                        }
                    }
                    this.traceCPU = 1;
                    this.traceCPU(2, "Unknown instruction!!!");
                    this.prevPCs();
                    this.running = false;
                    break;
                }
                default: {
                    this.traceCPU = 10;
                    this.traceCPU(1, "Unknown instruction!!!");
                    this.prevPCs();
                    this.running = false;
                }
            }
            ++this.instCount;
        }
        m1 = System.currentTimeMillis() - m1;
        this.log.write("Elapsed time: " + Long.toString(m1));
        this.log.write("Executed instuctions: " + Long.toString(this.instCount));
        this.log.write("T Cycles:" + Long.toString(this.t));
        double d1 = this.t;
        double d2 = (double)m1 / 1000.0;
        this.log.write("Frequency: " + Double.toString(d1 / d2 / 1000000.0));
        this.log.write("NOF Screen repaint: " + Integer.toString(this.tvc.surface.scr.nofRepaint));
    }

    public boolean initZ80() {
        int[] nArray = new int[7];
        nArray[1] = 1;
        nArray[2] = 2;
        nArray[3] = 3;
        nArray[4] = 4;
        nArray[5] = 5;
        nArray[6] = 7;
        int[] tt = nArray;
        this.instCount = 0L;
        this.t = 0L;
        this.traceCPU = 3;
        String s = "";
        int k = 0;
        while (k < 8) {
            s = String.valueOf(s) + "case 0x" + this.toHexString(0x86 | k << 3, 2) + ": ";
            ++k;
        }
        System.out.println(s);
        this.log.write(s);
        return true;
    }

    public final void setFlagS(boolean x) {
        this.F.r = x ? (this.F.r |= SET_S) : (this.F.r &= ~SET_S);
    }

    public final void setFlagZ(boolean x) {
        this.F.r = x ? (this.F.r |= SET_Z) : (this.F.r &= ~SET_Z);
    }

    public final void setFlagH(boolean x) {
        this.F.r = x ? (this.F.r |= SET_H) : (this.F.r &= ~SET_H);
    }

    public final void setFlagPV(boolean x) {
        this.F.r = x ? (this.F.r |= SET_PV) : (this.F.r &= ~SET_PV);
    }

    public final void setFlagN(boolean x) {
        this.F.r = x ? (this.F.r |= SET_N) : (this.F.r &= ~SET_N);
    }

    public final void setFlagC(boolean x) {
        this.F.r = x ? (this.F.r |= SET_C) : (this.F.r &= ~SET_C);
    }

    public final void setFlag3(boolean x) {
        this.F.r = x ? (this.F.r |= SET_3) : (this.F.r &= ~SET_3);
    }

    public final void setFlag5(boolean x) {
        this.F.r = x ? (this.F.r |= SET_5) : (this.F.r &= ~SET_5);
    }

    public final boolean getFlagS() {
        return (this.F.r & SET_S) != 0;
    }

    public final boolean getFlagZ() {
        return (this.F.r & SET_Z) != 0;
    }

    public final boolean getFlagH() {
        return (this.F.r & SET_H) != 0;
    }

    public final boolean getFlagPV() {
        return (this.F.r & SET_PV) != 0;
    }

    public final boolean getFlagN() {
        return (this.F.r & SET_N) != 0;
    }

    public final boolean getFlagC() {
        return (this.F.r & SET_C) != 0;
    }

    public final boolean getFlag3() {
        return (this.F.r & SET_3) != 0;
    }

    public final boolean getFlag5() {
        return (this.F.r & SET_5) != 0;
    }

    public boolean getccValue(int pIndex) {
        switch (pIndex) {
            case 0: {
                return !this.getFlagZ();
            }
            case 1: {
                return this.getFlagZ();
            }
            case 2: {
                return !this.getFlagC();
            }
            case 3: {
                return this.getFlagC();
            }
            case 4: {
                return !this.getFlagPV();
            }
            case 5: {
                return this.getFlagPV();
            }
            case 6: {
                return !this.getFlagS();
            }
            case 7: {
                return this.getFlagS();
            }
        }
        return false;
    }

    public final String getccName(int p) {
        return flagNames[p];
    }

    public void instNOP() {
        this.traceCPU(1, "NOP");
        this.prevPCs();
        this.mem.dump(this.SP.r, 32);
        ++this.PC.r;
        this.t += 4L;
    }

    public final void interrupt() {
        this.interrupt = false;
        if (!this.IFF1) {
            return;
        }
        switch (this.IM.r) {
            case 0: 
            case 1: {
                this.SP.r = this.SP.r - 2 & 0xFFFF;
                this.mem.setWord(this.SP.r, this.PC.r);
                this.IFF1 = false;
                this.IFF2 = false;
                this.PC.r = 56;
                return;
            }
            case 2: {
                this.SP.r = this.SP.r - 2 & 0xFFFF;
                this.mem.setWord(this.SP.r, this.PC.r);
                this.IFF1 = false;
                this.IFF2 = false;
                int t = this.I.r << 8 | 0xFF;
                this.PC.r = this.mem.getWord(t);
                return;
            }
        }
    }

    public void instJP() {
        int addr = this.mem.getWord(this.PC.r + 1);
        if (this.traceCPU >= TRC_J) {
            this.traceCPU(3, "JP    " + this.toHexString(addr, 4));
        }
        this.PC.r = addr;
        this.t += 10L;
    }

    public void instJP_HL() {
        if (this.traceCPU >= TRC_J) {
            this.traceCPU(3, "JP    HL");
        }
        this.PC.r = this.HL.get();
        this.t += 4L;
    }

    public void instJP_IND() {
        if (this.traceCPU >= TRC_J) {
            this.traceCPU(3, "JP    (" + this.IND.name + ")");
        }
        this.PC.r = this.IY.r;
        this.t += 8L;
    }

    public final void instJR_n8() {
        int n = this.mem.getByte(this.PC.r + 1);
        if (this.traceCPU >= TRC_J) {
            this.traceCPU(2, "JR    " + this.toHexString(this.PC.r + 2 + (byte)n, 4));
        }
        this.PC.r += 2;
        this.PC.r += (byte)n;
        this.t += 12L;
    }

    public final void instCALL_n16() {
        this.addr = this.mem.getWord(this.PC.r + 1);
        int newSP = this.SP.r - 2 & 0xFFFF;
        this.mem.setWord(newSP, this.PC.r + 3 & 0xFFFF);
        if (this.traceCPU >= TRC_CRR) {
            this.traceCPU(3, "CALL  " + this.toHexString(this.addr, 4) + "  ; (SP) <= " + this.toHexString(this.PC.r + 3 & 0xFFFF, 4));
            this.mem.dump(newSP, 8);
        }
        this.PC.r = this.addr;
        this.SP.r = newSP;
        this.t += 17L;
    }

    public final void instCALL_cc_n16() {
        int cc = (this.opcode & 0x38) >> 3;
        this.addr = this.mem.getWord(this.PC.r + 1);
        if (this.traceCPU >= TRC_CRR) {
            this.traceCPU(3, "CALL  " + this.getccName(cc) + (this.getccValue(cc) ? "(1)" : "(0)") + "," + this.toHexString(this.addr, 4) + "  ; (SP) <= " + this.toHexString(this.PC.r + 3 & 0xFFFF, 4));
        }
        this.PC.r = this.PC.r + 3 & 0xFFFF;
        this.t += 10L;
        if (this.getccValue(cc)) {
            this.SP.r = this.SP.r - 2 & 0xFFFF;
            this.mem.setWord(this.SP.r, this.PC.r);
            this.PC.r = this.addr;
            this.t += 7L;
        }
    }

    public final void instRST_p() {
        int p = this.opcode & 0x38;
        if (this.traceCPU >= TRC_CRR) {
            this.traceCPU(1, "RST   " + this.toHexString(p, 2));
        }
        this.SP.r = this.SP.r - 2 & 0xFFFF;
        this.mem.setWord(this.SP.r, this.PC.r + 1 & 0xFFFF);
        this.PC.r = p;
        this.t += 11L;
    }

    public final void instRET() {
        this.addr = this.mem.getWord(this.SP.r);
        if (this.traceCPU >= TRC_CRR) {
            this.traceCPU(1, "RET     ; PC <= " + this.toHexString(this.addr, 4));
            this.mem.dump(this.SP.r, 8);
        }
        this.SP.r = this.SP.r + 2 & 0xFFFF;
        this.PC.r = this.addr;
        this.t += 10L;
    }

    public final void instRETI() {
        this.addr = this.mem.getWord(this.SP.r);
        if (this.traceCPU >= TRC_CRR) {
            this.traceCPU(1, "RETI    ; PC <= " + this.toHexString(this.addr, 4));
            this.mem.dump(this.SP.r, 8);
        }
        this.SP.r = this.SP.r + 2 & 0xFFFF;
        this.PC.r = this.addr;
        this.t += 14L;
    }

    public final void instRET_cc() {
        int cc = (this.opcode & 0x38) >> 3;
        int newSP = this.SP.r + 2 & 0xFFFF;
        this.addr = this.mem.getWord(this.SP.r);
        if (this.traceCPU >= TRC_CRR) {
            this.traceCPU(1, "RET   " + this.getccName(cc) + (this.getccValue(cc) ? "(1)" : "(0)") + "  ; PC <= " + this.toHexString(this.addr, 4));
            this.mem.dump(this.SP.r, 8);
        }
        if (this.getccValue(cc)) {
            this.SP.r = newSP;
            this.PC.r = this.addr;
            this.t += 11L;
        } else {
            this.PC.r = this.PC.r + 1 & 0xFFFF;
            this.t += 5L;
        }
    }

    public void instDI() {
        if (this.traceCPU >= TRC_GP) {
            this.traceCPU(1, "DI");
        }
        this.IFF2 = false;
        this.IFF1 = false;
        ++this.PC.r;
    }

    public void instEI() {
        if (this.traceCPU >= TRC_GP) {
            this.traceCPU(1, "EI");
        }
        this.IFF2 = true;
        this.IFF1 = true;
        ++this.PC.r;
    }

    public void instLD_r8_r8() {
        this.r1 = this.r8[(this.opcode & 0x38) >> 3];
        this.r2 = this.r8[this.opcode & 7];
        if (this.traceCPU >= TRC_ALL) {
            this.traceCPU(1, "LD    " + this.r1.name + "," + this.r2.name);
        }
        this.r1.r = this.r2.r;
        ++this.PC.r;
        this.t += 4L;
    }

    public void instLD_r8_n8() {
        int n8 = this.mem.getByte(this.PC.r + 1);
        this.r1 = this.r8[(this.opcode & 0x38) >> 3];
        if (this.traceCPU >= TRC_ALL) {
            this.traceCPU(2, "LD    " + this.r1.name + "," + this.byte2HexnDecString(n8));
        }
        this.r1.r = n8;
        this.PC.r += 2;
        this.t += 7L;
    }

    public void instLD_r8_iHL() {
        int n8 = this.mem.getByte(this.HL.get());
        this.r1 = this.r8[(this.opcode & 0x38) >> 3];
        if (this.traceCPU >= TRC_ALL) {
            this.traceCPU(1, "LD    " + this.r1.name + ",(HL)" + "  ; (HL)=" + this.word2HexnDecString(n8));
        }
        this.r1.r = n8;
        ++this.PC.r;
        this.t += 7L;
    }

    public void instLD_iHL_r8() {
        this.r1 = this.r8[this.opcode & 7];
        if (this.traceCPU >= TRC_ALL) {
            this.traceCPU(1, "LD    (HL)," + this.r1.name);
        }
        this.mem.setByte(this.HL.get(), this.r1.r);
        ++this.PC.r;
        this.t += 7L;
    }

    public void instLD_in16_HL() {
        this.addr = this.mem.getWord(this.PC.r + 1);
        if (this.traceCPU >= TRC_ALL) {
            this.traceCPU(3, "LD    (" + this.toHexString(this.addr, 4) + "),HL");
        }
        this.mem.setWord(this.addr, this.HL.get());
        this.PC.r += 3;
        this.t += 16L;
    }

    public void instLD_in16_IND() {
        this.addr = this.mem.getWord(this.PC.r + 2);
        if (this.traceCPU >= TRC_ALL) {
            this.traceCPU(3, "LD    (" + this.toHexString(this.addr, 4) + ")," + this.IND.name);
        }
        this.mem.setWord(this.addr, this.IND.r);
        this.PC.r += 4;
        this.t += 20L;
    }

    public void instLD_HL_in16() {
        this.addr = this.mem.getWord(this.PC.r + 1);
        if (this.traceCPU >= TRC_ALL) {
            this.traceCPU(3, "LD    HL,(" + this.toHexString(this.addr, 4) + ")");
        }
        this.HL.set(this.mem.getWord(this.addr));
        this.PC.r += 3;
        this.t += 16L;
    }

    public void instLD_IND_in16() {
        this.addr = this.mem.getWord(this.PC.r + 2);
        if (this.traceCPU >= TRC_ALL) {
            this.traceCPU(4, "LD    " + this.IND.name + ",(" + this.toHexString(this.addr, 4) + ")");
        }
        this.IND.set(this.mem.getWord(this.addr));
        this.PC.r += 4;
        this.t += 20L;
    }

    public void instLD_in16_r16() {
        this.R1 = this.r16[(this.opcode & 0x30) >> 4];
        this.addr = this.mem.getWord(this.PC.r + 2);
        if (this.traceCPU >= TRC_ALL) {
            this.traceCPU(4, "LD    (" + this.toHexString(this.addr, 4) + ")," + this.R1.name);
        }
        this.mem.setWord(this.addr, this.R1.get());
        this.PC.r += 4;
        this.t += 20L;
    }

    public void instLD_r16_in16() {
        this.R1 = this.r16[(this.opcode & 0x30) >> 4];
        this.addr = this.mem.getWord(this.PC.r + 2);
        if (this.traceCPU >= TRC_ALL) {
            this.traceCPU(4, "LD    " + this.R1.name + ",(" + this.toHexString(this.addr, 4) + ")");
        }
        this.R1.set(this.mem.getWord(this.addr));
        this.PC.r += 4;
        this.t += 20L;
    }

    public void instLD_iHL_n8() {
        int n8 = this.mem.getByte(this.PC.r + 1);
        if (this.traceCPU >= TRC_ALL) {
            this.traceCPU(2, "LD    (HL)," + this.toHexString(n8, 2) + "   ; (HL)=" + this.word2HexnDecString(this.HL.get()));
        }
        this.mem.setByte(this.HL.get(), n8);
        this.PC.r += 2;
        this.t += 10L;
    }

    public final void instLD_r8_iINDd() {
        int d = this.mem.getByte(this.PC.r + 2);
        int n8 = this.mem.getByte(this.IND.r + (byte)d & 0xFFFF);
        this.r1 = this.r8[(this.opcode & 0x38) >> 3];
        if (this.traceCPU >= TRC_ALL) {
            this.traceCPU(3, "LD    " + this.r1.name + ",(IY+d)");
        }
        this.r1.r = n8;
        this.PC.r = this.PC.r + 3 & 0xFFFF;
        this.t += 19L;
    }

    public final void instLD_iINDd_r8() {
        int d = this.mem.getByte(this.PC.r + 2);
        this.r1 = this.r8[this.opcode & 7];
        if (this.traceCPU >= TRC_ALL) {
            this.traceCPU(3, "LD    (" + this.IND.name + "+d)," + this.r1.r);
        }
        this.mem.setByte(this.IND.r + (byte)d & 0xFFFF, this.r1.r);
        this.PC.r = this.PC.r + 3 & 0xFFFF;
        this.t += 19L;
    }

    public final void instLD_iINDd_n8() {
        int d = this.mem.getByte(this.PC.r + 2);
        int n8 = this.mem.getByte(this.PC.r + 3);
        if (this.traceCPU >= TRC_ALL) {
            this.traceCPU(4, "LD    (" + this.IND.name + "+d)," + this.byte2HexnDecString(n8));
        }
        this.mem.setByte(this.IND.r + (byte)d & 0xFFFF, n8);
        this.addPC_T(4, 19);
    }

    public void instLD_IND_n16() {
        this.IND.r = this.mem.getWord(this.PC.r + 2);
        if (this.traceCPU >= TRC_ALL) {
            this.traceCPU(4, "LD    " + this.IND.name + "," + this.word2HexnDecString(this.IND.r));
        }
        this.PC.r += 4;
        this.t += 14L;
    }

    public void instLD_iDE_A() {
        if (this.traceCPU >= TRC_ALL) {
            this.traceCPU(1, "LD    (DE)," + this.A.name);
        }
        this.mem.setByte(this.DE.get(), this.A.r);
        ++this.PC.r;
        this.t += 7L;
    }

    public void instLD_iBC_A() {
        if (this.traceCPU >= TRC_ALL) {
            this.traceCPU(1, "LD    (BC)," + this.A.name);
        }
        this.mem.setByte(this.BC.get(), this.A.r);
        ++this.PC.r;
        this.t += 7L;
    }

    public void instLD_A_in16() {
        int addr = this.mem.getWord(this.PC.r + 1);
        int v = this.mem.getByte(addr);
        if (this.traceCPU >= TRC_ALL) {
            this.traceCPU(3, "LD    A,(" + this.toHexString(addr, 4) + ")    ; (" + this.toHexString(addr, 4) + ")=" + this.byte2HexnDecString(v));
        }
        this.A.r = v;
        this.PC.r += 3;
        this.t += 13L;
    }

    public void instLD_in16_A() {
        int addr = this.mem.getWord(this.PC.r + 1);
        if (this.traceCPU >= TRC_ALL) {
            this.traceCPU(3, "LD    (" + this.toHexString(addr, 4) + "),A");
        }
        this.mem.setByte(addr, this.A.r);
        this.PC.r += 3;
        this.t += 13L;
    }

    public void instIM_1() {
        if (this.traceCPU >= TRC_GP) {
            this.traceCPU(1, "IM    1");
        }
        this.PC.r += 2;
    }

    public void instEX_AF_AF() {
        if (this.traceCPU >= TRC_ALL) {
            this.traceCPU(1, "EX    AF,AF'");
        }
        int temp = this.AF.get();
        this.AF.set(this.AF1);
        this.AF1 = temp;
        ++this.PC.r;
        this.t += 4L;
    }

    public void instEXX() {
        if (this.traceCPU >= TRC_ALL) {
            this.traceCPU(1, "EXX");
        }
        int temp = this.BC.get();
        this.BC.set(this.BC1);
        this.BC1 = temp;
        temp = this.DE.get();
        this.DE.set(this.DE1);
        this.DE1 = temp;
        temp = this.HL.get();
        this.HL.set(this.HL1);
        this.HL1 = temp;
        ++this.PC.r;
        this.t += 4L;
    }

    public void instEX_iSP_HL() {
        if (this.traceCPU >= TRC_ALL) {
            this.traceCPU(1, "EX    (SP),HL");
        }
        int temp = this.mem.getWord(this.SP.r);
        this.mem.setWord(this.SP.r, this.HL.get());
        this.HL.set(temp);
        ++this.PC.r;
        this.t += 19L;
    }

    public void instEX_iSP_IND() {
        if (this.traceCPU >= TRC_ALL) {
            this.traceCPU(1, "EX    (SP)," + this.IND.name);
        }
        int temp = this.mem.getWord(this.SP.r);
        this.mem.setWord(this.SP.r, this.IND.r);
        this.IND.r = temp;
        this.addPC_T(2, 23);
    }

    public void instEX_DE_HL() {
        if (this.traceCPU >= TRC_ALL) {
            this.traceCPU(1, "EX    DE,HL");
        }
        int t = this.D.r;
        this.D.r = this.H.r;
        this.H.r = t;
        t = this.E.r;
        this.E.r = this.L.r;
        this.L.r = t;
        ++this.PC.r;
        t += 4;
    }

    public void instOUT_n_A() {
        int n = this.mem.getByte(this.PC.r + 1);
        if (this.traceCPU >= TRC_ALL) {
            this.traceCPU(2, "OUT   (" + this.toHexString(n, 2) + "),A");
        }
        this.port.setPort(n, this.A.r);
        this.PC.r += 2;
        this.t += 11L;
    }

    public void instOUT_C_r8() {
        this.r1 = this.r8[(this.mem.getByte(this.PC.r + 1) & 0x38) >> 3];
        if (this.traceCPU >= TRC_ALL) {
            this.traceCPU(2, "OUT   (C)," + this.r1.name);
        }
        this.port.setPort(this.C.r, this.r1.r);
        this.PC.r += 2;
        this.t += 12L;
    }

    public void instIN_A_n() {
        int n = this.mem.getByte(this.PC.r + 1);
        if (this.traceCPU >= TRC_ALL) {
            this.traceCPU(2, "IN    A,(" + this.toHexString(n, 2) + ")");
        }
        this.A.r = this.port.getPort(n);
        this.PC.r += 2;
        this.t += 11L;
    }

    public void instLD_r16_n16() {
        this.n16 = this.mem.getWord(this.PC.r + 1);
        this.R1 = this.r16[(this.opcode & 0x30) >> 4];
        if (this.traceCPU >= TRC_ALL) {
            this.traceCPU(3, "LD    " + this.R1.name + "," + this.word2HexnDecString(this.n16));
        }
        this.R1.set(this.n16);
        this.PC.r += 3;
        this.t += 10L;
    }

    public void instINC_r16() {
        this.R1 = this.r16[(this.opcode & 0x30) >> 4];
        if (this.traceCPU >= TRC_ALL) {
            this.traceCPU(1, "INC   " + this.R1.name);
        }
        this.R1.set(this.R1.get() + 1 & 0xFFFF);
        ++this.PC.r;
        this.t += 6L;
    }

    public void instINC_IND() {
        if (this.traceCPU >= TRC_ALL) {
            this.traceCPU(1, "INC   " + this.IND.name);
        }
        this.IND.r = this.IND.r + 1 & 0xFFFF;
        this.PC.r += 2;
        this.t += 10L;
    }

    public void instDEC_r16() {
        this.R1 = this.r16[(this.opcode & 0x30) >> 4];
        if (this.traceCPU >= TRC_ALL) {
            this.traceCPU(1, "DEC   " + this.R1.name);
        }
        this.R1.set(this.R1.get() - 1 & 0xFFFF);
        ++this.PC.r;
        this.t += 6L;
    }

    public void instDEC_IND() {
        if (this.traceCPU >= TRC_ALL) {
            this.traceCPU(1, "DEC   " + this.IND.name);
        }
        this.IND.r = this.IND.r - 1 & 0xFFFF;
        this.PC.r += 2;
        this.t += 10L;
    }

    public void instOR_r8() {
        this.r1 = this.r8[this.opcode & 7];
        if (this.traceCPU >= TRC_ALL) {
            this.traceCPU(1, "OR    " + this.r1.name);
        }
        this.or_a(this.r1.r);
        ++this.PC.r;
        this.t += 4L;
    }

    public void instOR_n8() {
        int n8 = this.mem.getByte(this.PC.r + 1);
        if (this.traceCPU >= TRC_ALL) {
            this.traceCPU(1, "OR    " + this.byte2HexnDecString(n8));
        }
        this.or_a(n8);
        this.PC.r += 2;
        this.t += 7L;
    }

    public void instOR_iHL() {
        int n8 = this.mem.getByte(this.HL.get());
        if (this.traceCPU >= TRC_ALL) {
            this.traceCPU(1, "OR    (HL)  ; (HL)=" + this.byte2HexnDecString(n8));
        }
        this.or_a(n8);
        ++this.PC.r;
        this.t += 7L;
    }

    private final void or_a(int b) {
        this.A.r |= b;
        this.F.r = PSZTable[this.A.r];
    }

    public void instAND_r8() {
        this.r1 = this.r8[this.opcode & 7];
        if (this.traceCPU >= TRC_ALL) {
            this.traceCPU(1, "AND   " + this.r1.name);
        }
        this.and_a(this.r1.r);
        ++this.PC.r;
        this.t += 4L;
    }

    public void instAND_n8() {
        int n8 = this.mem.getByte(this.PC.r + 1);
        if (this.traceCPU >= TRC_ALL) {
            this.traceCPU(2, "AND   " + this.byte2HexnDecString(n8));
        }
        this.and_a(n8);
        this.PC.r += 2;
        this.t += 7L;
    }

    public void instAND_iHL() {
        int n8 = this.mem.getByte(this.HL.get());
        if (this.traceCPU >= TRC_ALL) {
            this.traceCPU(2, "AND   (HL) ; (HL)=" + this.byte2HexnDecString(n8));
        }
        this.and_a(n8);
        this.addPC_T(1, 7);
    }

    private final void and_a(int n) {
        this.A.r &= n;
        this.F.r = PSZTable[this.A.r] | SET_H;
    }

    public void instXOR_r8() {
        this.r1 = this.r8[this.opcode & 7];
        if (this.traceCPU >= TRC_ALL) {
            this.traceCPU(1, "XOR   " + this.r1.name);
        }
        this.xor_a(this.r1.r);
        ++this.PC.r;
        this.t += 4L;
    }

    public void instXOR_iHL() {
        int n8 = this.mem.getByte(this.HL.get());
        if (this.traceCPU >= TRC_ALL) {
            this.traceCPU(1, "XOR   (HL)  ; (HL)=" + this.byte2HexnDecString(n8));
        }
        this.xor_a(n8);
        ++this.PC.r;
        this.t += 7L;
    }

    public void instXOR_n8() {
        int n8 = this.mem.getByte(this.PC.r + 1);
        if (this.traceCPU >= TRC_ALL) {
            this.traceCPU(2, "XOR   " + this.byte2HexnDecString(n8));
        }
        this.xor_a(n8);
        ++this.PC.r;
        this.t += 7L;
    }

    public final void instXOR_iINDd() {
        int d = this.mem.getByte(this.PC.r + 2);
        int addr = this.IND.r + (byte)d & 0xFFFF;
        int n8 = this.mem.getByte(addr);
        if (this.traceCPU >= TRC_ALL) {
            this.traceCPU(1, "XOR   (" + this.IND.name + "+" + this.byte2HexnDecString(n8) + ")");
        }
        this.xor_a(n8);
        this.addPC_T(3, 19);
    }

    private final void xor_a(int n) {
        this.A.r = (this.A.r ^ n) & 0xFF;
        this.F.r = PSZTable[this.A.r];
    }

    public void instINC_r8() {
        this.r1 = this.r8[(this.opcode & 0x38) >> 3];
        if (this.traceCPU >= TRC_ALL) {
            this.traceCPU(1, "INC   " + this.r1.name);
        }
        this.r1.r = this.inc8(this.r1.r);
        ++this.PC.r;
        this.t += 4L;
    }

    public void instINC_iHL() {
        int addr = this.HL.get();
        if (this.traceCPU >= TRC_ALL) {
            this.traceCPU(1, "INC   (HL)");
        }
        int nv = this.mem.getByte(addr);
        nv = this.inc8(nv);
        this.mem.setByte(addr, nv);
        ++this.PC.r;
        this.t += 4L;
    }

    private final int inc8(int ans) {
        boolean pv = ans == 127;
        boolean h = ((ans & 0xF) + 1 & SET_H) != 0;
        ans = ans + 1 & 0xFF;
        this.setFlagS((ans & SET_S) != 0);
        this.setFlagZ(ans == 0);
        this.setFlagPV(pv);
        this.setFlagH(h);
        this.setFlagN(false);
        return ans;
    }

    public void instDEC_r8() {
        this.r1 = this.r8[(this.opcode & 0x38) >> 3];
        if (this.traceCPU >= TRC_ALL) {
            this.traceCPU(1, "DEC   " + this.r1.name);
        }
        this.r1.r = this.dec8(this.r1.r);
        ++this.PC.r;
        this.t += 4L;
    }

    public final void instDEC_iHL() {
        this.addr = this.HL.get();
        if (this.traceCPU >= TRC_ALL) {
            this.traceCPU(1, "DEC   (HL)");
        }
        this.mem.setByte(this.addr, this.dec8(this.mem.getByte(this.addr)));
        this.addPC_T(1, 11);
    }

    public final void instDEC_iINDd() {
        int d = this.mem.getByte(this.PC.r + 2);
        int addr = this.IND.r + (byte)d & 0xFFFF;
        int n8 = this.mem.getByte(addr);
        if (this.traceCPU >= TRC_ALL) {
            this.traceCPU(1, "DEC   (" + this.IND.name + "+" + this.byte2HexnDecString(n8) + ")");
        }
        this.mem.setByte(addr, this.dec8(n8));
        this.addPC_T(3, 23);
    }

    private final int dec8(int ans) {
        boolean pv = ans == 128;
        boolean h = ((ans & 0xF) - 1 & SET_H) != 0;
        ans = ans - 1 & 0xFF;
        this.setFlagS((ans & SET_S) != 0);
        this.setFlagZ(ans == 0);
        this.setFlagPV(pv);
        this.setFlagH(h);
        this.setFlagN(true);
        return ans;
    }

    public void instLD_A_iDE() {
        int n8 = this.mem.getByte(this.DE.get());
        if (this.traceCPU >= TRC_ALL) {
            this.traceCPU(1, "LD    A,(DE)  ; (DE)=" + this.byte2HexnDecString(n8));
        }
        this.A.r = n8;
        ++this.PC.r;
        this.t += 7L;
    }

    public void instCPI() {
        int n8 = this.mem.getByte(this.HL.get());
        boolean c = this.getFlagC();
        if (this.traceCPU >= TRC_ALL) {
            this.traceCPU(2, "CPI     ; (HL)=" + this.byte2HexnDecString(n8));
        }
        this.cp_a(n8);
        this.HL.set(this.HL.get() + 1);
        this.BC.set(this.BC.get() - 1);
        this.setFlagPV(this.BC.get() != 0);
        this.setFlagC(c);
        this.PC.r += 2;
        this.t += 16L;
    }

    public void instLDIR() {
        if (this.traceCPU >= TRC_ALL) {
            this.traceCPU(2, "LDIR");
        }
        do {
            this.mem.setByte(this.DE.get(), this.mem.getByte(this.HL.get()));
            this.DE.set(this.DE.get() + 1 & 0xFFFF);
            this.HL.set(this.HL.get() + 1 & 0xFFFF);
            this.BC.set(this.BC.get() - 1);
            this.t += 21L;
        } while (this.BC.get() != 0);
        this.setFlagH(false);
        this.setFlagPV(false);
        this.setFlagN(false);
        this.PC.r += 2;
        this.t += 16L;
    }

    public void instLDI() {
        if (this.traceCPU >= TRC_ALL) {
            this.traceCPU(2, "LDI");
        }
        this.mem.setByte(this.DE.get(), this.mem.getByte(this.HL.get()));
        this.DE.set(this.DE.get() + 1 & 0xFFFF);
        this.HL.set(this.HL.get() + 1 & 0xFFFF);
        this.BC.set(this.BC.get() - 1);
        this.setFlagH(false);
        this.setFlagPV(this.BC.get() != 0);
        this.setFlagN(false);
        this.PC.r += 2;
        this.t += 16L;
    }

    public void instJR_NZ_n8() {
        int n8 = this.mem.getByte(this.PC.r + 1);
        if (this.traceCPU >= TRC_Jcc) {
            this.traceCPU(2, "JR    NZ" + (!this.getFlagZ() ? "(1)" : "(0)") + "," + this.toHexString(this.PC.r + 2 + (byte)n8, 4));
        }
        this.PC.r += 2;
        this.t += 7L;
        if (!this.getFlagZ()) {
            this.PC.r += (byte)n8;
            this.t += 5L;
        }
    }

    public void instJP_cc_n16() {
        int cc = (this.opcode & 0x38) >> 3;
        this.addr = this.mem.getWord(this.PC.r + 1);
        if (this.traceCPU >= TRC_Jcc) {
            this.traceCPU(3, "JP    " + this.getccName(cc) + (this.getccValue(cc) ? "(1)" : "(0)") + "," + this.word2HexnDecString(this.addr));
        }
        this.PC.r = this.getccValue(cc) ? this.addr : (this.PC.r += 3);
        this.t += 10L;
    }

    public final void instJR_Z_n8() {
        int n8 = this.mem.getByte(this.PC.r + 1);
        if (this.traceCPU >= TRC_Jcc) {
            this.traceCPU(2, "JR    Z" + (this.getFlagZ() ? "(1)" : "(0)") + "," + this.toHexString(this.PC.r + 2 + (byte)n8, 4));
        }
        this.PC.r += 2;
        this.t += 7L;
        if (this.getFlagZ()) {
            this.PC.r += (byte)n8;
            this.t += 5L;
        }
    }

    public final void instJR_C_n8() {
        int n8 = this.mem.getByte(this.PC.r + 1);
        if (this.traceCPU >= TRC_Jcc) {
            this.traceCPU(2, "JR    C" + (this.getFlagC() ? "(1)" : "(0)") + "," + this.toHexString(this.PC.r + 2 + (byte)n8, 4));
        }
        this.PC.r += 2;
        this.t += 7L;
        if (this.getFlagC()) {
            this.PC.r += (byte)n8;
            this.t += 5L;
        }
    }

    public final void instJR_NC_n8() {
        int n8 = this.mem.getByte(this.PC.r + 1);
        if (this.traceCPU >= TRC_Jcc) {
            this.traceCPU(2, "JR    NC" + (!this.getFlagC() ? "(1)" : "(0)") + "," + this.toHexString(this.PC.r + 2 + (byte)n8, 4));
        }
        this.PC.r += 2;
        this.t += 7L;
        if (!this.getFlagC()) {
            this.PC.r += (byte)n8;
            this.t += 5L;
        }
    }

    public final void instDJNZ() {
        int n8 = this.mem.getByte(this.PC.r + 1);
        if (this.traceCPU >= TRC_Jcc) {
            this.traceCPU(2, "DJNZ  " + this.toHexString(this.PC.r + 2 + (byte)n8, 4));
        }
        --this.B.r;
        this.B.r &= 0xFF;
        this.PC.r += 2;
        this.t += 8L;
        if (this.B.r != 0) {
            this.PC.r += (byte)n8;
            this.t += 5L;
        }
    }

    public void instPUSH_r16() {
        this.R1 = this.r16AF[(this.opcode & 0x30) >> 4];
        if (this.traceCPU >= TRC_ALL) {
            this.traceCPU(1, "PUSH  " + this.R1.name);
        }
        this.SP.r = this.SP.r - 2 & 0xFFFF;
        this.mem.setWord(this.SP.r, this.R1.get());
        ++this.PC.r;
        this.t += 11L;
    }

    public void instPUSH_IND() {
        if (this.traceCPU >= TRC_ALL) {
            this.traceCPU(1, "PUSH  " + this.IND.name);
        }
        this.SP.r = this.SP.r - 2 & 0xFFFF;
        this.mem.setWord(this.SP.r, this.IND.r);
        this.PC.r += 2;
        this.t += 14L;
    }

    public void instPOP_r16() {
        this.R1 = this.r16AF[(this.opcode & 0x30) >> 4];
        if (this.traceCPU >= TRC_ALL) {
            this.traceCPU(1, "POP   " + this.R1.name);
        }
        this.R1.set(this.mem.getWord(this.SP.r));
        this.SP.r = this.SP.r + 2 & 0xFFFF;
        ++this.PC.r;
        this.t += 14L;
    }

    public void instPOP_IND() {
        if (this.traceCPU >= TRC_ALL) {
            this.traceCPU(2, "POP   " + this.IND.name);
        }
        this.IND.r = this.mem.getWord(this.SP.r);
        this.SP.r = this.SP.r + 2 & 0xFFFF;
        this.PC.r += 2;
        this.t += 14L;
    }

    public final void instRLCA() {
        if (this.traceCPU >= TRC_ALL) {
            this.traceCPU(1, "RLCA");
        }
        this.rlc_a();
        ++this.PC.r;
        this.t += 4L;
    }

    private final void rlc_a() {
        boolean c;
        int ans = this.A.r;
        boolean bl = c = (ans & 0x80) != 0;
        ans = c ? ans << 1 | 1 : (ans <<= 1);
        this.setFlagN(false);
        this.setFlagH(false);
        this.setFlagC(c);
        this.A.r = ans &= 0xFF;
    }

    public final void instRLA() {
        if (this.traceCPU >= TRC_ALL) {
            this.traceCPU(1, "RLA");
        }
        this.rl_a();
        ++this.PC.r;
        this.t += 4L;
    }

    private final void rl_a() {
        boolean c;
        int ans = this.A.r;
        boolean bl = c = (ans & 0x80) != 0;
        ans = this.getFlagC() ? ans << 1 | 1 : (ans <<= 1);
        this.setFlagN(false);
        this.setFlagH(false);
        this.setFlagC(c);
        this.A.r = ans &= 0xFF;
    }

    public final void instRLC_r8() {
        this.r1 = this.r8[this.opcode];
        if (this.traceCPU >= TRC_ALL) {
            this.traceCPU(2, "RLC   " + this.r1.name);
        }
        this.r1.r = this.rlc(this.r1.r);
        this.PC.r += 2;
        this.t += 8L;
    }

    private final int rlc(int ans) {
        boolean c;
        boolean bl = c = (ans & 0x80) != 0;
        ans = c ? ans << 1 | 1 : (ans <<= 1);
        this.F.r = PSZTable[ans &= 0xFF];
        this.setFlagC(c);
        return ans;
    }

    public final void instRRC_r8() {
        this.r1 = this.r8[this.opcode & 7];
        if (this.traceCPU >= TRC_ALL) {
            this.traceCPU(2, "RRC   " + this.r1.name);
        }
        this.r1.r = this.rrc(this.r1.r);
        this.PC.r += 2;
        this.t += 8L;
    }

    private final int rrc(int ans) {
        boolean c;
        boolean bl = c = (ans & 1) != 0;
        ans = c ? ans >> 1 | 0x80 : (ans >>= 1);
        this.F.r = PSZTable[ans];
        this.setFlagC(c);
        return ans;
    }

    public final void instRRA() {
        if (this.traceCPU >= TRC_ALL) {
            this.traceCPU(1, "RRA");
        }
        this.rr_a();
        ++this.PC.r;
        this.t += 4L;
    }

    private final void rr_a() {
        boolean c;
        int ans = this.A.r;
        boolean bl = c = (ans & 1) != 0;
        ans = this.getFlagC() ? ans >> 1 | 0x80 : (ans >>= 1);
        this.setFlagN(false);
        this.setFlagH(false);
        this.setFlagC(c);
        this.A.r = ans;
    }

    public final void instRRCA() {
        if (this.traceCPU >= TRC_ALL) {
            this.traceCPU(1, "RRCA");
        }
        this.rrc_a();
        ++this.PC.r;
        this.t += 4L;
    }

    private final void rrc_a() {
        boolean c;
        int ans = this.A.r;
        boolean bl = c = (ans & 1) != 0;
        ans = c ? ans >> 1 | 0x80 : (ans >>= 1);
        this.setFlagN(false);
        this.setFlagH(false);
        this.setFlagC(c);
        this.A.r = ans;
    }

    public final void instSUB_r8() {
        this.r1 = this.r8[this.opcode & 7];
        if (this.traceCPU >= TRC_ALL) {
            this.traceCPU(1, "SUB   " + this.r1.name);
        }
        this.sub_a(this.r1.r);
        ++this.PC.r;
        this.t += 4L;
    }

    public final void instSUB_n8() {
        int n8 = this.mem.getByte(this.PC.r + 1);
        if (this.traceCPU >= TRC_ALL) {
            this.traceCPU(2, "SUB   " + this.byte2HexnDecString(n8));
        }
        this.sub_a(n8);
        this.PC.r += 2;
        this.t += 7L;
    }

    public final void instSUB_iHL() {
        int n8 = this.mem.getByte(this.HL.get());
        if (this.traceCPU >= TRC_ALL) {
            this.traceCPU(2, "SUB   (HL)  ; (HL)=" + this.byte2HexnDecString(n8));
        }
        this.sub_a(n8);
        this.addPC_T(1, 7);
    }

    private final void sub_a(int b) {
        int a = this.A.r;
        int wans = a - b;
        int ans = wans & 0xFF;
        this.F.r = SZTable[ans];
        this.F.r |= SET_N;
        this.setFlagC((wans & 0x100) != 0);
        this.setFlagPV(((a ^ b) & (a ^ ans) & 0x80) != 0);
        this.setFlagH(((a & 0xF) - (b & 0xF) & SET_H) != 0);
        this.A.r = ans;
    }

    public final void instCP_n8() {
        int n8 = this.mem.getByte(this.PC.r + 1);
        if (this.traceCPU >= TRC_ALL) {
            this.traceCPU(2, "CP    " + this.byte2HexnDecString(n8));
        }
        this.cp_a(n8);
        this.PC.r += 2;
        this.t += 7L;
    }

    public final void instCP_r8() {
        this.r1 = this.r8[this.opcode & 7];
        if (this.traceCPU >= TRC_ALL) {
            this.traceCPU(2, "CP    " + this.r1.name);
        }
        this.cp_a(this.r1.r);
        ++this.PC.r;
        this.t += 4L;
    }

    public final void instCP_iHL() {
        int n8 = this.mem.getByte(this.HL.get());
        if (this.traceCPU >= TRC_ALL) {
            this.traceCPU(1, "CP    (HL)\t; (HL)=" + this.byte2HexnDecString(n8));
        }
        this.cp_a(n8);
        ++this.PC.r;
        this.t += 7L;
    }

    private final void cp_a(int b) {
        int a = this.A.r;
        int wans = a - b;
        int ans = wans & 0xFF;
        this.F.r = SZTable[ans] | SET_N;
        this.setFlagC((wans & 0x100) != 0);
        this.setFlagH(((a & 0xF) - (b & 0xF) & SET_H) != 0);
        this.setFlagPV(((a ^ b) & (a ^ ans) & 0x80) != 0);
    }

    public final void instADD_HL_r16() {
        this.R1 = this.r16[(this.opcode & 0x30) >> 4];
        if (this.traceCPU >= TRC_ALL) {
            this.traceCPU(1, "ADD   HL," + this.R1.name);
        }
        this.HL.set(this.add16(this.HL.get(), this.R1.get()));
        ++this.PC.r;
        this.t += 11L;
    }

    public final void instADD_IND_r16() {
        this.R1 = this.r16IND[(this.opcode & 0x30) >> 4];
        if (this.traceCPU >= TRC_ALL) {
            this.traceCPU(1, "ADD   " + this.IND.name + "," + this.R1.name);
        }
        this.IND.set(this.add16(this.IND.get(), this.R1.get()));
        this.PC.r += 2;
        this.t += 15L;
    }

    public final void instADC_HL_r16() {
        this.R1 = this.r16[(this.opcode & 0x30) >> 4];
        if (this.traceCPU >= TRC_ALL) {
            this.traceCPU(1, "ADC   HL," + this.R1.name);
        }
        this.HL.set(this.adc16(this.HL.get(), this.R1.get()));
        this.PC.r += 2;
        this.t += 11L;
    }

    private final int adc16(int a, int b) {
        int c = this.getFlagC() ? 1 : 0;
        int lans = a + b + c;
        int ans = lans & 0xFFFF;
        this.setFlagS((ans & SET_S << 8) != 0);
        this.setFlagZ(ans == 0);
        this.setFlagC((lans & 0x10000) != 0);
        this.setFlagPV(((a ^ ~b) & (a ^ ans) & 0x8000) != 0);
        this.setFlagH(((a & 0xFFF) + (b & 0xFFF) + c & 0x1000) != 0);
        this.setFlagN(false);
        return ans;
    }

    public final void instADD_r8() {
        this.r1 = this.r8[this.opcode & 7];
        if (this.traceCPU >= TRC_ALL) {
            this.traceCPU(1, "ADD   " + this.r1.name);
        }
        this.add_a(this.r1.r);
        ++this.PC.r;
        this.t += 4L;
    }

    public final void instADD_n8() {
        int n8 = this.mem.getByte(this.PC.r + 1);
        if (this.traceCPU >= TRC_ALL) {
            this.traceCPU(2, "ADD   A," + this.byte2HexnDecString(n8));
        }
        this.add_a(n8);
        this.PC.r = this.PC.r + 2 & 0xFFFF;
        this.t += 7L;
    }

    private final void add_a(int n) {
        int a = this.A.r;
        int wans = a + n;
        int ans = wans & 0xFF;
        this.F.r = SZTable[this.A.r];
        this.setFlagC((wans & 0x100) != 0);
        this.setFlagPV(((a ^ ~n) & (a ^ ans) & 0x80) != 0);
        this.setFlagH(((a & 0xF) + (n & 0xF) & SET_H) != 0);
        this.setFlagN(false);
        this.A.r = ans;
    }

    public final void instDAA() {
        if (this.traceCPU >= TRC_ALL) {
            this.traceCPU(2, "DAA   ");
        }
        this.daa_a();
        this.PC.r = this.PC.r + 1 & 0xFFFF;
        this.t += 4L;
    }

    private final void daa_a() {
        int ans = this.A.r;
        int incr = 0;
        boolean carry = this.getFlagC();
        if (this.getFlagH() || (ans & 0xF) > 9) {
            incr |= 6;
        }
        if (carry || ans > 159 || ans > 143 && (ans & 0xF) > 9) {
            incr |= 0x60;
        }
        if (ans > 153) {
            carry = true;
        }
        if (this.getFlagN()) {
            this.sub_a(incr);
        } else {
            this.add_a(incr);
        }
        ans = this.A.r;
        this.setFlagC(carry);
        this.setFlagPV((PSZTable[ans] & SET_PV) != 0);
    }

    public final void instADC_r8() {
        this.r1 = this.r8[this.opcode & 7];
        if (this.traceCPU >= TRC_ALL) {
            this.traceCPU(1, "ADC   " + this.r1.name);
        }
        this.adc_a(this.r1.r);
        ++this.PC.r;
        this.t += 4L;
    }

    public final void instADC_n8() {
        int n8 = this.mem.getByte(this.PC.get() + 1);
        if (this.traceCPU >= TRC_ALL) {
            this.traceCPU(1, "ADC   " + this.byte2HexnDecString(n8));
        }
        this.adc_a(n8);
        this.PC.r += 2;
        this.t += 7L;
    }

    public final void instADC_iHL() {
        int n8 = this.mem.getByte(this.HL.get());
        if (this.traceCPU >= TRC_ALL) {
            this.traceCPU(1, "ADC   (HL)  ; (HL)=" + this.byte2HexnDecString(n8));
        }
        this.adc_a(n8);
        this.addPC_T(1, 7);
    }

    private final void adc_a(int b) {
        int a = this.A.r;
        int c = this.getFlagC() ? 1 : 0;
        int wans = a + b + c;
        int ans = wans & 0xFF;
        this.setFlagS((ans & SET_S) != 0);
        this.setFlagZ(ans == 0);
        this.setFlagC((wans & 0x100) != 0);
        this.setFlagPV(((a ^ ~b) & (a ^ ans) & 0x80) != 0);
        this.setFlagH(((a & 0xF) + (b & 0xF) + c & SET_H) != 0);
        this.setFlagN(false);
        this.A.r = ans;
    }

    private final int add16(int a, int b) {
        int lans = a + b;
        int ans = lans & 0xFFFF;
        this.setFlag3((ans & SET_3 << 8) != 0);
        this.setFlag5((ans & SET_5 << 8) != 0);
        this.setFlagC((lans & 0x10000) != 0);
        this.setFlagH(((a & 0xFFF) + (b & 0xFFF) & 0x1000) != 0);
        this.setFlagN(false);
        return ans;
    }

    public final void instBIT_b_r8() {
        this.r1 = this.r8[this.opcode & 7];
        int b = (this.opcode & 0x38) >> 3;
        if (this.traceCPU >= TRC_ALL) {
            this.traceCPU(2, "BIT   " + Integer.toString(b) + "," + this.r1.name);
        }
        this.bit(b, this.r1.r);
        this.PC.r += 2;
        this.t += 8L;
    }

    public final void instBIT_b_iHL() {
        int b = (this.opcode & 0x38) >> 3;
        int n8 = this.mem.getByte(this.HL.get());
        if (this.traceCPU >= TRC_ALL) {
            this.traceCPU(2, "BIT   " + Integer.toString(b) + ",(HL)");
        }
        this.bit(b, n8);
        this.PC.r += 2;
        this.t += 12L;
    }

    public final void instBIT_b_iINDd() {
        int d = this.mem.getByte(this.PC.r + 2);
        int b = (this.opcode & 0x38) >> 3;
        this.addr = this.IND.r + (byte)d;
        if (this.traceCPU >= TRC_ALL) {
            this.traceCPU(4, "BIT   " + Integer.toString(b) + ",(" + this.IND.name + "+" + this.byte2HexnDecString(d).trim() + ")  ; " + this.IND.name + "+" + this.byte2HexnDecString(d).trim() + " => " + Integer.toHexString(this.addr));
        }
        this.bit(b, this.mem.getByte(this.addr));
        this.PC.r += 4;
        this.t += 20L;
    }

    private final void bit(int b, int n) {
        this.setFlagZ((n & 1 << b) == 0);
        this.setFlagH(true);
        this.setFlagN(false);
    }

    public final void instRES_b_iINDd() {
        int d = this.mem.getByte(this.PC.r + 2);
        int b = (this.opcode & 0x38) >> 3;
        int addr = this.IND.r + (byte)d;
        if (this.traceCPU >= TRC_ALL) {
            this.traceCPU(4, "RES   " + Integer.toString(b) + ",(" + this.IND.name + "+" + this.byte2HexnDecString(d).trim() + ")  ; " + this.IND.name + "+" + this.byte2HexnDecString(d).trim() + " => " + Integer.toHexString(addr));
        }
        this.mem.setByte(addr, this.mem.getByte(addr) & ~(1 << b));
        this.PC.r += 4;
        this.t += 20L;
    }

    public final void instSET_b_r8() {
        this.r1 = this.r8[this.opcode & 7];
        int b = (this.opcode & 0x38) >> 3;
        if (this.traceCPU >= TRC_ALL) {
            this.traceCPU(2, "SET   " + Integer.toString(b) + "," + this.r1.name);
        }
        this.r1.r |= 1 << b;
        this.PC.r += 2;
        this.t += 8L;
    }

    public final void instSET_b_iHL() {
        int b = (this.opcode & 0x38) >> 3;
        int addr = this.HL.get();
        int n8 = this.mem.getByte(addr);
        if (this.traceCPU >= TRC_ALL) {
            this.traceCPU(2, "SET   " + Integer.toString(b) + ",(HL) ; (HL)=" + this.byte2HexnDecString(n8));
        }
        this.mem.setByte(addr, n8 |= 1 << b);
        this.addPC_T(2, 15);
    }

    public final void instRES_b_r8() {
        this.r1 = this.r8[this.opcode & 7];
        int b = (this.opcode & 0x38) >> 3;
        if (this.traceCPU >= TRC_ALL) {
            this.traceCPU(2, "RES   " + Integer.toString(b) + "," + this.r1.name);
        }
        this.r1.r &= ~(1 << b);
        this.PC.r += 2;
        this.t += 8L;
    }

    public final void instRES_b_iHL() {
        int b = (this.opcode & 0x38) >> 3;
        int addr = this.HL.get();
        int n8 = this.mem.getByte(addr);
        if (this.traceCPU >= TRC_ALL) {
            this.traceCPU(2, "RES   " + Integer.toString(b) + ",(HL) ; (HL)=" + this.byte2HexnDecString(n8));
        }
        this.mem.setByte(addr, n8 &= ~(1 << b));
        this.addPC_T(2, 15);
    }

    public final void instRR_r8() {
        this.r1 = this.r8[this.opcode & 7];
        if (this.traceCPU >= TRC_ALL) {
            this.traceCPU(2, "RR    " + this.r1.name);
        }
        this.r1.r = this.rr(this.r1.r);
        this.PC.r += 2;
        this.t += 8L;
    }

    private final int rr(int ans) {
        boolean c;
        boolean bl = c = (ans & 1) != 0;
        ans = this.getFlagC() ? ans >> 1 | 0x80 : (ans >>= 1);
        this.F.r = PSZTable[ans];
        this.setFlagC(c);
        return ans;
    }

    public final void instSRL_r8() {
        this.r1 = this.r8[this.opcode & 7];
        if (this.traceCPU >= TRC_ALL) {
            this.traceCPU(2, "SRL   " + this.r1.name);
        }
        this.r1.r = this.srl(this.r1.r);
        this.PC.r += 2;
        this.t += 8L;
    }

    private final int srl(int ans) {
        boolean c = (ans & 1) != 0;
        this.F.r = PSZTable[ans >>= 1];
        this.setFlagC(c);
        return ans;
    }

    public final void instRL_r8() {
        this.r1 = this.r8[this.opcode & 7];
        if (this.traceCPU >= TRC_ALL) {
            this.traceCPU(2, "RL    " + this.r1.name);
        }
        this.r1.r = this.rl(this.r1.r);
        this.PC.r += 2;
        this.t += 8L;
    }

    private final int rl(int ans) {
        boolean c;
        boolean bl = c = (ans & 0x80) != 0;
        ans = this.getFlagC() ? ans << 1 | 1 : (ans <<= 1);
        this.F.r = PSZTable[ans &= 0xFF];
        this.setFlagC(c);
        return ans;
    }

    public final void instSBC_r8() {
        this.r1 = this.r8[this.opcode & 7];
        if (this.traceCPU >= TRC_ALL) {
            this.traceCPU(1, "SBC   " + this.r1.name);
        }
        this.sbc_a(this.r1.r);
        ++this.PC.r;
        this.t += 4L;
    }

    private final void sbc_a(int b) {
        int a = this.A.r;
        int c = this.F.r & 1;
        int wans = a - b - c;
        int ans = wans & 0xFF;
        this.F.r = SZTable[ans] | SET_N;
        this.setFlagC((wans & 0x100) != 0);
        this.setFlagPV(((a ^ b) & (a ^ ans) & 0x80) != 0);
        this.setFlagH(((a & 0xF) - (b & 0xF) - c & SET_H) != 0);
        this.A.r = ans;
    }

    public final void instSRA_r8() {
        this.r1 = this.r8[this.opcode & 7];
        if (this.traceCPU >= TRC_ALL) {
            this.traceCPU(2, "SRA   " + this.r1.name);
        }
        this.r1.r = this.sra(this.r1.r);
        this.PC.r += 2;
        this.t += 8L;
    }

    private final int sra(int ans) {
        boolean c = (ans & 1) != 0;
        ans = ans >> 1 | ans & 0x80;
        this.F.r = PSZTable[ans];
        this.setFlagC(c);
        return ans;
    }

    public final void instSLA_r8() {
        this.r1 = this.r8[this.opcode & 7];
        if (this.traceCPU >= TRC_ALL) {
            this.traceCPU(2, "SLA   " + this.r1.name);
        }
        this.r1.r = this.sla(this.r1.r);
        this.PC.r += 2;
        this.t += 8L;
    }

    private final int sla(int ans) {
        boolean c = (ans & 0x80) != 0;
        ans = ans << 1 & 0xFF;
        this.F.r = PSZTable[ans];
        this.setFlagC(c);
        return ans;
    }

    public final void instSBC_HL_r16() {
        this.R1 = this.r16[(this.opcode & 0x30) >> 4];
        if (this.traceCPU >= TRC_ALL) {
            this.traceCPU(1, "SBC   HL," + this.r1.name);
        }
        this.HL.set(this.sbc16(this.HL.get(), this.R1.get()));
        this.PC.r += 2;
        this.t += 15L;
    }

    private final int sbc16(int a, int b) {
        int c = this.F.r & 1;
        int lans = a - b - c;
        int ans = lans & 0xFFFF;
        this.setFlagS((ans & SET_S << 8) != 0);
        this.setFlagZ(ans == 0);
        this.setFlagC((lans & 0x10000) != 0);
        this.setFlagPV(((a ^ b) & (a ^ ans) & 0x8000) != 0);
        this.setFlagH(((a & 0xFFF) - (b & 0xFFF) - c & 0x1000) != 0);
        this.setFlagN(true);
        return ans;
    }

    public final void instNEG() {
        if (this.traceCPU >= TRC_ALL) {
            this.traceCPU(2, "NEG");
        }
        this.neg_a();
        this.PC.r += 2;
        this.t += 8L;
    }

    private final void neg_a() {
        int t = this.A.r;
        this.A.r = 0;
        this.sub_a(t);
    }

    public final void instCPL() {
        if (this.traceCPU >= TRC_ALL) {
            this.traceCPU(1, "CPL");
        }
        this.A.r ^= 0xFF;
        this.A.r &= 0xFF;
        this.F.r |= SET_N | SET_H;
        ++this.PC.r;
        this.t += 4L;
    }

    public final void instSCF() {
        if (this.traceCPU >= TRC_ALL) {
            this.traceCPU(1, "SCF");
        }
        this.F.r |= SET_C;
        this.F.r &= ~(SET_H | SET_N);
        ++this.PC.r;
        this.t += 4L;
    }

    public final void instCCF() {
        if (this.traceCPU >= TRC_ALL) {
            this.traceCPU(1, "CCF");
        }
        this.setFlagH(this.getFlagC());
        this.F.r ^= SET_C;
        this.F.r &= ~SET_N;
        ++this.PC.r;
        this.t += 4L;
    }

    public final void instRLD() {
        if (this.traceCPU >= TRC_ALL) {
            this.traceCPU(1, "RLD");
        }
        this.rld_a();
        this.addPC_T(2, 18);
    }

    private final void rld_a() {
        int t;
        int ans = this.A.r;
        int addr = this.HL.get();
        int q = t = this.mem.getByte(addr);
        int saveC = this.F.r & SET_C;
        t = t << 4 | ans & 0xF;
        ans = ans & 0xF0 | q >> 4;
        this.mem.setByte(addr, t & 0xFF);
        this.F.r = PSZTable[ans] | saveC;
        this.A.r = ans;
    }

    public final void instRRD() {
        if (this.traceCPU >= TRC_ALL) {
            this.traceCPU(1, "RRD");
        }
        this.rrd_a();
        this.addPC_T(2, 18);
    }

    private final void rrd_a() {
        int t;
        int ans = this.A.r;
        int addr = this.HL.get();
        int q = t = this.mem.getByte(addr);
        int saveC = this.F.r & SET_C;
        t = t >> 4 | ans << 4;
        ans = ans & 0xF0 | q & 0xF;
        this.mem.setByte(addr, t);
        this.F.r = PSZTable[ans] | saveC;
        this.A.r = ans;
    }

    public void addPC_T(int n, int td) {
        this.PC.r = this.PC.r + n & 0xFFFF;
        this.t += (long)td;
    }

    public void registerTrace() {
        this.log.write("A =" + this.byte2HexnDecString(this.A.r) + "F =(" + (this.getFlagS() ? "S=1," : "S=0,") + (this.getFlagZ() ? "Z=1," : "Z=0,") + (this.getFlagH() ? "H=1," : "H=0,") + (this.getFlagPV() ? "P/V=1," : "P/V=0,") + (this.getFlagN() ? "N=1," : "N=0,") + (this.getFlagC() ? "C=1)" : "C=0)") + "=" + this.byte2HexnDecString(this.F.r));
        this.log.write("B =" + this.byte2HexnDecString(this.B.r) + "C =" + this.byte2HexnDecString(this.C.r) + "BC=" + this.word2HexnDecString(this.BC.get()));
        this.log.write("D =" + this.byte2HexnDecString(this.D.r) + "E =" + this.byte2HexnDecString(this.E.r) + "DE=" + this.word2HexnDecString(this.DE.get()));
        this.log.write("H =" + this.byte2HexnDecString(this.H.r) + "L =" + this.byte2HexnDecString(this.L.r) + "HL=" + this.word2HexnDecString(this.HL.get()));
        this.log.write("IX=" + this.word2HexnDecString(this.IX.r) + "IY=" + this.word2HexnDecString(this.IY.r) + "SP=" + this.word2HexnDecString(this.SP.r));
    }

    public void traceCPU(int pLen, String pMnemoic) {
        this.registerTrace();
        this.log.write("------------------------------------------------------------| " + this.toHexString(this.PC.r, 4) + ": " + this.tracePCBytes(pLen) + pMnemoic);
    }

    public String word2HexnDecString(int pValue) {
        return (String.valueOf(this.toHexString(pValue, 4)) + "(" + this.toDecString(pValue, 5) + "," + this.toDecString((short)pValue, 6) + ")" + "                             ").substring(0, 16);
    }

    public String byte2HexnDecString(int pValue) {
        return (String.valueOf(this.toHexString(pValue, 2)) + "(" + this.toDecString(pValue, 4) + "," + this.toDecString((byte)pValue, 4) + ")" + "                             ").substring(0, 16);
    }

    public String toHexString(int pValue, int pLen) {
        String s = "0000000" + Integer.toHexString(pValue);
        return s.substring(s.length() - pLen);
    }

    public String toHexString2(int pValue, int pLen) {
        String s = "0000000" + Integer.toHexString(pValue);
        return s.substring(s.length() - pLen);
    }

    public String toDecString(int pValue, int pLen) {
        return Integer.toString(pValue);
    }

    public final String tracePCBytes(int pLen) {
        String s = "";
        int i = 0;
        while (i < pLen) {
            s = String.valueOf(s) + this.toHexString2(this.mem.getByte(this.PC.r + i), 2) + " ";
            ++i;
        }
        return (String.valueOf(s) + "            ").substring(0, 12);
    }

    public final void prevPCs() {
        String s = "";
        int i = 0;
        while (i < 1024) {
            s = String.valueOf(s) + this.toHexString(this.pPC[this.ppi + i & 0x3FF], 4) + "/";
            ++i;
        }
        this.log.write("PrevPCs: " + s);
    }

    public final void traceSubroutine() {
        String s = "";
        switch (this.PC.r) {
            case 50019: {
                s = "Function call control";
                break;
            }
            case 56572: {
                s = "BASIC initialize";
                break;
            }
            case 65151: {
                s = "Write text (HL=length)";
                break;
            }
            case 65178: {
                s = "Write char (A=Ascii code)";
                break;
            }
            case 55791: {
                s = "BASIC Start";
                break;
            }
            case 51625: {
                s = "VIDEO V0  - Video return";
                break;
            }
            case 51599: {
                s = "VIDEO V1  - Video dispatcher";
                break;
            }
            case 51626: {
                s = "VIDEO V2  - Video jump table dispatcher";
                break;
            }
            case 51635: {
                s = "VIDEO V3  - Coordinate transform X";
                break;
            }
            case 51642: {
                s = "VIDEO V4  - Coordinate transform Y";
                break;
            }
            case 51649: {
                s = "VIDEO V5  - HL coordinate transform. HL/2, or 4, or 8, based on Video mode. Mode:" + Integer.toString(this.tvc.surface.scr.videomode);
                break;
            }
            case 51654: {
                s = "VIDEO V51 - HL>>1, if b != 0, B=" + Integer.toString(this.B.r);
                break;
            }
            case 51661: {
                s = "VIDEO V6  - Display settings and IY.";
                break;
            }
            case 51698: {
                s = "VIDEO INIC- Video mode 4color";
                break;
            }
            case 51768: {
                s = "VIDEO 12  - PAL-DEF";
                break;
            }
            case 51785: {
                s = "VIDEO 5 05H - CLS";
            }
        }
        if (s != "") {
            this.log.write("SUB ==> " + s);
        }
    }

    class Reg8 {
        int r;
        String name;

        public Reg8(String name) {
            this.name = name;
            this.r = 0;
        }
    }

    class Reg16 {
        Reg8 rh;
        Reg8 rl;
        int r;
        String name;
        boolean pair;

        public Reg16(String name, Reg8 rh, Reg8 rl) {
            this.pair = true;
            this.name = name;
            this.rh = rh;
            this.rl = rl;
        }

        public Reg16(String name) {
            this.name = name;
            this.r = 0;
            this.pair = false;
        }

        public final int get() {
            return this.pair ? this.rh.r << 8 | this.rl.r : this.r;
        }

        public final void set(int p) {
            if (this.pair) {
                this.rh.r = p >> 8;
                this.rl.r = p & 0xFF;
            } else {
                this.r = p;
            }
        }
    }

    public class IntCursor
    implements Runnable {
        Z80 z80;

        public IntCursor(Z80 z802) {
            this.z80 = z802;
        }

        public void run() {
            while (this.z80.running) {
                this.z80.interrupt = true;
                this.z80.port.port_in[89] = this.z80.port.port_in[89] & 0xFFFFFFEF;
                try {
                    Thread.sleep(20L);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    }
}

