/**
 * @author Gabor
 *
 * To change this generated comment edit the template variable "typecomment":
 * Window>Preferences>Java>Templates.
 * To enable and disable the creation of type comments go to
 * Window>Preferences>Java>Code Generation.
 */

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;

public class Memory {
	
	Screen		scr;
	Log			log;
		
	class Page {
		
		int 		mem[];
		boolean	changed[];
		boolean	video;
		String		name;
		int		maxA, minA;

		public Page( String name, boolean video) {
			
			mem = new int[0x4000];
			for ( int i = 0; i < 0x4000; i++) mem[i] = 0;

			if ( video) {
				changed = new boolean[0x4000];
				for ( int i = 0; i < 0x4000; i++) changed[i] = false;
			}
			
			this.video = video;
			this.name = name;
		}
		
		public final int get( int addr) {
			return mem[addr];
		}
		
		public final void set( int addr, int p) {

			mem[addr] = p;
			
//			if ( video) scr.writeVideo( addr, p);
			if ( video) {
				tvc.surface.scr.changed = changed[addr] = true;
				if ( addr > maxA) maxA = addr;
				if ( addr < minA) minA = addr;
			} 
		}
	}
	
	Page SYS, EXT, VID, CART, U0, U1, U2, U3, M[];
	TVC tvc;
	
	public Memory( TVC tvc) {
		
		this.tvc = tvc;
		
		SYS  = new Page( "System", false);
		EXT  = new Page( "Ext", false);
		VID  = new Page( "Video", true);
		CART = new Page( "Cart", false);
		U0   = new Page( "U0", false);
		U1   = new Page( "U1", false);
		U2   = new Page( "U2", false);
		U3   = new Page( "U3", false);
		M    = new Page[4];
	}
	
	public void initialize() {
		scr = tvc.surface.scr;
		log = tvc.log;
	}
	
	public boolean LoadROM() {

		int i;		
		FileInputStream ROMFile;
		byte workSYS[] = new byte [0x2000];
		
		try {
//			ROMFile = new FileInputStream ( "test02.BIN");
			ROMFile = new FileInputStream ( "rom/TVC12_D4.BIN");
			ROMFile.read(workSYS);
			ROMFile.close();
		} catch (FileNotFoundException e) {
			log.write(e.getMessage());
			return false;
		} catch (IOException ee) {
			log.write(ee.getMessage());
			return false;
		}
		
		for ( i = 0; i < 0x2000; i++) SYS.set( i, workSYS[i] & 0xff);
		
		log.write( "TVC12_D4.BIN has been loaded into SYS_1");

		try {
			ROMFile = new FileInputStream ( "rom/TVC12_D3.BIN");
			ROMFile.read(workSYS);
			ROMFile.close();
		} catch (FileNotFoundException e) {
			log.write(e.getMessage());
			return false;
		} catch (IOException ee) {
			log.write(ee.getMessage());
			return false;
		}
		
		for ( i = 0; i < 0x2000; i++) SYS.set( i+0x2000, workSYS[i] & 0xff);
		
		log.write( "TVC12_D3.BIN has been loaded into SYS_2");

		try {
			ROMFile = new FileInputStream ( "rom/TVC12_D7.BIN");
			ROMFile.read(workSYS);
			ROMFile.close();
		} catch (FileNotFoundException e) {
			log.write(e.getMessage());
			return false;
		} catch (IOException ee) {
			log.write(ee.getMessage());
			return false;
		}
		
		for ( i = 0; i < 0x2000; i++) EXT.set( i+0x2000, workSYS[i] & 0xff);
		
		log.write( "TVC12_D7.BIN has been loaded into EXT");
		
		setPages( 0);
		
		return true;
	}
	
	public final int getByte ( int addr) {
		
		int page = addr >> 14, offset = addr & 0x3fff; 
/*
		switch ( addr) {
			case 0x1718: {
				log.write( "Memory read trace:" + Integer.toHexString( addr) + 
							"-" + 
							Integer.toHexString( M[page].mem[offset]) + 
							" PC: 0x" + Integer.toHexString( tvc.z80.PC.r));
			}  break;
		}
*/
		return M[page].mem[offset];
	}

	public final void setByte ( int addr, int p) {
		
		int page = addr >> 14, offset = addr & 0x3fff;
		
/*		switch (addr) {
			case 0x1718: 
			{
				log.write( "Memory write trace:" + Integer.toHexString( addr) + 
						"-" + 
						Integer.toHexString( p) + 
						" PC: 0x" + Integer.toHexString( tvc.z80.PC.r));
			} break; 
		}
*/
		M[page].set( offset, p);
	}

	public final void setWord ( int addr, int p) {

		setByte( addr, p & 0xff);
		setByte( addr + 1, (p >> 8));
	}
	
	public final int getWord ( int addr) {

		return getByte( addr) | (getByte( addr + 1) << 8); 
	}
	
	public void setPages( int p) {
		
		String s = "";

		// Page 0.
		switch (p & 0x18) {
			case ( 0x00) : M[0] = SYS;	s += "SYS"; break;
			case ( 0x08) : M[0] = CART; s += "CART"; break;
			case ( 0x10) : M[0] = U0;	s += "U0"; break;
		}
		
		// Page 1.
		M[1] = U1;
		s += "-U1";			
				
		// Page 2.
		switch (p & 0x20) {
			case ( 0x00) : M[2] = VID;	s += "-VID"; break;
			case ( 0x20) : M[2] = U2;	s += "-U2"; break;
		}
		
		// Page 3.
		switch (p & 0xc0) {
			case ( 0x00) : M[3] = CART;	s += "-CART"; break;
			case ( 0x40) : M[3] = SYS;	s += "-SYS"; break;
			case ( 0x80) : M[3] = U3;	s += "-U3"; break;
			case ( 0xc0) : M[3] = EXT;	s += "-EXT"; break;
		}		
				
		//		log.write( "Memory mapping has been changed: " + s);
	}
	
	public void dump (int pAddr, int pSize) {
		
		String s1 = new String("");
		String s2 = new String("");
		String s3 = new String("");
		int wByte;
				
		log.write( "Memory dump");
		log.write( "Address: 00 01 02 03 04 05 06 07 - 08 09 0a 0b 0c 0d 0e 0f");
		log.write( "----------------------------------------------------------");		

		for ( int i = 0; i < pSize; i++) {
			if ( i%16 == 0) {
				if ( i != 0) log.write ( s1 + "  " + s3);
				s2 = "0000" + Integer.toHexString( pAddr + i);
				s2 = s2.substring( s2.length()-4);
				s1 = "0x" + s2 + " : ";
				s3 = "";
			}

			wByte = getByte(pAddr + i);			
			s2 = "00" + Integer.toHexString( wByte);
			s2 = s2.substring( s2.length()-2);
			if ( i%8 == 0 && i%16 != 0) s1 += "- " + s2 + " ";
			                       else s1 += s2 + " ";
			s3 += (char) wByte; 
		}
		log.write ( s1);
	}
}
