/*
 * Created on Jul 17, 2003
 *
 * To change the template for this generated file go to
 * Window>Preferences>Java>Code Generation>Code and Comments
 */

/**
 * @author gah
 *
 * To change the template for this generated type comment go to
 * Window>Preferences>Java>Code Generation>Code and Comments
 */
public class Port {
	
	public int port_out[], port_in[];
	public boolean tracePORT = false; 
	
	TVC 		tvc;
	Memory 		mem;
	Utils		utils;
	Screen		scr;
	Log			log;
	
	public Port( TVC tvc) {
		
		port_out 	= new int[256];
		port_in		= new int[256];
		this.tvc 	= tvc;
	}
	
	public void initialize() {
		
		mem = tvc.mem;
		scr = tvc.surface.scr;
		log = tvc.log;
		
		port_in[0x5a] = 0xff; // csatolokartya azonosito 0xff --> minden csatolo ures 
		port_in[0x59] = 0xff; // csatolokartya azonosito 0xff --> minden csatolo ures 
	}
	
	public void setPort ( int num, int p) {
		
		if ( tracePORT) 
			log.write( "Port write: " + Utils.toHexString( num, 2) + " <== 0x" + Utils.toHexString( p, 2));
		
		port_out[num] = p;
		
		switch( num) {
			case 0x02: mem.setPages( p); break;
			case 0x06: tvc.surface.scr.setMode( p); break;
			case 0x07: port_in[0x59] |= 0x10; break;	// megszakitas nyugtazasa
//			case 0x50: port_out[num] ^= 0xff; log.write( "Flip-Flop" + port_out[num]); break;
			case 0x60:
			case 0x61:
			case 0x62:
			case 0x63: tvc.surface.scr.setPalette( num & 0x03, p);
			default: port_out[num] = p; break;
		}
	}
	
	public int getPort ( int num) {
		
		int rslt;
		
		switch( num) {
			case 0x58: rslt = tvc.kbd.matrix[port_out[0x03] & 0x0f]; break;
			default: rslt = port_in[num]; break;
		}
		
		if ( tracePORT)
			log.write( "Port read:  " + Utils.toHexString( num, 2) + " ==> 0x" + Utils.toHexString( rslt, 2));
		
		return rslt;
	}
}
