/*
 * Created on Aug 26, 2003
 *
 * To change the template for this generated file go to
 * Window>Preferences>Java>Code Generation>Code and Comments
 */

/**
 * @author gah
 *
 * To change the template for this generated type comment go to
 * Window>Preferences>Java>Code Generation>Code and Comments
 */

import java.awt.*;
import java.awt.image.*;
import java.awt.event.*;

class Screen extends Canvas implements Runnable {
	
	public int			videomode = 16, ref = 0;
	public boolean		changed = true; 
	public int			nofRepaint, minx, maxx, maxy, miny, maxY, minY;
	Image				i2, i4, i16, i;
	Graphics			screenGraphics;
	MemoryImageSource	mis2, mis4, mis16;
	IndexColorModel		icm2, icm4, icm16;
	int					pix2[], pix4[], pix16[];
	public int 			r4[], g4[], b4[];
	public static int  	r16[] = { 	0x00, 0x00, 0x7f, 0x7f, 0x00, 0x00, 0x7f, 0x7f,
									0x00, 0x00, 0xff, 0xff, 0x00, 0x00, 0xff, 0xff
						},
						g16[] = {	0x00, 0x00, 0x00, 0x00, 0x7f, 0x7f, 0x7f, 0x7f,
									0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff
						},
						b16[] = {	0x00, 0x7f, 0x00, 0x7f, 0x00, 0x7f, 0x00, 0x7f,
									0x00, 0xff, 0x00, 0xff, 0x00, 0xff, 0x00, 0xff 
						};
	public int				screenX = 512, screenY = 480;
	public Color			c16[], c4[];
	public BufferedImage	img16[], img4[], img2[];
	public MyKeyListener	kbdl;
	TVC						tvc;
		
	public Screen( TVC tvc) {
		
		Graphics g1, g2;
		
		this.tvc = tvc;
		
		c16 = new Color[16];
		c4  = new Color[4];
		
		r4 = new int [4]; 
		g4 = new int [4]; 
		b4 = new int [4];
		
		for ( int i = 0; i < 4; i++) {
			r4[i] = r16[i*4+1];
			g4[i] = g16[i*4+1];
			b4[i] = b16[i*4];
		}
		
		for ( int i = 0; i < 16; i++) {
			c16[i] = new Color( r16[i], g16[i], b16[i]);
		}
		
		img2 = new BufferedImage [256];
		img4 = new BufferedImage [256];
		for ( int i = 0; i < 256; i++) {
			img2[i] = new BufferedImage( 8, 1, BufferedImage.TYPE_INT_RGB);
			img4[i] = new BufferedImage( 4, 1, BufferedImage.TYPE_INT_RGB);
		} 
		
		img16 = new BufferedImage [256];
		for ( int i = 0; i < 256; i++) {
			Graphics g;
			img16[i] = new BufferedImage( 2, 1, BufferedImage.TYPE_INT_RGB);
			g = img16[i].getGraphics();
			g.setColor( c16[i>>4]);
			g.drawLine( 0, 0, 0, 0);
			g.setColor( c16[i&0x0f]);
			g.drawLine( 1, 0, 1, 0);
		}		

		i2  = new BufferedImage( 512, 240, BufferedImage.TYPE_INT_RGB);
		i4  = new BufferedImage( 256, 240, BufferedImage.TYPE_INT_RGB);		
		i16 = new BufferedImage( 128, 240, BufferedImage.TYPE_INT_RGB);
		
		setSize( screenX, screenY);
		
		kbdl = new MyKeyListener( tvc);
		addKeyListener( kbdl);
	}
	
	public void initialize() {
				
		setMode( 1);
		setPalette( 0, 0);
		setPalette( 1, 1);
		setPalette( 2, 2);
		setPalette( 3, 3);
				
		kbdl.initialize();
	}
		
	public void paint( Graphics g) {		
		g.drawImage( i, 0, 0, screenX, screenY, 0, 0, i.getWidth( this), i.getHeight( this), this);
	}
	
	public void update ( Graphics g) {
		paint( g);
	}
	
	public void setMode( int mode) {
		
		switch( mode & 0x03) {
			case 0x00:	{
				i = i2;
				videomode = 2;
			} break;
			case 0x01: {
				i = i4;
				videomode = 4;
			} break;
			default: {
				i = i16; 
				videomode = 16;
			} break;
		}
		
//		tvc.log.write( "Video mode: " + Integer.toString( mode) + "==> " + Integer.toString( videomode));
		
		screenGraphics = i.getGraphics();
		redrawScreen();
	}
	
	public void writeVideo( int a, int v) {
		
		int x = 0, y = 0;
		
		switch( videomode) {
			case 2: {
				x = (a & 0x3f) << 3;
				y = a >> 6;
				screenGraphics.drawImage( img2[v], x , y, this);
			} break;
			case 4: {
				x = (a & 0x3f) << 2;
				y = a >> 6;
				screenGraphics.drawImage( img4[v], x , y, this);
			} break;
			case 16: {
				x = ( a & 0x3f) << 1;
				y = a >> 6;
				screenGraphics.drawImage( img16[v], x, y, this);
			} break;
		}
		
		if ( x > maxx) maxx = x;
		if ( x < minx) minx = x;
		if ( y > maxx) maxy = y;
		if ( y < minx) miny = y;
		changed = true;		
	}
	
	public void run() {
		
		int x, y, a;
		int m[] = tvc.mem.VID.mem;
		boolean changed[] = tvc.mem.VID.changed;
		
		Thread.currentThread().setPriority( Thread.MIN_PRIORITY);
		nofRepaint = 0;
		
		while( true) {
			nofRepaint ++;
			
			if ( this.changed) {
				
				int minY = tvc.mem.VID.minA >> 6;
				int maxY = tvc.mem.VID.maxA >> 6;

				tvc.mem.VID.minA = 0x4000;
				tvc.mem.VID.maxA = 0x0000;
				a = minY << 6;

				switch( videomode) {
					case 2: {
						for ( y = minY; y <= maxY; y++)
							for ( x = 0; x < 512; x += 8) {
								if ( changed[a]) { 
									screenGraphics.drawImage( img2[m[a]], x , y, this);
									changed[a] = false;
								} 
								a ++;
							}
					} break;
					case 4: {
						for ( y = minY; y <= maxY; y++)
							for ( x = 0; x < 256; x += 4) {
								if ( changed[a]) { 
									screenGraphics.drawImage( img4[m[a]], x , y, this);
									changed[a] = false;
								} 
								a ++;
							}
					} break;
					case 16: {
					} break;
				}
				
				this.repaint();
				this.changed = false;
			}
				 
			try {
				Thread.sleep( 50);
			} catch ( Exception e) {}
		}
	}
	
	public void setPalette( int n, int v) {

		Graphics g;
		
		//  0 I 0 G | 0 R 0 B
		//  0 0 0 0 | I R G B
		int i = ((v&0x40)>>3) | ((v&0x10)>>3) | (v&0x04) | (v&0x01);
		
		c4[n] = c16[i];

		for ( i = 0; i < 256; i++) {
			g = img2[i].getGraphics();
			g.setColor( c4[(i>>7) & 0x01]);
			g.drawLine( 0, 0, 0, 0);
			g.setColor( c4[(i>>6) & 0x01]);
			g.drawLine( 1, 0, 1, 0);
			g.setColor( c4[(i>>5) & 0x01]);
			g.drawLine( 2, 0, 2, 0);
			g.setColor( c4[(i>>4) & 0x01]);
			g.drawLine( 3, 0, 3, 0);
			g.setColor( c4[(i>>3) & 0x01]);
			g.drawLine( 4, 0, 4, 0);
			g.setColor( c4[(i>>2) & 0x01]);
			g.drawLine( 5, 0, 5, 0);
			g.setColor( c4[(i>>1) & 0x01]);
			g.drawLine( 6, 0, 6, 0);
			g.setColor( c4[i&0x01]);
			g.drawLine( 7, 0, 7, 0);
		}
		
		for ( i = 0; i < 256; i++) {
			g = img4[i].getGraphics();
			g.setColor( c4[((i&0x80)>>6) | ((i&0x08)>>3)]);
			g.drawLine( 0, 0, 0, 0);
			g.setColor( c4[((i&0x40)>>5) | ((i&0x04)>>2)]);
			g.drawLine( 1, 0, 1, 0);
			g.setColor( c4[((i&0x20)>>4) | ((i&0x02)>>1)]);
			g.drawLine( 2, 0, 2, 0);
			g.setColor( c4[((i&0x10)>>3) | (i&0x01)]);
			g.drawLine( 3, 0, 3, 0);
		}
		
//		tvc.log.write( "SET PALETTE: " + n + " <== " + v + " PC: 0x" + Integer.toHexString( tvc.z80.PC.r));
		
		redrawScreen();
	}
	
	public void redrawScreen() {
		boolean changed[] = tvc.mem.VID.changed;
//		for ( int i = 0; i < 15630; i++) writeVideo( i, tvc.mem.VID.mem[i]);
		for ( int i = 0; i < 15630; i++) changed[i] = true;
		tvc.mem.VID.maxA = 0x3cff;
		tvc.mem.VID.minA = 0;
	}
	
	public class MyKeyListener implements KeyListener {
		
		TVC				tvc;
		Log				log;
		Keyboard		kbd;
	
		public MyKeyListener( TVC tvc) {
		
			this.tvc = tvc;
		}
	
		public void initialize() {
		
			this.log = tvc.log;
			this.kbd = tvc.kbd;
		
		}
	
		public void keyTyped( KeyEvent e) {
			return;
		}

		public void keyPressed( KeyEvent e) {
				
			keyHandling( e, true);
		}
	
		public void keyReleased( KeyEvent e) {
			keyHandling( e, false);
		}
	
		public void keyHandling( KeyEvent e, boolean pressed) {
			
			String t = KeyEvent.getKeyText( e.getKeyCode());
//			char c = e.getKeyChar();
			
			tvc.kbd.setMatrix( t, pressed); 
			
//			log.write( "Keyboard: " + (pressed ? "pressed  - |" : "released - |") + t + "| " + c);		
			return;			
		}
	}

}