;
; ZENO:  June 11, 1986 by David Seidman
;
;   Modified Sept 4, 1986 by Ron Tansky to fix 40-character mode
;   Modified Oct 31, 1986 by Ron Tansky to further fix 40-character mode
;           and to fix graphics mode
;   Modified Jan 28, 1987 by Chris Blum to add code to support TTY mode
;           call ( AH=0EH ). Required by some clone BIOS implementations
;           ( DTK / ERSO for one ) because they do not issue any 'set
;           cursor' calls from within the TTY mode call. This causes
;           ZENO to lose its video offset and the display goes out to
;           lunch.
;   Modified May 29, 1987 by Lynn Ransdell to support KEDIT 3.51
;   Modified Jun 25, 1998 by Elviro Mirko to fix a problem with cursor
;           offset. Added little help on command-line params. Now there
;           must be a space before parameters. Added '/Q' parameter (quiet
;           mode). Check if already resident. Environment memory freed to
;           reduce memory occupied. Other little modifications.
;   Modified Jul 12,1999 by Elviro Mirko to reduce TSR memory (only 704 bytes)
;           Removed message 'may cause snow' (obsolete).
;   Modified Sep 15, 1999 by Elviro Mirko. Implemented read char/attr function
;           (08h). Some parts totally rewritten and optimized. Variables
;           reorganized. Increased TTY output speed. Added
;           multiple pages support. Added routines for line-feed (0Ah),
;           carriage return (0Dh), backspace (08h) and video scrolling.
;           Added partial support for 80x43 and 80x50 text modes
;           and for 82h and 83h modes (AT&T VDC overlay modes)
;   Modified Mar 30, 2000 by Elviro Mirko (v1.51). Reduced memory consumption
;           from 1072 to 1040 bytes. Removed /N option (useless).
;           Little bug corrected (bad-written programs which write
;           beyond the 25th line of the screen could change the
;           char attribute).
;   Modified Apr 28, 2000 by Elviro Mirko (v1.6). TTY output increased. Now
;           Zeno works only on 386+ machines.
;   Modified May 2, 2000 by Elviro Mirko (v1.62). Write char+attr (09h)
;           output increased.
;   Modified May 6, 2000 by Elviro Mirko (v1.63). Corrected a little bug
;           introduced in v1.62. Added clear screen speed-up routine (06h).
;           Thanks to Javier Gutirrez Chamorro for some code optimization.
;   Modified May 9, 2000 by Elviro Mirko (v1.7). Optimized scrolling   
;           routine. Zeno v1.7 may be loaded in CONFIG.SYS with the command
;           DEVICEHIGH=zeno17.exe /q. In this way required memory is only
;           864 bytes. Zeno v1.7 can't be uninstalled from memory. 
;           General code optimization (thanks to Javier Gutirrez Chamorro).
;           General speed-up of all routines.
;   Modified May 14, 2000 by Elviro Mirko (v1.71). Optimized code. Speeded-up
;           video mode check (different method).
;   Modified May 15, 2000 by Elviro Mirko (v1.72). Added 386+ CPU checking to
;           avoid system crashes in 8086 and 80286 machines. Enabled 'Invalid
;           command line' error message. Corrected 2 bugs (Zeno could
;           be installed more than once in memory if current video
;           mode was different from 03h,83h,02h,82h,07h and it wasn't
;           active in DOS windows, but only in fullscreen).
;   Modified May 19, 2000 by Elviro Mirko (v1.73). Added full support for
;           80x43 and 80x50 modes. Added speed up routine for scroll-up
;           function (06h). A bug corrected (sometimes the high part of
;           EAX register was overwritten by Zeno).
;   Modified May 22, 2000 by Elviro Mirko (v1.73). Fixed a bug: when 
;           out-of-screen coordinates were passed to Zeno using function 06h
;           it drew nothing, now it sets coords to the max and draws the
;           window. Fixed a bug: now char attribute is obtained using the
;           same method of the BIOS (and now 80x50 page 3 works perfectly).
;           Scroll-up routine optimized.
;

.386
        PAGE      ,132

CSEG    SEGMENT   USE16
        ASSUME    CS:CSEG, DS:NOTHING, ES:NOTHING
        org       0000h              ; For all device drivers

; resident part

Header            dd     -1          ; one device
                  dw     08000h      ; character device
StratA            dw     Strat       ; strategy entrance
IntrA             dw     Intr        ; interrupt entrance
                  db     'ZENO174$'  ; 8 character dummy name

dwscroll          dw     0           ; number of dwords to move when scrolling
video_vector      dd     0           ; old video vector (10h)
video_addr        dw     0           ; video port (3B4h or 3D4h)
video_seg         dw     0           ; video segment (B000h or B800h)
page_offset       dw     0           ; offset of page (page num * page dim)
video_ofst        dw     0,0,0,0     ; offset of every of 8 pages of
                  dw     0,0,0,0     ; text(char is at video_seg:video_ofst)
notext            db     0           ; text = 0, quiet mode = 1
vid_mode          db     0           ; video mode
active_page       db     0           ; active page
diff              db     0           ; increment of di and si in 06h function
tocopy            db     0           ; dwords of a line to scroll (06h)
is_odd            db     0           ; flag
onesixty          db     0A0h

cur_vid_mode      equ    449h        ; 40h:49h = current video mode (byte)
cursor_pos        equ    450h        ; 40h:50h = cursor position (8 words)
cursor_type       equ    460h        ; 40h:60h = cursor type (start / end) (w)
cur_page_num      equ    462h        ; 40h:62h = current page number (byte)
rows_minus_1      equ    484h        ; 40h:84h = rows on screen -1
cols_minus_1      equ    79          ; cols on screen -1

;-------------------------------
; enter here from int 10h
;-------------------------------

video_int:
        sti                          ; interrupts on
        pushf                        ; save flags
        push      es                 ; save es register 
        push      0                  ; 0 on stack
        pop       es                 ; es=0
        push      ax                 ; save ax
        mov       al,cs:vid_mode     ; get video mode in al
        cmp       al,3h              ; video mode = 3 ?
        je short  video_keep         ; Jump if equal
        cmp       al,83h             ; video mode = 83 ?
        je short  video_keep         ; Jump if equal
        cmp       al,2h              ; video mode = 2 ?
        je short  video_keep         ; Jump if equal
        cmp       al,82h             ; video mode = 82 ?
        je short  video_keep         ; Jump if equal
        cmp       al,7h              ; video mode = 7 ?
        je short  video_keep         ; Jump if equal
        pop       ax                 ; restore ax
        jmp short v_exit             ; Jump to exit
video_keep:
        pop       ax                 ; restore ax
        cmp       ah,14              ; to write as TTY
        je        TTY                ;
        cmp       ah,2               ; to set cursor pos
        je short  set_cursor_r       ;
        cmp       ah,9               ; to write char/attr
        je short  write_char         ;
        cmp       ah,10              ; to write char only
        je short  write_char         ;
        cmp       ah,3               ; to read cursor pos
        je short  route_read_cursor  ;
        cmp       ah,6               ; scroll up window
        je        scroll_up          ; 
        cmp       ah,1               ; to set cursor type
        je short  set_type           ;
        cmp       ah,5               ; to set page
        je short  route_set_page     ;
        cmp       ah,8               ; to read attribute
        je short  route_read_attr1   ;
v_exit:                              
        pop       es                 ; restore es
        test      ah,ah              ; to set video mode
        je short  route_set_mode     ; jump if set mode required
        cmp       ax,0FEFEh          ; check if resident
        jne short v_exit2            ; jump to exit if not equal
        mov       ax,0FF0Fh          ; value returned if already resident
        popf                         ; restore flags
        iret                         ; return from interrupt
v_exit2:
        popf                         ; restore flags
        jmp       cs:dword ptr video_vector ; hand off interrupt

set_cursor_r:
        jmp short set_cursor

route_set_page:
        jmp short route_set_page2

set_type:
        mov       es:cursor_type,cx  ; save type of cursor
        pop       es                 ; restore es
        popf                         ; restore flags
        jmp       cs:dword ptr video_vector ; hand off interrupt

route_set_mode:
        jmp short route_set_mode2

route_read_cursor:
        jmp short read_cursor

write_char:
        cld                          ; frontwards
        push      cx                 ; save cx
        push      dx                 ; save dx
        push      di                 ; save di
        push      es                 ; save es
        push      bx                 ; save bx
        and       bh,0Fh             ; page number MOD 16
        mov       bl,bh              ; page num in bl
        xor       bh,bh              ; bh=0
        shl       bx,1h              ; bx = numpage * 2
        mov       dx,es:cursor_pos[bx] ; get cursor pos from BIOS

; convert cursor position (in dx) into page offset (in di)
                                     
        push      ax                 ; save ax
        xor       ah,ah              ; clear high byte of ax
        mov       al,dh              ; move rows into al (ax)
        mov       bx,ax              ; mov y position into bx   
        shl       ax,7               ; shift ax 7 places to the left   y*128
        shl       bx,5               ; shift bx 5 places to the left   y*32
        add       ax,bx              ; add ax and bx together
        xor       dh,dh              ; dh = 0
        shl       dx,1               ; columns * 2
        add       ax,dx              ; add columns * 2 to ax
        mov       di,ax              ; get offset in di
        pop       ax                 ; restore ax

        add       di,cs:page_offset  ; add offset (for multi-page)
        mov       es,cs:video_seg    ; B000h or B800h
        pop       bx                 ; restore bx
        cmp       ah,9               ; write char & attr ?
        je short  both               ; jump if yes
a2:     stosb                        ; dump to screen
        inc       di                 ; di incremented a 2nd time (jump attr)
        loop short a2                ; write char until cx=0
        jmp short done               ; jump when done

route_read_attr1:
        jmp short route_read_attr2   ;

both:   push      eax                ; save eax
        mov       ah,bl              ; get attribute in ah
        shr       cx,1               ; num of chars/2 (I use dwords)
        jnc       noodd              ; carry set if cx was odd
        stosw                        ; write char & attr
        test      cx,cx              ; check no of chars
        jz short  done2              ; zero? Then jump
noodd:  push      ax                 ; duplicate the
        push      ax                 ; AX value in
        pop       eax                ; EAX register
        rep       stosd              ; write eax until cx=0
done2:  pop       eax                ; restore eax
done:   pop       es                 ; restore es
        pop       di                 ; restore di
        pop       dx                 ; restore dx
        pop       cx                 ; restore cx
        jmp short i_ret              ; return from interrupt

route_set_page2:
        jmp short set_page

set_cursor:
        push      bx                 ; save bx
        and       bh,0Fh             ; page number MOD 16
        mov       bl,bh              ; page num in bl
        xor       bh,bh              ; bh=0
        shl       bx,1h              ; bx = numpage * 2
        call      update_pos         ; update offset & cursor pos
i_ret2: pop       bx                 ; restore bx
i_ret:  pop       es                 ; restore es
        popf                         ; restore flags
        iret                         ; done

route_set_mode2:
        jmp short set_mode

read_cursor:
        push      bx                 ; save bx
        and       bh,0Fh             ; page number MOD 16
        mov       bl,bh              ; page num in bl
        xor       bh,bh              ; bh=0
        shl       bx,1h              ; bx = numpage * 2
        mov       dx,es:cursor_pos[bx] ; get cursor pos from BIOS
        mov       cx,es:cursor_type  ; get cursor type
        jmp short i_ret2             ; jump to exit

route_read_attr2:
        jmp short route_read_attr3   ;

set_page:
        push      bx                 ; save bx
        push      ax                 ; save ax
        pushf                        ; save flags
        call      cs:dword ptr video_vector ; call real interrupt
        mov       al,es:cur_page_num ; read new page number
        and       ax,0Fh             ; current page number MOD 16 (ah=0)
        mov       cs:active_page,al  ; store it in active_page
        mov       bx,1000h           ; 1000h words every page (80x25)
        cmp       byte ptr es:rows_minus_1,18h ; 24 lines?
        je short  video2             ; if yes, jump
        mov       bx,1BE0h           ; 1BE0h words every page (80x43)
        cmp       byte ptr es:rows_minus_1,2Ah ; 42 lines?
        je short  video2             ; if yes, jump
        mov       bx,2040h           ; 2040h words every page (80x50)
video2: push      dx                 ; save dx
        imul      ax,bx              ; dx:ax = page_size * ax
        pop       dx                 ; restore dx
        mov       cs:page_offset,ax  ; store new page offset
        pop       ax                 ; restore ax
        jmp short i_ret2             ; return from interrupt

set_mode:
        push      bx                 ; save bx
        mov       cs:active_page,0   ; set active page to 0
        call      change_mode        ; set new parameters (update variables)
        xor       bx,bx              ; bx=0
cycle:  mov       cs:video_ofst[bx],0 ; Clear all page offsets from 0 to 8
        inc       bx                 ; in video_ofst (8 pages = 16 bytes)
        cmp       bx,8h              ; 8 pages
        jne short cycle              ; Jump if not equal
        pop       bx                 ; restore bx
        popf                         ; restore flags
        jmp       cs:dword ptr video_vector ; hand off interrupt

i_ret4: pop       es                 ; restore es
        popf                         ; restore flags
        iret                         ; done

scroll_up:
        cmp       ch,es:rows_minus_1 ; upper row
        jbe short l1                 ; if below then jump 
        mov       ch,es:rows_minus_1 ; set upper row
l1:     cmp       dh,es:rows_minus_1 ; lower row
        jbe short l2                 ; if below then jump
        mov       dh,es:rows_minus_1 ; set lower row
        jmp short l2

route_read_attr3:
        jmp short route_read_attr4   ;

l2:     cmp       ch,dh              ; upper row <= lower row
        ja short  i_ret4             ; if no, then exit
        cmp       cl,4Fh             ; left column<=79?
        jbe short l3                 ; if below then jump
        mov       cl,4fh             ; left column=79
l3:     cmp       dl,4Fh             ; right column<=79?
        jbe short l4                 ; if below then jump
        mov       dl,4Fh             ; right column=79
l4:     cmp       cl,dl              ; left column<=right column
        ja short  i_ret4             ; if no, then exit
        push      ds                 ; save ds (es is already saved)
        pushad                       ; save all registers

        mov       bl,dh              ; max row in bl
        sub       bl,ch              ; bl=window size in rows
        cmp       al,bl              ; lines to scroll<window size?
        jb short  cont7              ; if yes, jump
        xor       al,al              ; lines to scroll=0
cont7:  mov       bl,al              ; lines to scroll in bl
        mov       di,cs:page_offset  ; get page offset in di
        mov       ds,cs:video_seg    ; ds=B800h or B000h
        push      ds                 ; save ds
        pop       es                 ; es=ds=B800h or B000h

; find and save DI and SI

        mov       al,ch              ; rows in al
        mul       cs:onesixty        ; ax=al*160 (160 bytes every line)
        add       di,ax              ; now I still have to add columns
        xor       ah,ah              ; ah=0
        mov       al,cl              ; get starting column in di
        shl       al,1               ; column*2
        add       di,ax              ; starting offset where to copy (ES:DI)

        mov       si,di              ; SI=DI now I have to adjust SI
        mov       al,bl              ; no. of lines to scroll in al
        mul       cs:onesixty        ; ax=al*160 (160 bytes every line)
        add       si,ax              ; now DS:SI points to the right location
        xor       ah,ah              ; ah=0
        push      bx                 ; save bx
        mov       al,dl              ; max columns in al
        mov       bl,050h            ; 80 columns (calculating increment)
        sub       al,cl              ; al=size of window in columns
        inc       al                 ; al=al+1 to compensate
        sub       bl,al              ; subtract window columns
        shl       bl,1               ; columns * 2
        mov       cs:diff,bl         ; store increment of di and si
        shr       al,1               ; I need the size of the line in dwords
        pop       bx                 ; restore bx
        jnc short okay               ; jump if no odd
        mov       byte ptr cs:is_odd,1 ; 1 if chars on a line are odd
        jmp short cont6              ; continue
okay:   mov       byte ptr cs:is_odd,0 ; 0 if chars on a line are even
        jmp short cont6

route_read_attr4:
        jmp short route_read_attr5   ;

cont6:  mov       byte ptr cs:tocopy,al ; save no. of dwords of every line
        test      bl,bl              ; if bl=0 then no lines to scroll
        jz short  over               ; jump and fill with empty lines
        mov       al,dh              ; max rows in al (ah is 0)
        push      dx                 ; save dx
        sub       al,ch              ; window size in rows
        push      cx                 ; save cx
        sub       al,bl              ; subtract no. of lines to scroll
        push      bx                 ; save bx
        inc       al                 ; al=al+1 to compensate 
                                     ; now ax=no. of lines to copy & paste
        mov       bx,ax              ; counter in bx
        mov       dx,1               ; jump flag
        mov       word ptr cs:[ch2+2],0A5A5h ; transform stosd into movsd

vid_loop:                            
        push      dx                 ; save jump flag
        xor       ch,ch              ; ch=0
        mov       dl,cs:diff         ; get increment in dl
        cmp       byte ptr cs:is_odd,1 ; is no. of chars of line odd?
        jz short  main_loop2         ; if yes, jump
        mov       byte ptr cs:[ch1],90h ; nop

main_loop2:
okay2:  mov       cl,byte ptr cs:tocopy ; no. of dwords to copy
ch2:    rep       movsd              ; write the remaining char of the line
ch1:    movsw                        ; write a word (1 video char)
        add       di,dx              ; increment di
        add       si,dx              ; increment si
        dec       bl                 ; decrement counter
        jnz short main_loop2         ; if not zero, jump
        pop       dx                 ; restore jump flag
        test      dl,dl              ; check the jump flag
        jz short  jump2              ; if zero, jump
        pop       bx                 ; restore bx
        pop       cx                 ; restore cx
        pop       dx                 ; restore dx

over:   mov       ah,bh              ; get attribute of new line in ah
        mov       al,20h             ; space
        push      ax                 ; duplicate
        push      ax                 ; value of ax in
        pop       eax                ; eax register
        test      bl,bl              ; lines to scroll=0?
        jnz short write_new_lines    ; if no, jump
        mov       bl,dh              ; max rows in bl
        sub       bl,ch              ; window size in rows
        inc       bl                 ; lines to scroll=size of window

write_new_lines:
        mov       word ptr cs:[ch2+2],0ABABh ; transform movsd into stosd
        xor       dx,dx              ; set jump flag to 0
        jmp short vid_loop           ; draw empty lines
jump2:  popad                        ; restore all registers
        pop       ds                 ; restore ds
        pop       es                 ; restore es
        popf                         ; restore flags
        iret                         ; return from interrupt

route_read_attr5:
        jmp short route_read_attr6   ;

video_exit:
        pop       es                 ; restore es
        popf                         ; restore flags
        jmp       cs:dword ptr video_vector ; hand off interrupt

TTY:
        push      bx                 ; save bx
        mov       bh,cs:active_page  ; page selected must be active page
        push      eax                ; save eax
        push      cx                 ; save cx
        push      dx                 ; save dx
        and       bh,0Fh             ; page number MOD 16
        mov       bl,bh              ; page num in bl
        xor       bh,bh              ; bh=0
        shl       bx,1h              ; bx = numpage * 2
        mov       dx,es:cursor_pos[bx] ; bios 40h:50h
        push      bx                 ; save bx (pagenum *2)
        push      dx                 ; save rows & columns
        push      ax                 ; save ax
        push      bx                 ; save bx
        xor       ah,ah              ; clear high byte of ax
        mov       al,dh              ; move rows into al (ax)
        mov       bx,ax              ; mov y position into bx   
        shl       ax,7               ; shift ax 7 places to the left   y*128
        shl       bx,5               ; shift bx 5 places to the left   y*32
        add       ax,bx              ; add ax and bx together
        pop       bx                 ; restore bx
        xor       dh,dh              ; dh = 0
        shl       dx,1               ; columns * 2
        add       ax,dx              ; add columns * 2 to ax
        mov       cs:video_ofst[bx],ax ; store new offs of current page (ax)
        pop       ax                 ; restore ax
        pop       dx                 ; restore rows & columns
        cmp       al,0Dh             ; char equal to 0D?
        ja short  printable_char     ; Jump if above (normal char)
        jnz short other_char         ; Jump if not zero (char < 0Dh)
        xor       dl,dl              ; Columns = 0
        jmp short rout               ; jump to end

route_read_attr6:
        jmp short route_read_attr7   ;

other_char:                          ; *** CONTROL CHARS ***
        cmp       al,8               ; char = backspace?
        jne short other_char_2       ; Jump if not equal
        test      dl,dl              ; Columns = Zero ?
        jz short  rout               ; Jump if col=zero
        dec       dl                 ; dec columns
        jmp short rout               ; jump to end

other_char_2:                        ; *** Continue to examine char ***
        cmp       al,0Ah             ; char is 0Ah? (Line Feed)
        je short  line_feed          ; if yes, jump
        cmp       al,7               ; char is 07? (Beep)
        jne short printable_char     ; Jump if not equal
        pop       bx                 ; so is a beep char...
        pop       dx                 ; restore bx,dx
        pop       cx                 ; restore cx
        pop       eax                ; restore ax
        pop       bx                 ; restore bx
        pop       es                 ; restore es
        popf                         ; restore flags
        jmp       cs:dword ptr video_vector ; hand off interrupt

printable_char:                      ; *** NORMAL CHARS ***
        mov       cl,al              ; save char to write
        push      es                 ; save es register
        mov       es,cs:video_seg    ; es=B800h or B000h
        mov       ax,cs:video_ofst[bx] ; bx is offset
        add       ax,cs:page_offset  ; get page offset in ax
        mov       bx,ax              ; and in bx
        mov       es:[bx],cl         ; write char in video memory
        inc       dl                 ; inc columns
        pop       es                 ; restore es after writing
        cmp       dl,cols_minus_1    ; compare dl with 79
        ja short  new_line           ; Jump if cols > 79
rout:   jmp short all2               ; jump to end

new_line:
        xor       dl,dl              ; columns=0 and new line

line_feed:                           ; *** CHAR =0Ah Line feed ***
        inc       dh                 ; Increment row
        mov       al,es:rows_minus_1 ; 40h:84h = rows on scr -1
        test      al,al              ; Zero ?
        jnz short cont3              ; Jump if not zero
        mov       al,18h             ; 24 lines by default if 40h:84h = 0
cont3:
        cmp       dh,al              ; compares rows to 24
        ja short  scroll_video       ; Jump if above
        jmp short all2               ; jump to end

route_read_attr7:
        jmp short read_attr          ;

scroll_video:                        ; **** scroll video ****
        mov       cl,al              ; rows-1 in cl (24)
        push      bx                 ; save bx
        xor       ah,ah              ; clear high byte of ax
        mov       bx,ax              ; mov y position into bx   
        shl       ax,3               ; shift ax 7 places to the left   y*8
        shl       bx,5               ; shift bx 5 places to the left   y*32
        add       ax,bx              ; ax=ax*40 (40 dwords per line)
        pop       bx                 ; restore bx
        mov       cs:dwscroll,ax     ; update number of dwords to scroll
        mov       dh,cl              ; cl = rows on screen - 1
        push      si                 ; save si
        push      di                 ; save di
        push      es                 ; save es
        push      ds                 ; save ds
        mov       bx,cs:page_offset  ; get page offset in bx
        mov       ds,cs:video_seg    ; ds=B800h or B000h
        push      ds                 ; save ds
        pop       es                 ; es=ds
        mov       di,bx              ; page offset in di
        mov       si,bx              ; page offset in si
        add       si,0A0h            ; si=si+160
        mov       cx,cs:dwscroll     ; cx=960 (40*24) dw to move up if 80x25
        rep       movsd              ; Rep when cx >0 Mov [si] to es:[di]
        mov       ax,cs:dwscroll     ; dwords to move up  
        shl       ax,2               ; ax*4
        add       ax,bx              ; add page offset (numpage * 4096)
        mov       di,ax              ; di = first char of last line
        mov       bx,ax              ; bx = first char of last line
        mov       ah,ds:[bx+1]       ; get attr of first char of 25th row
        mov       cx,28h             ; cx = 40
        mov       al,20h             ; write a new line made of spaces(20h)
        push      ax                 ; duplicate
        push      ax                 ; the value of ax
        pop       eax                ; into eax register
        rep       stosd              ; Rep when cx >0 Store ax to es:[di]
        pop       ds                 ; restore ds
        pop       es                 ; restore es
        pop       di                 ; restore di
        pop       si                 ; restore si
all2:   pop       bx                 ; restore bx
        call      update_pos         ; update offset & cursor pos

all_done:
        pop       dx                 ; restore dx
        pop       cx                 ; restore cx
        pop       eax                ; restore eax
i_ret3: pop       bx                 ; restore bx
        pop       es                 ; restore es
        popf                         ; restore flags
        iret                         ; done

read_attr:
        push      bx                 ; save bx
        mov       bl,bh              ; Get page number
        xor       bh,bh              ; bh=0
        shl       bx,1               ; page number *2
        mov       bx,cs:video_ofst[bx] ; bx=char offset
        add       bx,cs:page_offset  ; add page offset

        push      es                 ; save es
        mov       es,cs:video_seg    ; es=b800h or B000h
        mov       ax,es:[bx]         ; get char+attr in ax
        pop       es                 ; restore es
        jmp short i_ret3             ; return from interrupt

update_pos:                          ; dh=rows, dl=cols, bx = page num * 2
                                     ; CURSOR POSITION IS UPDATED IN BIOS
                                     ; ACCORDING TO DX. ON ACTIVE PAGE THE
                                     ; CURSOR IS ALSO MOVED ON SCREEN
        push      ax                 ; save ax
        push      dx                 ; save dx
        push      bx                 ; save bx
        mov       es:cursor_pos[bx],dx ; update cursor pos in BIOS
        push      bx                 ; save bx (page num * 2)
        xor       ah,ah              ; clear high byte of ax
        mov       al,dh              ; move rows into al (ax)
        mov       bx,ax              ; mov y position into bx   
        shl       ax,7               ; shift ax 7 places to the left   y*128
        shl       bx,5               ; shift bx 5 places to the left   y*32
        add       ax,bx              ; add ax and bx together
        pop       bx                 ; restore bx (page num * 2)
        xor       dh,dh              ; dh = 0
        shl       dx,1               ; columns * 2
        add       ax,dx              ; add columns * 2 to ax
        mov       cs:video_ofst[bx],ax ; store new offset of current page (ax)
        shr       bx,1               ; bx = active page
        cmp       bl,cs:active_page  ; working on active page?
        jne short offset_ready       ; Jump if not equal
        mov       bx,ax              ; get offset in bx
        add       bx,cs:page_offset  ; calc page offset
        shr       bx,1               ; page offset / 2
        mov       dx,cs:video_addr   ; video port (3B4h or 3D4h)
        mov       al,0Eh             ; cursor location (high byte)
        mov       ah,bh              ; get high byte
        out       dx,ax              ; port 0, DMA-1 bas&add ch 0
        inc       al                 ; al = 0Fh
        mov       ah,bl              ; get low byte
        out       dx,ax              ; port 0, DMA-1 bas&add ch 0

offset_ready:
        pop       bx                 ; restore bx
        pop       dx                 ; restore dx
        pop       ax                 ; restore ax
        retn                         ; return from procedure

change_mode       proc    near
        mov       cs:vid_mode,al     ; store new video mode
        cmp       al,7               ; video mode = 7 ?
        je short  video_ok           ; Jump if equal
        and       al,7Fh             ; 7Fh=01111111b
        cmp       al,3h              ; video mode = 3 ?
        je short  video_ok           ; Jump if equal
        cmp       al,2h              ; video mode = 2 ?
        jne short end_change         ; Jump if not equal

video_ok:
        push      bx                 ; save bx
        push      cx                 ; save cx
        mov       bx,0B800h          ; video segment for mode 2h, 3h, 82h, 83h
        mov       cx,3D4h            ; video port for mode 2h, 3h, 82h, 83h
        cmp       al,7               ; mono mode?
        jne short store_new_values   ; if no, then jump
        mov       bx,0B000h          ; video segment for mono mode (7h)
        mov       cx,3B4h            ; video port for mono mode (7h)

store_new_values:
        mov       cs:video_seg,bx    ; store new segment
        mov       cs:video_addr,cx   ; store new port
        mov       cs:page_offset,0h  ; page offset = 0
        pop       cx                 ; restore cx
        pop       bx                 ; restore bx

end_change:
        retn                         ; return from procedure
change_mode       endp

IOPacket          STRUC
IO_CMDLEN         db      ?
IO_UNIT           db      ?
IO_CMD            db      ?
IO_STATUS         dw      ?
                  db      8 DUP(?)
IO_MEDIA          db      ?
IO_ADDRESS        dw      ?
                  dw      ?
IO_COUNT          dw      ?
IO_START          dw      ?
IOPacket          ENDS

end_core:

Init    proc      far
        assume    DS:nothing, ES:nothing

Packet  dd        0                  ; Request packet address

Strat:  mov       word ptr Packet,bx ; Save Packet info
        mov       word ptr Packet+2,es
        ret

Intr:   push      bx                 ; Save registers
        push      ds

; initialization code

        push      ax
        push      cx
        push      dx
        push      si
        push      di
        push      es

; check for 32-bit code support (386+)

        xor       dx,dx              ; clear dx                     
        push      dx                 ;
        popf                         ; clear flags                  
        pushf                        ;
        pop       ax                 ; load cleared flags           
        and       ax,0F000h          ; check hi bits for F0h        
        cmp       ax,0F000h          ;
        je short  no_support         ; quit if 8088                 
        mov       ax,0F000h          ; now check for 80286          
        push      ax                 ;
        popf                         ;
        pushf                        ;
        pop       ax                 ; if the top 4 bits aren't set 
        and       ax,0F000h          ; it's a 80286+
        jne short ok_go_on           ; ok, it's a 80386+

no_support:
        lea       si,cs:auth_msg     ; get message
        call      write_msg          ; write message
        lea       dx,cs:no_supp      ; get error message
        mov       ah,9h              ; write string
        int       21h                ; call interrupt
        mov       byte ptr cs:installed,1 ; don't install
        jmp       exit2              ; jump to exit

; check for color screen; set video segment

ok_go_on:
        push      cs
        pop       ds
        mov       cs:video_seg,0B000h ; assume mono
        mov       cs:video_addr,03B4h ; assume mono
        int       11h                ; for equip check
        and       ax,30h             ; isolate adapter
        cmp       ax,30h             ; check for mono
        je short  mono_screen        ; go if found
        mov       cs:video_seg,0B800h ; reset for color
        mov       cs:video_addr,03D4h ; reset for color
mono_screen:

; check command line

        push      ds                 ; save ds
        lds       bx,dword ptr Packet
        lds       si,dword ptr [bx+IO_COUNT] ; get command line
bypass: lodsb                        ; Get CMD character
        cmp       al,0Dh             ; CR code?
        je short  command_clear      ; Yes, done with analysis
        cmp       al,0Ah             ; LF code?
        je short  command_clear      ; Yes, done with analysis
        cmp       al,1Ah             ; EOF code?
        je short  command_clear      ; Yes, done with analysis
        cmp       al,'/'             ; Switch?
        je short  delimit            ; if found, jump
        jmp short bypass             ; No, skip garbage

delimit:
        lodsb                        ; Get a character
        cmp       al,0Dh             ; CR code?
        je short  command_clear      ; Yes, done with analysis
        cmp       al,0Ah             ; LF code?
        je short  command_clear      ; Yes, done with analysis
        cmp       al,1Ah             ; EOF code?
        je short  command_clear      ; Yes, done with analysis
        cmp       al,'q'             ; valid switch?
        je short  set_n_go           ; if yes, quiet mode enabled
        cmp       al,'Q'             ; valid switch?  
        je short  set_n_go           ; if yes, quiet mode enabled
retry:
        pop       ds                 ; restore ds
        lea       si,cs:auth_msg     ; get auth message
        call      write_msg          ; write message
        lea       dx,cs:retry_msg    ; get error message
        mov       ah,9h              ; write string
        int       21h                ; call interrupt
        mov       byte ptr cs:installed,1 ; don't install
        jmp short r_exit2            ; jmp to exit

set_n_go:
        pop       ds                 ; restore ds
        mov       cs:notext,1        ; quiet mode on
        jmp short cont2              ; jump messages and continue

command_clear:
        pop       ds                 ; restore ds
        lea       si,cs:auth_msg     ; get message
        call      write_msg          ; print message on screen
cont2:

; check if already in memory

        mov       ax,0FEFEh          ; value used for check
        xor       bx,bx              ; bx=0
        int       10h                ; call video interrupt
        cmp       ax,0FF0Fh          ; if ax=0FF0Fh then it's already in mem
        jne short cnt                ; else continue
        lea       dx,cs:warn_msg     ; get message
        mov       ah,9h              ; write string
        int       21h                ; call interrupt
        mov       byte ptr cs:installed,1 ; don't install
r_exit2:jmp short exit2              ; jump to exit

; find and set current variables

cnt:    push      ds                 ; save ds
        push      0                  ; push 0 on stack
        pop       ds                 ; ds = 0
        mov       al,ds:cur_vid_mode ; get current mode 40h:49h
        mov       cs:vid_mode,al     ; save video mode
        mov       al,ds:cur_page_num ; get active page  40h:62h
        mov       cs:active_page,al  ; save active page
        mov       cx,8h              ; calc offset of 8 pages
        xor       di,di              ; di = 0
o_fill: mov       dx,ds:cursor_pos[bx] ; get cursor position from BIOS
        xor       ax,ax              ; ax = 0
        push      bx                 ; save bx
        xor       ah,ah              ; clear high byte of ax
        mov       al,dh              ; move rows into al (ax)
        mov       bx,ax              ; mov y position into bx   
        shl       ax,7               ; shift ax 7 places to the left   y*128
        shl       bx,5               ; shift bx 5 places to the left   y*32
        add       ax,bx              ; add ax and bx together
        pop       bx                 ; restore bx
        xor       dh,dh              ; dh = 0
        shl       dl,1               ; dx = columns * 2
        add       ax,dx              ; add columns * 2 to ax
        mov       cs:video_ofst[di],ax ; update offset (ax)
        add       bx,2               ; inc bx by a word
        add       di,2               ; inc di by a word
        loop short o_fill            ; repeat for every of 8 pages
        pop       ds                 ; save ds
;
; set video interrupt
;
        push      es                 ; save
        mov       ax,3510h           ; to get vector
        int       21h                ; get vector
        mov       word ptr cs:video_vector,bx ; store offset
        mov       word ptr cs:video_vector+2,es ; store segment
        pop       es                 ; restore
        mov       ax,2510h           ; to set video vector
        lea       dx,cs:video_int    ; get offset; ds OK
        int       21h                ; set vector
;
; print messages; terminate and stay resident
;
        cmp       cs:notext,1        ; no output?
        je short  exit2              ; ok!
        lea       dx,cs:install_msg  ; get message
        mov       ah,9h              ; write string
        int       21h                ; call interrupt

exit2:  pop       es
        pop       di
        pop       si
        pop       dx
        pop       cx
        pop       ax
        jmp       exit

install_msg       db   13,10,'ZENO v1.74 successfully installed.',13,10,'$'
warn_msg          db   13,10,'ZENO v1.74 already installed!',13,10,'$'
auth_msg          db   ''
                  db   'ͻ',13,10
                  db   ' ZENO v1.74 - Extra fast video '
                  db   'output accelerator ',13,10
                  db   ' by Elviro Mirko (beast2@freemail.it)'
                  db   '             ',13,10
                  db   ' May,22 2000                         '  
                  db   '             ',13,10
                  db   ''
                  db   'ͼ',13,10,0
retry_msg         db   13,10,'No action: Invalid command line',13,10
                  db   'Valid command line parameters:',13,10
                  db   '/Q Start in quiet mode',13,10,7,'$'
no_supp           db   13,10
                  db   'No action: a 386 or better CPU required!',13,10,'$'
installed         db   0
cursor_temp1      db   0
cursor_temp2      db   0
cur_page_temp     dw   0

write_msg         proc near
        push      bx                 ; save bx
        push      es                 ; save es
        push      0                  ;
        pop       es                 ; es=0
        mov       bl,es:cur_page_num ; current page number
        xor       bh,bh              ; bx=current page number
        mov cs:cur_page_temp,bx      ; store current page number
        mov       ah,3               ; get cursor pos on current page
        mov       bh,byte ptr cs:cur_page_temp ; get current page in bh
        int       10h                ; get cursor loc in dx, mode cx
        mov       word ptr cs:cursor_temp1,dx  ; save cursor position
main_loop:
        mov       al,[si]            ; get char
        cmp       al,0Ah             ; line feed?
        je short  l_feed             ; jump if equal
        cmp       al,0Dh             ; carriage return?
        je short  c_return           ; jump if equal
        test      al,al              ; end of message?
        jz short  end_writing        ; if yes, jump to end
        mov       ah,9               ; write char+attr
        mov       bl,1Eh             ; yellow on blue
        mov       bh,byte ptr cs:cur_page_temp ; get current page in bh
        mov       cx,1               ; number of chars to write
        int       10h                ; call video interrupt
        inc       byte ptr cs:cursor_temp1 ; inc cursor position
        jmp short move_cursor
l_feed:
        inc       byte ptr cs:cursor_temp2 ; increment rows
        jmp short c_scroll
c_return:
        mov       byte ptr cs:cursor_temp1,0 ; columns=0
c_scroll:
        mov       bh,byte ptr es:rows_minus_1 ; get screen lines
        cmp       bh,byte ptr cs:cursor_temp2 ; last line?
        jae short move_cursor        ; if not, jump
        xor       bl,bl              ; columns=0
        mov       word ptr cs:cursor_temp1,bx ; set max lines in cursor pos
        mov       dx,bx              ; calculate lower right corner
        add       dx,4Fh             ; add 79 to obtain lower right corner
        xor       cx,cx              ; upper left corner=0,0
        mov       ax,601h            ; scroll up 1 line
        mov       bh,7               ; attribute of chars of new line
        int       10h                ; scroll
move_cursor:
        mov       ah,2               ; set cursor position
        mov       bh,es:cur_page_num ; current page number
        mov       dx,word ptr cs:cursor_temp1 ; cursor position in dx
        int       10h                ; set cursor
        inc       si                 ; next character to read
        jmp short main_loop          ; jump and read new char

end_writing:
        pop       bx
        pop       es
        ret
write_msg         endp

Exit:
        assume    DS:nothing, ES:nothing
        lds       bx,dword ptr Packet ; restore packet info
        mov       word ptr [BX+IO_ADDRESS],offset End_core ; set memory
        mov       word ptr [BX+IO_ADDRESS+2],cs ; to be resident
        mov       [bx+IO_STATUS],00100h ; set done bits
        pop       ds                 ; restore registers used
        pop       bx
        ret                          ; exit device installaion
Init	ENDP

EXEPacket         IOPacket        <> ; Requires packet space

Start   proc      near               ; Execute DDD installation
        mov       sp,offset StackTop ; Shorten stack
        push      es                 ; Save PSP segment
        mov       ah,049H            ; Release environment
        mov       es,es:0002Ch       ; 2Ch = environment
        int       21h                ; release memory
        push      cs                 ; DS = CS
        pop       ds
        assume    ds:CSEG
        pop       ax                 ; ES:0081 = Command string
        mov       EXEPacket.IO_COUNT+2,ax ; Put address in packet
        mov       EXEPacket.IO_COUNT,00081h
        sub       al,al              ; 0 = Initialize DDD
        mov       EXEPacket.IO_CMD,al ; Put command in packet
        mov       bx,offset EXEPacket ; ES:BX = packet address
        push      cs
        pop       es
        assume    es:CSEG
        push      cs                 ; FAR return
        call      StratA             ; Perform strategy
        push      cs                 ; FAR return
        call      IntrA              ; Perform interrupt
        cmp       byte ptr cs:installed,1 ; if installed=1, don't install
        je short  ended              ; skip installation
        mov       dx,EXEPacket.IO_ADDRESS ; Get ending address
        add       dx,0010Fh          ; add PSP and round up
        shr       dx,4               ; convert to paragraphs
        mov       ax,03100h          ; DOS stay resident function
        int       021h               ; call DOS interrupt
ended:  mov       ah,4ch             ; terminate program
        int       21h
                  dw      80h DUP (?)
StackTop          dw      0
Start	ENDP
CSEG	ENDS
        END       Start


