;----------------------------------------------
; SAA1099P test program for TVC
; 2013 RetroHW
;
; Source:
;        http://sdinterface.atw.hu (TVC demo)
;        http://wwww.micklab.narod.ru (ETunes)
;        http://www.keprt.cz (Songs)
;----------------------------------------------

.org 6639
	.db	0FH,0AH,0,0DDH
	.db	" USR"
	.db	96H,"6659"
	.db	95H,0FFH,0,0,0,0,0	; 20 byte-os fej
;
prog:	jp	pmain			; program kezdete
;
psave	.db	070h			; P_SAVE mentett rtke (program indulsakor a memrialapozs)
xitflag	.db	0

;----------------------------------------------
;----------------- FŐPROGRAM -----------------
;----------------------------------------------
pmain:	exx				; fprogram
	push	bc
	push	de
	push	hl
	exx
	ld	a,(00003h)		; A reg.= P_SAVE (aktulis memrialapozs)
	ld	(psave),a		; ments a sajt vltozba
;
	ld	c,000h			; VMODE grafikus md: 0-ktszn 1-ngy 2-tizenhat
	rst	30h
	.db	4
	ld	hl,introtxt		; ismertet kirsa
	call	ut_prnt

	ld	c,255
	ld	b,28
	out	(c),b
	ld	c,254
	ld	b,1
	out	(c),b                   ;SAA engedlyezs

	ld	c,3
	ld	b,2
	out	(c),b
	ld      hl,songdata
        ld	(EPlayerInit+1),hl            ;tadjuk a dal cmt

        call	EPlayerInit			; Inicializljuk a playert

	call	intat                         ; Interrupt tlltsa
task:
        di
	ld	c,058H
	in	a,(c)
	xor	10111111b			; ha Q-t nyomott akkor kilpnk
	jp	z,exit
	ei
	jp task

exit:
	call	intvissza                     ; Interrupt visszalltsa

	ld	c,255
	ld	b,28
	out	(c),b
	ld	c,254
	ld	b,0
	out	(c),b                   ; SAA disable

	rst	30h
	.db	5			; CLS

	ld	a,(psave)		; elmentett P_SAVE vissza A reg.-be
	ld	(0003h),a		; eredeti memrialapozs visszalltsa
	out	(002h),a
	exx
	pop	hl
	pop	de
	pop	bc
	exx
	ret
;----------------------------------------------
;----------------- vge -----------------------
;----------------------------------------------

;------------megszaktskezel----------------
; trs sajt megszaktskezel alprogramra

intat:

	di				; megszak. tilt
	ld	a,(0B12h)		; A reg.= Port5 tkrkpe
	res	5,a			; hang IT tiltva
	res	4,a			; hangjel is tiltva
	ld	(0B12h),a		; j rtk a memriba
	out	(005h),a		; s a portra

	ld	a,00Ah			; CRTC R10-es regiszterben a kurzor engedlyezse
	out	(070h),a
	ld	a,003h
	out	(071h),a
	ld	a,0C3h			; A reg.= JP XXXX kdja
	ld	(0038h),a		; megszaktsrutin els bjtjnak trsa
	ld	hl,sajatint
	ld	(0039h),hl		; ugrutasts clcm bersa
	ei				; megszak. eng.
	ret

intvissza:
	di				; megszak. tilt
	ld	hl,L1D2F		; HL= eredeti megszak. rutin visszalltand kdrszlete
	ld	de,0038h		; DE= megszak. cme
	ld	bc,0003h		; BC= 3 bjt lesz
	ldir				; bjtok msolsa
	ld	a,(0B12h)		; A reg.= Port5 tkrkpe
	res	5,a			; hang IT tiltva
	res	4,a			; hangjel is tiltva
	ld	(0B12h),a		; j rtk a memriba
	out	(005h),a		; s a portra
	ld	a,00Ah			; CRTC R10-es regiszterben a kurzor engedlyezse
	out	(070h),a
	ld	a,003h
	out	(071h),a
	ei				; megszak. eng.
	ret
;
;	Eredeti megszak. rutin visszalltand kdrszlete
;
L1D2F:	push	af
	ld	a,070h

;
;
;	Sajt megszakts-kiszolgl rutin
;
sajatint:
	di				; tovbbi megszak. tilt
	push	af			; A reg. mentse
	ld	a,090h			; memrialapozs: U0,U1,VID,U3
	out	(002h),a		; memrialapozs belltsa
	out	(007h),a		; kurzor/hang megszak. krs trlse

		push	hl
		push	bc
		push	de
		push	af

		call	EPlayerPlay

		pop	af
		pop	de
		pop	bc
		pop	hl

	ld	a,(0003h)		; eredeti memrialapozs vissza
	out	(002h),a
	pop	af			; A reg. vissza
	ei				; megszak. eng
	ret				; visszatrs

;------------------------
;szubrutinok vge

;----------------------------------------------
;----------------- fggvnyek -----------------
;----------------------------------------------

;----------------------------------------------
;	Szveg kirsa az aktulis vagy adott xy pozciba
;	in:  B  - X poz. ('ut_prn0'-nl belpve)
;	     C  - Y poz. ('ut_prn0'-nl belpve)
;	     HL - 0-val lezrt string kezdete
;	out: HL - a lezr nulla utni cm
;

ut_prnt:ld	bc,0000h		; aktulis pozciba r
ut_prn0:rst	30h			; kurzor-pozicionls
	.db	023h			; CPOS
ut_prn1:ld	a,(hl)
	inc	hl
	or	a
	ret	z
	ld	c,a
	rst	30h			; karakter kirsa
	.db	021h			; ED_CHOUT
	jr	ut_prn1


;----------------------------------------------
;----------------------------------------------
;----------------------------------------------

introtxt
	.text	"SAA1099P teszt program TVC-re\r\n\r\n"
	.text	"Kilps Q billenty megnyomsval...\r\n\r\n"
	.text	"\r\n\r\nevil.sng\r\n\r\n\r\n\r\n2013 RetroHW\r\n"
	.text	"\r\n\000"

songdata
;Converted by bin2hex script for TASM
;http://retrohw.com
;File original size: 4605bytes

	.db	059H, 010H, 089H, 010H, 02BH, 010H, 045H, 010H, 051H, 010H, 045H, 054H, 072H, 061H, 063H, 06BH
	.db	065H, 072H, 020H, 028H, 043H, 029H, 020H, 042H, 059H, 020H, 045H, 053H, 049H, 02EH, 05BH, 035H
	.db	011H, 087H, 0FFH, 0E3H, 051H, 0FFH, 0E3H, 051H, 053H, 08FH, 0D5H, 091H, 0D5H, 096H, 0D5H, 099H
	.db	0D5H, 08FH, 0D5H, 091H, 0D5H, 096H, 0D5H, 099H, 0D5H, 08AH, 0D5H, 08DH, 0D5H, 091H, 0D5H, 096H
	.db	0D5H, 08AH, 0D5H, 08DH, 0D5H, 091H, 0D5H, 096H, 0D5H, 051H, 020H, 0FFH, 0D3H, 05AH, 011H, 0A5H
	.db	0D3H, 015H, 0D3H, 011H, 0A4H, 0D3H, 015H, 0D3H, 011H, 0A0H, 0D3H, 015H, 0D3H, 011H, 09BH, 0D3H
	.db	015H, 0D3H, 051H, 0FFH, 0D3H, 05AH, 035H, 011H, 0A5H, 0D3H, 015H, 0D3H, 011H, 0A4H, 0D3H, 015H
	.db	0D3H, 011H, 0A0H, 0D3H, 015H, 0D3H, 011H, 09BH, 0D5H, 051H, 056H, 010H, 09DH, 0D2H, 017H, 09DH
	.db	0D2H, 01BH, 09DH, 0D2H, 01DH, 09DH, 0D2H, 011H, 09DH, 0D2H, 017H, 09DH, 0D2H, 01BH, 09DH, 0D2H
	.db	01DH, 09DH, 0D2H, 054H, 034H, 011H, 08AH, 0D2H, 010H, 0DCH, 056H, 011H, 09DH, 0D2H, 017H, 09DH
	.db	0D2H, 01BH, 09DH, 0D2H, 01EH, 09DH, 0D2H, 054H, 011H, 08AH, 0D2H, 010H, 0D8H, 056H, 010H, 09DH
	.db	0D2H, 017H, 09DH, 0D2H, 01BH, 09DH, 0D2H, 01DH, 09DH, 0D2H, 011H, 09DH, 0D2H, 017H, 09DH, 0D2H
	.db	01BH, 09DH, 0D2H, 01DH, 09DH, 0D2H, 054H, 011H, 08AH, 0D2H, 010H, 0D8H, 05AH, 011H, 0A5H, 0D3H
	.db	015H, 0D3H, 011H, 0A4H, 0D3H, 015H, 0D3H, 011H, 0A0H, 0D3H, 015H, 0D3H, 011H, 09BH, 0D3H, 015H
	.db	0D3H, 051H, 05AH, 0A2H, 0D2H, 0A5H, 0D2H, 0A2H, 0D2H, 09DH, 0D2H, 0A5H, 0D2H, 0A2H, 0D2H, 09DH
	.db	0D2H, 0A5H, 0D2H, 0A2H, 0D2H, 09DH, 0D2H, 0A5H, 0D2H, 0A2H, 0D2H, 09DH, 0D2H, 0A7H, 0D2H, 0A2H
	.db	0D2H, 09DH, 0D2H, 0A9H, 0D2H, 0A2H, 0D2H, 09DH, 0D2H, 0A9H, 0D2H, 0A2H, 0D2H, 09DH, 0D2H, 0A9H
	.db	0D2H, 0A2H, 0D2H, 09DH, 0D2H, 0ACH, 0D2H, 0A2H, 0D2H, 09DH, 0D2H, 0ACH, 0D2H, 0A2H, 0D2H, 09DH
	.db	0D2H, 0ACH, 0D2H, 0A2H, 0D2H, 0ABH, 0D2H, 0A2H, 0D2H, 09DH, 0D2H, 0ABH, 0D2H, 0A2H, 0D2H, 09DH
	.db	0D2H, 0ABH, 0D2H, 0A2H, 0D2H, 09DH, 0D2H, 0A9H, 0D2H, 0A2H, 0D2H, 09DH, 0D2H, 0A9H, 0D2H, 0A2H
	.db	0D2H, 09DH, 0D2H, 0A7H, 0D2H, 0A2H, 0D2H, 09DH, 0D2H, 0A7H, 0D2H, 0A2H, 0D2H, 09DH, 0D2H, 0A9H
	.db	0D2H, 0A2H, 0D2H, 09DH, 0D2H, 0ACH, 0D2H, 0A2H, 0D2H, 09DH, 0D2H, 0ACH, 0D2H, 0A2H, 0D2H, 09DH
	.db	0D2H, 0ACH, 0D2H, 051H, 0D2H, 05DH, 030H, 011H, 08AH, 0D2H, 08AH, 0D2H, 08AH, 0D5H, 08AH, 0D3H
	.db	08AH, 0D2H, 08AH, 0D2H, 08AH, 0D7H, 08AH, 0D2H, 08AH, 0D2H, 08AH, 0D5H, 08AH, 0D3H, 08AH, 0D2H
	.db	08AH, 0D2H, 091H, 0D3H, 091H, 0D3H, 091H, 0D3H, 08FH, 0D2H, 08FH, 0D2H, 08FH, 0D3H, 08FH, 0D3H
	.db	08FH, 0D3H, 08FH, 0D2H, 08FH, 0D2H, 08FH, 0D4H, 08FH, 0D2H, 08FH, 0D3H, 08FH, 0D2H, 08FH, 0D2H
	.db	08FH, 0D4H, 08FH, 0D4H, 08FH, 0D2H, 08FH, 0D2H, 08FH, 0D4H, 08FH, 0D2H, 08FH, 0D2H, 051H, 0D2H
	.db	05DH, 031H, 011H, 08AH, 0D2H, 08AH, 0D2H, 08AH, 0D5H, 08AH, 0D3H, 08AH, 0D2H, 08AH, 0D2H, 08AH
	.db	0D7H, 030H, 08AH, 0D2H, 08AH, 0D2H, 08AH, 0D5H, 08AH, 0D3H, 08AH, 0D2H, 08AH, 0D2H, 091H, 0D3H
	.db	091H, 0D3H, 091H, 0D3H, 08FH, 0D2H, 08FH, 0D2H, 08FH, 0D3H, 08FH, 0D3H, 08FH, 0D3H, 08FH, 0D2H
	.db	08FH, 0D2H, 08FH, 0D4H, 08FH, 0D2H, 08FH, 0D3H, 08FH, 0D2H, 08FH, 0D2H, 08FH, 0D4H, 08FH, 0D4H
	.db	08FH, 0D2H, 08FH, 0D2H, 08FH, 0D4H, 08FH, 0D2H, 08FH, 0D2H, 051H, 0D2H, 05DH, 031H, 08AH, 0D2H
	.db	08AH, 0D2H, 08AH, 0D5H, 08AH, 0D3H, 08AH, 0D2H, 08AH, 0D2H, 08AH, 0D7H, 030H, 08AH, 0D2H, 08AH
	.db	0D2H, 08AH, 0D5H, 08AH, 0D3H, 08AH, 0D2H, 08AH, 0D2H, 091H, 0D3H, 091H, 0D3H, 091H, 0D3H, 08FH
	.db	0D2H, 08FH, 0D2H, 08FH, 0D3H, 08FH, 0D3H, 08FH, 0D3H, 08FH, 0D2H, 08FH, 0D2H, 08FH, 0D4H, 08FH
	.db	0D2H, 08FH, 0D3H, 08FH, 0D2H, 08FH, 0D2H, 08FH, 0D4H, 08FH, 0D4H, 08FH, 0D2H, 08FH, 0D2H, 08FH
	.db	0D4H, 08FH, 0D2H, 08FH, 0D2H, 051H, 056H, 010H, 09DH, 0D2H, 017H, 09DH, 0D2H, 01BH, 09DH, 0D2H
	.db	01DH, 09DH, 0D2H, 011H, 09DH, 0D2H, 017H, 09DH, 0D2H, 01BH, 09DH, 0D2H, 01DH, 09DH, 0D2H, 054H
	.db	034H, 011H, 08AH, 0D2H, 010H, 0DCH, 056H, 011H, 09DH, 0D2H, 017H, 09DH, 0D2H, 01BH, 09DH, 0D2H
	.db	01EH, 09DH, 0D2H, 054H, 011H, 08AH, 0D2H, 010H, 0F8H, 051H, 05BH, 035H, 022H, 0AEH, 0FFH, 0E3H
	.db	051H, 05EH, 022H, 0AEH, 0FFH, 0E3H, 051H, 05BH, 022H, 0AEH, 0FFH, 0E3H, 051H, 05BH, 022H, 0ACH
	.db	0F1H, 0AEH, 0F1H, 051H, 05BH, 022H, 0B5H, 0F1H, 0ACH, 0F1H, 051H, 05BH, 022H, 096H, 0F1H, 0AEH
	.db	0F1H, 051H, 05BH, 022H, 096H, 0F1H, 022H, 0AEH, 0F1H, 051H, 05BH, 022H, 0A2H, 0D2H, 09DH, 0D2H
	.db	096H, 0D2H, 096H, 0D2H, 057H, 033H, 024H, 0BAH, 0D2H, 05BH, 035H, 022H, 0A2H, 0D2H, 0A2H, 0D2H
	.db	0A2H, 0D2H, 033H, 024H, 0C6H, 0D2H, 035H, 022H, 0A2H, 0D2H, 096H, 0D2H, 096H, 0D2H, 057H, 033H
	.db	024H, 0BAH, 0D2H, 05BH, 035H, 022H, 0A2H, 0D2H, 033H, 024H, 0C6H, 0D2H, 035H, 022H, 0A2H, 0D2H
	.db	022H, 0A2H, 0D2H, 09DH, 0D2H, 096H, 0D2H, 096H, 0D2H, 057H, 033H, 024H, 0BAH, 0D2H, 05BH, 035H
	.db	022H, 0A2H, 0D2H, 0A2H, 0D2H, 0A2H, 0D2H, 033H, 024H, 0C6H, 0D2H, 035H, 022H, 0A2H, 0D2H, 096H
	.db	0D2H, 096H, 0D2H, 057H, 033H, 024H, 0BAH, 0D2H, 05BH, 035H, 022H, 0A2H, 0D2H, 033H, 024H, 0C6H
	.db	0D2H, 035H, 022H, 0A2H, 0D2H, 022H, 0A7H, 0D2H, 0A2H, 0D2H, 09BH, 0D2H, 09BH, 0D2H, 057H, 033H
	.db	024H, 0BAH, 0D2H, 05BH, 035H, 022H, 0A7H, 0D2H, 0A7H, 0D2H, 0A7H, 0D2H, 033H, 024H, 0CBH, 0D2H
	.db	035H, 022H, 0A7H, 0D2H, 09BH, 0D2H, 09BH, 0D2H, 057H, 033H, 024H, 0BAH, 0D2H, 05BH, 035H, 022H
	.db	0A7H, 0D2H, 033H, 024H, 0CBH, 0D2H, 035H, 022H, 0A7H, 0D2H, 022H, 0A7H, 0D2H, 0A2H, 0D2H, 09BH
	.db	0D2H, 09BH, 0D2H, 057H, 033H, 024H, 0BAH, 0D2H, 05BH, 035H, 022H, 0A7H, 0D2H, 0A7H, 0D2H, 0A7H
	.db	0D2H, 033H, 024H, 0CBH, 0D2H, 035H, 022H, 0A7H, 0D2H, 09BH, 0D2H, 09BH, 0D2H, 057H, 033H, 024H
	.db	0BAH, 0D2H, 05BH, 035H, 022H, 0A7H, 0D2H, 033H, 024H, 0CBH, 0D2H, 035H, 022H, 0A7H, 0D2H, 051H
	.db	05BH, 022H, 0AAH, 0D2H, 0A5H, 0D2H, 09EH, 0D2H, 09EH, 0D2H, 057H, 033H, 024H, 0BAH, 0D2H, 05BH
	.db	035H, 022H, 0AAH, 0D2H, 0AAH, 0D2H, 0AAH, 0D2H, 033H, 024H, 0C6H, 0D2H, 035H, 022H, 0AAH, 0D2H
	.db	09EH, 0D2H, 09EH, 0D2H, 057H, 033H, 024H, 0BAH, 0D2H, 05BH, 035H, 022H, 0AAH, 0D2H, 033H, 024H
	.db	0C6H, 0D2H, 035H, 022H, 09EH, 0D2H, 022H, 0AAH, 0D2H, 0A5H, 0D2H, 09EH, 0D2H, 09EH, 0D2H, 057H
	.db	033H, 024H, 0BAH, 0D2H, 05BH, 035H, 022H, 0AAH, 0D2H, 0AAH, 0D2H, 0AAH, 0D2H, 033H, 024H, 0C6H
	.db	0D2H, 035H, 022H, 0AAH, 0D2H, 09EH, 0D2H, 09EH, 0D2H, 057H, 033H, 024H, 0BAH, 0D2H, 05BH, 035H
	.db	022H, 0AAH, 0D2H, 033H, 024H, 0C6H, 0D2H, 035H, 022H, 09EH, 0D2H, 022H, 0AFH, 0D2H, 0AAH, 0D2H
	.db	0A3H, 0D2H, 0A3H, 0D2H, 057H, 033H, 024H, 0BAH, 0D2H, 05BH, 035H, 022H, 0AFH, 0D2H, 0AFH, 0D2H
	.db	0AFH, 0D2H, 033H, 024H, 0C6H, 0D2H, 035H, 022H, 0AFH, 0D2H, 0A3H, 0D2H, 0A3H, 0D2H, 057H, 033H
	.db	024H, 0BAH, 0D2H, 05BH, 035H, 022H, 0A3H, 0D2H, 033H, 024H, 0C6H, 0D2H, 035H, 022H, 0A3H, 0D2H
	.db	022H, 0AFH, 0D2H, 0AAH, 0D2H, 0A3H, 0D2H, 0A3H, 0D2H, 057H, 033H, 024H, 0BAH, 0D2H, 05BH, 035H
	.db	022H, 0AFH, 0D2H, 0AFH, 0D2H, 0AFH, 0D2H, 033H, 024H, 0C6H, 0D2H, 035H, 022H, 0AFH, 0D2H, 0A3H
	.db	0D2H, 0A3H, 0D2H, 057H, 033H, 024H, 0BAH, 0D2H, 05BH, 035H, 022H, 0A3H, 0D2H, 033H, 024H, 0C6H
	.db	0D2H, 035H, 022H, 0A3H, 0D2H, 051H, 05BH, 022H, 0B1H, 0D2H, 0ACH, 0D2H, 0A5H, 0D2H, 0A5H, 0D2H
	.db	057H, 033H, 024H, 0BAH, 0D2H, 05BH, 035H, 022H, 0B1H, 0D2H, 0B1H, 0D2H, 0B1H, 0D2H, 033H, 024H
	.db	0C6H, 0D2H, 035H, 022H, 0B1H, 0D2H, 0A5H, 0D2H, 0A5H, 0D2H, 057H, 033H, 024H, 0BAH, 0D2H, 05BH
	.db	035H, 022H, 0A5H, 0D2H, 033H, 024H, 0C6H, 0D2H, 035H, 022H, 0A5H, 0D2H, 022H, 0B1H, 0D2H, 0ACH
	.db	0D2H, 0A5H, 0D2H, 0A5H, 0D2H, 057H, 033H, 024H, 0BAH, 0D2H, 05BH, 035H, 022H, 0B1H, 0D2H, 0B1H
	.db	0D2H, 0B1H, 0D2H, 033H, 024H, 0C6H, 0D2H, 035H, 022H, 0B1H, 0D2H, 0A5H, 0D2H, 0A5H, 0D2H, 057H
	.db	033H, 024H, 0BAH, 0D2H, 05BH, 035H, 022H, 0A5H, 0D2H, 033H, 024H, 0C6H, 0D2H, 035H, 022H, 0A5H
	.db	0D2H, 022H, 0A7H, 0D2H, 0A2H, 0D2H, 09BH, 0D2H, 09BH, 0D2H, 057H, 033H, 024H, 0BAH, 0D2H, 05BH
	.db	035H, 022H, 0A7H, 0D2H, 0A7H, 0D2H, 0A7H, 0D2H, 033H, 024H, 0C6H, 0D2H, 035H, 022H, 0A7H, 0D2H
	.db	09BH, 0D2H, 09BH, 0D2H, 057H, 033H, 024H, 0BAH, 0D2H, 05BH, 035H, 022H, 0A7H, 0D2H, 033H, 024H
	.db	0C6H, 0D2H, 035H, 022H, 0A7H, 0D2H, 022H, 0A7H, 0D2H, 0A2H, 0D2H, 09BH, 0D2H, 09BH, 0D2H, 057H
	.db	033H, 024H, 0BAH, 0D2H, 05BH, 035H, 022H, 0A7H, 0D2H, 0A7H, 0D2H, 0A7H, 0D2H, 033H, 024H, 0C6H
	.db	0D2H, 035H, 022H, 0A7H, 0D2H, 09BH, 0D2H, 09BH, 0D2H, 057H, 033H, 024H, 0BAH, 0D2H, 05BH, 035H
	.db	022H, 0A7H, 0D2H, 033H, 024H, 0C6H, 0D2H, 035H, 022H, 0A7H, 0D2H, 051H, 05BH, 022H, 0A2H, 0D2H
	.db	09DH, 0D2H, 096H, 0D2H, 096H, 0D3H, 035H, 022H, 0A2H, 0D2H, 0A2H, 0D2H, 0A2H, 0D2H, 033H, 024H
	.db	0C6H, 0D2H, 035H, 022H, 0A2H, 0D2H, 096H, 0D2H, 096H, 0D3H, 022H, 0A2H, 0D2H, 033H, 024H, 0C6H
	.db	0D2H, 035H, 022H, 0A2H, 0D2H, 022H, 0A2H, 0D2H, 09DH, 0D2H, 096H, 0D2H, 096H, 0D3H, 022H, 0A2H
	.db	0D2H, 0A2H, 0D2H, 0A2H, 0D2H, 033H, 024H, 0C6H, 0D2H, 035H, 022H, 0A2H, 0D2H, 096H, 0D2H, 096H
	.db	0D3H, 022H, 0A2H, 0D2H, 033H, 024H, 0C6H, 0D2H, 035H, 022H, 0A2H, 0D2H, 022H, 0A7H, 0D2H, 0A2H
	.db	0D2H, 09BH, 0D2H, 09BH, 0D3H, 022H, 0A7H, 0D2H, 0A7H, 0D2H, 0A7H, 0D2H, 033H, 024H, 0CBH, 0D2H
	.db	035H, 022H, 0A7H, 0D2H, 09BH, 0D2H, 09BH, 0D3H, 022H, 0A7H, 0D2H, 033H, 024H, 0CBH, 0D2H, 035H
	.db	022H, 0A7H, 0D2H, 022H, 0A7H, 0D2H, 0A2H, 0D2H, 09BH, 0D2H, 09BH, 0D3H, 022H, 0A7H, 0D2H, 0A7H
	.db	0D2H, 0A7H, 0D2H, 033H, 024H, 0CBH, 0D2H, 035H, 022H, 0A7H, 0D2H, 09BH, 0D2H, 09BH, 0D3H, 022H
	.db	0A7H, 0D2H, 033H, 024H, 0CBH, 0D2H, 035H, 022H, 0A7H, 0D2H, 051H, 05BH, 022H, 0A2H, 0D2H, 09DH
	.db	0D2H, 096H, 0D2H, 096H, 0D3H, 035H, 022H, 0A2H, 0D2H, 0A2H, 0D2H, 0A2H, 0D2H, 033H, 024H, 0C6H
	.db	0D2H, 035H, 022H, 0A2H, 0D2H, 096H, 0D2H, 096H, 0D3H, 022H, 0A2H, 0D2H, 033H, 024H, 0C6H, 0D2H
	.db	035H, 022H, 0A2H, 0D2H, 022H, 0A2H, 0D2H, 09DH, 0D2H, 096H, 0D2H, 096H, 0D3H, 022H, 0A2H, 0D2H
	.db	0A2H, 0D2H, 0A2H, 0D2H, 033H, 024H, 0C6H, 0D2H, 035H, 022H, 0A2H, 0D2H, 096H, 0D2H, 096H, 0D3H
	.db	022H, 0A2H, 0D2H, 033H, 024H, 0C6H, 0D2H, 035H, 022H, 0A2H, 0D2H, 022H, 0A7H, 0F1H, 051H, 055H
	.db	035H, 011H, 08AH, 0FFH, 0E3H, 051H, 05CH, 08AH, 0FFH, 0E3H, 051H, 055H, 08AH, 0FFH, 0E3H, 051H
	.db	055H, 088H, 0F1H, 08AH, 0F1H, 051H, 055H, 07EH, 0F1H, 07CH, 0F1H, 051H, 055H, 091H, 0F1H, 08AH
	.db	0F1H, 051H, 055H, 091H, 0F1H, 08FH, 0F1H, 051H, 059H, 08AH, 0D2H, 085H, 0D2H, 07EH, 0D2H, 07EH
	.db	0D2H, 054H, 033H, 010H, 0BAH, 0D2H, 059H, 035H, 00FH, 08AH, 0D2H, 08AH, 0D2H, 08AH, 0D2H, 056H
	.db	0A2H, 0D2H, 059H, 08AH, 0D2H, 08AH, 0D2H, 08AH, 0D2H, 054H, 033H, 010H, 0BFH, 0D2H, 059H, 035H
	.db	00FH, 08AH, 0D2H, 056H, 0A2H, 0D2H, 059H, 08AH, 0D2H, 08AH, 0D2H, 085H, 0D2H, 07EH, 0D2H, 07EH
	.db	0D2H, 054H, 033H, 010H, 0BAH, 0D2H, 059H, 035H, 00FH, 08AH, 0D2H, 08AH, 0D2H, 08AH, 0D2H, 056H
	.db	0A2H, 0D2H, 059H, 08AH, 0D2H, 08AH, 0D2H, 08AH, 0D2H, 054H, 033H, 010H, 0BFH, 0D2H, 059H, 035H
	.db	00FH, 08AH, 0D2H, 056H, 0A2H, 0D2H, 08AH, 0D2H, 059H, 08FH, 0D2H, 08AH, 0D2H, 083H, 0D2H, 083H
	.db	0D2H, 054H, 033H, 010H, 0BFH, 0D2H, 059H, 035H, 00FH, 08FH, 0D2H, 08FH, 0D2H, 08FH, 0D2H, 056H
	.db	0A7H, 0D2H, 059H, 08FH, 0D2H, 08FH, 0D2H, 08FH, 0D2H, 054H, 033H, 010H, 0C4H, 0D2H, 059H, 035H
	.db	00FH, 08FH, 0D2H, 056H, 0A7H, 0D2H, 059H, 08FH, 0D2H, 08FH, 0D2H, 08AH, 0D2H, 083H, 0D2H, 083H
	.db	0D2H, 054H, 033H, 010H, 0BFH, 0D2H, 059H, 035H, 00FH, 08FH, 0D2H, 08FH, 0D2H, 08FH, 0D2H, 056H
	.db	0A7H, 0D2H, 059H, 08FH, 0D2H, 08FH, 0D2H, 08FH, 0D2H, 054H, 033H, 010H, 0C4H, 0D2H, 059H, 035H
	.db	00FH, 08FH, 0D2H, 056H, 0A7H, 0D2H, 08FH, 0D2H, 051H, 059H, 092H, 0D2H, 08DH, 0D2H, 086H, 0D2H
	.db	086H, 0D2H, 054H, 033H, 010H, 0BAH, 0D2H, 059H, 035H, 00FH, 092H, 0D2H, 092H, 0D2H, 092H, 0D2H
	.db	056H, 0A2H, 0D2H, 059H, 092H, 0D2H, 086H, 0D2H, 086H, 0D2H, 054H, 033H, 010H, 0BFH, 0D2H, 059H
	.db	035H, 00FH, 092H, 0D2H, 056H, 0A2H, 0D2H, 059H, 092H, 0D2H, 092H, 0D2H, 08DH, 0D2H, 086H, 0D2H
	.db	086H, 0D2H, 054H, 033H, 010H, 0BAH, 0D2H, 059H, 035H, 00FH, 092H, 0D2H, 092H, 0D2H, 092H, 0D2H
	.db	056H, 0A2H, 0D2H, 059H, 092H, 0D2H, 086H, 0D2H, 086H, 0D2H, 054H, 033H, 010H, 0BFH, 0D2H, 059H
	.db	035H, 00FH, 092H, 0D2H, 056H, 0A2H, 0D2H, 059H, 092H, 0D2H, 08BH, 0D2H, 086H, 0D2H, 07FH, 0D2H
	.db	07FH, 0D2H, 054H, 033H, 010H, 0BFH, 0D2H, 059H, 035H, 00FH, 08BH, 0D2H, 08BH, 0D2H, 08BH, 0D2H
	.db	056H, 0A2H, 0D2H, 059H, 08BH, 0D2H, 07FH, 0D2H, 07FH, 0D2H, 054H, 033H, 010H, 0C4H, 0D2H, 059H
	.db	035H, 00FH, 08BH, 0D2H, 056H, 0A2H, 0D2H, 059H, 07FH, 0D2H, 08BH, 0D2H, 086H, 0D2H, 07FH, 0D2H
	.db	07FH, 0D2H, 054H, 033H, 010H, 0BFH, 0D2H, 059H, 035H, 00FH, 08BH, 0D2H, 08BH, 0D2H, 08BH, 0D2H
	.db	056H, 0A2H, 0D2H, 059H, 08BH, 0D2H, 07FH, 0D2H, 07FH, 0D2H, 054H, 033H, 010H, 0C4H, 0D2H, 059H
	.db	035H, 00FH, 08BH, 0D2H, 056H, 0A2H, 0D2H, 059H, 07FH, 0D2H, 051H, 059H, 08DH, 0D2H, 088H, 0D2H
	.db	081H, 0D2H, 081H, 0D2H, 054H, 033H, 010H, 0BAH, 0D2H, 059H, 035H, 00FH, 08DH, 0D2H, 08DH, 0D2H
	.db	08DH, 0D2H, 056H, 0A2H, 0D2H, 059H, 08DH, 0D2H, 081H, 0D2H, 081H, 0D2H, 054H, 033H, 010H, 0BFH
	.db	0D2H, 059H, 035H, 00FH, 08DH, 0D2H, 056H, 0A2H, 0D2H, 059H, 08DH, 0D2H, 08DH, 0D2H, 088H, 0D2H
	.db	081H, 0D2H, 081H, 0D2H, 054H, 033H, 010H, 0BAH, 0D2H, 059H, 035H, 00FH, 08DH, 0D2H, 08DH, 0D2H
	.db	08DH, 0D2H, 056H, 0A2H, 0D2H, 059H, 08DH, 0D2H, 081H, 0D2H, 081H, 0D2H, 054H, 033H, 010H, 0BFH
	.db	0D2H, 059H, 035H, 00FH, 08DH, 0D2H, 056H, 0A2H, 0D2H, 059H, 08DH, 0D2H, 08FH, 0D2H, 08AH, 0D2H
	.db	083H, 0D2H, 083H, 0D2H, 054H, 033H, 010H, 0BFH, 0D2H, 059H, 035H, 00FH, 08FH, 0D2H, 08FH, 0D2H
	.db	08FH, 0D2H, 056H, 0A2H, 0D2H, 059H, 08FH, 0D2H, 08FH, 0D2H, 08FH, 0D2H, 054H, 033H, 010H, 0C4H
	.db	0D2H, 059H, 035H, 00FH, 08FH, 0D2H, 056H, 0A2H, 0D2H, 059H, 08FH, 0D2H, 08FH, 0D2H, 08AH, 0D2H
	.db	083H, 0D2H, 083H, 0D2H, 054H, 033H, 010H, 0BFH, 0D2H, 059H, 035H, 00FH, 08FH, 0D2H, 08FH, 0D2H
	.db	08FH, 0D2H, 056H, 0A2H, 0D2H, 059H, 08FH, 0D2H, 08FH, 0D2H, 08FH, 0D2H, 054H, 033H, 010H, 0C4H
	.db	0D2H, 059H, 035H, 00FH, 08FH, 0D2H, 056H, 0A2H, 0D2H, 08FH, 0D2H, 051H, 05AH, 08AH, 0D2H, 085H
	.db	0D2H, 07EH, 0D2H, 07EH, 0D3H, 035H, 08AH, 0D2H, 08AH, 0D2H, 08AH, 0D2H, 056H, 0A2H, 0D2H, 05AH
	.db	08AH, 0D2H, 08AH, 0D2H, 08AH, 0D3H, 08AH, 0D2H, 056H, 0A2H, 0D2H, 05AH, 08AH, 0D2H, 08AH, 0D2H
	.db	085H, 0D2H, 07EH, 0D2H, 07EH, 0D3H, 08AH, 0D2H, 08AH, 0D2H, 08AH, 0D2H, 056H, 0A2H, 0D2H, 05AH
	.db	08AH, 0D2H, 08AH, 0D2H, 08AH, 0D3H, 08AH, 0D2H, 056H, 0A2H, 0D2H, 08AH, 0D2H, 05AH, 08FH, 0D2H
	.db	08AH, 0D2H, 083H, 0D2H, 083H, 0D3H, 08FH, 0D2H, 08FH, 0D2H, 08FH, 0D2H, 056H, 0A7H, 0D2H, 05AH
	.db	08FH, 0D2H, 08FH, 0D2H, 08FH, 0D3H, 08FH, 0D2H, 056H, 0A7H, 0D2H, 05AH, 08FH, 0D2H, 08FH, 0D2H
	.db	08AH, 0D2H, 083H, 0D2H, 083H, 0D3H, 08FH, 0D2H, 08FH, 0D2H, 08FH, 0D2H, 056H, 0A7H, 0D2H, 05AH
	.db	08FH, 0D2H, 08FH, 0D2H, 08FH, 0D3H, 08FH, 0D2H, 056H, 0A7H, 0D2H, 08FH, 0D2H, 051H, 05AH, 08AH
	.db	0D2H, 085H, 0D2H, 07EH, 0D2H, 07EH, 0D3H, 035H, 08AH, 0D2H, 08AH, 0D2H, 08AH, 0D2H, 056H, 0A2H
	.db	0D2H, 05AH, 08AH, 0D2H, 08AH, 0D2H, 08AH, 0D3H, 08AH, 0D2H, 056H, 0A2H, 0D2H, 05AH, 08AH, 0D2H
	.db	08AH, 0D2H, 085H, 0D2H, 07EH, 0D2H, 07EH, 0D3H, 08AH, 0D2H, 08AH, 0D2H, 08AH, 0D2H, 056H, 0A2H
	.db	0D2H, 05AH, 08AH, 0D2H, 08AH, 0D2H, 08AH, 0D3H, 08AH, 0D2H, 056H, 0A2H, 0D2H, 05AH, 08AH, 0D2H
	.db	08FH, 0F1H, 051H, 05BH, 035H, 011H, 085H, 0FFH, 0E3H, 051H, 0D3H, 052H, 016H, 08FH, 0D5H, 091H
	.db	0D5H, 096H, 0D5H, 099H, 0D5H, 08FH, 0D5H, 091H, 0D5H, 096H, 0D5H, 099H, 0D5H, 08AH, 0D5H, 08DH
	.db	0D5H, 091H, 0D5H, 096H, 0D5H, 08AH, 0D5H, 08DH, 0D5H, 091H, 0D5H, 096H, 0D3H, 051H, 020H, 0D2H
	.db	020H, 0FFH, 0D3H, 01BH, 0D2H, 053H, 035H, 017H, 0A5H, 0D2H, 017H, 0D4H, 0A4H, 0D5H, 0A0H, 0D5H
	.db	09BH, 0D3H, 051H, 0D2H, 020H, 0FFH, 0D3H, 01BH, 0D2H, 053H, 035H, 017H, 0A5H, 0D2H, 017H, 0D4H
	.db	0A4H, 0D5H, 0A0H, 0D5H, 09BH, 0D3H, 051H, 010H, 0D2H, 056H, 016H, 09DH, 0D2H, 01BH, 09DH, 0D2H
	.db	020H, 09DH, 0D2H, 020H, 09DH, 0D2H, 011H, 09DH, 0D2H, 017H, 09DH, 0D2H, 01BH, 09DH, 0D2H, 01DH
	.db	09DH, 0D2H, 054H, 034H, 010H, 08AH, 0D2H, 016H, 0DCH, 056H, 011H, 09DH, 0D2H, 017H, 09DH, 0D2H
	.db	01BH, 09DH, 0D2H, 01EH, 09DH, 0D2H, 054H, 010H, 08AH, 0D2H, 016H, 0D8H, 056H, 010H, 09DH, 0D2H
	.db	017H, 09DH, 0D2H, 01BH, 09DH, 0D2H, 01DH, 09DH, 0D2H, 011H, 09DH, 0D2H, 017H, 09DH, 0D2H, 01BH
	.db	09DH, 0D2H, 01DH, 09DH, 0D2H, 054H, 010H, 08AH, 0D2H, 016H, 0D8H, 053H, 017H, 0D2H, 017H, 0A5H
	.db	0D4H, 017H, 0D2H, 0A4H, 0D2H, 015H, 0D3H, 017H, 0D2H, 0A0H, 0D2H, 015H, 0D3H, 017H, 0D2H, 09BH
	.db	0D2H, 015H, 0D2H, 051H, 0D2H, 053H, 016H, 0A2H, 0D2H, 0A5H, 0D2H, 0A2H, 0D2H, 09DH, 0D2H, 0A5H
	.db	0D2H, 0A2H, 0D2H, 09DH, 0D2H, 0A5H, 0D2H, 0A2H, 0D2H, 09DH, 0D2H, 0A5H, 0D2H, 0A2H, 0D2H, 09DH
	.db	0D2H, 0A7H, 0D2H, 0A2H, 0D2H, 09DH, 0D2H, 0A9H, 0D2H, 0A2H, 0D2H, 09DH, 0D2H, 0A9H, 0D2H, 0A2H
	.db	0D2H, 09DH, 0D2H, 0A9H, 0D2H, 0A2H, 0D2H, 09DH, 0D2H, 0ACH, 0D2H, 0A2H, 0D2H, 09DH, 0D2H, 0ACH
	.db	0D2H, 0A2H, 0D2H, 09DH, 0D2H, 0ACH, 0D2H, 05AH, 0A2H, 0D2H, 0ABH, 0D2H, 0A2H, 0D2H, 09DH, 0D2H
	.db	0ABH, 0D2H, 0A2H, 0D2H, 09DH, 0D2H, 0ABH, 0D2H, 0A2H, 0D2H, 09DH, 0D2H, 0A9H, 0D2H, 0A2H, 0D2H
	.db	09DH, 0D2H, 0A9H, 0D2H, 0A2H, 0D2H, 09DH, 0D2H, 0A7H, 0D2H, 0A2H, 0D2H, 09DH, 0D2H, 0A7H, 0D2H
	.db	0A2H, 0D2H, 09DH, 0D2H, 0A9H, 0D2H, 0A2H, 0D2H, 09DH, 0D2H, 0ACH, 0D2H, 0A2H, 0D2H, 09DH, 0D2H
	.db	0ACH, 0D2H, 0A2H, 0D2H, 09DH, 0D2H, 051H, 058H, 011H, 0A2H, 0D5H, 057H, 00FH, 09BH, 0D4H, 058H
	.db	0A2H, 0D5H, 0A2H, 0D2H, 057H, 09BH, 0D5H, 058H, 011H, 0A2H, 0D5H, 057H, 00FH, 09BH, 0D4H, 058H
	.db	0A2H, 0D5H, 0A2H, 0D2H, 057H, 09BH, 0D3H, 058H, 0A2H, 0D3H, 011H, 0A2H, 0D5H, 057H, 00FH, 09BH
	.db	0D4H, 058H, 0A2H, 0D5H, 0A2H, 0D2H, 057H, 09BH, 0D5H, 058H, 011H, 0A2H, 0D5H, 057H, 00FH, 09BH
	.db	0D4H, 058H, 0A2H, 0D5H, 0A2H, 0D2H, 057H, 09BH, 0D3H, 058H, 0A2H, 0D3H, 051H, 05BH, 035H, 022H
	.db	0B0H, 0F1H, 0B1H, 0F1H, 051H, 05EH, 022H, 0B0H, 0F1H, 0B1H, 0E9H, 05BH, 0B0H, 0D9H, 051H, 05BH
	.db	022H, 0B3H, 0F1H, 022H, 0B5H, 0F1H, 051H, 05BH, 032H, 022H, 0A2H, 0D5H, 0A9H, 0D5H, 0ACH, 0D5H
	.db	05EH, 0A2H, 0D5H, 05BH, 0A0H, 0D5H, 0A9H, 0D5H, 0A2H, 0D3H, 0A5H, 0D3H, 0A2H, 0D3H, 0A0H, 0D3H
	.db	0A2H, 0D3H, 0A0H, 0D3H, 09DH, 0EDH, 051H, 05BH, 032H, 022H, 0A2H, 0D5H, 0A9H, 0D5H, 0ACH, 0D5H
	.db	05EH, 0AEH, 0D5H, 0B5H, 0D9H, 05BH, 0A2H, 0D3H, 0A5H, 0D3H, 0A2H, 0D3H, 0A0H, 0D3H, 0A2H, 0D3H
	.db	0A0H, 0D3H, 0A9H, 0EDH, 051H, 05BH, 032H, 022H, 0AEH, 0D5H, 0B5H, 0D5H, 0B8H, 0D5H, 05EH, 0AEH
	.db	0D5H, 05BH, 0ACH, 0D5H, 0B5H, 0D5H, 0AEH, 0D3H, 0B1H, 0D3H, 0AEH, 0D3H, 0ACH, 0D3H, 0AEH, 0D3H
	.db	0ACH, 0D3H, 0A9H, 0EDH, 051H, 05BH, 032H, 022H, 0AEH, 0D5H, 0B5H, 0D5H, 0B8H, 0D5H, 05EH, 0BAH
	.db	0D5H, 0C1H, 0D9H, 05BH, 0AEH, 0D3H, 0B1H, 0D3H, 0AEH, 0D3H, 0ACH, 0D3H, 0AEH, 0D3H, 0ACH, 0D3H
	.db	0B5H, 0EDH, 051H, 05EH, 032H, 022H, 0C1H, 0D5H, 05BH, 0C4H, 0D5H, 0C1H, 0D3H, 0C4H, 0D3H, 05EH
	.db	0C1H, 0D3H, 05BH, 0BDH, 0D3H, 0BFH, 0D5H, 0B5H, 0D5H, 0AEH, 0D3H, 0B1H, 0D3H, 0AEH, 0D3H, 0ACH
	.db	0D3H, 0AEH, 0D3H, 0ACH, 0D3H, 0A2H, 0EDH, 051H, 05BH, 032H, 022H, 0AEH, 0D2H, 0B1H, 0D2H, 0B3H
	.db	0D2H, 0B5H, 0D2H, 0B8H, 0D2H, 0BAH, 0D2H, 0BDH, 0D2H, 0BFH, 0D2H, 0C1H, 0D2H, 0C4H, 0D2H, 0C6H
	.db	0D2H, 0C4H, 0D2H, 0C1H, 0D2H, 0C6H, 0D2H, 0C4H, 0D2H, 0C1H, 0D2H, 0C6H, 0D2H, 0C4H, 0D2H, 0C1H
	.db	0D2H, 05EH, 0C9H, 0D6H, 0CBH, 0D5H, 05BH, 0C6H, 0D5H, 0C6H, 0D5H, 0C4H, 0EDH, 051H, 05BH, 022H
	.db	0B5H, 0F1H, 022H, 0B5H, 0F1H, 051H, 05BH, 022H, 0B5H, 0EDH, 05EH, 0B8H, 0D5H, 05BH, 022H, 0B7H
	.db	0F1H, 051H, 05BH, 022H, 0B5H, 0EDH, 05EH, 0B8H, 0D5H, 05BH, 022H, 0B7H, 0EDH, 05EH, 022H, 0B8H
	.db	0D5H, 051H, 05BH, 035H, 022H, 0B4H, 0D5H, 05EH, 0B8H, 0D5H, 05BH, 0BDH, 0D5H, 0BFH, 0D7H, 0C0H
	.db	0D3H, 05EH, 0C4H, 0D5H, 05BH, 0C3H, 0D5H, 05EH, 0CCH, 0D5H, 05BH, 0CBH, 0EFH, 022H, 0C9H, 0D2H
	.db	0CBH, 0D2H, 051H, 05EH, 035H, 022H, 0CCH, 0E1H, 05BH, 0CBH, 0D3H, 0C9H, 0D5H, 0C3H, 0D5H, 05EH
	.db	0C9H, 0D7H, 05BH, 0C6H, 0EFH, 022H, 0C5H, 0D2H, 0C6H, 0D2H, 051H, 05BH, 035H, 022H, 0B9H, 0E1H
	.db	0C6H, 0D3H, 0C9H, 0D5H, 0CEH, 0D5H, 0CCH, 0D7H, 05EH, 0CBH, 0DFH, 05BH, 0D2H, 0C7H, 0D2H, 0C2H
	.db	0D7H, 0C2H, 0D2H, 0BFH, 0D2H, 05EH, 0BBH, 0D7H, 05BH, 022H, 0B9H, 0D2H, 0B8H, 0D2H, 051H, 05BH
	.db	022H, 0B5H, 0EDH, 022H, 0B1H, 0D5H, 022H, 0AEH, 0EDH, 05EH, 022H, 0B8H, 0D5H, 051H, 05BH, 022H
	.db	0A2H, 0F1H, 022H, 0AEH, 0F1H, 051H, 05BH, 022H, 096H, 0FFH, 0E3H, 051H, 055H, 035H, 011H, 091H
	.db	0F1H, 08DH, 0F1H, 051H, 05CH, 091H, 0F1H, 08DH, 0E9H, 055H, 08CH, 0D9H, 051H, 055H, 08FH, 0F1H
	.db	091H, 0F1H, 051H, 055H, 07EH, 0D5H, 085H, 0D5H, 088H, 0D5H, 05CH, 08AH, 0D5H, 055H, 088H, 0D5H
	.db	085H, 0D5H, 07EH, 0D3H, 081H, 0D3H, 07EH, 0D3H, 07CH, 0D3H, 07EH, 0D3H, 07CH, 0D3H, 079H, 0EDH
	.db	051H, 055H, 07EH, 0D5H, 085H, 0D5H, 088H, 0D5H, 05CH, 08AH, 0D5H, 091H, 0D9H, 055H, 07EH, 0D3H
	.db	081H, 0D3H, 07EH, 0D3H, 07CH, 0D3H, 07EH, 0D3H, 07CH, 0D3H, 085H, 0EDH, 051H, 055H, 08AH, 0D5H
	.db	091H, 0D5H, 094H, 0D5H, 05CH, 096H, 0D5H, 055H, 094H, 0D5H, 091H, 0D5H, 08AH, 0D3H, 08DH, 0D3H
	.db	08AH, 0D3H, 088H, 0D3H, 08AH, 0D3H, 088H, 0D3H, 085H, 0EDH, 051H, 055H, 08AH, 0D5H, 091H, 0D5H
	.db	094H, 0D5H, 05CH, 096H, 0D5H, 09DH, 0D9H, 055H, 08AH, 0D3H, 08DH, 0D3H, 08AH, 0D3H, 088H, 0D3H
	.db	08AH, 0D3H, 088H, 0D3H, 091H, 0EDH, 051H, 05CH, 09DH, 0D5H, 055H, 0A0H, 0D5H, 09DH, 0D3H, 0A0H
	.db	0D3H, 05CH, 09DH, 0D3H, 055H, 099H, 0D3H, 09BH, 0D5H, 091H, 0D5H, 096H, 0D3H, 099H, 0D3H, 096H
	.db	0D3H, 094H, 0D3H, 096H, 0D3H, 094H, 0D3H, 091H, 0EDH, 051H, 055H, 08AH, 0D2H, 08DH, 0D2H, 08FH
	.db	0D2H, 091H, 0D2H, 094H, 0D2H, 096H, 0D2H, 099H, 0D2H, 09BH, 0D2H, 09DH, 0D2H, 0A0H, 0D2H, 0A2H
	.db	0D2H, 0A0H, 0D2H, 09DH, 0D2H, 0A2H, 0D2H, 0A0H, 0D2H, 09DH, 0D2H, 0A2H, 0D2H, 0A0H, 0D2H, 09DH
	.db	0D2H, 05CH, 0A5H, 0D6H, 0A7H, 0D5H, 055H, 0A2H, 0D5H, 0A2H, 0D5H, 0A0H, 0EDH, 051H, 055H, 091H
	.db	0F1H, 091H, 0F1H, 051H, 055H, 091H, 0EDH, 05CH, 094H, 0D5H, 055H, 093H, 0F1H, 051H, 055H, 091H
	.db	0EDH, 05CH, 094H, 0D5H, 055H, 093H, 0EDH, 05CH, 094H, 0D5H, 051H, 055H, 0A8H, 0D5H, 05CH, 094H
	.db	0D5H, 055H, 099H, 0D5H, 09BH, 0D7H, 09CH, 0D3H, 05CH, 0A0H, 0D5H, 055H, 09FH, 0D5H, 05CH, 0A8H
	.db	0D5H, 055H, 0A7H, 0EFH, 0A5H, 0D2H, 0A7H, 0D2H, 051H, 05CH, 0A8H, 0E1H, 055H, 035H, 0A7H, 0D3H
	.db	0A5H, 0D5H, 09FH, 0D5H, 05CH, 0A5H, 0D7H, 055H, 0A2H, 0EFH, 0A1H, 0D2H, 0A2H, 0D2H, 051H, 055H
	.db	035H, 0A1H, 0E1H, 0A2H, 0D3H, 0A5H, 0D5H, 0AAH, 0D5H, 0A8H, 0D7H, 05CH, 0A7H, 0DFH, 055H, 0D2H
	.db	0A3H, 0D2H, 09EH, 0D7H, 09EH, 0D2H, 09BH, 0D2H, 05CH, 097H, 0D7H, 055H, 095H, 0D2H, 094H, 0D2H
	.db	051H, 055H, 091H, 0EDH, 08DH, 0D5H, 08AH, 0EDH, 05CH, 094H, 0D5H, 051H, 055H, 08AH, 0F1H, 08FH
	.db	0F1H, 051H, 055H, 07EH, 0FFH, 0E3H, 051H, 0FEH, 000H, 00CH, 000H, 00CH, 000H, 00CH, 0FFH, 0FEH
	.db	000H, 005H, 007H, 0FFH, 00CH, 07DH, 000H, 0FFH, 0FEH, 009H, 00CH, 0FFH, 07EH, 000H, 0FFH, 000H
	.db	0FFH, 011H, 000H, 005H, 0FFH, 011H, 001H, 000H, 011H, 002H, 011H, 001H, 011H, 000H, 0DDH, 0FEH
	.db	011H, 000H, 006H, 0DDH, 01FH, 0FFH, 01FH, 0FEH, 011H, 002H, 0CCH, 011H, 001H, 0CCH, 000H, 011H
	.db	000H, 0BBH, 0BBH, 01FH, 0FFH, 0CCH, 000H, 01FH, 0FEH, 0CCH, 0DDH, 01FH, 0FFH, 0DDH, 0FCH, 011H
	.db	000H, 07AH, 011H, 004H, 08AH, 011H, 008H, 09BH, 011H, 004H, 0ABH, 011H, 000H, 0AAH, 01FH, 0FCH
	.db	0A9H, 01FH, 0F8H, 0A9H, 01FH, 0FCH, 099H, 011H, 000H, 088H, 011H, 004H, 078H, 011H, 008H, 068H
	.db	011H, 004H, 058H, 011H, 000H, 048H, 01FH, 0FCH, 029H, 01FH, 0F8H, 018H, 01FH, 0FCH, 018H, 011H
	.db	000H, 017H, 011H, 004H, 016H, 011H, 008H, 015H, 011H, 004H, 014H, 011H, 000H, 013H, 01FH, 0FCH
	.db	012H, 01FH, 0F8H, 011H, 01FH, 0FCH, 031H, 011H, 000H, 051H, 011H, 004H, 051H, 011H, 008H, 041H
	.db	011H, 004H, 005H, 031H, 01FH, 0FEH, 011H, 002H, 01FH, 0FEH, 011H, 002H, 0FCH, 02AH, 0A1H, 000H
	.db	0FFH, 0EDH, 0BBH, 0BBH, 0AAH, 0AAH, 099H, 099H, 088H, 088H, 077H, 077H, 066H, 066H, 055H, 055H
	.db	044H, 044H, 033H, 033H, 022H, 022H, 011H, 021H, 000H, 011H, 0FCH, 014H, 011H, 000H, 0FFH, 0EFH
	.db	0DFH, 0CFH, 0CFH, 0BFH, 0BEH, 0AEH, 0AEH, 006H, 09EH, 0FEH, 002H, 011H, 000H, 08EH, 08DH, 08DH
	.db	0FCH, 01DH, 010H, 0FFH, 000H, 01BH, 0E0H, 0FFH, 0DEH, 01BH, 080H, 0CDH, 01BH, 070H, 0ABH, 01BH
	.db	060H, 09AH, 01BH, 050H, 078H, 01BH, 040H, 067H, 01BH, 030H, 045H, 01BH, 020H, 034H, 0FCH, 0B1H
	.db	000H, 0FFH, 06FH, 0E9H, 0A9H, 0BFH, 0D1H, 0A9H, 06FH, 0BAH, 098H, 0BFH, 0A2H, 077H, 06FH, 08BH
	.db	067H, 07FH, 073H, 076H, 02FH, 05CH, 071H, 07FH, 044H, 061H, 02FH, 02DH, 006H, 050H, 0BFH, 015H
	.db	0ADH, 0FEH, 0FCH, 0BDH, 010H, 0FFH, 01BH, 0E0H, 0FFH, 07BH, 0E0H, 0DEH, 01BH, 080H, 0CDH, 03BH
	.db	070H, 0ABH, 01BH, 060H, 09AH, 01BH, 050H, 078H, 01BH, 040H, 067H, 01BH, 030H, 045H, 01BH, 020H
	.db	034H, 0FCH, 0A1H, 000H, 0FFH, 0A1H, 004H, 0EEH, 011H, 008H, 0CEH, 011H, 004H, 0BCH, 011H, 000H
	.db	0BBH, 01FH, 0FCH, 0BBH, 01FH, 0F8H, 0BAH, 01FH, 0FCH, 0BAH, 011H, 000H, 0AAH, 011H, 004H, 0AAH
	.db	011H, 008H, 09AH, 011H, 004H, 08AH, 011H, 000H, 07AH, 01FH, 0FCH, 07BH, 01FH, 0F8H, 07AH, 01FH
	.db	0FCH, 07AH, 011H, 000H, 078H, 011H, 004H, 057H, 011H, 008H, 056H, 011H, 004H, 056H, 011H, 000H
	.db	053H, 01FH, 0FCH, 052H, 01FH, 0F8H, 051H, 01FH, 0FCH, 061H, 011H, 000H, 061H, 011H, 004H, 051H
	.db	011H, 008H, 041H, 011H, 004H, 005H, 031H, 01FH, 0FEH, 011H, 002H, 01FH, 0FEH, 011H, 002H, 0FCH
	.db	011H, 000H, 0DDH, 011H, 002H, 0BBH, 011H, 004H, 099H, 011H, 002H, 077H, 011H, 000H, 006H, 033H
	.db	01FH, 0FEH, 01FH, 0FCH, 01FH, 0FEH, 004H, 006H, 022H, 011H, 000H, 011H, 002H, 011H, 004H, 011H
	.db	002H, 011H, 000H, 01FH, 0FEH, 000H, 0FCH, 0FEH, 001H, 000H, 004H, 008H, 0FFH, 001H, 001H, 001H
	.db	002H, 001H, 001H, 001H, 003H, 001H, 002H, 001H, 001H, 001H, 000H, 0FCH, 01FH, 0DCH, 005H, 0FFH
	.db	01FH, 0DEH, 01FH, 0E0H, 01FH, 0E2H, 01FH, 0E4H, 01FH, 0E6H, 0EFH, 01FH, 0E8H, 007H, 0DFH, 01FH
	.db	0EAH, 01FH, 0ECH, 01FH, 0EEH, 01FH, 0F0H, 01FH, 0F2H, 01FH, 0F4H, 01FH, 0F6H, 01FH, 0F8H, 011H
	.db	000H, 01FH, 0FFH, 004H, 004H, 0DEH, 002H, 011H, 000H, 0FEH, 011H, 001H, 005H, 0DEH, 000H, 01FH
	.db	0FEH, 01FH, 0FFH, 011H, 000H, 0FCH, 004H, 011H, 000H, 0A9H, 065H, 032H, 011H, 0FCH, 00FH, 0DAH
	.db	0FFH, 00FH, 0DCH, 0FFH, 00FH, 0DEH, 0DFH, 00FH, 0E0H, 0DFH, 00FH, 0E2H, 0CFH, 00FH, 0E4H, 0CFH
	.db	00FH, 0E6H, 006H, 0CCH, 00FH, 0E8H, 00FH, 0EAH, 00FH, 0ECH, 0DCH, 00FH, 0EEH, 007H, 0CCH, 00FH
	.db	0F0H, 00FH, 0F2H, 00FH, 0F4H, 00FH, 0F6H, 00FH, 0FEH, 00FH, 0FDH, 002H, 001H, 002H, 0FEH, 001H
	.db	003H, 005H, 0CCH, 000H, 00FH, 0FCH, 00FH, 0FDH, 00FH, 0FEH, 0FCH, 0F1H, 00DH, 01FH, 00EH, 07DH
	.db	00EH, 09BH, 00EH, 0B1H, 00EH, 0CFH, 00EH, 0F3H, 00EH, 012H, 00FH, 070H, 00FH, 097H, 00FH, 0ACH
	.db	00FH, 0E6H, 00FH, 0EEH, 00FH, 0D7H, 00DH, 0DFH, 00DH, 0E4H, 00DH, 0E8H, 00DH, 0ECH, 00DH, 0EFH
	.db	00DH, 004H, 006H, 003H, 005H, 005H, 007H, 00AH, 000H, 0FEH, 061H, 000H, 003H, 006H, 009H, 009H
	.db	00CH, 00FH, 012H, 015H, 018H, 01BH, 01EH, 021H, 024H, 027H, 027H, 02AH, 02DH, 02DH, 030H, 033H
	.db	036H, 039H, 03CH, 03FH, 036H, 039H, 03CH, 03FH, 042H, 045H, 048H, 048H, 04BH, 04BH, 04EH, 04EH
	.db	051H, 054H, 051H, 054H, 057H, 05AH, 05AH, 000H, 0FFH, 01EH, 000H, 07AH, 002H, 01FH, 006H, 053H
	.db	009H, 0DDH, 00AH, 06CH, 00CH, 025H, 000H, 081H, 002H, 026H, 006H, 025H, 000H, 0E5H, 00AH, 074H
	.db	00CH, 025H, 000H, 087H, 002H, 02BH, 006H, 025H, 000H, 0EFH, 00AH, 07DH, 00CH, 028H, 000H, 087H
	.db	002H, 02BH, 006H, 05AH, 009H, 0EFH, 00AH, 07DH, 00CH, 028H, 000H, 08DH, 002H, 030H, 006H, 05AH
	.db	009H, 0EFH, 00AH, 07DH, 00CH, 04AH, 000H, 094H, 002H, 036H, 006H, 07EH, 009H, 0F7H, 00AH, 083H
	.db	00CH, 063H, 000H, 094H, 002H, 036H, 006H, 093H, 009H, 017H, 00BH, 0A1H, 00CH, 07AH, 000H, 094H
	.db	002H, 036H, 006H, 0A7H, 009H, 0F7H, 00AH, 083H, 00CH, 07AH, 000H, 094H, 002H, 036H, 006H, 0A7H
	.db	009H, 017H, 00BH, 0A1H, 00CH, 07AH, 000H, 094H, 002H, 036H, 006H, 0A7H, 009H, 035H, 00BH, 0BDH
	.db	00CH, 07AH, 000H, 094H, 002H, 036H, 006H, 0A7H, 009H, 055H, 00BH, 0DBH, 00CH, 07AH, 000H, 094H
	.db	002H, 036H, 006H, 0A7H, 009H, 073H, 00BH, 0F7H, 00CH, 07AH, 000H, 094H, 002H, 036H, 006H, 0A7H
	.db	009H, 098H, 00BH, 01AH, 00DH, 07AH, 000H, 087H, 002H, 02BH, 006H, 0A7H, 009H, 0EFH, 00AH, 07DH
	.db	00CH, 07AH, 000H, 08DH, 002H, 030H, 006H, 0A7H, 009H, 0EFH, 00AH, 07DH, 00CH, 025H, 000H, 09BH
	.db	002H, 03CH, 006H, 025H, 000H, 0CEH, 00BH, 04EH, 00DH, 0E2H, 000H, 09BH, 002H, 03CH, 006H, 014H
	.db	00AH, 0CEH, 00BH, 04EH, 00DH, 0E2H, 000H, 0A2H, 002H, 042H, 006H, 014H, 00AH, 0D6H, 00BH, 054H
	.db	00DH, 025H, 000H, 0AAH, 002H, 048H, 006H, 097H, 00AH, 0E2H, 00BH, 05EH, 00DH, 025H, 000H, 080H
	.db	003H, 009H, 007H, 097H, 00AH, 0F2H, 00BH, 06BH, 00DH, 025H, 000H, 056H, 004H, 0CBH, 007H, 097H
	.db	00AH, 013H, 00CH, 089H, 00DH, 025H, 000H, 080H, 003H, 009H, 007H, 097H, 00AH, 02BH, 00CH, 09FH
	.db	00DH, 025H, 000H, 0AAH, 002H, 048H, 006H, 097H, 00AH, 04FH, 00CH, 0C1H, 00DH, 064H, 001H, 0AAH
	.db	002H, 048H, 006H, 097H, 00AH, 04FH, 00CH, 0C1H, 00DH, 0AFH, 001H, 0AAH, 002H, 048H, 006H, 097H
	.db	00AH, 05EH, 00CH, 0CCH, 00DH, 0FBH, 001H, 02CH, 005H, 08CH, 008H, 025H, 000H, 05EH, 00CH, 0CCH
	.db	00DH, 07AH, 000H, 02CH, 005H, 08CH, 008H, 0A7H, 009H, 05EH, 00CH, 0CCH, 00DH, 07AH, 000H, 02CH
	.db	005H, 08CH, 008H, 0A7H, 009H, 0F7H, 00AH, 083H, 00CH, 07AH, 000H, 02CH, 005H, 08CH, 008H, 0A7H
	.db	009H, 017H, 00BH, 0A1H, 00CH, 046H, 002H, 0CBH, 005H, 00EH, 009H, 025H, 000H, 0F7H, 00AH, 083H
	.db	00CH, 025H, 000H, 025H, 000H, 025H, 000H, 025H, 000H, 066H, 00CH, 0D2H, 00DH

.include  etplayer.asm

.end
